/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.NONPOSITIVEINTEGERDatatype;
import uk.ac.manchester.cs.jfact.datatypes.Utils;

class NEGATIVEINTEGERDatatype<R extends Comparable<R>>
extends NONPOSITIVEINTEGERDatatype<R> {
    protected NEGATIVEINTEGERDatatype() {
        super((HasIRI)XSDVocabulary.NEGATIVE_INTEGER, Utils.generateAncestors(DatatypeFactory.NONPOSITIVEINTEGER));
        this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
        this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
        this.knownNonNumericFacetValues.put(Facets.whiteSpace, DatatypeFactory.WHITESPACE);
        this.knownNonNumericFacetValues.put(Facets.pattern, DatatypeFactory.NUMBER_EXPRESSION);
        this.knownNumericFacetValues.put(Facets.maxInclusive, new BigDecimal(-1L));
    }

    @Override
    public R parseValue(String s) {
        BigInteger parse = new BigInteger(s);
        if (parse.compareTo(new BigInteger("-1")) > 0) {
            throw new ArithmeticException("Negative integer required, but found: " + s);
        }
        return (R)parse;
    }
}

