/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.visitors.DLExpressionVisitor;
import uk.ac.manchester.cs.jfact.visitors.DLExpressionVisitorEx;

class LiteralImpl<T extends Comparable<T>>
implements Literal<T>,
Serializable {
    @Nonnull
    private final Datatype<T> type;
    @Nonnull
    private final String value;

    public LiteralImpl(Datatype<T> type, String value) {
        this.type = type;
        this.value = value;
    }

    @Override
    public Datatype<T> getDatatypeExpression() {
        return this.type;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public T typedValue() {
        return this.type.parseValue(this.value);
    }

    @Override
    public void accept(DLExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(DLExpressionVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public int compareTo(@Nullable Literal<T> arg0) {
        return this.type.parseValue(this.value).compareTo(arg0.typedValue());
    }

    @Nonnull
    public String toString() {
        return String.valueOf('\"') + this.value + "\"^^" + this.type;
    }

    @Override
    public IRI getIRI() {
        return IRI.create((String)this.toString());
    }

    public boolean equals(@Nullable Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof Literal) {
            Literal other = (Literal)obj;
            if ((this.type.equals(DatatypeFactory.PLAINLITERAL) || this.type.equals(DatatypeFactory.STRING)) && (other.getDatatypeExpression().equals(DatatypeFactory.PLAINLITERAL) || other.getDatatypeExpression().equals(DatatypeFactory.STRING))) {
                return this.value.replace("@", "").equals(other.value().replace("@", ""));
            }
            return this.type.equals(other.getDatatypeExpression()) && this.typedValue().equals(other.typedValue());
        }
        return false;
    }

    public int hashCode() {
        if (this.type.equals(DatatypeFactory.PLAINLITERAL) || this.type.equals(DatatypeFactory.STRING)) {
            return DatatypeFactory.PLAINLITERAL.hashCode() + this.value.replace("@", "").hashCode();
        }
        return this.type.hashCode() + this.typedValue().hashCode();
    }
}

