/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.EnumMap;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import org.semanticweb.owlapi.vocab.OWLFacet;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facet;
import uk.ac.manchester.cs.jfact.datatypes.Literal;

public class Facets
implements Serializable {
    public static final Facet length = new LimitFacet("length", OWLFacet.LENGTH);
    public static final Facet minLength = new LimitFacet("minLength", OWLFacet.MIN_LENGTH);
    public static final Facet maxLength = new LimitFacet("maxLength", OWLFacet.MAX_LENGTH);
    public static final Facet totalDigits = new LimitFacet("totalDigits", OWLFacet.TOTAL_DIGITS);
    public static final Facet fractionDigits = new LimitFacet("fractionDigits", OWLFacet.FRACTION_DIGITS);
    public static final Facet whiteSpace = new AbstractFacet("whiteSpace", false, null){

        public whitespace parse(Object value) {
            if (value instanceof whitespace) {
                return (whitespace)((Object)value);
            }
            if (value instanceof String) {
                return whitespace.valueOf((String)value);
            }
            throw new ReasonerInternalException("Cannot parse " + value + " as a whitespace enum value");
        }
    };
    public static final Facet pattern = new AbstractFacet("pattern", false, OWLFacet.PATTERN){

        public String parse(Object value) {
            return value.toString();
        }
    };
    public static final Facet enumeration = new AbstractFacet("enumeration", false, null);
    public static final Facet maxInclusive = new LimitFacet("maxInclusive", "]", OWLFacet.MAX_INCLUSIVE);
    public static final Facet maxExclusive = new LimitFacet("maxExclusive", ")", OWLFacet.MAX_EXCLUSIVE);
    public static final Facet minInclusive = new LimitFacet("minInclusive", "[", OWLFacet.MIN_INCLUSIVE);
    public static final Facet minExclusive = new LimitFacet("minExclusive", "(", OWLFacet.MIN_EXCLUSIVE);
    private static final List<Facet> values = Arrays.asList(enumeration, fractionDigits, length, maxExclusive, maxInclusive, minExclusive, minInclusive, maxLength, minLength, pattern, totalDigits, whiteSpace);
    private static EnumMap<OWLFacet, Facet> facets = Facets.facets();

    public static Stream<Facet> values() {
        return values.stream();
    }

    private static EnumMap<OWLFacet, Facet> facets() {
        EnumMap<OWLFacet, Facet> map = new EnumMap<OWLFacet, Facet>(OWLFacet.class);
        values.stream().filter(f -> f.facet() != null).forEach(f -> {
            Facet facet = map.put(f.facet(), (Facet)f);
        });
        return map;
    }

    public static Facet parse(OWLFacet f) {
        Facet facet = facets.get(f);
        if (facet == null) {
            throw new OWLRuntimeException("Unsupported facet: " + f);
        }
        return facet;
    }

    public static Facet parse(String in) {
        String f = String.valueOf('#') + in.substring(in.indexOf(58) + 1);
        for (Facet facet : values) {
            if (!facet.getURI().endsWith(f)) continue;
            return facet;
        }
        throw new OWLRuntimeException("Unsupported facet: " + f);
    }

    private static class AbstractFacet
    implements Facet,
    Serializable {
        protected final String uri;
        protected final String fragment;
        protected final boolean isNumber;
        protected final OWLFacet facet;

        public AbstractFacet(String u, boolean number, OWLFacet f) {
            this.uri = String.valueOf(DatatypeFactory.getNamespace()) + u;
            this.fragment = u;
            this.isNumber = number;
            this.facet = f;
        }

        @Override
        public OWLFacet facet() {
            return this.facet;
        }

        @Override
        public final boolean isNumberFacet() {
            return this.isNumber;
        }

        @Override
        public String getURI() {
            return this.uri;
        }

        public String toString() {
            return "facet[" + this.fragment + ']';
        }

        public int hashCode() {
            return this.uri.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (super.equals(obj)) {
                return true;
            }
            if (obj instanceof Facet) {
                return this.uri.equals(((Facet)obj).getURI());
            }
            return false;
        }

        public Comparable parseNumber(@Nullable Object value) {
            if (!this.isNumberFacet()) {
                throw new UnsupportedOperationException("Only number facets can parse numbers");
            }
            if (value == null) {
                throw new IllegalArgumentException("Cannot parse a null value");
            }
            try {
                if (value instanceof String) {
                    return new BigDecimal((String)value);
                }
                if (value instanceof Number) {
                    return new BigDecimal(value.toString());
                }
                if (value instanceof Literal) {
                    Object typedValue = ((Literal)value).typedValue();
                    if (typedValue instanceof Number) {
                        return new BigDecimal(typedValue.toString());
                    }
                    if (typedValue instanceof Calendar) {
                        return (Comparable)typedValue;
                    }
                }
                if (value instanceof Comparable) {
                    return (Comparable)value;
                }
                return new BigDecimal(value.toString());
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Cannot parse '" + value.toString() + "' as a big decimal: " + e.getMessage());
            }
        }

        @Override
        public Comparable parse(Object o) {
            return (Comparable)o;
        }
    }

    private static class LimitFacet
    extends AbstractFacet {
        private String toString;

        public LimitFacet(String u, String toString, OWLFacet f) {
            super(u, true, f);
            this.toString = toString;
        }

        public LimitFacet(String u, OWLFacet f) {
            super(u, true, f);
            this.toString = super.toString();
        }

        @Override
        public String toString() {
            return this.toString;
        }
    }

    public static enum whitespace {
        PRESERVE{

            @Override
            public String normalize(@Nonnull String input) {
                return input;
            }
        }
        ,
        REPLACE{

            @Override
            public String normalize(@Nonnull String input) {
                return input.replace('\t', ' ').replace('\n', ' ').replace('\r', ' ');
            }
        }
        ,
        COLLAPSE{

            @Override
            public String normalize(@Nonnull String input) {
                StringBuilder b = new StringBuilder(REPLACE.normalize(input));
                int i = 0;
                while (i < b.length()) {
                    if (b.charAt(i) == ' ') {
                        while (i < b.length() - 1 && b.charAt(i + 1) == ' ') {
                            b.deleteCharAt(i + 1);
                        }
                    }
                    ++i;
                }
                return b.toString();
            }
        };


        public abstract String normalize(String var1);
    }
}

