/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeExpression;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facet;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.datatypes.NumericDatatype;
import uk.ac.manchester.cs.jfact.datatypes.NumericDatatypeWrapper;
import uk.ac.manchester.cs.jfact.datatypes.OrderedDatatype;
import uk.ac.manchester.cs.jfact.datatypes.cardinality;
import uk.ac.manchester.cs.jfact.datatypes.ordered;
import uk.ac.manchester.cs.jfact.visitors.DLExpressionVisitor;
import uk.ac.manchester.cs.jfact.visitors.DLExpressionVisitorEx;

public class DatatypeNegation<R extends Comparable<R>>
implements DatatypeExpression<R>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatatypeNegation.class);
    @Nonnull
    private final Datatype<R> host;
    @Nonnull
    private final IRI uri = DatatypeFactory.getIndex("urn:neg").getIRI();

    public DatatypeNegation(Datatype<R> d) {
        this.host = d;
    }

    @Override
    public boolean isExpression() {
        return true;
    }

    @Override
    public DatatypeExpression<R> asExpression() {
        return this;
    }

    @Override
    public Collection<Datatype<?>> getAncestors() {
        return this.host.getAncestors();
    }

    @Override
    public boolean getBounded() {
        return this.host.getBounded();
    }

    @Override
    public cardinality getCardinality() {
        return this.host.getCardinality();
    }

    @Override
    public Set<Facet> getFacets() {
        return this.host.getFacets();
    }

    @Override
    public boolean emptyValueSpace() {
        if (this.host.emptyValueSpace()) {
            return false;
        }
        if (this.host.getCardinality() == cardinality.COUNTABLYINFINITE) {
            return false;
        }
        return false;
    }

    @Override
    public Map<Facet, Comparable> getKnownNumericFacetValues() {
        return this.host.getKnownNumericFacetValues();
    }

    @Override
    public Map<Facet, Comparable> getKnownNonNumericFacetValues() {
        return this.host.getKnownNonNumericFacetValues();
    }

    @Override
    @Nullable
    public Comparable getFacetValue(Facet f) {
        return this.host.getFacetValue(f);
    }

    @Override
    @Nullable
    public Comparable getNumericFacetValue(Facet f) {
        return this.host.getNumericFacetValue(f);
    }

    @Override
    public boolean getNumeric() {
        return this.host.getNumeric();
    }

    @Override
    public ordered getOrdered() {
        return this.host.getOrdered();
    }

    @Override
    public boolean isCompatible(Literal<?> l) {
        return !this.host.isCompatible(l);
    }

    @Override
    public boolean isInValueSpace(R l) {
        return !this.host.isInValueSpace(l);
    }

    @Override
    public R parseValue(String s) {
        return this.host.parseValue(s);
    }

    @Override
    public Literal<R> buildLiteral(String s) {
        return this.host.buildLiteral(s);
    }

    @Override
    public boolean isSubType(Datatype<?> type) {
        return this.host.isSubType(type);
    }

    @Override
    public IRI getDatatypeIRI() {
        return this.uri;
    }

    @Override
    public boolean isCompatible(Datatype<?> type) {
        if (type instanceof DatatypeNegation) {
            return !this.host.isCompatible(((DatatypeNegation)type).host);
        }
        return !this.host.isCompatible(type);
    }

    @Override
    public boolean isContradictory(Datatype<?> type) {
        return !this.isCompatible(type);
    }

    @Override
    public void accept(DLExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(DLExpressionVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Collection<Literal<R>> listValues() {
        return OWLAPIStreamUtils.asList(this.host.listValues().stream().filter(p -> !this.host.isCompatible((Literal<?>)p)));
    }

    @Override
    public boolean isNumericDatatype() {
        return this.host.isNumericDatatype();
    }

    @Override
    public NumericDatatype<R> asNumericDatatype() {
        return new NumericDatatypeWrapper(this);
    }

    @Override
    public boolean isOrderedDatatype() {
        return this.host.isOrderedDatatype();
    }

    @Override
    public OrderedDatatype<R> asOrderedDatatype() {
        return (OrderedDatatype)((Object)this);
    }

    @Nonnull
    public String toString() {
        return this.uri + "{" + this.host + '}';
    }

    @Override
    public Datatype<R> getHostType() {
        return this.host.isExpression() ? this.host.asExpression().getHostType() : this.host;
    }

    @Override
    public DatatypeExpression<R> addNumericFacet(Facet f, @Nullable Comparable<?> value) {
        LOGGER.warn("DatatypeNumericEnumeration.addFacet() WARNING: cannot add facets to a negation; returning the same object: {}", (Object)this);
        return this;
    }

    @Override
    public DatatypeExpression<R> addNonNumericFacet(Facet f, @Nullable Comparable<?> value) {
        LOGGER.warn("DatatypeNumericEnumeration.addFacet() WARNING: cannot add facets to a negation; returning the same object: {}", (Object)this);
        return this;
    }

    @Override
    public IRI getIRI() {
        return IRI.create((String)this.toString());
    }
}

