/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeCombination;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.helpers.Helper;

public class DatatypeIntersection<T extends Comparable<T>>
implements DatatypeCombination<DatatypeIntersection<T>, Datatype<T>> {
    private final Set<Datatype<T>> basics = new HashSet<Datatype<T>>();
    private final IRI uri = DatatypeFactory.getIndex("urn:intersection#a").getIRI();
    private final Datatype<T> host;

    public DatatypeIntersection(Datatype<T> host) {
        this.host = host;
    }

    public DatatypeIntersection(Datatype<T> host, Iterable<Datatype<T>> list) {
        this(host);
        list.forEach(this.basics::add);
    }

    @Nullable
    public static Datatype<?> getHostDatatype(List<Datatype<?>> collection) {
        int oldSize;
        if (Helper.anyMatchOnAllPairs(collection, v -> !((Datatype)v.i).isCompatible((Datatype)v.j))) {
            return null;
        }
        ArrayList list = new ArrayList(collection);
        do {
            oldSize = list.size();
            int i = 0;
            while (i < list.size() - 1) {
                Datatype next = (Datatype)list.get(i + 1);
                Datatype current = (Datatype)list.get(i);
                assert (current != null);
                assert (next != null);
                if (current.isSubType(next)) {
                    list.remove(i + 1);
                    continue;
                }
                if (next.isSubType(current)) {
                    list.remove(i);
                    continue;
                }
                ++i;
            }
        } while (list.size() > 1 && oldSize != list.size());
        if (list.size() == 1) {
            return (Datatype)list.get(0);
        }
        return null;
    }

    @Override
    public Datatype<?> getHost() {
        return this.host;
    }

    @Override
    public Iterable<Datatype<T>> getList() {
        return this.basics;
    }

    @Override
    public DatatypeIntersection<T> add(Datatype<T> d) {
        DatatypeIntersection<T> toReturn = new DatatypeIntersection<T>(this.host, this.basics);
        toReturn.basics.add(d);
        return toReturn;
    }

    @Override
    public boolean isCompatible(Literal<?> l) {
        if (!this.host.isCompatible(l)) {
            return false;
        }
        return this.basics.stream().allMatch(d -> d.isCompatible(l));
    }

    @Override
    public IRI getDatatypeIRI() {
        return this.uri;
    }

    @Override
    public boolean isCompatible(Datatype<?> type) {
        if (!this.host.isCompatible(type)) {
            return false;
        }
        return this.basics.stream().allMatch(d -> d.isCompatible(type));
    }

    @Override
    public boolean isContradictory(Datatype<?> type) {
        return !this.isCompatible(type);
    }

    @Override
    public boolean emptyValueSpace() {
        if (!this.host.getNumeric()) {
            return false;
        }
        Comparable min = null;
        Comparable max = null;
        boolean minExclusive = false;
        boolean maxExclusive = false;
        for (Datatype<T> dt : this.basics) {
            Comparable facetValue = dt.asNumericDatatype().getMin();
            if (facetValue != null && (min == null || min.compareTo(facetValue) < 0)) {
                min = facetValue;
            }
            if ((facetValue = dt.asNumericDatatype().getMax()) != null && (max == null || facetValue.compareTo(max) < 0)) {
                max = facetValue;
            }
            if (dt.asNumericDatatype().hasMinExclusive()) {
                minExclusive = true;
            }
            if (!dt.asNumericDatatype().hasMaxExclusive()) continue;
            maxExclusive = true;
        }
        int excluded = 0;
        if (minExclusive) {
            ++excluded;
        }
        if (maxExclusive) {
            ++excluded;
        }
        return !DatatypeFactory.intervalWithValues(min, max, excluded);
    }

    public String toString() {
        return this.uri + "{" + this.basics + '}';
    }
}

