/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import conformance.Original;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeExpression;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeExpressionImpl;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeNumericExpressionImpl;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeOrderedExpressionImpl;
import uk.ac.manchester.cs.jfact.datatypes.Facet;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.datatypes.NumericDatatype;
import uk.ac.manchester.cs.jfact.datatypes.OrderedDatatype;
import uk.ac.manchester.cs.jfact.datatypes.cardinality;
import uk.ac.manchester.cs.jfact.datatypes.ordered;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataExpression;

@Original
public interface Datatype<R extends Comparable<R>>
extends DataExpression {
    public boolean isExpression();

    public DatatypeExpression<R> asExpression();

    public Collection<Datatype<?>> getAncestors();

    public boolean getBounded();

    public cardinality getCardinality();

    public Set<Facet> getFacets();

    public Map<Facet, Comparable> getKnownNumericFacetValues();

    public Map<Facet, Comparable> getKnownNonNumericFacetValues();

    @Nullable
    public Comparable getFacetValue(Facet var1);

    @Nullable
    public Comparable getNumericFacetValue(Facet var1);

    public boolean getNumeric();

    public ordered getOrdered();

    public boolean isCompatible(Datatype<?> var1);

    public boolean isCompatible(Literal<?> var1);

    public boolean isContradictory(Datatype<?> var1);

    public boolean isInValueSpace(R var1);

    public boolean emptyValueSpace();

    public R parseValue(String var1);

    public Literal<R> buildLiteral(String var1);

    public boolean isSubType(Datatype<?> var1);

    public IRI getDatatypeIRI();

    public Collection<Literal<R>> listValues();

    public boolean isNumericDatatype();

    public NumericDatatype<R> asNumericDatatype();

    public boolean isOrderedDatatype();

    public OrderedDatatype<R> asOrderedDatatype();

    default public DatatypeExpression<R> wrapAsNumericExpression() {
        return this.isNumericDatatype() ? new DatatypeNumericExpressionImpl(this) : null;
    }

    default public DatatypeExpression<R> wrapAsOrderedExpression() {
        return this.isOrderedDatatype() ? new DatatypeOrderedExpressionImpl(this) : null;
    }

    default public DatatypeExpression<R> wrapAsDatatypeExpression() {
        return new DatatypeExpressionImpl(this);
    }

    default public Datatype<R> host() {
        if (this.isExpression()) {
            return this.asExpression().getHostType();
        }
        return this;
    }
}

