/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.math.BigDecimal;
import java.util.Set;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facet;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.RATIONALDatatype;
import uk.ac.manchester.cs.jfact.datatypes.Utils;
import uk.ac.manchester.cs.jfact.datatypes.ordered;

class DECIMALDatatype<R extends Comparable<R>>
extends RATIONALDatatype<R> {
    DECIMALDatatype() {
        this((HasIRI)XSDVocabulary.DECIMAL, Utils.generateAncestors(DatatypeFactory.RATIONAL));
    }

    DECIMALDatatype(HasIRI uri, Set<Datatype<?>> ancestors) {
        super(uri, Utils.getFacets(new Facet[][]{DatatypeFactory.DIGS, DatatypeFactory.PEW, DatatypeFactory.MINMAX}), ancestors);
        this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
        this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
        this.knownNonNumericFacetValues.put(Facets.whiteSpace, DatatypeFactory.WHITESPACE);
    }

    @Override
    public R parseValue(String s) {
        return (R)new BigDecimal(s);
    }

    @Override
    public ordered getOrdered() {
        return ordered.TOTAL;
    }
}

