/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact;

import java.io.Serializable;
import java.util.List;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.jfact.TranslationMachinery;
import uk.ac.manchester.cs.jfact.kernel.ReasoningKernel;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;

public class EntailmentChecker
implements OWLAxiomVisitorEx<Boolean>,
Serializable {
    private final ReasoningKernel kernel;
    private final TranslationMachinery tr;
    private final OWLDataFactory df;

    public EntailmentChecker(ReasoningKernel k, OWLDataFactory df, TranslationMachinery tr) {
        this.kernel = k;
        this.tr = tr;
        this.df = df;
    }

    public Boolean visit(OWLSubClassOfAxiom axiom) {
        if (axiom.getSuperClass().equals(this.df.getOWLThing()) || axiom.getSubClass().equals(this.df.getOWLNothing())) {
            return Boolean.TRUE;
        }
        ConceptExpression sub = this.tr.pointer(axiom.getSubClass());
        if (!this.kernel.isSatisfiable(sub)) {
            return Boolean.TRUE;
        }
        ConceptExpression sup = this.tr.pointer(axiom.getSuperClass());
        return this.kernel.isSubsumedBy(sub, sup);
    }

    public Boolean visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        return (Boolean)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
    }

    public Boolean visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        return this.kernel.isAsymmetric(this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty()));
    }

    public Boolean visit(OWLReflexiveObjectPropertyAxiom axiom) {
        return this.kernel.isReflexive(this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty()));
    }

    public Boolean visit(OWLDisjointClassesAxiom axiom) {
        return axiom.allMatch((a, b) -> this.kernel.isDisjoint(this.tr.pointer((OWLClassExpression)a), this.tr.pointer((OWLClassExpression)b)));
    }

    public Boolean visit(OWLDataPropertyDomainAxiom axiom) {
        return (Boolean)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
    }

    public Boolean visit(OWLObjectPropertyDomainAxiom axiom) {
        return (Boolean)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
    }

    public Boolean visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        return axiom.asSubObjectPropertyOfAxioms().stream().allMatch(ax -> (Boolean)ax.accept((OWLAxiomVisitorEx)this));
    }

    public Boolean visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        return (Boolean)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
    }

    public Boolean visit(OWLDifferentIndividualsAxiom axiom) {
        return axiom.asOWLSubClassOfAxioms().stream().allMatch(ax -> (Boolean)ax.accept((OWLAxiomVisitorEx)this));
    }

    public Boolean visit(OWLDisjointDataPropertiesAxiom axiom) {
        return axiom.allMatch((i, j) -> this.kernel.isDisjointRoles(this.tr.pointer((OWLDataPropertyExpression)i), this.tr.pointer((OWLDataPropertyExpression)j)));
    }

    public Boolean visit(OWLDisjointObjectPropertiesAxiom axiom) {
        return axiom.allMatch((i, j) -> this.kernel.isDisjointRoles(this.tr.pointer((OWLObjectPropertyExpression)i), this.tr.pointer((OWLObjectPropertyExpression)j)));
    }

    public Boolean visit(OWLObjectPropertyRangeAxiom axiom) {
        return (Boolean)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
    }

    public Boolean visit(OWLObjectPropertyAssertionAxiom axiom) {
        return (Boolean)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
    }

    public Boolean visit(OWLFunctionalObjectPropertyAxiom axiom) {
        return this.kernel.isFunctional(this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty()));
    }

    public Boolean visit(OWLSubObjectPropertyOfAxiom axiom) {
        return this.kernel.isSubRoles(this.tr.pointer((OWLObjectPropertyExpression)axiom.getSubProperty()), this.tr.pointer((OWLObjectPropertyExpression)axiom.getSuperProperty()));
    }

    public Boolean visit(OWLDisjointUnionAxiom axiom) {
        return (Boolean)axiom.getOWLEquivalentClassesAxiom().accept((OWLAxiomVisitorEx)this) != false && (Boolean)axiom.getOWLDisjointClassesAxiom().accept((OWLAxiomVisitorEx)this) != false;
    }

    public Boolean visit(OWLDeclarationAxiom axiom) {
        return Boolean.FALSE;
    }

    public Boolean visit(OWLAnnotationAssertionAxiom axiom) {
        return Boolean.FALSE;
    }

    public Boolean visit(OWLSymmetricObjectPropertyAxiom axiom) {
        return this.kernel.isSymmetric(this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty()));
    }

    public Boolean visit(OWLDataPropertyRangeAxiom axiom) {
        return (Boolean)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
    }

    public Boolean visit(OWLFunctionalDataPropertyAxiom axiom) {
        return this.kernel.isFunctional(this.tr.pointer((OWLDataPropertyExpression)axiom.getProperty()));
    }

    public Boolean visit(OWLEquivalentDataPropertiesAxiom axiom) {
        return axiom.asSubDataPropertyOfAxioms().stream().allMatch(ax -> (Boolean)ax.accept((OWLAxiomVisitorEx)this));
    }

    public Boolean visit(OWLClassAssertionAxiom axiom) {
        return this.kernel.isInstance(this.tr.pointer(axiom.getIndividual()), this.tr.pointer(axiom.getClassExpression()));
    }

    public Boolean visit(OWLEquivalentClassesAxiom axiom) {
        return axiom.allMatch((a, b) -> this.kernel.isEquivalent(this.tr.pointer((OWLClassExpression)a), this.tr.pointer((OWLClassExpression)b)));
    }

    public Boolean visit(OWLDataPropertyAssertionAxiom axiom) {
        return (Boolean)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
    }

    public Boolean visit(OWLTransitiveObjectPropertyAxiom axiom) {
        return this.kernel.isTransitive(this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty()));
    }

    public Boolean visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        return this.kernel.isIrreflexive(this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty()));
    }

    public Boolean visit(OWLSubDataPropertyOfAxiom axiom) {
        return this.kernel.isSubRoles(this.tr.pointer((OWLDataPropertyExpression)axiom.getSubProperty()), this.tr.pointer((OWLDataPropertyExpression)axiom.getSuperProperty()));
    }

    public Boolean visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        return this.kernel.isInverseFunctional(this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty()));
    }

    public Boolean visit(OWLSameIndividualAxiom axiom) {
        return axiom.allMatch((indA, indB) -> this.kernel.isSameIndividuals(this.tr.pointer((OWLIndividual)indA), this.tr.pointer((OWLIndividual)indB)));
    }

    public Boolean visit(OWLSubPropertyChainOfAxiom axiom) {
        List l = OWLAPIStreamUtils.asList(axiom.getPropertyChain().stream().map(this.tr::pointer));
        return this.kernel.isSubChain(this.tr.pointer(axiom.getSuperProperty()), l);
    }

    public Boolean visit(OWLInverseObjectPropertiesAxiom axiom) {
        return axiom.asSubObjectPropertyOfAxioms().stream().allMatch(ax -> (Boolean)ax.accept((OWLAxiomVisitorEx)this));
    }

    public Boolean visit(OWLHasKeyAxiom axiom) {
        throw new UnsupportedEntailmentTypeException((OWLAxiom)axiom);
    }

    public Boolean visit(OWLDatatypeDefinitionAxiom axiom) {
        throw new UnsupportedEntailmentTypeException((OWLAxiom)axiom);
    }

    public Boolean visit(SWRLRule rule) {
        throw new UnsupportedEntailmentTypeException((OWLAxiom)rule);
    }

    public Boolean visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        return Boolean.FALSE;
    }

    public Boolean visit(OWLAnnotationPropertyDomainAxiom axiom) {
        return Boolean.FALSE;
    }

    public Boolean visit(OWLAnnotationPropertyRangeAxiom axiom) {
        return Boolean.FALSE;
    }
}

