/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataRangeVisitorEx;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.impl.DefaultNode;
import org.semanticweb.owlapi.reasoner.impl.DefaultNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLDatatypeNode;
import org.semanticweb.owlapi.reasoner.impl.OWLDatatypeNodeSet;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.jfact.OWLEntityTranslator;
import uk.ac.manchester.cs.jfact.TranslationMachinery;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeExpression;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facet;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.kernel.ExpressionCache;
import uk.ac.manchester.cs.jfact.kernel.ExpressionManager;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataExpression;

public class DataRangeTranslator
extends OWLEntityTranslator<OWLDatatype, DataExpression>
implements OWLDataRangeVisitorEx<DataExpression> {
    private final DatatypeFactory f;

    public DataRangeTranslator(ExpressionCache em, OWLDataFactory df, TranslationMachinery tr, DatatypeFactory f) {
        super(em, df, tr);
        this.f = f;
    }

    @Override
    @Nullable
    protected DataExpression getTopEntityPointer() {
        return ExpressionManager.dataTop();
    }

    @Override
    @Nullable
    protected DataExpression getBottomEntityPointer() {
        return null;
    }

    @Override
    protected DefaultNode<OWLDatatype> createDefaultNode(Stream<OWLDatatype> stream) {
        return new OWLDatatypeNode(stream);
    }

    @Override
    @Nullable
    protected OWLDatatype getTopEntity() {
        return this.df.getTopDatatype();
    }

    @Override
    @Nullable
    protected OWLDatatype getBottomEntity() {
        return null;
    }

    @Override
    protected DefaultNodeSet<OWLDatatype> createDefaultNodeSet(Stream<Node<OWLDatatype>> stream) {
        return new OWLDatatypeNodeSet(stream);
    }

    @Override
    protected DataExpression createPointerForEntity(OWLDatatype entity) {
        return this.f.getKnownDatatype(entity.getIRI());
    }

    public Datatype<?> visit(OWLDatatype node) {
        return this.f.getKnownDatatype(node.getIRI());
    }

    public DataExpression visit(OWLDataOneOf node) {
        return ExpressionManager.dataOneOf(OWLAPIStreamUtils.asList(node.values().map(this.tr::pointer)));
    }

    public DataExpression visit(OWLDataComplementOf node) {
        return ExpressionManager.dataNot((DataExpression)node.getDataRange().accept((OWLDataRangeVisitorEx)this));
    }

    public DataExpression visit(OWLDataIntersectionOf node) {
        return ExpressionManager.dataAnd(this.translateDataRangeSet(node.operands()));
    }

    private List<DataExpression> translateDataRangeSet(Stream<? extends OWLDataRange> dataRanges) {
        return OWLAPIStreamUtils.asList(dataRanges.map(op -> (DataExpression)op.accept((OWLDataRangeVisitorEx)this)));
    }

    public DataExpression visit(OWLDataUnionOf node) {
        return ExpressionManager.dataOr(this.translateDataRangeSet(node.operands()));
    }

    public DataExpression visit(OWLDatatypeRestriction node) {
        Datatype type = this.f.getKnownDatatype(node.getDatatype().getIRI());
        Iterator facetRestrictions = node.facetRestrictions().iterator();
        if (!facetRestrictions.hasNext()) {
            return type;
        }
        DatatypeExpression toReturn = type.isNumericDatatype() ? type.wrapAsNumericExpression() : (type.isOrderedDatatype() ? type.wrapAsOrderedExpression() : type.wrapAsDatatypeExpression());
        while (facetRestrictions.hasNext()) {
            OWLFacetRestriction restriction = (OWLFacetRestriction)facetRestrictions.next();
            Literal<?> dv = this.tr.pointer(restriction.getFacetValue());
            Facet facet = Facets.parse(restriction.getFacet());
            toReturn = facet.isNumberFacet() ? toReturn.addNumericFacet(facet, (Comparable<?>)dv.typedValue()) : toReturn.addNonNumericFacet(facet, (Comparable<?>)dv.typedValue());
        }
        return toReturn;
    }
}

