/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.todolist;

import conformance.PortedFrom;
import java.io.Serializable;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.DagTag;

@PortedFrom(file="PriorityMatrix.h", name="ToDoPriorMatrix")
public class ToDoPriorMatrix
implements Serializable {
    @PortedFrom(file="PriorityMatrix.h", name="nRegularOps")
    public static final int NREGULAROPTIONS = 7;
    @PortedFrom(file="PriorityMatrix.h", name="iId")
    protected static final int PRIORITYINDEXID = 8;
    @PortedFrom(file="PriorityMatrix.h", name="iNN")
    protected static final int PRIORITYINDEXNOMINALNODE = 9;
    @PortedFrom(file="PriorityMatrix.h", name="iAnd")
    private int indexAnd;
    @PortedFrom(file="PriorityMatrix.h", name="iOr")
    private int indexOr;
    @PortedFrom(file="PriorityMatrix.h", name="iExists")
    private int indexExists;
    @PortedFrom(file="PriorityMatrix.h", name="iForAll")
    private int indexForall;
    @PortedFrom(file="PriorityMatrix.h", name="iLE")
    private int indexLE;
    @PortedFrom(file="PriorityMatrix.h", name="iGE")
    private int indexGE;

    @PortedFrom(file="PriorityMatrix.h", name="initPriorities")
    public void initPriorities(String options) {
        if (options.length() < 7) {
            throw new ReasonerInternalException("ToDo List option string should have length 7");
        }
        this.indexAnd = options.charAt(1) - 48;
        this.indexOr = options.charAt(2) - 48;
        this.indexExists = options.charAt(3) - 48;
        this.indexForall = options.charAt(4) - 48;
        this.indexLE = options.charAt(5) - 48;
        this.indexGE = options.charAt(6) - 48;
        if (this.indexAnd >= 7 || this.indexOr >= 7 || this.indexExists >= 7 || this.indexForall >= 7 || this.indexGE >= 7 || this.indexLE >= 7) {
            throw new ReasonerInternalException("ToDo List option out of range");
        }
    }

    @PortedFrom(file="PriorityMatrix.h", name="getIndex")
    public int getIndex(DagTag op, boolean sign, boolean nominalNode) {
        switch (op) {
            case AND: {
                return sign ? this.indexAnd : this.indexOr;
            }
            case FORALL: 
            case IRR: {
                return sign ? this.indexForall : this.indexExists;
            }
            case PROJ: 
            case CHOOSE: {
                return this.indexOr;
            }
            case LE: {
                return sign ? (nominalNode ? 9 : this.indexLE) : this.indexGE;
            }
            case DATATYPE: 
            case DATAVALUE: 
            case DATAEXPR: 
            case NN: 
            case TOP: {
                return 7;
            }
            case PSINGLETON: 
            case PCONCEPT: {
                return sign ? 8 : 7;
            }
            case NSINGLETON: 
            case NCONCEPT: {
                return 8;
            }
        }
        throw new UnreachableSituationException("Error: " + (Object)((Object)op));
    }
}

