/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.todolist;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import uk.ac.manchester.cs.jfact.helpers.SaveStack;
import uk.ac.manchester.cs.jfact.kernel.ConceptWDep;
import uk.ac.manchester.cs.jfact.kernel.DagTag;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.SaveStackRare;
import uk.ac.manchester.cs.jfact.kernel.todolist.ArrayQueue;
import uk.ac.manchester.cs.jfact.kernel.todolist.QueueQueue;
import uk.ac.manchester.cs.jfact.kernel.todolist.TODOListSaveState;
import uk.ac.manchester.cs.jfact.kernel.todolist.ToDoEntry;
import uk.ac.manchester.cs.jfact.kernel.todolist.ToDoPriorMatrix;

@PortedFrom(file="ToDoList.h", name="ToDoList")
public class ToDoList
implements Serializable {
    @PortedFrom(file="ToDoList.h", name="queueID")
    private final ArrayQueue queueID = new ArrayQueue();
    @PortedFrom(file="ToDoList.h", name="queueNN")
    private final QueueQueue queueNN;
    @PortedFrom(file="ToDoList.h", name="Wait")
    private final List<ArrayQueue> waitQueue = new ArrayList<ArrayQueue>(7);
    @PortedFrom(file="ToDoList.h", name="SaveStack")
    private final SaveStack<TODOListSaveState> saveStack = new SaveStack();
    @PortedFrom(file="ToDoList.h", name="Matrix")
    private final ToDoPriorMatrix matrix = new ToDoPriorMatrix();
    @PortedFrom(file="ToDoList.h", name="noe")
    private int noe;

    public ToDoList(SaveStackRare r) {
        this.queueNN = new QueueQueue(r);
        this.noe = 0;
        for (int i = 0; i < 7; ++i) {
            this.waitQueue.add(new ArrayQueue());
        }
    }

    @PortedFrom(file="ToDoList.h", name="saveState")
    public void saveState(TODOListSaveState tss) {
        tss.backupIDsp = this.queueID.getsPointer();
        tss.backupIDep = this.queueID.getWaitSize();
        this.queueNN.save(tss);
        tss.backup6key = this.waitQueue.get(6).getsPointer();
        tss.backup6value = this.waitQueue.get(6).getWaitSize();
        tss.backup5key = this.waitQueue.get(5).getsPointer();
        tss.backup5value = this.waitQueue.get(5).getWaitSize();
        tss.backup4key = this.waitQueue.get(4).getsPointer();
        tss.backup4value = this.waitQueue.get(4).getWaitSize();
        tss.backup3key = this.waitQueue.get(3).getsPointer();
        tss.backup3value = this.waitQueue.get(3).getWaitSize();
        tss.backup2key = this.waitQueue.get(2).getsPointer();
        tss.backup2value = this.waitQueue.get(2).getWaitSize();
        tss.backup1key = this.waitQueue.get(1).getsPointer();
        tss.backup1value = this.waitQueue.get(1).getWaitSize();
        tss.backup0key = this.waitQueue.get(0).getsPointer();
        tss.backup0value = this.waitQueue.get(0).getWaitSize();
        tss.noe = this.noe;
    }

    @PortedFrom(file="ToDoList.h", name="restoreState")
    public void restoreState(TODOListSaveState tss) {
        this.queueID.restore(tss.backupIDsp, tss.backupIDep);
        this.queueNN.restore(tss);
        this.waitQueue.get(0).restore(tss.backup0key, tss.backup0value);
        this.waitQueue.get(1).restore(tss.backup1key, tss.backup1value);
        this.waitQueue.get(2).restore(tss.backup2key, tss.backup2value);
        this.waitQueue.get(3).restore(tss.backup3key, tss.backup3value);
        this.waitQueue.get(4).restore(tss.backup4key, tss.backup4value);
        this.waitQueue.get(5).restore(tss.backup5key, tss.backup5value);
        this.waitQueue.get(6).restore(tss.backup6key, tss.backup6value);
        this.noe = tss.noe;
    }

    @Original
    public void initPriorities(String options) {
        this.matrix.initPriorities(options);
    }

    @PortedFrom(file="ToDoList.h", name="clear")
    public void clear() {
        this.queueID.clear();
        this.queueNN.clear();
        for (int i = 6; i >= 0; --i) {
            this.waitQueue.get(i).clear();
        }
        this.saveStack.clear();
        this.noe = 0;
    }

    public boolean isEmpty() {
        return this.noe == 0;
    }

    @PortedFrom(file="ToDoList.h", name="addEntry")
    public void addEntry(DlCompletionTree node, DagTag type, ConceptWDep c) {
        int index = this.matrix.getIndex(type, c.getConcept() > 0, node.isNominalNode());
        switch (index) {
            case 7: {
                return;
            }
            case 8: {
                this.queueID.add(node, c);
                break;
            }
            case 9: {
                this.queueNN.add(node, c);
                break;
            }
            default: {
                this.waitQueue.get(index).add(node, c);
            }
        }
        ++this.noe;
    }

    @PortedFrom(file="ToDoList.h", name="save")
    public void save() {
        TODOListSaveState state = new TODOListSaveState();
        this.saveState(state);
        this.saveStack.push(state);
    }

    @PortedFrom(file="ToDoList.h", name="restore")
    public void restore(int level) {
        this.restoreState(this.saveStack.pop(level));
    }

    @Nullable
    @PortedFrom(file="ToDoList.h", name="getNextEntry")
    public ToDoEntry getNextEntry() {
        assert (!this.isEmpty());
        --this.noe;
        if (!this.queueID.isEmpty()) {
            return this.queueID.get();
        }
        if (!this.queueNN.isEmpty()) {
            return this.queueNN.get();
        }
        for (int i = 0; i < 7; ++i) {
            ArrayQueue arrayQueue = this.waitQueue.get(i);
            if (arrayQueue.isEmpty()) continue;
            return arrayQueue.get();
        }
        return null;
    }

    public String toString() {
        StringBuilder l = new StringBuilder("Todolist{");
        l.append('\n');
        l.append(this.queueID);
        l.append('\n');
        for (int i = 0; i < 7; ++i) {
            l.append(this.waitQueue.get(i));
            l.append('\n');
        }
        l.append('\n');
        l.append('}');
        return l.toString();
    }
}

