/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.todolist;

import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.kernel.ConceptWDep;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.Restorer;
import uk.ac.manchester.cs.jfact.kernel.SaveStackRare;
import uk.ac.manchester.cs.jfact.kernel.todolist.TODOListSaveState;
import uk.ac.manchester.cs.jfact.kernel.todolist.ToDoEntry;

public class QueueQueue
implements Serializable {
    List<ToDoEntry> wait = new ArrayList<ToDoEntry>();
    SaveStackRare stack;
    int sPointer = 0;
    private int size = 0;

    public QueueQueue(SaveStackRare rare) {
        this.stack = rare;
    }

    protected void add(DlCompletionTree node, ConceptWDep offset) {
        int n;
        ToDoEntry e = new ToDoEntry(node, offset);
        if (this.isEmpty() || this.wait.get(this.size - 1).getNode().getNominalLevel() <= node.getNominalLevel()) {
            this.wait.add(e);
            ++this.size;
            return;
        }
        this.stack.push(new QueueRestorer(this));
        for (n = this.size; n > this.sPointer && this.wait.get(n - 1).getNode().getNominalLevel() > node.getNominalLevel(); --n) {
        }
        this.wait.add(n, e);
        ++this.size;
    }

    @PortedFrom(file="ToDoList.h", name="clear")
    protected void clear() {
        this.sPointer = 0;
        this.wait.clear();
        this.size = 0;
    }

    protected boolean isEmpty() {
        return this.sPointer == this.size;
    }

    protected ToDoEntry get() {
        return this.wait.get(this.sPointer++);
    }

    @PortedFrom(file="ToDoList.h", name="save")
    protected void save(TODOListSaveState tss) {
        tss.sp = this.sPointer;
        tss.ep = this.size;
    }

    @PortedFrom(file="ToDoList.h", name="restore")
    protected void restore(TODOListSaveState tss) {
        this.sPointer = tss.sp;
        Helper.resize(this.wait, tss.ep);
        this.size = tss.ep;
    }

    public String toString() {
        return "{" + (!this.isEmpty() ? (Serializable)this.wait.get(this.sPointer) : "empty") + " sPointer: " + this.sPointer + " size: " + this.size + " Wait: " + this.wait + '}';
    }

    class QueueRestorer
    extends Restorer {
        List<ToDoEntry> restorerWait = new ArrayList<ToDoEntry>();
        QueueQueue queue;
        int sp;

        QueueRestorer(QueueQueue q) {
            this.restorerWait = q.wait;
            this.queue = q;
            this.sp = q.sPointer;
        }

        @Override
        public void restore() {
            this.queue.wait = this.restorerWait;
            this.queue.sPointer = this.sp;
        }
    }
}

