/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.todolist;

import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.kernel.ConceptWDep;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.todolist.ToDoEntry;

public class ArrayQueue
implements Serializable {
    private final List<ToDoEntry> wait = new ArrayList<ToDoEntry>(50);
    private int sPointer = 0;

    public void add(DlCompletionTree node, ConceptWDep offset) {
        this.wait.add(new ToDoEntry(node, offset));
    }

    @PortedFrom(file="ToDoList.h", name="clear")
    public void clear() {
        this.setsPointer(0);
        this.wait.clear();
    }

    @PortedFrom(file="ToDoList.h", name="empty")
    public boolean isEmpty() {
        return this.sPointer == this.wait.size();
    }

    public ToDoEntry get() {
        return this.wait.get(this.sPointer++);
    }

    @PortedFrom(file="ToDoList.h", name="save")
    public void save(int[][] tss, int pos) {
        tss[pos][0] = this.sPointer;
        tss[pos][1] = this.wait.size();
    }

    @PortedFrom(file="ToDoList.h", name="restore")
    public void restore(int[][] tss, int pos) {
        this.setsPointer(tss[pos][0]);
        Helper.resize(this.wait, tss[pos][1]);
    }

    @PortedFrom(file="ToDoList.h", name="restore")
    public void restore(int sp, int ep) {
        this.setsPointer(sp);
        Helper.resize(this.wait, ep);
    }

    public String toString() {
        return "ArrayQueue{" + this.sPointer + "," + this.wait.stream().map(Object::toString).collect(Collectors.joining(" ")) + "}";
    }

    public int getsPointer() {
        return this.sPointer;
    }

    public void setsPointer(int sPointer) {
        this.sPointer = sPointer;
    }

    public int getWaitSize() {
        return this.wait.size();
    }
}

