/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.modelcaches;

import conformance.PortedFrom;
import java.util.BitSet;
import java.util.stream.Stream;
import uk.ac.manchester.cs.chainsaw.FastSet;
import uk.ac.manchester.cs.chainsaw.FastSetFactory;
import uk.ac.manchester.cs.jfact.helpers.DLVertex;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.ConceptWDep;
import uk.ac.manchester.cs.jfact.kernel.DLDag;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.RAStateTransitions;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheInterface;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheSingleton;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheState;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheType;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;

@PortedFrom(file="modelCacheIan.h", name="modelCacheIan")
public class ModelCacheIan
extends ModelCacheInterface {
    @PortedFrom(file="modelCacheIan.h", name="posDConcepts")
    private final BitSet posDConcepts = new BitSet();
    @PortedFrom(file="modelCacheIan.h", name="posNConcepts")
    private final BitSet posNConcepts = new BitSet();
    @PortedFrom(file="modelCacheIan.h", name="negDConcepts")
    private final BitSet negDConcepts = new BitSet();
    @PortedFrom(file="modelCacheIan.h", name="negNConcepts")
    private final BitSet negNConcepts = new BitSet();
    @PortedFrom(file="modelCacheIan.h", name="extraDConcepts")
    private final FastSet extraDConcepts = FastSetFactory.create();
    @PortedFrom(file="modelCacheIan.h", name="extraNConcepts")
    private final FastSet extraNConcepts = FastSetFactory.create();
    @PortedFrom(file="modelCacheIan.h", name="existsRoles")
    private final FastSet existsRoles = FastSetFactory.create();
    @PortedFrom(file="modelCacheIan.h", name="forallRoles")
    private final FastSet forallRoles = FastSetFactory.create();
    @PortedFrom(file="modelCacheIan.h", name="funcRoles")
    private final FastSet funcRoles = FastSetFactory.create();
    @PortedFrom(file="modelCacheIan.h", name="curState")
    private ModelCacheState curState = ModelCacheState.VALID;
    private final int nC;
    private final int nR;
    private final JFactReasonerConfiguration simpleRules;

    public ModelCacheIan(DLDag heap, DlCompletionTree p, boolean flagNominals, int nC, int nR, JFactReasonerConfiguration simpleRules) {
        this(flagNominals, nC, nR, simpleRules);
        this.initCacheByLabel(heap, p);
        this.initRolesFromArcs(p);
    }

    public ModelCacheIan(boolean flagNominals, int nC, int nR, JFactReasonerConfiguration simpleRules) {
        super(flagNominals);
        this.simpleRules = simpleRules;
        this.nC = nC;
        this.nR = nR;
    }

    @PortedFrom(file="modelCacheIan.h", name="processLabelInterval")
    private void processLabelInterval(DLDag dlHeap, Stream<ConceptWDep> start) {
        start.forEach(p -> this.processConcept(dlHeap.get(p.getConcept()), p.getConcept() > 0, p.getDep().isEmpty()));
    }

    @PortedFrom(file="modelCacheIan.h", name="initCacheByLabel")
    private void initCacheByLabel(DLDag dlHeap, DlCompletionTree pCT) {
        this.processLabelInterval(dlHeap, pCT.simpleConcepts().stream());
        this.processLabelInterval(dlHeap, pCT.complexConcepts().stream());
    }

    @Override
    @PortedFrom(file="modelCacheIan.h", name="getState")
    public ModelCacheState getState() {
        return this.curState;
    }

    @PortedFrom(file="modelCacheIan.h", name="getDConcepts")
    private BitSet getDConcepts(boolean pos) {
        return pos ? this.posDConcepts : this.negDConcepts;
    }

    @PortedFrom(file="modelCacheIan.h", name="getNConcepts")
    private BitSet getNConcepts(boolean pos) {
        return pos ? this.posNConcepts : this.negNConcepts;
    }

    @PortedFrom(file="modelCacheIan.h", name="getExtra")
    private FastSet getExtra(boolean det) {
        return det ? this.extraDConcepts : this.extraNConcepts;
    }

    @PortedFrom(file="modelCacheIan.h", name="initRolesFromArcs")
    public void initRolesFromArcs(DlCompletionTree pCT) {
        pCT.getNeighbour().stream().filter(p -> !p.isIBlocked()).forEach(p -> this.addExistsRole(p.getRole()));
        this.curState = ModelCacheState.VALID;
    }

    @Override
    @PortedFrom(file="modelCacheIan.h", name="getCacheType")
    public ModelCacheType getCacheType() {
        return ModelCacheType.IAN;
    }

    @Override
    @PortedFrom(file="modelCacheIan.h", name="shallowCache")
    public boolean shallowCache() {
        return this.existsRoles.isEmpty();
    }

    @PortedFrom(file="modelCacheIan.h", name="clear")
    public void clear() {
        this.posDConcepts.clear();
        this.posNConcepts.clear();
        this.negDConcepts.clear();
        this.negNConcepts.clear();
        if (this.simpleRules.isUseSimpleRules()) {
            this.extraDConcepts.clear();
            this.extraNConcepts.clear();
        }
        this.existsRoles.clear();
        this.forallRoles.clear();
        this.funcRoles.clear();
        this.curState = ModelCacheState.VALID;
    }

    @PortedFrom(file="modelCacheIan.h", name="processConcept")
    public void processConcept(DLVertex cur, boolean pos, boolean det) {
        switch (cur.getType()) {
            case TOP: 
            case DATATYPE: 
            case DATAVALUE: 
            case DATAEXPR: {
                throw new UnreachableSituationException(cur.toString() + " Top datatype property, datatype, data value or data expression used in an unexpected position");
            }
            case NCONCEPT: 
            case PCONCEPT: 
            case NSINGLETON: 
            case PSINGLETON: {
                int toAdd = ((ClassifiableEntry)cur.getConcept()).getIndex();
                (det ? this.getDConcepts(pos) : this.getNConcepts(pos)).set(toAdd);
                break;
            }
            case IRR: 
            case FORALL: 
            case LE: {
                if (cur.getRole().isTop()) {
                    (pos ? this.forallRoles : this.existsRoles).completeSet(this.nR);
                    break;
                }
                if (!pos) break;
                if (cur.getRole().isSimple()) {
                    this.forallRoles.add(cur.getRole().getIndex());
                    break;
                }
                this.processAutomaton(cur);
                break;
            }
        }
    }

    @PortedFrom(file="modelCacheIan.h", name="processAutomaton")
    public void processAutomaton(DLVertex cur) {
        RAStateTransitions rst = cur.getRole().getAutomaton().get(cur.getState());
        rst.begin().stream().flatMap(p -> p.begin().stream()).forEach(r -> this.forallRoles.add(r.getIndex()));
    }

    @PortedFrom(file="modelCacheIan.h", name="addRoleToCache")
    private void addRoleToCache(Role r) {
        this.existsRoles.add(r.getIndex());
        if (r.isTopFunc()) {
            this.funcRoles.add(r.getIndex());
        }
    }

    @PortedFrom(file="modelCacheIan.h", name="addExistsRole")
    private void addExistsRole(Role r) {
        this.addRoleToCache(r);
        r.getAncestor().forEach(this::addRoleToCache);
    }

    @Override
    @PortedFrom(file="modelCacheIan.h", name="canMerge")
    public ModelCacheState canMerge(ModelCacheInterface p) {
        if (this.hasNominalClash(p)) {
            return ModelCacheState.FAILED;
        }
        if (p.getState() != ModelCacheState.VALID || this.curState != ModelCacheState.VALID) {
            return ModelCacheIan.mergeStatus(p.getState(), this.curState);
        }
        switch (p.getCacheType()) {
            case CONST: {
                return ModelCacheState.VALID;
            }
            case SINGLETON: {
                int singleton = ((ModelCacheSingleton)p).getValue();
                return this.isMergableSingleton(Math.abs(singleton), singleton > 0);
            }
            case IAN: {
                return this.isMergableIan((ModelCacheIan)p);
            }
        }
        return ModelCacheState.UNKNOWN;
    }

    @PortedFrom(file="modelCacheIan.h", name="isMergableSingleton")
    public ModelCacheState isMergableSingleton(int singleton, boolean pos) {
        assert (singleton != 0);
        if (this.getDConcepts(!pos).get(singleton)) {
            return ModelCacheState.INVALID;
        }
        if (this.getNConcepts(!pos).get(singleton)) {
            return ModelCacheState.FAILED;
        }
        return ModelCacheState.VALID;
    }

    @PortedFrom(file="modelCacheIan.h", name="isMergableIan")
    public ModelCacheState isMergableIan(ModelCacheIan q) {
        if (this.posDConcepts.intersects(q.negDConcepts) || q.posDConcepts.intersects(this.negDConcepts)) {
            return ModelCacheState.INVALID;
        }
        if (this.existsRoles.intersect(q.forallRoles) || q.existsRoles.intersect(this.forallRoles) || this.funcRoles.intersect(q.funcRoles) || this.posDConcepts.intersects(q.negNConcepts) || this.posNConcepts.intersects(q.negDConcepts) || this.posNConcepts.intersects(q.negNConcepts) || q.posDConcepts.intersects(this.negNConcepts) || q.posNConcepts.intersects(this.negDConcepts) || q.posNConcepts.intersects(this.negNConcepts)) {
            return ModelCacheState.FAILED;
        }
        if (this.simpleRules.isUseSimpleRules() && this.getExtra(true).intersect(q.getExtra(true))) {
            return ModelCacheState.INVALID;
        }
        if (this.simpleRules.isUseSimpleRules() && (this.getExtra(true).intersect(q.getExtra(false)) || this.getExtra(false).intersect(q.getExtra(true)) || this.getExtra(false).intersect(q.getExtra(false)))) {
            return ModelCacheState.FAILED;
        }
        return ModelCacheState.VALID;
    }

    @PortedFrom(file="modelCacheIan.h", name="merge")
    public ModelCacheState merge(ModelCacheInterface p) {
        assert (p != null);
        if (this.hasNominalClash(p)) {
            this.curState = ModelCacheState.FAILED;
            return this.curState;
        }
        switch (p.getCacheType()) {
            case CONST: {
                this.curState = ModelCacheIan.mergeStatus(this.curState, p.getState());
                break;
            }
            case SINGLETON: {
                int em = ((ModelCacheSingleton)p).getValue();
                this.mergeSingleton(Math.abs(em), em > 0);
                break;
            }
            case IAN: {
                this.mergeIan((ModelCacheIan)p);
                break;
            }
            default: {
                throw new UnreachableSituationException();
            }
        }
        this.updateNominalStatus(p);
        return this.curState;
    }

    @PortedFrom(file="modelCacheIan.h", name="mergeSingleton")
    private void mergeSingleton(int singleton, boolean pos) {
        ModelCacheState newState = this.isMergableSingleton(singleton, pos);
        if (newState != ModelCacheState.VALID) {
            this.curState = ModelCacheIan.mergeStatus(this.curState, newState);
        } else {
            this.getDConcepts(pos).set(singleton);
        }
    }

    @PortedFrom(file="modelCacheIan.h", name="mergeIan")
    private void mergeIan(ModelCacheIan p) {
        this.curState = this.isMergableIan(p);
        this.posDConcepts.or(p.posDConcepts);
        this.posNConcepts.or(p.posNConcepts);
        this.negDConcepts.or(p.negDConcepts);
        this.negNConcepts.or(p.negNConcepts);
        if (this.simpleRules.isUseSimpleRules()) {
            this.extraDConcepts.addAll(p.extraDConcepts);
            this.extraNConcepts.addAll(p.extraNConcepts);
        }
        this.existsRoles.addAll(p.existsRoles);
        this.forallRoles.addAll(p.forallRoles);
        this.funcRoles.addAll(p.funcRoles);
    }

    @Override
    @PortedFrom(file="modelCacheIan.h", name="logCacheEntry")
    public void logCacheEntry(int level, LogAdapter l) {
        l.print("\nIan cache: posDConcepts = {", this.posDConcepts, "}, posNConcepts = {", this.posNConcepts, "}, negDConcepts = {", this.negDConcepts, "}, negNConcepts = {", this.negNConcepts, "}, existsRoles = {", this.existsRoles, "}, forallRoles = {", this.forallRoles, "}, funcRoles = {", this.funcRoles, "}");
    }

    @PortedFrom(file="modelCacheInterface.h", name="mergeStatus")
    private static ModelCacheState mergeStatus(ModelCacheState s1, ModelCacheState s2) {
        if (s1 == ModelCacheState.INVALID || s2 == ModelCacheState.INVALID) {
            return ModelCacheState.INVALID;
        }
        if (s1 == ModelCacheState.FAILED || s2 == ModelCacheState.FAILED) {
            return ModelCacheState.FAILED;
        }
        if (s1 == ModelCacheState.UNKNOWN || s2 == ModelCacheState.UNKNOWN) {
            return ModelCacheState.UNKNOWN;
        }
        return ModelCacheState.VALID;
    }
}

