/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.helpers.Templates;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;

@PortedFrom(file="taxVertex.h", name="TaxonomyVertex")
public class TaxonomyVertex
implements Serializable {
    @PortedFrom(file="taxVertex.h", name="Links")
    private LinkedHashSet<TaxonomyVertex> linksParent = new LinkedHashSet();
    @PortedFrom(file="taxVertex.h", name="Links")
    private LinkedHashSet<TaxonomyVertex> linksChild = new LinkedHashSet();
    @PortedFrom(file="taxVertex.h", name="sample")
    private ClassifiableEntry sample = null;
    @PortedFrom(file="taxVertex.h", name="synonyms")
    private Set<ClassifiableEntry> synonyms = new LinkedHashSet<ClassifiableEntry>();
    @PortedFrom(file="taxVertex.h", name="checked")
    private long checked;
    @Original
    private long isValued;
    @PortedFrom(file="taxVertex.h", name="common")
    private int common;
    @PortedFrom(file="taxVertex.h", name="checkValue")
    private boolean checkValue;
    @PortedFrom(file="taxVertex.h", name="inUse")
    private boolean inUse = true;

    public TaxonomyVertex() {
        this.initFlags();
    }

    public TaxonomyVertex(ClassifiableEntry p) {
        this.initFlags();
        this.setSample(p, true);
    }

    @PortedFrom(file="taxVertex.h", name="setVertexAsHost")
    public void setVertexAsHost(ClassifiableEntry entry) {
        entry.setTaxVertex(this);
    }

    @PortedFrom(file="taxVertex.h", name="setSample")
    public void setSample(ClassifiableEntry entry, boolean linkBack) {
        this.sample = entry;
        if (linkBack) {
            this.setVertexAsHost(entry);
        }
    }

    @PortedFrom(file="taxVertex.h", name="neigh")
    public Stream<TaxonomyVertex> neigh(boolean upDirection) {
        return upDirection ? this.linksParent.stream() : this.linksChild.stream();
    }

    @PortedFrom(file="taxVertex.h", name="isChecked")
    public boolean isChecked(long checkLab) {
        return checkLab == this.checked;
    }

    @PortedFrom(file="taxVertex.h", name="setChecked")
    public void setChecked(long checkLab) {
        this.checked = checkLab;
    }

    @PortedFrom(file="taxVertex.h", name="isValued")
    public boolean isValued(long valueLab) {
        return valueLab == this.isValued;
    }

    @PortedFrom(file="taxVertex.h", name="getValue")
    public boolean getValue() {
        return this.checkValue;
    }

    @PortedFrom(file="taxVertex.h", name="setValued")
    public boolean setValued(boolean val, long valueLab) {
        this.isValued = valueLab;
        this.checkValue = val;
        return val;
    }

    @PortedFrom(file="taxVertex.h", name="isCommon")
    public boolean isCommon() {
        return this.common != 0;
    }

    @PortedFrom(file="taxVertex.h", name="setCommon")
    public void setCommon() {
        ++this.common;
    }

    @PortedFrom(file="taxVertex.h", name="clearCommon")
    public void clearCommon() {
        this.common = 0;
    }

    @PortedFrom(file="taxVertex.h", name="correctCommon")
    public boolean correctCommon(int n) {
        if (this.common == n) {
            return true;
        }
        this.common = 0;
        return false;
    }

    @PortedFrom(file="taxVertex.h", name="initFlags")
    private void initFlags() {
        this.checked = 0L;
        this.isValued = 0L;
        this.common = 0;
    }

    @PortedFrom(file="taxVertex.h", name="begin_syn")
    public Stream<ClassifiableEntry> synonyms() {
        return this.synonyms.stream();
    }

    @PortedFrom(file="taxVertex.h", name="addSynonym")
    public void addSynonym(ClassifiableEntry p) {
        this.synonyms.add(p);
        p.setTaxVertex(this);
    }

    @PortedFrom(file="taxVertex.h", name="clear")
    public void clear() {
        this.linksParent.clear();
        this.linksChild.clear();
        this.sample = null;
        this.initFlags();
    }

    @PortedFrom(file="taxVertex.h", name="getPrimer")
    public ClassifiableEntry getPrimer() {
        return this.sample;
    }

    @PortedFrom(file="taxVertex.h", name="addNeighbour")
    public void addNeighbour(boolean upDirection, TaxonomyVertex p) {
        OWLAPIPreconditions.checkNotNull((Object)p, (String)"p cannot be null");
        this.add(upDirection, p);
    }

    public void add(boolean direction, TaxonomyVertex t) {
        if (direction) {
            this.linksParent.add(t);
        } else {
            this.linksChild.add(t);
        }
    }

    @PortedFrom(file="taxVertex.h", name="noNeighbours")
    public boolean noNeighbours(boolean upDirection) {
        if (upDirection) {
            return this.linksParent.isEmpty();
        }
        return this.linksChild.isEmpty();
    }

    @Nullable
    @PortedFrom(file="taxVertex.h", name="getSynonymNode")
    public TaxonomyVertex getSynonymNode() {
        return Helper.elementFromIntersection(this.linksParent, this.linksChild).orElse(null);
    }

    @PortedFrom(file="taxVertex.h", name="clearLinks")
    public void clearLinks(boolean upDirection) {
        if (upDirection) {
            this.linksParent.clear();
        } else {
            this.linksChild.clear();
        }
    }

    @PortedFrom(file="taxVertex.h", name="removeLink")
    public boolean removeLink(boolean upDirection, TaxonomyVertex p) {
        if (upDirection) {
            return this.linksParent.remove(p);
        }
        return this.linksChild.remove(p);
    }

    @PortedFrom(file="taxVertex.h", name="incorporate")
    public void incorporate(JFactReasonerConfiguration c) {
        for (TaxonomyVertex d : this.linksChild) {
            for (TaxonomyVertex u2 : this.linksParent) {
                if (!d.removeLink(true, u2)) continue;
                u2.removeLink(false, d);
            }
            d.removeLink(true, this);
            d.addNeighbour(true, this);
        }
        this.neigh(true).forEach(u -> u.addNeighbour(false, this));
        if (c.isLoggingActive()) {
            LogAdapter logAdapter = c.getLog();
            logAdapter.printTemplate(Templates.INCORPORATE, this.sample.getIRI()).print((Object)this.names(this.linksParent)).print("} and down = {").print((Object)this.names(this.linksChild)).print("}");
        }
    }

    Iterable<IRI> names(Collection<TaxonomyVertex> l) {
        return OWLAPIStreamUtils.asList(l.stream().map(t -> t.sample.getIRI()));
    }

    @PortedFrom(file="taxVertex.h", name="removeLinks")
    public void removeLinks(boolean upDirection) {
        this.neigh(upDirection).forEach(p -> p.removeLink(!upDirection, this));
        this.clearLinks(upDirection);
    }

    @PortedFrom(file="taxVertex.h", name="remove")
    public void remove() {
        this.removeLinks(true);
        this.removeLinks(false);
        this.setInUse(false);
    }

    @PortedFrom(file="taxVertex.h", name="isInUse")
    public boolean isInUse() {
        return this.inUse;
    }

    @PortedFrom(file="taxVertex.h", name="setInUse")
    public void setInUse(boolean value) {
        this.inUse = value;
    }

    @PortedFrom(file="taxVertex.h", name="mergeIndepNode")
    public void mergeIndepNode(TaxonomyVertex node, Set<TaxonomyVertex> excludes, ClassifiableEntry curEntry) {
        if (!node.getPrimer().equals(curEntry)) {
            this.addSynonym(node.getPrimer());
        }
        node.synonyms().forEach(this::addSynonym);
        for (TaxonomyVertex p : this.linksParent) {
            if (!excludes.contains(p)) {
                this.addNeighbour(true, p);
            }
            p.removeLink(false, node);
        }
        for (TaxonomyVertex p : this.linksChild) {
            if (!excludes.contains(p)) {
                this.addNeighbour(false, p);
            }
            p.removeLink(true, node);
        }
    }

    @PortedFrom(file="taxVertex.h", name="printSynonyms")
    public String printSynonyms() {
        assert (this.sample != null);
        StringBuilder o = new StringBuilder();
        if (this.synonyms.isEmpty()) {
            o.append('\"').append((CharSequence)this.sample.getIRI()).append('\"');
        } else {
            o.append("(\"").append((CharSequence)this.sample.getIRI());
            o.append(this.synonyms().map(NamedEntry::getIRI).collect(Collectors.joining("\"=\"")));
            o.append("\")");
        }
        return o.toString();
    }

    @PortedFrom(file="taxVertex.h", name="printNeighbours")
    private static String printNeighbours(Collection<TaxonomyVertex> list) {
        StringBuilder o = new StringBuilder();
        o.append(" {").append(list.size()).append(':');
        ArrayList<TaxonomyVertex> l = new ArrayList<TaxonomyVertex>(list);
        l.sort((o1, o2) -> o1.getPrimer().getIRI().compareTo((OWLObject)o2.getPrimer().getIRI()));
        l.forEach(p -> o.append(" \"").append((CharSequence)p.sample.getIRI()).append('\"'));
        o.append('}');
        return o.toString();
    }

    public String toString() {
        return this.printSynonyms() + TaxonomyVertex.printNeighbours(this.linksParent) + TaxonomyVertex.printNeighbours(this.linksChild) + '\n';
    }
}

