/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.linked.TIntLinkedList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapitools.decomposition.Signature;
import uk.ac.manchester.cs.chainsaw.FastSet;
import uk.ac.manchester.cs.chainsaw.FastSetFactory;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeEntry;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeExpression;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.LiteralEntry;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeFactory;
import uk.ac.manchester.cs.jfact.helpers.DLVertex;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.helpers.Pair;
import uk.ac.manchester.cs.jfact.helpers.Templates;
import uk.ac.manchester.cs.jfact.helpers.Timer;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.AxiomSet;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.DIOp;
import uk.ac.manchester.cs.jfact.kernel.DLConceptTaxonomy;
import uk.ac.manchester.cs.jfact.kernel.DLDag;
import uk.ac.manchester.cs.jfact.kernel.DagTag;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.DlSatTester;
import uk.ac.manchester.cs.jfact.kernel.DumpInterface;
import uk.ac.manchester.cs.jfact.kernel.DumpLisp;
import uk.ac.manchester.cs.jfact.kernel.InAx;
import uk.ac.manchester.cs.jfact.kernel.Individual;
import uk.ac.manchester.cs.jfact.kernel.KBFlags;
import uk.ac.manchester.cs.jfact.kernel.KBStatus;
import uk.ac.manchester.cs.jfact.kernel.Lexeme;
import uk.ac.manchester.cs.jfact.kernel.LogicFeatures;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.NamedEntryCollection;
import uk.ac.manchester.cs.jfact.kernel.NominalReasoner;
import uk.ac.manchester.cs.jfact.kernel.Related;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.RoleMaster;
import uk.ac.manchester.cs.jfact.kernel.SimpleRule;
import uk.ac.manchester.cs.jfact.kernel.Taxonomy;
import uk.ac.manchester.cs.jfact.kernel.Token;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleName;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleName;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheConst;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheInterface;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheSingleton;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheState;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;

@PortedFrom(file="dlTBox.h", name="TBox")
public class TBox
implements Serializable {
    private static final String DONE_IN = " done in ";
    private static final String SECONDS = " seconds\n\n";
    @PortedFrom(file="dlTBox.h", name="relevance")
    private long relevance = 1L;
    @PortedFrom(file="dlTBox.h", name="DLHeap")
    private final DLDag dlHeap;
    @PortedFrom(file="dlTBox.h", name="stdReasoner")
    private DlSatTester stdReasoner = null;
    @PortedFrom(file="dlTBox.h", name="nomReasoner")
    private NominalReasoner nomReasoner;
    @PortedFrom(file="dlTBox.h", name="pTax")
    private Taxonomy pTax;
    @PortedFrom(file="dlTBox.h", name="pTaxCreator")
    private DLConceptTaxonomy pTaxCreator;
    @PortedFrom(file="dlTBox.h", name="pName2Sig")
    private Map<OWLEntity, Signature> pName2Sig;
    @Original
    private final JFactReasonerConfiguration config;
    @PortedFrom(file="dlTBox.h", name="Status")
    private KBStatus kbStatus;
    @PortedFrom(file="dlTBox.h", name="KBFeatures")
    private final LogicFeatures kbFeatures = new LogicFeatures();
    @PortedFrom(file="dlTBox.h", name="GCIFeatures")
    private final LogicFeatures gciFeatures = new LogicFeatures();
    @PortedFrom(file="dlTBox.h", name="NCFeatures")
    private LogicFeatures nominalCloudFeatures = new LogicFeatures();
    @PortedFrom(file="dlTBox.h", name="auxFeatures")
    private LogicFeatures auxFeatures = new LogicFeatures();
    @PortedFrom(file="dlTBox.h", name="curFeature")
    private LogicFeatures curFeature = null;
    @PortedFrom(file="dlTBox.h", name="pTemp")
    private Concept pTemp;
    @PortedFrom(file="dlTBox.h", name="pQuery")
    private Concept pQuery;
    @PortedFrom(file="dlTBox.h", name="concepts")
    private final NamedEntryCollection<Concept> concepts;
    @PortedFrom(file="dlTBox.h", name="individuals")
    private final NamedEntryCollection<Individual> individuals;
    @PortedFrom(file="dlTBox.h", name="ORM")
    private final RoleMaster objectRoleMaster;
    @PortedFrom(file="dlTBox.h", name="DRM")
    private final RoleMaster dataRoleMaster;
    @PortedFrom(file="dlTBox.h", name="Axioms")
    private AxiomSet axioms;
    @PortedFrom(file="dlTBox.h", name="RelatedI")
    private final List<Related> relatedIndividuals = new ArrayList<Related>();
    @PortedFrom(file="dlTBox.h", name="DifferentIndividuals")
    private final List<List<Individual>> differentIndividuals = new ArrayList<List<Individual>>();
    @PortedFrom(file="dlTBox.h", name="SimpleRules")
    private final List<SimpleRule> simpleRules = new ArrayList<SimpleRule>();
    @PortedFrom(file="dlTBox.h", name="T_G")
    private int internalisedGeneralAxiom;
    @PortedFrom(file="dlTBox.h", name="GCIs")
    private final KBFlags gcis = new KBFlags();
    @PortedFrom(file="dlTBox.h", name="RCCache")
    private final Map<DLTree, Concept> forallRCCache = new HashMap<DLTree, Concept>();
    @PortedFrom(file="dlTBox.h", name="auxConceptID")
    private int auxConceptID = 0;
    @PortedFrom(file="dlTBox.h", name="nNominalReferences")
    private int nNominalReferences;
    @PortedFrom(file="dlTBox.h", name="CInProcess")
    private final Set<Concept> conceptInProcess = new HashSet<Concept>();
    @PortedFrom(file="dlTBox.h", name="Fairness")
    private final List<Concept> fairness = new ArrayList<Concept>();
    @PortedFrom(file="dlTBox.h", name="duringClassification")
    private boolean duringClassification;
    @PortedFrom(file="dlTBox.h", name="nSkipBeforeBlock")
    private int nSkipBeforeBlock;
    @PortedFrom(file="dlTBox.h", name="isLikeGALEN")
    private boolean isLikeGALEN;
    @PortedFrom(file="dlTBox.h", name="isLikeWINE")
    private boolean isLikeWINE;
    @PortedFrom(file="dlTBox.h", name="consistent")
    private boolean consistent;
    @PortedFrom(file="dlTBox.h", name="preprocTime")
    private long preprocTime;
    @PortedFrom(file="dlTBox.h", name="consistTime")
    private long consistTime;
    @PortedFrom(file="dlTBox.h", name="nC")
    protected int nC = 0;
    @PortedFrom(file="dlTBox.h", name="nR")
    protected AtomicInteger nR = new AtomicInteger(0);
    @PortedFrom(file="dlTBox.h", name="ConceptMap")
    private final List<Concept> conceptMap = new ArrayList<Concept>();
    @PortedFrom(file="dlTBox.h", name="SameI")
    private final Map<Concept, Pair> sameIndividuals = new HashMap<Concept, Pair>();
    @PortedFrom(file="dlTBox.h", name="ToldSynonyms")
    private final Set<Concept> toldSynonyms = new HashSet<Concept>();
    @PortedFrom(file="dlTBox.h", name="Status")
    private KBStatus status;
    private Map<Concept, DLTree> extraConceptDefs = new HashMap<Concept, DLTree>();
    private InAx statistics = new InAx();
    @PortedFrom(file="dlTBox.h", name="arrayCD")
    private final List<Concept> arrayCD = new ArrayList<Concept>();
    @PortedFrom(file="dlTBox.h", name="arrayNoCD")
    private final List<Concept> arrayNoCD = new ArrayList<Concept>();
    @PortedFrom(file="dlTBox.h", name="arrayNP")
    private final List<Concept> arrayNP = new ArrayList<Concept>();
    @Original
    private int nItems = 0;
    @Original
    private final AtomicBoolean interrupted;
    @Original
    private final DatatypeFactory datatypeFactory;
    @PortedFrom(file="dlTBox.h", name="top")
    private Concept top;
    @PortedFrom(file="dlTBox.h", name="bottom")
    private Concept bottom;
    @PortedFrom(file="dlTBox.h", name="nRelevantCCalls")
    private long nRelevantCCalls;
    @PortedFrom(file="dlTBox.h", name="nRelevantBCalls")
    private long nRelevantBCalls;
    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="IV")
    private final IterableVec<Individual> iv = new IterableVec();
    @PortedFrom(file="ConjunctiveQueryFolding.cpp", name="concepts")
    private final TIntArrayList conceptsForQueryAnswering = new TIntArrayList();
    private OWLDataFactory df;

    public TBox(DatatypeFactory datatypeFactory, JFactReasonerConfiguration configuration, AtomicBoolean interrupted, OWLDataFactory df) {
        this.df = df;
        this.datatypeFactory = datatypeFactory;
        this.interrupted = interrupted;
        this.config = configuration;
        this.axioms = new AxiomSet(this);
        this.dlHeap = new DLDag(configuration);
        this.kbStatus = KBStatus.KBLOADING;
        this.pQuery = null;
        this.concepts = new NamedEntryCollection<Concept>("concept", name -> new Concept((IRI)name), this.config);
        this.individuals = new NamedEntryCollection<Individual>("individual", name -> new Individual((IRI)name), this.config);
        this.objectRoleMaster = new RoleMaster(false, new ObjectRoleName((OWLEntity)df.getOWLTopObjectProperty()), new ObjectRoleName((OWLEntity)df.getOWLBottomObjectProperty()), this.config);
        this.dataRoleMaster = new RoleMaster(true, new DataRoleName((OWLEntity)df.getOWLTopDataProperty()), new DataRoleName((OWLEntity)df.getOWLBottomDataProperty()), this.config);
        this.axioms = new AxiomSet(this);
        this.internalisedGeneralAxiom = 1;
        this.duringClassification = false;
        this.isLikeGALEN = false;
        this.isLikeWINE = false;
        this.consistent = true;
        this.preprocTime = 0L;
        this.consistTime = 0L;
        this.config.getLog().printTemplate(Templates.READ_CONFIG, this.config.getuseCompletelyDefined(), "useRelevantOnly(obsolete)", this.config.getdumpQuery(), this.config.getalwaysPreferEquals());
        this.axioms.initAbsorptionFlags(this.config.getabsorptionFlags());
        this.initTopBottom();
        this.setForbidUndefinedNames(false);
        this.initTaxonomy();
    }

    public InAx getStatistics() {
        return this.statistics;
    }

    @PortedFrom(file="dlTBox.h", name="i_begin")
    public Stream<Individual> individuals() {
        return this.individuals.getConcepts();
    }

    @PortedFrom(file="dlTBox.h", name="c_begin")
    public Stream<Concept> getConcepts() {
        return this.concepts.getConcepts();
    }

    @Original
    public JFactReasonerConfiguration getOptions() {
        return this.config;
    }

    @PortedFrom(file="dlTBox.h", name="getDataEntryByBP")
    public String getDataEntryByBP(int bp) {
        NamedEntry p = this.dlHeap.get(bp).getConcept();
        if (p instanceof DatatypeEntry) {
            return ((DatatypeEntry)p).getFacet().toString();
        }
        if (p instanceof LiteralEntry) {
            return ((LiteralEntry)p).getFacet().toString();
        }
        return "";
    }

    @PortedFrom(file="dlTBox.h", name="makeNonPrimitive")
    public DLTree makeNonPrimitive(Concept p, DLTree desc) {
        DLTree ret = p.makeNonPrimitive(desc);
        this.checkEarlySynonym(p);
        return ret;
    }

    @PortedFrom(file="dlTBox.h", name="checkEarlySynonym")
    public void checkEarlySynonym(Concept p) {
        if (p.isSynonym()) {
            return;
        }
        if (p.isPrimitive()) {
            return;
        }
        if (!p.getDescription().isCN()) {
            return;
        }
        p.setSynonym(this.getCI(p.getDescription()));
        p.initToldSubsumers();
    }

    @PortedFrom(file="dlTBox.h", name="processDisjoint")
    public void processDisjoint(List<DLTree> beg) {
        while (!beg.isEmpty()) {
            DLTree r = beg.remove(0);
            this.addSubsumeAxiom(r, DLTreeFactory.buildDisjAux(beg));
        }
    }

    @PortedFrom(file="dlTBox.h", name="reflexive2dag")
    public int reflexive2dag(Role r) {
        if (!r.isSimple()) {
            throw new ReasonerInternalException("Non simple role used as simple: " + r.getIRI());
        }
        return -this.dlHeap.add(new DLVertex(DagTag.IRR, 0, r, 0, null, this.dlHeap));
    }

    @PortedFrom(file="dlTBox.h", name="dataForall2dag")
    public int dataForall2dag(Role r, int c) {
        return this.dlHeap.add(new DLVertex(DagTag.FORALL, 0, r, c, null, this.dlHeap));
    }

    @PortedFrom(file="dlTBox.h", name="dataAtMost2dag")
    public int dataAtMost2dag(int n, Role r, int c) {
        return this.dlHeap.add(new DLVertex(DagTag.LE, n, r, c, null, this.dlHeap));
    }

    @PortedFrom(file="dlTBox.h", name="concept2dag")
    public int concept2dag(@Nullable Concept p) {
        if (p == null) {
            return 0;
        }
        if (!Helper.isValid(p.getpName())) {
            this.addConceptToHeap(p);
        }
        return p.resolveId();
    }

    @PortedFrom(file="dlTBox.h", name="processGCI")
    public void processGCI(DLTree c, DLTree d) {
        this.axioms.addAxiom(c, d);
    }

    @PortedFrom(file="dlTBox.h", name="AbsorbAxioms")
    public void absorbAxioms() {
        long nSynonyms = this.countSynonyms();
        this.axioms.absorb();
        if ((long)this.countSynonyms() > nSynonyms) {
            this.replaceAllSynonyms();
        }
        if (this.axioms.wasRoleAbsorptionApplied()) {
            this.initToldSubsumers();
        }
    }

    @PortedFrom(file="dlTBox.h", name="initToldSubsumers")
    public void initToldSubsumers() {
        this.concepts.getConcepts().filter(pc -> !pc.isSynonym()).forEach(pc -> pc.initToldSubsumers());
        this.individuals.getConcepts().filter(pi -> !pi.isSynonym()).forEach(pi -> pi.initToldSubsumers());
    }

    @PortedFrom(file="dlTBox.h", name="setToldTop")
    public void setToldTop() {
        this.concepts.getConcepts().forEach(pc -> pc.setToldTop(this.top));
        this.individuals.getConcepts().forEach(pi -> pi.setToldTop(this.top));
    }

    @PortedFrom(file="dlTBox.h", name="calculateTSDepth")
    public void calculateTSDepth() {
        this.concepts.getConcepts().forEach(pc -> pc.calculateTSDepth());
        this.individuals.getConcepts().forEach(pi -> pi.calculateTSDepth());
    }

    @PortedFrom(file="dlTBox.h", name="countSynonyms")
    public int countSynonyms() {
        long nSynonyms = this.concepts.getConcepts().filter(p -> p.isSynonym()).count();
        return (int)(nSynonyms += this.individuals.getConcepts().filter(p -> p.isSynonym()).count());
    }

    @PortedFrom(file="dlTBox.h", name="initRuleFields")
    public void initRuleFields(List<Concept> v, int index) {
        v.forEach(q -> q.addExtraRule(index));
    }

    @PortedFrom(file="dlTBox.h", name="fillsClassificationTag")
    public void fillsClassificationTag() {
        this.concepts.getConcepts().forEach(p -> p.getClassTag());
        this.individuals.getConcepts().forEach(p -> p.getClassTag());
    }

    @PortedFrom(file="dlTBox.h", name="setConceptIndex")
    public void setConceptIndex(Concept c) {
        c.setIndex(this.nC);
        this.conceptMap.add(c);
        ++this.nC;
    }

    @PortedFrom(file="dlTBox.h", name="reasonersInited")
    private boolean reasonersInited() {
        return this.stdReasoner != null;
    }

    @PortedFrom(file="dlTBox.h", name="getReasoner")
    public DlSatTester getReasoner() {
        assert (this.curFeature != null);
        if (this.curFeature.hasSingletons()) {
            return this.nomReasoner;
        }
        return this.stdReasoner;
    }

    @PortedFrom(file="dlTBox.h", name="PrintConcepts")
    public void printConcepts(LogAdapter o) {
        if (this.concepts.size() == 0) {
            return;
        }
        o.print("Concepts (").print(this.concepts.size()).print("):\n");
        this.concepts.getConcepts().forEach(pc -> this.printConcept(o, (Concept)pc));
    }

    @PortedFrom(file="dlTBox.h", name="PrintIndividuals")
    public void printIndividuals(LogAdapter o) {
        if (this.individuals.size() == 0) {
            return;
        }
        o.print("Individuals (").print(this.individuals.size()).print("):\n");
        this.individuals.getConcepts().forEach(pi -> this.printConcept(o, (Concept)pi));
    }

    @PortedFrom(file="dlTBox.h", name="PrintSimpleRules")
    public void printSimpleRules(LogAdapter o) {
        if (this.simpleRules.isEmpty() || !o.isEnabled()) {
            return;
        }
        o.print("Simple rules (").print(this.simpleRules.size()).print("):\n");
        for (SimpleRule p : this.simpleRules) {
            o.print(p.getBody().stream().map(NamedEntry::getIRI).collect(Collectors.joining(", ", "(", ")")));
            o.print((Object)" => ", (Object)p.tHead, (Object)"\n");
        }
    }

    @PortedFrom(file="dlTBox.h", name="PrintAxioms")
    public void printAxioms(LogAdapter o) {
        if (this.internalisedGeneralAxiom == 1) {
            return;
        }
        o.print("Axioms:\nT [=");
        this.printDagEntry(o, this.internalisedGeneralAxiom);
    }

    @PortedFrom(file="dlTBox.h", name="isIrreflexive")
    public boolean isIrreflexive(Role r) {
        assert (r != null);
        if (r.isDataRole()) {
            return true;
        }
        this.curFeature = this.kbFeatures;
        this.getReasoner().setBlockingMethod(this.isIRinQuery(), this.isNRinQuery());
        boolean result = this.getReasoner().checkIrreflexivity(r);
        this.clearFeatures();
        return result;
    }

    @PortedFrom(file="dlTBox.h", name="collectLogicFeature")
    private void collectLogicFeature(Concept p) {
        if (this.curFeature != null) {
            this.curFeature.fillConceptData(p);
        }
    }

    @PortedFrom(file="dlTBox.h", name="collectLogicFeature")
    private void collectLogicFeature(Role p) {
        if (this.curFeature != null) {
            this.curFeature.fillRoleData(p, p.inverse().isRelevant(this.relevance));
        }
    }

    @PortedFrom(file="dlTBox.h", name="collectLogicFeature")
    private void collectLogicFeature(DLVertex v, boolean pos) {
        if (this.curFeature != null) {
            this.curFeature.fillDAGData(v, pos);
        }
    }

    @PortedFrom(file="dlTBox.h", name="markGCIsRelevant")
    private void markGCIsRelevant() {
        this.setRelevant(this.internalisedGeneralAxiom);
    }

    @PortedFrom(file="dlTBox.h", name="markAllRelevant")
    private void markAllRelevant() {
        this.concepts.getConcepts().forEach(pc -> {
            if (!pc.isRelevant(this.relevance)) {
                ++this.nRelevantCCalls;
                pc.setRelevant(this.relevance);
                this.collectLogicFeature((Concept)pc);
                this.setRelevant(pc.getpBody());
            }
        });
        this.individuals.getConcepts().forEach(pi -> {
            if (!pi.isRelevant(this.relevance)) {
                ++this.nRelevantCCalls;
                pi.setRelevant(this.relevance);
                this.collectLogicFeature((Concept)pi);
                this.setRelevant(pi.getpBody());
            }
        });
        this.markGCIsRelevant();
    }

    @PortedFrom(file="dlTBox.h", name="clearRelevanceInfo")
    public void clearRelevanceInfo() {
        ++this.relevance;
    }

    @PortedFrom(file="dlTBox.h", name="getFreshConcept")
    public DLTree getFreshConcept() {
        return DLTreeFactory.buildTree(new Lexeme(Token.CNAME, this.pTemp));
    }

    @PortedFrom(file="dlTBox.h", name="setConceptRelevant")
    private void setConceptRelevant(Concept p) {
        this.curFeature = p.getPosFeatures();
        this.setRelevant(p.getpBody());
        this.kbFeatures.or(p.getPosFeatures());
        this.collectLogicFeature(p);
        this.clearRelevanceInfo();
        if (p.isPrimitive()) {
            return;
        }
        this.curFeature = p.getNegFeatures();
        this.setRelevant(-p.getpBody());
        this.kbFeatures.or(p.getNegFeatures());
        this.clearRelevanceInfo();
    }

    @PortedFrom(file="dlTBox.h", name="updateAuxFeatures")
    private void updateAuxFeatures(LogicFeatures lf) {
        if (!lf.isEmpty()) {
            this.auxFeatures.or(lf);
            this.auxFeatures.mergeRoles();
        }
    }

    @PortedFrom(file="dlTBox.h", name="clearFeatures")
    public void clearFeatures() {
        this.curFeature = null;
    }

    @PortedFrom(file="dlTBox.h", name="getORM")
    public RoleMaster getORM() {
        return this.objectRoleMaster;
    }

    @PortedFrom(file="dlTBox.h", name="getDRM")
    public RoleMaster getDRM() {
        return this.dataRoleMaster;
    }

    @PortedFrom(file="dlTBox.h", name="getRM")
    public RoleMaster getRM(Role r) {
        return r.isDataRole() ? this.dataRoleMaster : this.objectRoleMaster;
    }

    @PortedFrom(file="dlTBox.h", name="getDag")
    public DLDag getDag() {
        return this.dlHeap;
    }

    @PortedFrom(file="dlTBox.h", name="getConcept")
    public Concept getConcept(IRI name) {
        return this.concepts.get(name);
    }

    @PortedFrom(file="dlTBox.h", name="getIndividual")
    public Individual getIndividual(IRI name) {
        return this.individuals.get(name);
    }

    @PortedFrom(file="dlTBox.h", name="isIndividual")
    private boolean isIndividual(IRI name) {
        return this.individuals.isRegistered(name);
    }

    @PortedFrom(file="dlTBox.h", name="isIndividual")
    public boolean isIndividual(DLTree tree) {
        return tree.token() == Token.INAME && this.isIndividual(tree.elem().getNE().getIRI());
    }

    @Nullable
    @PortedFrom(file="dlTBox.h", name="getCI")
    public Concept getCI(DLTree name) {
        if (name.isTOP()) {
            return this.top;
        }
        if (name.isBOTTOM()) {
            return this.bottom;
        }
        if (!name.isName()) {
            return null;
        }
        return (Concept)name.elem().getNE();
    }

    @Nullable
    @PortedFrom(file="dlTBox.h", name="getTree")
    public DLTree getTree(@Nullable Concept c) {
        if (c == null) {
            return null;
        }
        if (c.isTop()) {
            return DLTreeFactory.createTop();
        }
        if (c.isBottom()) {
            return DLTreeFactory.createBottom();
        }
        return DLTreeFactory.buildTree(new Lexeme(this.isIndividual(c.getIRI()) ? Token.INAME : Token.CNAME, c));
    }

    @PortedFrom(file="dlTBox.h", name="setForbidUndefinedNames")
    public boolean setForbidUndefinedNames(boolean val) {
        this.objectRoleMaster.setUndefinedNames(!val);
        this.dataRoleMaster.setUndefinedNames(!val);
        this.individuals.setLocked(val);
        return this.concepts.setLocked(val);
    }

    @PortedFrom(file="dlTBox.h", name="RegisterIndividualRelation")
    public void registerIndividualRelation(NamedEntry a, NamedEntry r, NamedEntry b) {
        if (!this.isIndividual(a.getIRI()) || !this.isIndividual(b.getIRI())) {
            throw new ReasonerInternalException("Individual expected in related()");
        }
        this.relatedIndividuals.add(new Related((Individual)a, (Individual)b, (Role)r));
        this.relatedIndividuals.add(new Related((Individual)b, (Individual)a, ((Role)r).inverse()));
    }

    @PortedFrom(file="dlTBox.h", name="addSubsumeAxiom")
    public void addSubsumeAxiom(Concept c, DLTree d) {
        this.addSubsumeAxiom(this.getTree(c), d);
    }

    @PortedFrom(file="dlTBox.h", name="addSimpleRule")
    private void addSimpleRule(SimpleRule rule) {
        this.initRuleFields(rule.getBody(), this.simpleRules.size());
        this.simpleRules.add(rule);
    }

    @PortedFrom(file="dlTBox.h", name="finishLoading")
    public void finishLoading() {
        this.setForbidUndefinedNames(true);
    }

    @PortedFrom(file="dlTBox.h", name="hasFC")
    public boolean hasFC() {
        return !this.fairness.isEmpty();
    }

    @PortedFrom(file="dlTBox.h", name="setFairnessConstraint")
    private void setFairnessConstraint(Collection<DLTree> c) {
        for (DLTree beg : c) {
            if (beg.isName()) {
                this.fairness.add(this.getCI(beg));
                continue;
            }
            Concept fc = this.getAuxConcept(null);
            this.fairness.add(fc);
            this.addEqualityAxiom(this.getTree(fc), beg);
        }
        if (this.config.getUseAnywhereBlocking() && this.hasFC()) {
            this.config.setUseAnywhereBlocking(false);
            this.config.getLog().print("\nFairness constraints: set useAnywhereBlocking = 0");
        }
    }

    @PortedFrom(file="dlTBox.h", name="setFairnessConstraint")
    public void setFairnessConstraintDLTrees(List<DLTree> l) {
        l.forEach(this::setFairnessConstraintDLTrees);
    }

    protected void setFairnessConstraintDLTrees(DLTree d) {
        Concept fc = this.getAuxConcept(null);
        this.fairness.add(fc);
        this.addSubsumeAxiom(d, this.getTree(fc));
    }

    @PortedFrom(file="dlTBox.h", name="getTG")
    public int getTG() {
        return this.internalisedGeneralAxiom;
    }

    @PortedFrom(file="dlTBox.h", name="getSimpleRule")
    public SimpleRule getSimpleRule(int index) {
        return this.simpleRules.get(index);
    }

    @PortedFrom(file="dlTBox.h", name="isIRinQuery")
    public boolean isIRinQuery() {
        if (this.curFeature != null) {
            return this.curFeature.hasInverseRole();
        }
        return this.kbFeatures.hasInverseRole();
    }

    @PortedFrom(file="dlTBox.h", name="isNRinQuery")
    public boolean isNRinQuery() {
        LogicFeatures p = this.curFeature != null ? this.curFeature : this.kbFeatures;
        return p.hasFunctionalRestriction() || p.hasNumberRestriction() || p.hasQNumberRestriction();
    }

    @PortedFrom(file="dlTBox.h", name="testHasNominals")
    public boolean testHasNominals() {
        if (this.curFeature != null) {
            return this.curFeature.hasSingletons();
        }
        return this.kbFeatures.hasSingletons();
    }

    @PortedFrom(file="dlTBox.h", name="testHasTopRole")
    public boolean testHasTopRole() {
        if (this.curFeature != null) {
            return this.curFeature.hasTopRole();
        }
        return this.kbFeatures.hasTopRole();
    }

    @PortedFrom(file="dlTBox.h", name="canUseSortedReasoning")
    public boolean canUseSortedReasoning() {
        return this.config.isUseSortedReasoning() && !this.gcis.isGCI() && !this.gcis.isReflexive();
    }

    @PortedFrom(file="dlTBox.h", name="performClassification")
    public void performClassification() {
        this.createTaxonomy(false);
    }

    @PortedFrom(file="dlTBox.h", name="performRealisation")
    public void performRealisation() {
        this.createTaxonomy(true);
    }

    @PortedFrom(file="dlTBox.h", name="getTaxonomy")
    public Taxonomy getTaxonomy() {
        return this.pTax;
    }

    @PortedFrom(file="dlTBox.h", name="getStatus")
    public KBStatus getStatus() {
        return this.kbStatus;
    }

    @PortedFrom(file="dlTBox.h", name="setConsistency")
    public void setConsistency(boolean val) {
        this.kbStatus = KBStatus.KBCHECKED;
        this.consistent = val;
    }

    @PortedFrom(file="dlTBox.h", name="isConsistent")
    public boolean isConsistent() {
        if (this.kbStatus.ordinal() < KBStatus.KBCHECKED.ordinal()) {
            this.prepareReasoning();
            if (this.kbStatus.ordinal() < KBStatus.KBCHECKED.ordinal() && this.consistent) {
                this.setConsistency(this.performConsistencyCheck());
            }
        }
        return this.consistent;
    }

    @PortedFrom(file="dlTBox.h", name="testSortedNonSubsumption")
    public boolean testSortedNonSubsumption(Concept p, @Nullable Concept q) {
        if (!this.canUseSortedReasoning()) {
            return false;
        }
        if (q == null) {
            return false;
        }
        return !this.dlHeap.haveSameSort(p.getpName(), q.getpName());
    }

    @PortedFrom(file="dlTBox.h", name="print")
    public void print() {
        this.dlHeap.printStat(this.config.getLog());
        this.objectRoleMaster.print(this.config.getLog(), "Object");
        this.dataRoleMaster.print(this.config.getLog(), "Data");
        this.printConcepts(this.config.getLog());
        this.printIndividuals(this.config.getLog());
        this.printSimpleRules(this.config.getLog());
        this.printAxioms(this.config.getLog());
        this.config.getLog().print((Object)this.dlHeap);
    }

    @PortedFrom(file="dlTBox.h", name="buildDAG")
    public void buildDAG() {
        int nInd;
        this.nNominalReferences = 0;
        this.nC = 1;
        this.conceptMap.add(null);
        this.concept2dag(this.pTemp);
        this.concepts.getConcepts().forEach(this::concept2dag);
        this.individuals.getConcepts().forEach(this::concept2dag);
        this.simpleRules.forEach(q -> q.setBpHead(this.tree2dag(q.tHead)));
        this.initRangeDomain(this.objectRoleMaster);
        this.initRangeDomain(this.dataRoleMaster);
        DLTree gci = this.axioms.getGCI();
        ArrayList<DLTree> list = new ArrayList<DLTree>();
        if (this.config.isUseSpecialDomains()) {
            this.objectRoleMaster.getRoles().stream().filter(p -> !p.isSynonym() && p.hasSpecialDomain()).forEach(p -> list.add(p.getTSpecialDomain().copy()));
        }
        if (!this.objectRoleMaster.getBotRole().isSimple()) {
            list.add(DLTreeFactory.createSNFForall(DLTreeFactory.createRole(this.objectRoleMaster.getBotRole()), DLTreeFactory.createBottom()));
        }
        if (!list.isEmpty()) {
            list.add(gci);
            gci = DLTreeFactory.createSNFAnd(list);
        }
        this.internalisedGeneralAxiom = this.tree2dag(gci);
        this.gcis.setGCI(this.internalisedGeneralAxiom != 1);
        this.gcis.setReflexive(this.objectRoleMaster.hasReflexiveRoles());
        Stream.concat(this.objectRoleMaster.getRoles().stream(), this.dataRoleMaster.getRoles().stream()).filter(p -> !p.isSynonym() && p.isTopFunc()).forEach(p -> p.setFunctional(this.atmost2dag(1, (Role)p, 1)));
        if (this.nNominalReferences > 0 && (nInd = this.individuals.size()) > 100 && this.nNominalReferences > nInd) {
            this.isLikeWINE = true;
        }
        this.dlHeap.setFinalSize();
    }

    @PortedFrom(file="dlTBox.h", name="initRangeDomain")
    public void initRangeDomain(RoleMaster rm) {
        rm.getRoles().stream().filter(r -> !r.isSynonym()).forEach(this::initRangeDomain);
    }

    protected void initRangeDomain(Role r) {
        if (this.config.isUpdaterndFromSuperRoles()) {
            r.collectDomainFromSupers();
        }
        DLTree dom = r.getTDomain();
        int bp = 1;
        if (dom != null) {
            bp = this.tree2dag(dom);
            this.gcis.setRnD(true);
        }
        r.setBPDomain(bp);
        r.initSpecialDomain();
        if (r.hasSpecialDomain()) {
            r.setSpecialDomain(this.tree2dag(r.getTSpecialDomain()));
        }
    }

    @PortedFrom(file="dlTBox.h", name="addDataExprToHeap")
    public int addDataExprToHeap(LiteralEntry p) {
        if (Helper.isValid(p.getIndex())) {
            return p.getIndex();
        }
        DagTag dt = DagTag.DATAVALUE;
        int hostBP = this.addDatatypeExpressionToHeap(p.getType());
        DLVertex ver = new DLVertex(dt, 0, null, hostBP, null, this.dlHeap);
        ver.setConcept(p);
        p.setIndex(this.dlHeap.directAdd(ver, false));
        return p.getIndex();
    }

    @PortedFrom(file="dlTBox.h", name="addDataExprToHeap")
    public int addDataExprToHeap(DatatypeEntry p) {
        if (Helper.isValid(p.getIndex())) {
            return p.getIndex();
        }
        DagTag dt = p.isBasicDataType() ? DagTag.DATATYPE : DagTag.DATAEXPR;
        int hostBP = 1;
        if (!p.isBasicDataType()) {
            Datatype baseType = ((DatatypeExpression)p.getDatatype()).getHostType();
            hostBP = this.addDatatypeExpressionToHeap(baseType);
        }
        DLVertex ver = new DLVertex(dt, 0, null, hostBP, null, this.dlHeap);
        ver.setConcept(p);
        p.setIndex(this.dlHeap.directAdd(ver, false));
        return p.getIndex();
    }

    @Original
    public int addDatatypeExpressionToHeap(Datatype<?> p) {
        DatatypeEntry concept = new DatatypeEntry(p);
        int index = this.dlHeap.index(concept);
        if (index != 0) {
            return index;
        }
        DLVertex ver = new DLVertex(DagTag.DATATYPE, 0, null, 1, null, this.dlHeap);
        ver.setConcept(concept);
        return this.dlHeap.directAdd(ver, true);
    }

    @PortedFrom(file="dlTBox.h", name="addConceptToHeap")
    public void addConceptToHeap(Concept pConcept) {
        DagTag tag;
        DagTag dagTag = pConcept.isPrimitive() ? (pConcept.isSingleton() ? DagTag.PSINGLETON : DagTag.PCONCEPT) : (tag = pConcept.isSingleton() ? DagTag.NSINGLETON : DagTag.NCONCEPT);
        if (tag == DagTag.NSINGLETON && !pConcept.isSynonym()) {
            pConcept.setNominal(true);
        }
        DLVertex ver = new DLVertex(tag, this.dlHeap);
        ver.setConcept(pConcept);
        pConcept.setpName(this.dlHeap.directAdd(ver, false));
        int desc = 1;
        if (pConcept.getDescription() != null) {
            desc = this.tree2dag(pConcept.getDescription());
        } else assert (pConcept.isPrimitive());
        pConcept.setpBody(desc);
        ver.setChild(desc);
        if (!pConcept.isSynonym() && pConcept.getIndex() == 0) {
            this.setConceptIndex(pConcept);
        }
    }

    @PortedFrom(file="dlTBox.h", name="tree2dag")
    public int tree2dag(@Nullable DLTree t) {
        int ret;
        if (t == null) {
            return 0;
        }
        Lexeme cur = t.elem();
        switch (cur.getToken()) {
            case BOTTOM: {
                ret = -1;
                break;
            }
            case TOP: {
                ret = 1;
                break;
            }
            case DATAEXPR: {
                if (cur.getNE() instanceof DatatypeEntry) {
                    ret = this.addDataExprToHeap((DatatypeEntry)cur.getNE());
                    break;
                }
                ret = this.addDataExprToHeap((LiteralEntry)cur.getNE());
                break;
            }
            case CNAME: {
                ret = this.concept2dag((Concept)cur.getNE());
                break;
            }
            case INAME: {
                ++this.nNominalReferences;
                Concept ind = (Concept)cur.getNE();
                ind.setNominal(true);
                ret = this.concept2dag(ind);
                break;
            }
            case NOT: {
                ret = -this.tree2dag(t.getChild());
                break;
            }
            case AND: {
                ret = this.and2dag(new DLVertex(DagTag.AND, this.dlHeap), t);
                break;
            }
            case FORALL: {
                ret = this.forall2dag(Role.resolveRole(t.getLeft()), this.tree2dag(t.getRight()));
                break;
            }
            case SELF: {
                ret = this.reflexive2dag(Role.resolveRole(t.getChild()));
                break;
            }
            case LE: {
                ret = this.atmost2dag(cur.getData(), Role.resolveRole(t.getLeft()), this.tree2dag(t.getRight()));
                break;
            }
            case PROJFROM: {
                ret = this.dlHeap.directAdd(new DLVertex(DagTag.PROJ, 0, Role.resolveRole(t.getLeft()), this.tree2dag(t.getRight().getRight()), Role.resolveRole(t.getRight().getLeft()), this.dlHeap), false);
                break;
            }
            default: {
                assert (DLTreeFactory.isSNF(t));
                throw new UnreachableSituationException();
            }
        }
        return ret;
    }

    @PortedFrom(file="dlTBox.h", name="and2dag")
    public int and2dag(DLVertex v, DLTree t) {
        int ret = -1;
        if (!this.fillANDVertex(v, t)) {
            int value = v.getAndToDagValue();
            if (value != 0) {
                return value;
            }
            return this.dlHeap.add(v);
        }
        return ret;
    }

    @PortedFrom(file="dlTBox.h", name="forall2dag")
    public int forall2dag(Role r, int c) {
        if (r.isDataRole()) {
            return this.dataForall2dag(r, c);
        }
        int ret = this.dlHeap.add(new DLVertex(DagTag.FORALL, 0, r, c, null, this.dlHeap));
        if (r.isSimple()) {
            return ret;
        }
        if (!this.dlHeap.isLast(ret)) {
            return ret;
        }
        for (int i = 1; i < r.getAutomaton().size(); ++i) {
            this.dlHeap.directAddAndCache(new DLVertex(DagTag.FORALL, i, r, c, null, this.dlHeap));
        }
        return ret;
    }

    @PortedFrom(file="dlTBox.h", name="atmost2dag")
    public int atmost2dag(int n, Role r, int c) {
        if (!r.isSimple()) {
            throw new ReasonerInternalException("Non simple role used as simple: " + r.getIRI());
        }
        if (r.isDataRole()) {
            return this.dataAtMost2dag(n, r, c);
        }
        if (c == -1) {
            return 1;
        }
        int ret = this.dlHeap.add(new DLVertex(DagTag.LE, n, r, c, null, this.dlHeap));
        if (!this.dlHeap.isLast(ret)) {
            return ret;
        }
        for (int m = n - 1; m > 0; --m) {
            this.dlHeap.directAddAndCache(new DLVertex(DagTag.LE, m, r, c, null, this.dlHeap));
        }
        this.dlHeap.directAddAndCache(new DLVertex(DagTag.NN, this.dlHeap));
        return ret;
    }

    @PortedFrom(file="dlTBox.h", name="fillANDVertex")
    private boolean fillANDVertex(DLVertex v, DLTree t) {
        if (t.isAND()) {
            return t.getChildren().stream().anyMatch(i -> this.fillANDVertex(v, (DLTree)i));
        }
        return v.addChild(this.tree2dag(t));
    }

    @PortedFrom(file="dlTBox.h", name="fillArrays")
    public <T extends Concept> int fillArrays(Stream<T> begin) {
        AtomicInteger n = new AtomicInteger(0);
        begin.filter(p -> !p.isNonClassifiable()).forEach(p -> {
            n.incrementAndGet();
            switch (p.getClassTag()) {
                case COMPLETELYDEFINED: {
                    this.arrayCD.add((Concept)p);
                    break;
                }
                case NONPRIMITIVE: 
                case HASNONPRIMITIVETS: {
                    this.arrayNP.add((Concept)p);
                    break;
                }
                default: {
                    this.arrayNoCD.add((Concept)p);
                }
            }
        });
        return n.get();
    }

    @Original
    public int getNItems() {
        return this.nItems;
    }

    @PortedFrom(file="dlTBox.h", name="createTaxonomy")
    public void createTaxonomy(boolean needIndividual) {
        boolean needConcept = !needIndividual;
        this.clearQueryConcept();
        this.dlHeap.setSubOrder();
        this.pTaxCreator.setBottomUp(this.gcis);
        needConcept |= needIndividual;
        if (this.config.getverboseOutput()) {
            this.config.getLog().print("Processing query...\n");
        }
        Timer locTimer = new Timer();
        locTimer.start();
        this.nItems = 0;
        this.arrayCD.clear();
        this.arrayNoCD.clear();
        this.arrayNP.clear();
        this.nItems += this.fillArrays(this.concepts.getConcepts());
        this.nItems += this.fillArrays(this.individuals.getConcepts());
        this.config.getProgressMonitor().reasonerTaskStarted("Classifying");
        this.duringClassification = true;
        this.classifyConcepts(this.arrayCD, true, "completely defined");
        this.classifyConcepts(this.arrayNoCD, false, "regular");
        this.classifyConcepts(this.arrayNP, false, "non-primitive");
        this.duringClassification = false;
        this.config.getProgressMonitor().reasonerTaskStopped();
        this.pTax.finalise();
        locTimer.stop();
        if (this.config.getverboseOutput()) {
            this.config.getLog().print(DONE_IN).print(locTimer.calcDelta()).print(SECONDS);
        }
        if (needConcept && this.kbStatus.ordinal() < KBStatus.KBCLASSIFIED.ordinal()) {
            this.kbStatus = KBStatus.KBCLASSIFIED;
        }
        if (needIndividual || this.nNominalReferences > 0) {
            this.kbStatus = KBStatus.KBREALISED;
        }
        if (this.config.getverboseOutput()) {
            this.config.getLog().print((Object)this.pTax);
        }
    }

    @PortedFrom(file="dlTBox.h", name="classifyConcepts")
    public void classifyConcepts(List<Concept> collection, boolean curCompletelyDefined, String type) {
        this.pTaxCreator.setCompletelyDefined(curCompletelyDefined);
        this.config.getLog().printTemplate(Templates.CLASSIFY_CONCEPTS, type);
        int n = (int)collection.stream().filter(q -> !this.interrupted.get() && !q.isClassified()).map(this::classifyEntry).filter(ClassifiableEntry::isClassified).count();
        this.config.getLog().printTemplateMixInt(Templates.CLASSIFY_CONCEPTS2, type, n);
    }

    @PortedFrom(file="dlTBox.h", name="classifyEntry")
    private Concept classifyEntry(Concept entry) {
        if (this.isBlockedInd(entry)) {
            this.classifyEntry(this.getBlockingInd(entry));
        }
        if (!entry.isClassified()) {
            this.pTaxCreator.classifyEntry(entry);
        }
        return entry;
    }

    @PortedFrom(file="dlTBox.h", name="getAuxConcept")
    public Concept getAuxConcept(@Nullable DLTree desc) {
        boolean old = this.setForbidUndefinedNames(false);
        Concept c = this.getConcept(IRI.create((String)("urn:aux" + ++this.auxConceptID)));
        this.setForbidUndefinedNames(old);
        c.setSystem();
        c.setNonClassifiable(true);
        c.setPrimitive(true);
        c.addDesc(desc);
        c.initToldSubsumers();
        return c;
    }

    @PortedFrom(file="dlTBox.h", name="initTopBottom")
    private void initTopBottom() {
        this.top = Concept.getTOP(this.df);
        this.bottom = Concept.getBOTTOM(this.df);
        this.pTemp = Concept.getTEMP();
        this.pQuery = Concept.getQuery();
    }

    @PortedFrom(file="dlTBox.h", name="prepareReasoning")
    public void prepareReasoning() {
        this.preprocess();
        this.initReasoner();
        this.dumpQuery();
        this.dlHeap.setSatOrder();
    }

    @Original
    private void dumpQuery() {
        if (this.config.getdumpQuery()) {
            this.markAllRelevant();
            DumpLisp lDump = new DumpLisp(this.config.getLog());
            this.dump(lDump);
            this.clearRelevanceInfo();
        }
    }

    @PortedFrom(file="dlTBox.h", name="prepareFeatures")
    public void prepareFeatures(@Nullable Concept pConcept, @Nullable Concept qConcept) {
        this.auxFeatures = new LogicFeatures(this.gciFeatures);
        if (pConcept != null) {
            this.updateAuxFeatures(pConcept.getPosFeatures());
        }
        if (qConcept != null) {
            this.updateAuxFeatures(qConcept.getNegFeatures());
        }
        if (this.auxFeatures.hasSingletons()) {
            this.updateAuxFeatures(this.nominalCloudFeatures);
        }
        this.curFeature = this.auxFeatures;
        this.getReasoner().setBlockingMethod(this.isIRinQuery(), this.isNRinQuery());
    }

    @PortedFrom(file="dlTBox.h", name="buildSimpleCache")
    public void buildSimpleCache() {
        this.initConstCache(-1);
        this.initSingletonCache(this.pTemp, true);
        this.initSingletonCache(this.pTemp, false);
        if (this.gcis.isGCI() || this.gcis.isReflexive()) {
            return;
        }
        this.initConstCache(1);
        this.concepts.getConcepts().filter(pc -> pc.isPrimitive()).forEach(pc -> this.initSingletonCache((Concept)pc, false));
        this.individuals.getConcepts().filter(pc -> pc.isPrimitive()).forEach(pc -> this.initSingletonCache((Concept)pc, false));
    }

    @PortedFrom(file="dlTBox.h", name="performConsistencyCheck")
    public boolean performConsistencyCheck() {
        boolean ret;
        if (this.config.getverboseOutput()) {
            this.config.getLog().print("Consistency checking...\n");
        }
        Timer pt = new Timer();
        pt.start();
        this.buildSimpleCache();
        Concept test = this.nominalCloudFeatures.hasSingletons() ? (Concept)this.individuals.first() : null;
        this.prepareFeatures(test, null);
        if (test != null) {
            if (this.dlHeap.getCache(1) == null) {
                this.initConstCache(1);
            }
            ret = this.nomReasoner.consistentNominalCloud();
        } else {
            ret = this.isSatisfiable(this.top);
        }
        if (this.gcis.isGCI()) {
            this.dlHeap.setCache(-this.internalisedGeneralAxiom, new ModelCacheConst(false));
        }
        pt.stop();
        this.consistTime = pt.calcDelta();
        if (this.config.getverboseOutput()) {
            this.config.getLog().print(DONE_IN).print(this.consistTime).print(SECONDS);
        }
        return ret;
    }

    @PortedFrom(file="dlTBox.h", name="isSatisfiable")
    public boolean isSatisfiable(Concept pConcept) {
        assert (pConcept != null);
        ModelCacheInterface cache = this.dlHeap.getCache(pConcept.getpName());
        if (cache != null) {
            return cache.getState() != ModelCacheState.INVALID;
        }
        this.config.getLog().printTemplate(Templates.IS_SATISFIABLE, pConcept.getIRI());
        this.prepareFeatures(pConcept, null);
        int resolveId = pConcept.resolveId();
        if (resolveId == 0) {
            this.config.getLog().print("query concept still invalid after prepareFeatures()");
            return false;
        }
        boolean result = this.getReasoner().runSat(resolveId, 1);
        cache = this.getReasoner().buildCacheByCGraph(result);
        this.dlHeap.setCache(pConcept.getpName(), cache);
        this.clearFeatures();
        this.config.getLog().printTemplate(Templates.IS_SATISFIABLE1, pConcept.getIRI(), !result ? "un" : "");
        return result;
    }

    @PortedFrom(file="dlTBox.h", name="isSubHolds")
    public boolean isSubHolds(Concept pConcept, Concept qConcept) {
        assert (pConcept != null && qConcept != null);
        this.config.getLog().printTemplate(Templates.ISSUBHOLDS1, pConcept.getIRI(), qConcept.getIRI());
        this.prepareFeatures(pConcept, qConcept);
        boolean result = !this.getReasoner().runSat(pConcept.resolveId(), -qConcept.resolveId());
        this.clearFeatures();
        this.config.getLog().printTemplate(Templates.ISSUBHOLDS2, pConcept.getIRI(), qConcept.getIRI(), !result ? " NOT" : "");
        return result;
    }

    @PortedFrom(file="dlTBox.h", name="isSameIndividuals")
    public boolean isSameIndividuals(Individual a, Individual b) {
        Individual indb;
        if (a.equals(b)) {
            return true;
        }
        Individual inda = ClassifiableEntry.resolveSynonym(a);
        if (inda.equals(indb = ClassifiableEntry.resolveSynonym(b))) {
            return true;
        }
        if (!this.isIndividual(inda.getIRI()) || !this.isIndividual(indb.getIRI())) {
            throw new ReasonerInternalException("Individuals are expected in the isSameIndividuals() query");
        }
        if (inda.isFresh() || indb.isFresh()) {
            if (inda.isSynonym()) {
                return this.isSameIndividuals((Individual)inda.getSynonym(), indb);
            }
            if (indb.isSynonym()) {
                return this.isSameIndividuals(inda, (Individual)indb.getSynonym());
            }
            return false;
        }
        return inda.getTaxVertex().equals(indb.getTaxVertex());
    }

    @PortedFrom(file="dlTBox.h", name="isDisjointRoles")
    public boolean isDisjointRoles(Role r, Role s) {
        assert (r != null && s != null);
        if (r.isDataRole() != s.isDataRole()) {
            return true;
        }
        this.curFeature = this.kbFeatures;
        this.getReasoner().setBlockingMethod(this.isIRinQuery(), this.isNRinQuery());
        boolean result = this.getReasoner().checkDisjointRoles(r, s);
        this.clearFeatures();
        return result;
    }

    @PortedFrom(file="dlTBox.h", name="createQueryConcept")
    public Concept createQueryConcept(DLTree desc) {
        assert (desc != null);
        this.clearQueryConcept();
        this.makeNonPrimitive(this.pQuery, desc.copy());
        this.pQuery.setIndex(this.nC - 1);
        return this.pQuery;
    }

    @PortedFrom(file="dlTBox.h", name="preprocessQueryConcept")
    public void preprocessQueryConcept(Concept query) {
        this.addConceptToHeap(query);
        this.setConceptRelevant(query);
        this.initCache(query, false);
    }

    @PortedFrom(file="dlTBox.h", name="clearQueryConcept")
    public void clearQueryConcept() {
        this.dlHeap.removeQuery();
    }

    @PortedFrom(file="dlTBox.h", name="classifyQueryConcept")
    public void classifyQueryConcept() {
        this.pQuery.initToldSubsumers();
        assert (this.pTax != null);
        this.pTaxCreator.setCompletelyDefined(false);
        this.pTaxCreator.classifyEntry(this.pQuery);
    }

    @PortedFrom(file="dlTBox.h", name="buildCompletionTree")
    public DlCompletionTree buildCompletionTree(Concept pConcept) {
        DlCompletionTree ret = null;
        this.prepareFeatures(pConcept, null);
        this.config.setUseNodeCache(false);
        if (this.getReasoner().runSat(pConcept.resolveId(), 1)) {
            ret = this.getReasoner().getRootNode();
        }
        this.config.setUseNodeCache(true);
        this.clearFeatures();
        return ret;
    }

    @PortedFrom(file="dlTBox.h", name="writeReasoningResult")
    public void writeReasoningResult(long time) {
        LogAdapter o = this.config.getLog();
        if (this.nomReasoner != null) {
            o.print("Query processing reasoning statistic: Nominals");
            this.nomReasoner.writeTotalStatistic(o);
        }
        o.print("Query processing reasoning statistic: Standard");
        this.stdReasoner.writeTotalStatistic(o);
        assert (this.kbStatus.ordinal() >= KBStatus.KBCHECKED.ordinal());
        if (this.consistent) {
            o.print("Required");
        } else {
            o.print("KB is inconsistent. Query is NOT processed\nConsistency");
        }
        long sum = this.preprocTime + this.consistTime;
        o.print(" check done in ").print(time).print(" seconds\nof which:\nPreproc. takes ").print(this.preprocTime).print(" seconds\nConsist. takes ").print(this.consistTime).print(" seconds");
        if (this.nomReasoner != null) {
            o.print("\nReasoning NOM:");
            sum = (long)((float)sum + this.nomReasoner.printReasoningTime(o));
        }
        o.print("\nReasoning STD:");
        sum = (long)((float)sum + this.stdReasoner.printReasoningTime(o));
        o.print("\nThe rest takes ");
        long f = time - sum;
        if (f < 0L) {
            f = 0L;
        }
        o.print((float)f / 1000.0f);
        o.print(" seconds\n");
        this.print();
    }

    @PortedFrom(file="dlTBox.h", name="PrintDagEntry")
    public void printDagEntry(LogAdapter o, int p) {
        assert (Helper.isValid(p));
        if (p == 1) {
            o.print(" *TOP*");
            return;
        }
        if (p == -1) {
            o.print(" *BOTTOM*");
            return;
        }
        if (p < 0) {
            o.print(" (not");
            this.printDagEntry(o, -p);
            o.print(")");
            return;
        }
        DLVertex v = this.dlHeap.get(Math.abs(p));
        DagTag type = v.getType();
        switch (type) {
            case TOP: {
                o.print(" *TOP*");
                return;
            }
            case PCONCEPT: 
            case NCONCEPT: 
            case PSINGLETON: 
            case NSINGLETON: 
            case DATATYPE: 
            case DATAVALUE: {
                o.print(" ");
                o.print((Object)v.getConcept().getIRI());
                return;
            }
            case DATAEXPR: {
                o.print(" ");
                o.print(this.getDataEntryByBP(p));
                return;
            }
            case IRR: {
                o.print((Object)" (", (Object)type.getName(), (Object)" ", (Object)v.getRole().getIRI(), (Object)")");
                return;
            }
            case COLLECTION: 
            case AND: {
                o.print(" (");
                o.print(type.getName());
                for (int q : v.begin()) {
                    this.printDagEntry(o, q);
                }
                o.print(")");
                return;
            }
            case FORALL: 
            case LE: {
                o.print(" (");
                o.print(type.getName());
                if (type == DagTag.LE) {
                    o.print(" ");
                    o.print(v.getNumberLE());
                }
                o.print(" ");
                o.print((Object)v.getRole().getIRI());
                this.printDagEntry(o, v.getConceptIndex());
                o.print(")");
                return;
            }
            case PROJ: {
                o.print((Object)" (", (Object)type.getName(), (Object)" ", (Object)v.getRole().getIRI(), (Object)")");
                this.printDagEntry(o, v.getConceptIndex());
                o.print((Object)" => ", (Object)v.getProjRole().getIRI(), (Object)")");
                return;
            }
            case NN: 
            case CHOOSE: {
                throw new UnreachableSituationException();
            }
            case BAD: {
                o.print("WRONG: printing a badtag dtBad!\n");
                break;
            }
            default: {
                throw new ReasonerInternalException("Error printing vertex of type " + type.getName() + '(' + (Object)((Object)type) + ')');
            }
        }
    }

    @PortedFrom(file="dlTBox.h", name="PrintConcept")
    public void printConcept(LogAdapter o, Concept p) {
        if (Helper.isValid(p.getpName())) {
            o.print(p.getClassTagPlain().getCTTagName());
            if (p.isSingleton()) {
                o.print(p.isNominal() ? (char)'o' : '!');
            }
            o.print((Object)".", (Object)p.getIRI(), (Object)" [").print(p.getTsDepth()).print((Object)"] ", (Object)(p.isPrimitive() ? "[=" : "="));
            if (Helper.isValid(p.getpBody())) {
                this.printDagEntry(o, p.getpBody());
            }
            if (p.getDescription() != null) {
                o.print((Object)(p.isPrimitive() ? "\n-[=" : "\n-="), (Object)p.getDescription());
            }
            o.print("\n");
        }
    }

    @PortedFrom(file="dlTBox.h", name="dump")
    private void dump(DumpInterface dump) {
        dump.prologue();
        this.dumpAllRoles(dump);
        this.concepts.getConcepts().filter(p -> p.isRelevant(this.relevance)).forEach(p -> this.dumpConcept(dump, (Concept)p));
        this.individuals.getConcepts().filter(p -> p.isRelevant(this.relevance)).forEach(p -> this.dumpConcept(dump, (Concept)p));
        if (this.internalisedGeneralAxiom != 1) {
            dump.startAx(DIOp.IMPLIESC);
            dump.dumpTop();
            dump.contAx(DIOp.IMPLIESC);
            this.dumpExpression(dump, this.internalisedGeneralAxiom);
            dump.finishAx(DIOp.IMPLIESC);
        }
        dump.epilogue();
    }

    @PortedFrom(file="dlTBox.h", name="dumpConcept")
    public void dumpConcept(DumpInterface dump, Concept p) {
        dump.startAx(DIOp.DEFINEC);
        dump.dumpConcept(p);
        dump.finishAx(DIOp.DEFINEC);
        if (p.getpBody() != 1) {
            DIOp ax = p.isPrimitive() ? DIOp.IMPLIESC : DIOp.EQUALSC;
            dump.startAx(ax);
            dump.dumpConcept(p);
            dump.contAx(ax);
            this.dumpExpression(dump, p.getpBody());
            dump.finishAx(ax);
        }
    }

    @PortedFrom(file="dlTBox.h", name="dumpRole")
    public void dumpRole(DumpInterface dump, Role p) {
        if (p.getId() > 0 || !p.inverse().isRelevant(this.relevance)) {
            Role q = p.getId() > 0 ? p : p.inverse();
            dump.startAx(DIOp.DEFINER);
            dump.dumpRole(q);
            dump.finishAx(DIOp.DEFINER);
            q.getToldSubsumers().forEach(i -> {
                dump.startAx(DIOp.IMPLIESR);
                dump.dumpRole(q);
                dump.contAx(DIOp.IMPLIESR);
                dump.dumpRole((Role)i);
                dump.finishAx(DIOp.IMPLIESR);
            });
        }
        if (p.isTransitive()) {
            dump.startAx(DIOp.TRANSITIVER);
            dump.dumpRole(p);
            dump.finishAx(DIOp.TRANSITIVER);
        }
        if (p.isTopFunc()) {
            dump.startAx(DIOp.FUNCTIONALR);
            dump.dumpRole(p);
            dump.finishAx(DIOp.FUNCTIONALR);
        }
        if (p.getBPDomain() != 1) {
            dump.startAx(DIOp.DOMAINR);
            dump.dumpRole(p);
            dump.contAx(DIOp.DOMAINR);
            this.dumpExpression(dump, p.getBPDomain());
            dump.finishAx(DIOp.DOMAINR);
        }
        if (p.getBPRange() != 1) {
            dump.startAx(DIOp.RANGER);
            dump.dumpRole(p);
            dump.contAx(DIOp.RANGER);
            this.dumpExpression(dump, p.getBPRange());
            dump.finishAx(DIOp.RANGER);
        }
    }

    @PortedFrom(file="dlTBox.h", name="dumpExpression")
    public void dumpExpression(DumpInterface dump, int p) {
        assert (Helper.isValid(p));
        if (p == 1) {
            dump.dumpTop();
            return;
        }
        if (p == -1) {
            dump.dumpBottom();
            return;
        }
        if (p < 0) {
            dump.startOp(DIOp.NOT);
            this.dumpExpression(dump, -p);
            dump.finishOp(DIOp.NOT);
            return;
        }
        DLVertex v = this.dlHeap.get(Math.abs(p));
        DagTag type = v.getType();
        switch (type) {
            case TOP: {
                dump.dumpTop();
                return;
            }
            case PCONCEPT: 
            case NCONCEPT: 
            case PSINGLETON: 
            case NSINGLETON: {
                dump.dumpConcept((Concept)v.getConcept());
                return;
            }
            case AND: {
                int[] begin;
                dump.startOp(DIOp.AND);
                for (int q : begin = v.begin()) {
                    if (q != begin[0]) {
                        dump.contOp(DIOp.AND);
                    }
                    this.dumpExpression(dump, q);
                }
                dump.finishOp(DIOp.AND);
                return;
            }
            case FORALL: {
                dump.startOp(DIOp.FORALL);
                dump.dumpRole(v.getRole());
                dump.contOp(DIOp.FORALL);
                this.dumpExpression(dump, v.getConceptIndex());
                dump.finishOp(DIOp.FORALL);
                return;
            }
            case LE: {
                dump.startOp(DIOp.LE, v.getNumberLE());
                dump.dumpRole(v.getRole());
                dump.contOp(DIOp.LE);
                this.dumpExpression(dump, v.getConceptIndex());
                dump.finishOp(DIOp.LE);
                return;
            }
        }
        throw new ReasonerInternalException("Error dumping vertex of type " + type.getName() + '(' + (Object)((Object)type) + ')');
    }

    @PortedFrom(file="dlTBox.h", name="dumpAllRoles")
    public void dumpAllRoles(DumpInterface dump) {
        Stream.concat(this.objectRoleMaster.getRoles().stream(), this.dataRoleMaster.getRoles().stream()).filter(p -> p.isRelevant(this.relevance)).forEach(p -> this.dumpRole(dump, (Role)p));
    }

    @PortedFrom(file="dlTBox.h", name="addSubsumeAxiom")
    public void addSubsumeAxiom(@Nullable DLTree sub, @Nullable DLTree sup) {
        if (DLTree.equalTrees(sub, sup)) {
            return;
        }
        if (sup.isCN() && (sup = this.applyAxiomCToCN(sub, sup)) == null) {
            return;
        }
        if (sub.isCN() && (sub = this.applyAxiomCNToC(sub, sup)) == null) {
            return;
        }
        if (!TBox.axiomToRangeDomain(sub, sup)) {
            this.processGCI(sub, sup);
        }
    }

    @Nullable
    @PortedFrom(file="dlTBox.h", name="applyAxiomCToCN")
    public DLTree applyAxiomCToCN(DLTree d, DLTree cn) {
        Concept ci = this.getCI(cn);
        assert (ci != null);
        Concept c = ClassifiableEntry.resolveSynonym(ci);
        if (c.isBottom()) {
            return DLTreeFactory.createBottom();
        }
        if (c.isTop()) {
            return null;
        }
        if (c.isSingleton() && d.isName() || !DLTree.equalTrees(c.getDescription(), d)) {
            return cn;
        }
        this.makeNonPrimitive(c, d);
        return null;
    }

    @Nullable
    @PortedFrom(file="dlTBox.h", name="applyAxiomCNToC")
    public DLTree applyAxiomCNToC(DLTree cn, DLTree d) {
        Concept ci = this.getCI(cn);
        assert (ci != null);
        Concept c = ClassifiableEntry.resolveSynonym(ci);
        if (c.isTop()) {
            return DLTreeFactory.createTop();
        }
        if (c.isBottom()) {
            return null;
        }
        if (c.isPrimitive()) {
            c.addDesc(d);
        } else {
            this.addSubsumeForDefined(c, d);
        }
        return null;
    }

    @PortedFrom(file="dlTBox.h", name="addSubsumeForDefined")
    public void addSubsumeForDefined(Concept c, DLTree e) {
        DLTree d;
        if (DLTreeFactory.isSubTree(e, c.getDescription())) {
            return;
        }
        if (c.hasSelfInDesc()) {
            d = c.getDescription().copy();
            c.removeSelfFromDescription();
            assert (!DLTree.equalTrees(d, c.getDescription()));
        } else {
            this.processGCI(this.getTree(c), e);
            return;
        }
        this.makeDefinitionPrimitive(c, e, d);
    }

    @PortedFrom(file="dlTBox.h", name="axiomToRangeDomain")
    public static boolean axiomToRangeDomain(DLTree sub, DLTree sup) {
        if (sub.isTOP() && sup.token() == Token.FORALL) {
            Role.resolveRole(sup.getLeft()).setRange(sup.getRight().copy());
            return true;
        }
        if (sub.token() == Token.NOT && sub.getChild().token() == Token.FORALL && sub.getChild().getRight().isBOTTOM()) {
            Role.resolveRole(sub.getChild().getLeft()).setDomain(sup);
            return true;
        }
        return false;
    }

    @PortedFrom(file="dlTBox.h", name="addEqualityAxiom")
    private void addEqualityAxiom(DLTree left, DLTree right) {
        boolean isNamedRHS;
        Concept leftCI = this.getCI(left);
        Concept rightCI = this.getCI(right);
        Concept c = null;
        if (leftCI != null) {
            c = ClassifiableEntry.resolveSynonym(leftCI);
        }
        boolean isNamedLHS = c != null && !c.isTop() && !c.isBottom();
        Concept d = null;
        if (rightCI != null) {
            d = ClassifiableEntry.resolveSynonym(rightCI);
        }
        boolean bl = isNamedRHS = d != null && !d.isTop() && !d.isBottom();
        if (isNamedLHS && this.addNonprimitiveDefinition(c, d, right)) {
            return;
        }
        if (isNamedRHS && this.addNonprimitiveDefinition(d, c, left)) {
            return;
        }
        if (isNamedLHS && this.switchToNonprimitive(left, right)) {
            return;
        }
        if (isNamedRHS && this.switchToNonprimitive(right, left)) {
            return;
        }
        this.addSubsumeAxiom(left.copy(), right.copy());
        this.addSubsumeAxiom(right, left);
    }

    @PortedFrom(file="dlTBox.h", name="addNonprimitiveDefinition")
    public boolean addNonprimitiveDefinition(Concept left, @Nullable Concept right, DLTree rightOrigin) {
        if (right != null) {
            if (ClassifiableEntry.resolveSynonym(right).equals(left)) {
                return true;
            }
            if (left.isSingleton() && !right.isSingleton()) {
                return false;
            }
        }
        if (left.canInitNonPrim(rightOrigin)) {
            this.makeNonPrimitive(left, rightOrigin);
            return true;
        }
        return false;
    }

    @PortedFrom(file="dlTBox.h", name="switchToNonprimitive")
    public boolean switchToNonprimitive(DLTree left, DLTree right) {
        Concept ci = this.getCI(left);
        if (ci == null) {
            return false;
        }
        Concept c = ClassifiableEntry.resolveSynonym(ci);
        if (c.isTop() || c.isBottom()) {
            return false;
        }
        Concept ci2 = this.getCI(right);
        if (c.isSingleton() && ci2 != null && !ClassifiableEntry.resolveSynonym(ci2).isSingleton()) {
            return false;
        }
        if (this.config.getalwaysPreferEquals() && c.isPrimitive()) {
            this.addSubsumeForDefined(c, this.makeNonPrimitive(c, right));
            return true;
        }
        return false;
    }

    @PortedFrom(file="dlTBox.h", name="makeDefinitionPrimitive")
    void makeDefinitionPrimitive(Concept c, DLTree e, DLTree d) {
        c.setPrimitive(true);
        c.addDesc(e);
        c.initToldSubsumers();
        this.addSubsumeAxiom(d, this.getTree(c));
    }

    @PortedFrom(file="dlTBox.h", name="processDisjointC")
    public void processDisjointC(Collection<DLTree> beg) {
        ArrayList<DLTree> prim = new ArrayList<DLTree>();
        ArrayList<DLTree> rest = new ArrayList<DLTree>();
        for (DLTree d : beg) {
            if (d.isName() && ((Concept)d.elem().getNE()).isPrimitive()) {
                prim.add(d);
                continue;
            }
            rest.add(d);
        }
        if (!prim.isEmpty() && !rest.isEmpty()) {
            DLTree nrest = DLTreeFactory.buildDisjAux(rest);
            prim.forEach(q -> this.addSubsumeAxiom((DLTree)q, nrest));
        }
        if (!rest.isEmpty()) {
            this.processDisjoint(rest);
        }
        if (!prim.isEmpty()) {
            this.processDisjoint(prim);
        }
    }

    @PortedFrom(file="dlTBox.h", name="processEquivalentC")
    public void processEquivalentC(List<DLTree> l) {
        Helper.pairs(l, (a, b) -> this.addEqualityAxiom((DLTree)a, (DLTree)b));
    }

    @PortedFrom(file="dlTBox.h", name="processDifferent")
    public void processDifferent(List<DLTree> l) {
        if (l.stream().anyMatch(i -> !this.isIndividual((DLTree)i))) {
            throw new ReasonerInternalException("Only individuals allowed in processDifferent()");
        }
        List acc = OWLAPIStreamUtils.asList(l.stream().map(i -> (Individual)i.elem().getNE()));
        l.clear();
        if (acc.size() > 1) {
            this.differentIndividuals.add(acc);
        }
    }

    @PortedFrom(file="dlTBox.h", name="processSame")
    public void processSame(List<DLTree> l) {
        if (l.stream().anyMatch(i -> !this.isIndividual((DLTree)i))) {
            throw new ReasonerInternalException("Only individuals allowed in processSame()");
        }
        Helper.pairs(l, (a, b) -> this.addEqualityAxiom((DLTree)a, (DLTree)b));
    }

    @PortedFrom(file="dlTBox.h", name="processDisjointR")
    public void processDisjointR(List<DLTree> l) {
        if (l.isEmpty()) {
            throw new ReasonerInternalException("Empty disjoint role axiom");
        }
        if (l.stream().anyMatch(DLTreeFactory::isTopRole)) {
            throw new ReasonerInternalException("Universal role in the disjoint roles axiom");
        }
        List roles = OWLAPIStreamUtils.asList(l.stream().map(Role::resolveRole));
        RoleMaster rm = this.getRM((Role)roles.get(0));
        Helper.allPairs(roles, (a, b) -> rm.addDisjointRoles((Role)a, (Role)b));
    }

    @PortedFrom(file="dlTBox.h", name="processEquivalentR")
    public void processEquivalentR(List<DLTree> l) {
        Helper.pairs(l, (a, b) -> RoleMaster.addRoleSynonym(Role.resolveRole(a), Role.resolveRole(b)));
        l.clear();
    }

    @PortedFrom(file="dlTBox.h", name="preprocess")
    public void preprocess() {
        if (this.config.getverboseOutput()) {
            this.config.getLog().print("\nPreprocessing...\n");
        }
        Timer pt = new Timer();
        pt.start();
        this.objectRoleMaster.initAncDesc();
        this.dataRoleMaster.initAncDesc();
        if (this.config.getverboseOutput()) {
            this.config.getLog().print((Object)this.objectRoleMaster.getTaxonomy());
            this.config.getLog().print((Object)this.dataRoleMaster.getTaxonomy());
        }
        if (this.countSynonyms() > 0) {
            this.replaceAllSynonyms();
        }
        this.preprocessRelated();
        this.transformExtraSubsumptions();
        this.initToldSubsumers();
        this.transformToldCycles();
        this.transformSingletonHierarchy();
        this.absorbAxioms();
        this.setToldTop();
        this.buildDAG();
        this.fillsClassificationTag();
        this.calculateTSDepth();
        this.setAllIndexes();
        this.determineSorts();
        this.gatherRelevanceInfo();
        this.printFeatures();
        this.dlHeap.setOrderDefaults(this.isLikeGALEN ? "Fdn" : (this.isLikeWINE ? "Sdp" : "Sap"), this.isLikeGALEN ? "Ban" : (this.isLikeWINE ? "Fdn" : "Dap"));
        this.dlHeap.gatherStatistic();
        this.calculateStatistic();
        this.removeExtraDescriptions();
        pt.stop();
        this.preprocTime = pt.calcDelta();
        if (this.config.getverboseOutput()) {
            this.config.getLog().print(DONE_IN).print(pt.calcDelta()).print(SECONDS);
        }
    }

    @PortedFrom(file="Preprocess.cpp", name="isReferenced")
    boolean isReferenced(Concept c, DLTree tree, Set<Concept> processed) {
        assert (tree != null);
        if (tree.isName()) {
            Concept d = (Concept)tree.elem().getNE();
            if (c.equals(d)) {
                return true;
            }
            if (!processed.isEmpty()) {
                return false;
            }
            return this.isReferenced(c, d, processed);
        }
        if (tree.getChildren().size() == 1) {
            return this.isReferenced(c, tree.getChild(), processed);
        }
        if (tree.token() == Token.SELF || tree.isTOP() || tree.isBOTTOM()) {
            return false;
        }
        if (tree.isAND() || tree.token() == Token.OR) {
            return tree.getChildren().stream().anyMatch(child -> this.isReferenced(c, (DLTree)child, processed));
        }
        throw new UnreachableSituationException("cannot match the tree type");
    }

    boolean isReferenced(Concept c, Concept d, Set<Concept> processed) {
        processed.add(d);
        if (d.getDescription() == null) {
            return false;
        }
        if (this.isReferenced(c, d.getDescription(), processed)) {
            return true;
        }
        if (d.isPrimitive()) {
            return false;
        }
        DLTree p = this.extraConceptDefs.get(d);
        if (p != null) {
            return this.isReferenced(c, p, processed);
        }
        return false;
    }

    @PortedFrom(file="Preprocess.cpp", name="TransformExtraSubsumptions")
    void transformExtraSubsumptions() {
        Iterator<Map.Entry<Concept, DLTree>> it = this.extraConceptDefs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Concept, DLTree> p = it.next();
            Concept c = p.getKey();
            DLTree e = p.getValue();
            if (this.isCyclic(c)) {
                DLTree d = c.getDescription().copy();
                this.makeDefinitionPrimitive(c, e, d);
            } else {
                this.processGCI(this.getTree(c), e);
            }
            it.remove();
        }
        this.extraConceptDefs.clear();
    }

    @PortedFrom(file="Preprocess.cpp", name="isCyclic")
    public boolean isCyclic(Concept c) {
        return this.isReferenced(c, c, new HashSet<Concept>());
    }

    @PortedFrom(file="dlTBox.h", name="setAllIndexes")
    private void setAllIndexes() {
        ++this.nC;
        this.nR.set(1);
        Stream.concat(this.objectRoleMaster.getRoles().stream(), this.dataRoleMaster.getRoles().stream()).filter(r -> !r.isSynonym()).forEach(r -> r.setIndex(this.nR.getAndIncrement()));
    }

    @PortedFrom(file="dlTBox.h", name="replaceAllSynonyms")
    private void replaceAllSynonyms() {
        this.objectRoleMaster.getRoles().stream().filter(r -> !r.isSynonym()).forEach(r -> DLTreeFactory.replaceSynonymsFromTree(r.getTDomain()));
        this.dataRoleMaster.getRoles().stream().filter(r -> !r.isSynonym()).forEach(r -> DLTreeFactory.replaceSynonymsFromTree(r.getTDomain()));
        this.concepts.getConcepts().filter(p -> DLTreeFactory.replaceSynonymsFromTree(p.getDescription())).forEach(p -> p.initToldSubsumers());
        this.individuals.getConcepts().filter(p -> DLTreeFactory.replaceSynonymsFromTree(p.getDescription())).forEach(p -> p.initToldSubsumers());
    }

    @PortedFrom(file="dlTBox.h", name="preprocessRelated")
    public void preprocessRelated() {
        this.relatedIndividuals.forEach(q -> q.simplify());
    }

    @PortedFrom(file="dlTBox.h", name="transformToldCycles")
    public void transformToldCycles() {
        int nSynonyms = this.countSynonyms();
        this.clearRelevanceInfo();
        this.concepts.getConcepts().filter(p -> !p.isSynonym()).forEach(this::checkToldCycle);
        this.individuals.getConcepts().filter(p -> !p.isSynonym()).forEach(this::checkToldCycle);
        this.clearRelevanceInfo();
        nSynonyms = this.countSynonyms() - nSynonyms;
        if (nSynonyms > 0) {
            this.config.getLog().printTemplateInt(Templates.TRANSFORM_TOLD_CYCLES, nSynonyms);
            this.replaceAllSynonyms();
        }
    }

    @Nullable
    @PortedFrom(file="dlTBox.h", name="checkToldCycle")
    public Concept checkToldCycle(Concept p) {
        assert (p != null);
        Concept cp = ClassifiableEntry.resolveSynonym(p);
        if (cp.isTop()) {
            return null;
        }
        if (this.conceptInProcess.contains(cp)) {
            return cp;
        }
        if (cp.isRelevant(this.relevance)) {
            return null;
        }
        Concept ret = null;
        this.conceptInProcess.add(cp);
        boolean redo = false;
        block0: while (!redo) {
            redo = true;
            for (ClassifiableEntry r : cp.getToldSubsumers()) {
                ret = this.checkToldCycle((Concept)r);
                if (ret == null) continue;
                if (ret.equals(cp)) {
                    this.toldSynonyms.add(cp);
                    for (Concept q : this.toldSynonyms) {
                        if (!q.isSingleton()) continue;
                        cp = q;
                    }
                    HashSet<DLTree> leaves = new HashSet<DLTree>();
                    for (Concept q : this.toldSynonyms) {
                        if (q.equals(cp)) continue;
                        DLTree d = this.makeNonPrimitive(q, this.getTree(cp));
                        if (d.isBOTTOM()) {
                            leaves.clear();
                            leaves.add(d);
                            break;
                        }
                        leaves.add(d);
                        DLTree extra = this.extraConceptDefs.get(q);
                        if (extra == null) continue;
                        if (extra.isBOTTOM()) {
                            leaves.clear();
                            leaves.add(extra);
                            break;
                        }
                        leaves.add(d);
                        this.extraConceptDefs.remove(q);
                    }
                    this.toldSynonyms.clear();
                    cp.setPrimitive(true);
                    cp.addLeaves(leaves);
                    cp.removeSelfFromDescription();
                    if (!ret.equals(cp)) {
                        this.conceptInProcess.remove(ret);
                        this.conceptInProcess.add(cp);
                        ret.setRelevant(this.relevance);
                        cp.dropRelevant();
                    }
                    ret = null;
                    redo = false;
                    continue block0;
                }
                this.toldSynonyms.add(cp);
                redo = true;
                continue block0;
            }
        }
        this.conceptInProcess.remove(cp);
        cp.setRelevant(this.relevance);
        return ret;
    }

    @PortedFrom(file="dlTBox.h", name="transformSingletonHierarchy")
    public void transformSingletonHierarchy() {
        long nSynonyms = this.countSynonyms();
        AtomicBoolean changed = new AtomicBoolean(false);
        do {
            changed.set(false);
            this.individuals.getConcepts().filter(pi -> !pi.isSynonym() && pi.isHasSP()).forEach(pi -> {
                this.transformSingletonWithSP((Concept)pi).removeSelfFromDescription();
                changed.set(true);
            });
        } while (changed.get());
        nSynonyms = (long)this.countSynonyms() - nSynonyms;
        if (nSynonyms > 0L) {
            this.replaceAllSynonyms();
        }
    }

    @PortedFrom(file="dlTBox.h", name="getSPForConcept")
    public Individual getSPForConcept(Concept p) {
        for (ClassifiableEntry r : p.getToldSubsumers()) {
            Concept i = (Concept)r;
            if (i.isSingleton()) {
                return (Individual)i;
            }
            if (!i.isHasSP()) continue;
            return this.transformSingletonWithSP(i);
        }
        throw new UnreachableSituationException();
    }

    @PortedFrom(file="dlTBox.h", name="transformSingletonWithSP")
    private Individual transformSingletonWithSP(Concept p) {
        Individual i = this.getSPForConcept(p);
        if (p.isSingleton()) {
            i.addRelated((Individual)p);
        }
        this.addSubsumeAxiom(i, this.makeNonPrimitive(p, this.getTree(i)));
        return i;
    }

    @PortedFrom(file="dlTBox.h", name="determineSorts")
    public void determineSorts() {
        if (this.config.isUseSortedReasoning()) {
            this.relatedIndividuals.forEach(p -> this.dlHeap.updateSorts(p.getA().getpName(), p.getRole(), p.getB().getpName()));
            this.simpleRules.forEach(q -> q.simpleRuleBody.forEach(r -> this.dlHeap.merge(this.dlHeap.get(q.bpHead).getSort(), r.getpName())));
            this.dlHeap.determineSorts(this.objectRoleMaster, this.dataRoleMaster);
        }
    }

    @PortedFrom(file="dlTBox.h", name="CalculateStatistic")
    public void calculateStatistic() {
        AtomicInteger npFull = new AtomicInteger();
        AtomicInteger nsFull = new AtomicInteger();
        AtomicInteger nPC = new AtomicInteger();
        AtomicInteger nNC = new AtomicInteger();
        AtomicInteger nSing = new AtomicInteger();
        AtomicInteger nNoTold = new AtomicInteger();
        this.concepts.getConcepts().filter(p -> Helper.isValid(p.getpName())).forEach(n -> {
            if (n.isPrimitive()) {
                nPC.incrementAndGet();
            } else {
                nNC.incrementAndGet();
            }
            if (n.isSynonym()) {
                nsFull.incrementAndGet();
            }
            if (n.isCompletelyDefined()) {
                if (n.isPrimitive()) {
                    npFull.incrementAndGet();
                }
            } else if (!n.hasToldSubsumers()) {
                nNoTold.incrementAndGet();
            }
        });
        this.individuals.getConcepts().filter(p -> Helper.isValid(p.getpName())).forEach(n -> {
            nSing.incrementAndGet();
            if (n.isPrimitive()) {
                nPC.incrementAndGet();
            } else {
                nNC.incrementAndGet();
            }
            if (n.isSynonym()) {
                nsFull.incrementAndGet();
            }
            if (n.isCompletelyDefined()) {
                if (n.isPrimitive()) {
                    npFull.incrementAndGet();
                }
            } else if (!n.hasToldSubsumers()) {
                nNoTold.incrementAndGet();
            }
        });
        this.config.getLog().print("There are ").print((Object)nPC).print(" primitive concepts used\n of which ").print((Object)npFull).print(" completely defined\n      and ").print((Object)nNoTold).print(" has no told subsumers\nThere are ").print((Object)nNC).print(" non-primitive concepts used\n of which ").print((Object)nsFull).print(" synonyms\nThere are ").print((Object)nSing).print(" individuals or nominals used\n");
    }

    @PortedFrom(file="dlTBox.h", name="RemoveExtraDescriptions")
    public void removeExtraDescriptions() {
        this.concepts.getConcepts().forEach(pc -> pc.removeDescription());
        this.individuals.getConcepts().forEach(pi -> pi.removeDescription());
    }

    @Original
    public void setToDoPriorities() {
        this.stdReasoner.initToDoPriorities();
        if (this.nomReasoner != null) {
            this.nomReasoner.initToDoPriorities();
        }
    }

    @PortedFrom(file="dlTBox.h", name="isBlockedInd")
    public boolean isBlockedInd(Concept c) {
        return this.sameIndividuals.containsKey(c);
    }

    @PortedFrom(file="dlTBox.h", name="getBlockingInd")
    public Individual getBlockingInd(Concept c) {
        return this.sameIndividuals.get((Object)c).first;
    }

    @PortedFrom(file="dlTBox.h", name="isBlockingDet")
    public boolean isBlockingDet(Concept c) {
        return this.sameIndividuals.get((Object)c).second;
    }

    @PortedFrom(file="dlTBox.h", name="initConstCache")
    private void initConstCache(int p) {
        this.dlHeap.setCache(p, ModelCacheConst.createConstCache(p));
    }

    @PortedFrom(file="dlTBox.h", name="initSingletonCache")
    private void initSingletonCache(Concept p, boolean pos) {
        this.dlHeap.setCache(Helper.createBiPointer(p.getpName(), pos), new ModelCacheSingleton(Helper.createBiPointer(p.getIndex(), pos)));
    }

    @PortedFrom(file="dlTBox.h", name="initCache")
    public ModelCacheInterface initCache(Concept pConcept, boolean sub) {
        int bp = sub ? -pConcept.getpName() : pConcept.getpName();
        ModelCacheInterface cache = this.dlHeap.getCache(bp);
        if (cache == null) {
            if (sub) {
                this.prepareFeatures(null, pConcept);
            } else {
                this.prepareFeatures(pConcept, null);
            }
            cache = this.getReasoner().createCache(bp, FastSetFactory.create());
            this.clearFeatures();
        }
        return cache;
    }

    @PortedFrom(file="dlTBox.h", name="testCachedNonSubsumption")
    public ModelCacheState testCachedNonSubsumption(Concept p, Concept q) {
        ModelCacheInterface pCache = this.initCache(p, false);
        ModelCacheInterface nCache = this.initCache(q, true);
        return pCache.canMerge(nCache);
    }

    @PortedFrom(file="dlTBox.h", name="initReasoner")
    public void initReasoner() {
        assert (!this.reasonersInited());
        this.stdReasoner = new DlSatTester(this, this.config);
        if (this.nominalCloudFeatures.hasSingletons()) {
            this.nomReasoner = new NominalReasoner(this, this.config);
        }
        this.setToDoPriorities();
    }

    @PortedFrom(file="DLConceptTaxonomy.h", name="initTaxonomy")
    public void initTaxonomy() {
        this.pTax = new Taxonomy(this.top, this.bottom, this.config);
        this.pTaxCreator = new DLConceptTaxonomy(this.pTax, this);
    }

    @PortedFrom(file="dlTBox.h", name="setNameSigMap")
    public void setNameSigMap(Map<OWLEntity, Signature> p) {
        this.pName2Sig = p;
    }

    @Nullable
    @Original
    public Signature getSignature(ClassifiableEntry c) {
        if (this.pName2Sig == null) {
            return null;
        }
        if (c.getEntity() == null) {
            return null;
        }
        return this.pName2Sig.get(c.getEntity());
    }

    @PortedFrom(file="dlTBox.h", name="setRelevant")
    private void setRelevant(int p) {
        FastSet done = FastSetFactory.create();
        TIntLinkedList queue = new TIntLinkedList();
        queue.add(p);
        block8: while (!queue.isEmpty()) {
            int nextP = queue.removeAt(0);
            if (done.contains(nextP)) continue;
            done.add(nextP);
            assert (Helper.isValid(nextP));
            if (nextP == 1 || nextP == -1) continue;
            DLVertex v = this.realSetRelevant(nextP);
            DagTag type = v.getType();
            switch (type) {
                case DATATYPE: 
                case DATAVALUE: 
                case DATAEXPR: 
                case NN: {
                    break;
                }
                case PCONCEPT: 
                case NCONCEPT: 
                case PSINGLETON: 
                case NSINGLETON: {
                    Concept concept = (Concept)v.getConcept();
                    if (concept.isRelevant(this.relevance)) continue block8;
                    ++this.nRelevantCCalls;
                    concept.setRelevant(this.relevance);
                    this.collectLogicFeature(concept);
                    queue.add(concept.getpBody());
                    break;
                }
                case FORALL: 
                case LE: {
                    Role vRole = v.getRole();
                    LinkedList<Role> rolesToExplore = new LinkedList<Role>();
                    rolesToExplore.add(vRole);
                    while (!rolesToExplore.isEmpty()) {
                        Role roleToExplore = (Role)rolesToExplore.remove(0);
                        if (roleToExplore.getId() == 0 && !roleToExplore.isTop() || roleToExplore.isRelevant(this.relevance)) continue;
                        roleToExplore.setRelevant(this.relevance);
                        this.collectLogicFeature(roleToExplore);
                        queue.add(roleToExplore.getBPDomain());
                        queue.add(roleToExplore.getBPRange());
                        rolesToExplore.addAll(roleToExplore.getAncestor());
                    }
                    queue.add(v.getConceptIndex());
                    break;
                }
                case PROJ: 
                case CHOOSE: {
                    queue.add(v.getConceptIndex());
                    break;
                }
                case IRR: {
                    Role vRole = v.getRole();
                    LinkedList<Role> vRolesToExplore = new LinkedList<Role>();
                    vRolesToExplore.add(vRole);
                    while (!vRolesToExplore.isEmpty()) {
                        Role roleToExplore = (Role)vRolesToExplore.remove(0);
                        if (roleToExplore.getId() == 0 || roleToExplore.isRelevant(this.relevance)) continue;
                        roleToExplore.setRelevant(this.relevance);
                        this.collectLogicFeature(roleToExplore);
                        queue.add(roleToExplore.getBPDomain());
                        queue.add(roleToExplore.getBPRange());
                        vRolesToExplore.addAll(roleToExplore.getAncestor());
                    }
                    continue block8;
                }
                case COLLECTION: 
                case AND: {
                    for (int q : v.begin()) {
                        queue.add(q);
                    }
                    continue block8;
                }
                default: {
                    throw new ReasonerInternalException("Error setting relevant vertex of type " + (Object)((Object)type));
                }
            }
        }
    }

    @Original
    private DLVertex realSetRelevant(int p) {
        DLVertex v = this.dlHeap.get(p);
        boolean pos = p > 0;
        ++this.nRelevantBCalls;
        this.collectLogicFeature(v, pos);
        return v;
    }

    @PortedFrom(file="dlTBox.h", name="gatherRelevanceInfo")
    private void gatherRelevanceInfo() {
        this.nRelevantCCalls = 0L;
        this.nRelevantBCalls = 0L;
        this.curFeature = this.gciFeatures;
        this.markGCIsRelevant();
        this.clearRelevanceInfo();
        this.kbFeatures.or(this.gciFeatures);
        this.nominalCloudFeatures = new LogicFeatures(this.gciFeatures);
        this.individuals.getConcepts().forEach(pi -> {
            this.setConceptRelevant((Concept)pi);
            this.nominalCloudFeatures.or(pi.getPosFeatures());
        });
        if (this.nominalCloudFeatures.hasSomeAll() && !this.relatedIndividuals.isEmpty()) {
            this.nominalCloudFeatures.setInverseRoles();
        }
        this.concepts.getConcepts().forEach(this::setConceptRelevant);
        int bSize = this.dlHeap.size() - 2;
        this.curFeature = null;
        double bRatio = 0.0;
        double sqBSize = 1.0;
        if (bSize > 20) {
            bRatio = (float)this.nRelevantBCalls / (float)bSize;
            sqBSize = Math.sqrt(bSize);
        }
        boolean bl = this.isLikeGALEN = bRatio > sqBSize * 20.0 && bRatio < (double)bSize;
        if (this.kbFeatures.hasTopRole()) {
            this.config.setUseSortedReasoning(false);
        }
    }

    @PortedFrom(file="dlTBox.h", name="printFeatures")
    public void printFeatures() {
        this.kbFeatures.writeState(this.config.getLog());
        this.config.getLog().print("KB contains ", this.gcis.isGCI() ? "" : "NO ", "GCIs\nKB contains ", this.gcis.isReflexive() ? "" : "NO ", "reflexive roles\nKB contains ", this.gcis.isRnD() ? "" : "NO ", "range and domain restrictions\n");
    }

    @Original
    public List<List<Individual>> getDifferent() {
        return this.differentIndividuals;
    }

    @Original
    public List<Related> getRelatedI() {
        return this.relatedIndividuals;
    }

    @Original
    public DLDag getDLHeap() {
        return this.dlHeap;
    }

    @Original
    public KBFlags getGCIs() {
        return this.gcis;
    }

    @PortedFrom(file="dlTBox.h", name="replaceForall")
    public Concept replaceForall(DLTree rc) {
        if (this.forallRCCache.containsKey(rc)) {
            return this.forallRCCache.get(rc);
        }
        Concept x = this.getAuxConcept(null);
        DLTree c = DLTreeFactory.createSNFNot(rc.getRight().copy());
        DLTree forAll = DLTreeFactory.createSNFForall(DLTreeFactory.createInverse(rc.getLeft().copy()), this.getTree(x));
        this.config.getAbsorptionLog().print("\nReplaceForall: add").print((Object)c).print(" [=").print((Object)forAll);
        this.addSubsumeAxiom(c, forAll);
        this.forallRCCache.put(rc, x);
        return x;
    }

    @PortedFrom(file="dlTBox.h", name="isCancelled")
    public AtomicBoolean isCancelled() {
        return this.interrupted;
    }

    @Original
    public List<Concept> getFairness() {
        return this.fairness;
    }

    public void addSameIndividuals(Individual p, Pair pair) {
        this.sameIndividuals.put(p, pair);
    }

    public void reclassify(Set<OWLEntity> mPlus, Set<OWLEntity> mMinus) {
        this.pTaxCreator.reclassify(mPlus, mMinus);
        this.status = KBStatus.KBREALISED;
    }

    public TIntList getConceptsForQueryAnswering() {
        return this.conceptsForQueryAnswering;
    }

    public boolean isDuringClassification() {
        return this.duringClassification;
    }

    public IterableVec<Individual> getIV() {
        return this.iv;
    }

    public int getnSkipBeforeBlock() {
        return this.nSkipBeforeBlock;
    }

    static class IterableVec<E>
    implements Serializable {
        private final List<IterableElem<E>> base = new ArrayList<IterableElem<E>>();

        IterableVec() {
        }

        public void clear() {
            this.base.clear();
        }

        public boolean next(int i) {
            if (this.base.get(i).next()) {
                return i == 0 ? true : this.next(i - 1);
            }
            return false;
        }

        void add(IterableElem<E> it) {
            this.base.add(it);
        }

        boolean next() {
            return this.next(this.base.size() - 1);
        }

        int size() {
            return this.base.size();
        }

        E get(int i) {
            return this.base.get(i).getCur();
        }
    }

    static class IterableElem<E>
    implements Serializable {
        private final List<E> elems;
        private final int pBeg;
        private final int pEnd;
        private int pCur;

        IterableElem(List<E> init) {
            this.elems = init;
            this.pBeg = 0;
            this.pEnd = this.elems.size();
            this.pCur = 0;
            if (this.elems.isEmpty()) {
                throw new IllegalArgumentException("no empties allowed");
            }
        }

        public E getCur() {
            return this.elems.get(this.pCur);
        }

        public boolean next() {
            if (++this.pCur >= this.pEnd) {
                this.pCur = this.pBeg;
                return true;
            }
            return false;
        }
    }
}

