/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeFactory;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.Lexeme;
import uk.ac.manchester.cs.jfact.kernel.NameSet;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.Taxonomy;
import uk.ac.manchester.cs.jfact.kernel.TaxonomyCreator;
import uk.ac.manchester.cs.jfact.kernel.Token;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.NamedEntity;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;

@PortedFrom(file="RoleMaster.h", name="RoleMaster")
public class RoleMaster
implements Serializable {
    @PortedFrom(file="RoleMaster.h", name="newRoleId")
    private int newRoleId = 1;
    @PortedFrom(file="RoleMaster.h", name="Roles")
    private final List<Role> roles = new ArrayList<Role>();
    @PortedFrom(file="RoleMaster.h", name="emptyRole")
    private final Role emptyRole;
    @PortedFrom(file="RoleMaster.h", name="universalRole")
    private final Role universalRole;
    @PortedFrom(file="RoleMaster.h", name="roleNS")
    private final NameSet<Role, IRI> roleNS;
    @PortedFrom(file="RoleMaster.h", name="pTax")
    private final Taxonomy pTax;
    @PortedFrom(file="RoleMaster.h", name="DJRolesA")
    private final List<Role> disjointRolesA = new ArrayList<Role>();
    @PortedFrom(file="RoleMaster.h", name="DJRolesB")
    private final List<Role> disjointRolesB = new ArrayList<Role>();
    @PortedFrom(file="RoleMaster.h", name="DataRoles")
    private final boolean dataRoles;
    @PortedFrom(file="RoleMaster.h", name="useUndefinedNames")
    private boolean useUndefinedNames;
    @Original
    private static final int FIRSTROLEINDEX = 2;

    public RoleMaster(boolean d, NamedEntity topRoleName, NamedEntity botRoleName, JFactReasonerConfiguration c) {
        this.emptyRole = new Role(botRoleName.getIRI());
        this.emptyRole.setEntity(botRoleName);
        this.universalRole = new Role(topRoleName.getIRI());
        this.universalRole.setEntity(topRoleName);
        this.roleNS = new NameSet<Role, IRI>(name -> new Role((IRI)name));
        this.dataRoles = d;
        this.useUndefinedNames = true;
        this.roles.add(null);
        this.roles.add(null);
        this.emptyRole.setId(0);
        this.emptyRole.setInverse(this.emptyRole);
        this.emptyRole.setDataRole(this.dataRoles);
        this.emptyRole.setBPDomain(-1);
        this.emptyRole.setBottom();
        this.universalRole.setId(0);
        this.universalRole.setInverse(this.universalRole);
        this.universalRole.setDataRole(this.dataRoles);
        this.universalRole.setBPDomain(1);
        this.universalRole.setTop();
        this.universalRole.getAutomaton().setCompleted(true);
        this.pTax = new Taxonomy(this.universalRole, this.emptyRole, c);
    }

    @PortedFrom(file="RoleMaster.h", name="registerRole")
    private void registerRole(Role r) {
        assert (r != null && r.getInverse() == null);
        assert (r.getId() == 0);
        if (this.dataRoles) {
            r.setDataRole(true);
        }
        this.roles.add(r);
        r.setId(this.newRoleId);
        Role ri = new Role(IRI.create((String)("-" + r.getIRI())));
        r.setInverse(ri);
        ri.setInverse(r);
        this.roles.add(ri);
        ri.setId(-this.newRoleId);
        ++this.newRoleId;
    }

    @PortedFrom(file="RoleMaster.h", name="isRegisteredRole")
    private boolean isRegisteredRole(NamedEntry p) {
        if (!(p instanceof Role)) {
            return false;
        }
        Role r = (Role)p;
        int ind = r.getAbsoluteIndex();
        return ind >= 2 && ind < this.roles.size() && this.roles.get(ind).equals(p);
    }

    @PortedFrom(file="RoleMaster.h", name="size")
    public int size() {
        return this.roles.size() / 2 - 1;
    }

    @PortedFrom(file="RoleMaster.h", name="ensureRoleName")
    public NamedEntry ensureRoleName(IRI name) {
        if (name.equals((Object)this.emptyRole.getIRI())) {
            return this.emptyRole;
        }
        if (name.equals((Object)this.universalRole.getIRI())) {
            return this.universalRole;
        }
        Role p = this.roleNS.insert(name);
        if (this.isRegisteredRole(p)) {
            return p;
        }
        if (p.getId() != 0 || !this.useUndefinedNames) {
            throw new OWLRuntimeException("Unable to register '" + name + "' as a " + (this.dataRoles ? "data role" : "role"));
        }
        this.registerRole(p);
        return p;
    }

    @PortedFrom(file="RoleMaster.h", name="addRoleSynonym")
    public static void addRoleSynonym(Role role, Role syn) {
        RoleMaster.addRoleParentProper(ClassifiableEntry.resolveSynonym(role), ClassifiableEntry.resolveSynonym(syn));
        RoleMaster.addRoleParentProper(ClassifiableEntry.resolveSynonym(syn), ClassifiableEntry.resolveSynonym(role));
    }

    @PortedFrom(file="RoleMaster.h", name="addRoleParentProper")
    public static void addRoleParentProper(Role role, Role parent) {
        assert (!role.isSynonym() && !parent.isSynonym());
        if (role.equals(parent)) {
            return;
        }
        if (role.isDataRole() != parent.isDataRole()) {
            throw new ReasonerInternalException("Mixed object and data roles in role subsumption axiom");
        }
        if (role.isTop() && parent.isBottom()) {
            throw new InconsistentOntologyException();
        }
        if (role.isTop()) {
            parent.setSynonym(role);
            parent.inverse().setSynonym(role);
            return;
        }
        if (parent.isBottom()) {
            role.setSynonym(parent);
            role.inverse().setSynonym(parent);
            return;
        }
        role.addParent(parent);
        role.inverse().addParent(parent.inverse());
    }

    @PortedFrom(file="RoleMaster.h", name="addDisjointRoles")
    public void addDisjointRoles(Role r, Role s) {
        if (r.isDataRole() != s.isDataRole()) {
            return;
        }
        this.disjointRolesA.add(r);
        this.disjointRolesB.add(s);
    }

    @PortedFrom(file="RoleMaster.h", name="setUndefinedNames")
    public void setUndefinedNames(boolean val) {
        this.useUndefinedNames = val;
    }

    @PortedFrom(file="RoleMaster.h", name="begin")
    public List<Role> getRoles() {
        return this.roles.subList(2, this.roles.size());
    }

    @PortedFrom(file="RoleMaster.h", name="getTaxonomy")
    public Taxonomy getTaxonomy() {
        return this.pTax;
    }

    public Stream<Role> roles() {
        return this.roles.stream().skip(2L);
    }

    @PortedFrom(file="RoleMaster.h", name="Print")
    public void print(LogAdapter o, String type) {
        if (this.size() == 0) {
            return;
        }
        o.print((Object)type, (Object)" Roles (").print(this.size()).print("):\n");
        o.print((Object)this.emptyRole);
        this.roles().forEach(p -> p.print(o));
    }

    @PortedFrom(file="RoleMaster.h", name="hasReflexiveRoles")
    public boolean hasReflexiveRoles() {
        return this.roles().anyMatch(p -> p.isReflexive());
    }

    @PortedFrom(file="RoleMaster.h", name="fillReflexiveRoles")
    public void fillReflexiveRoles(List<Role> rr) {
        rr.clear();
        OWLAPIStreamUtils.add(rr, this.roles().filter(p -> !p.isSynonym() && p.isReflexive()));
    }

    @PortedFrom(file="RoleMaster.h", name="addRoleParent")
    public static void addRoleParent(Role role, Role parent) {
        RoleMaster.addRoleParentProper(ClassifiableEntry.resolveSynonym(role), ClassifiableEntry.resolveSynonym(parent));
    }

    @PortedFrom(file="RoleMaster.h", name="addRoleParent")
    public static void addRoleParent(@Nullable DLTree tree, Role parent) {
        if (tree == null) {
            return;
        }
        if (tree.token() == Token.RCOMPOSITION) {
            parent.addComposition(tree);
            DLTree inv = DLTreeFactory.inverseComposition(tree);
            parent.inverse().addComposition(inv);
        } else if (tree.token() == Token.PROJINTO) {
            Role r = Role.resolveRole(tree.getLeft());
            if (r.isDataRole()) {
                throw new ReasonerInternalException("Projection into not implemented for the data role");
            }
            DLTree c = tree.getRight().copy();
            DLTree invP = DLTreeFactory.buildTree(new Lexeme(Token.RNAME, parent.inverse()));
            DLTree invR = DLTreeFactory.buildTree(new Lexeme(Token.RNAME, r.inverse()));
            c = DLTreeFactory.buildTree(new Lexeme(Token.PROJINTO), invP, c);
            c = DLTreeFactory.buildTree(new Lexeme(Token.PROJFROM), invR, c);
            r.setRange(c);
        } else if (tree.token() == Token.PROJFROM) {
            Role r = Role.resolveRole(tree.getLeft());
            DLTree c = tree.getRight().copy();
            DLTree p = DLTreeFactory.buildTree(new Lexeme(Token.RNAME, parent));
            c = DLTreeFactory.buildTree(new Lexeme(Token.PROJINTO), p, c);
            c = DLTreeFactory.buildTree(new Lexeme(Token.PROJFROM), tree.getLeft().copy(), c);
            r.setDomain(c);
        } else {
            RoleMaster.addRoleParent(Role.resolveRole(tree), parent);
        }
    }

    @PortedFrom(file="RoleMaster.h", name="initAncDesc")
    public void initAncDesc() {
        int nRoles = this.roles.size();
        this.roles().forEach(p -> p.eliminateToldCycles());
        this.roles().filter(p -> p.isSynonym()).forEach(p -> {
            p.canonicaliseSynonym();
            p.addFeaturesToSynonym();
        });
        this.roles().filter(p -> !p.isSynonym()).forEach(p -> p.removeSynonymsFromParents());
        this.universalRole.completeAutomaton(nRoles);
        this.roles().filter(p -> !p.isSynonym() && !p.hasToldSubsumers()).forEach(p -> p.addParent(this.universalRole));
        TaxonomyCreator taxCreator = new TaxonomyCreator(this.pTax);
        taxCreator.setCompletelyDefined(true);
        this.roles().filter(p -> !p.isClassified()).forEach(taxCreator::classifyEntry);
        this.roles().filter(p -> !p.isSynonym()).forEach(p -> p.initADbyTaxonomy(this.pTax, nRoles));
        this.roles().filter(p -> !p.isSynonym()).forEach(p -> p.completeAutomaton(nRoles));
        this.pTax.finalise();
        if (!this.disjointRolesA.isEmpty()) {
            for (int i = 0; i < this.disjointRolesA.size(); ++i) {
                Role r = (Role)ClassifiableEntry.resolveSynonym((ClassifiableEntry)this.disjointRolesA.get(i));
                Role s = (Role)ClassifiableEntry.resolveSynonym((ClassifiableEntry)this.disjointRolesB.get(i));
                r.addDisjointRole(s);
                s.addDisjointRole(r);
                r.inverse().addDisjointRole(s.inverse());
                s.inverse().addDisjointRole(r.inverse());
            }
            this.roles().filter(p -> !p.isSynonym() && p.isDisjoint()).forEach(p -> p.checkHierarchicalDisjoint());
        }
        this.roles().filter(p -> !p.isSynonym()).forEach(p -> p.postProcess());
        this.roles().filter(p -> !p.isSynonym()).forEach(p -> p.consistent());
    }

    @PortedFrom(file="RoleMaster.h", name="getTopRole")
    public Role getTopRole() {
        return this.universalRole;
    }

    @PortedFrom(file="RoleMaster.h", name="getBotRole")
    public Role getBotRole() {
        return this.emptyRole;
    }
}

