/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.kernel.RAStateTransitions;
import uk.ac.manchester.cs.jfact.kernel.RATransition;

@PortedFrom(file="RAutomaton.h", name="RoleAutomaton")
public class RoleAutomaton
implements Serializable {
    @Original
    public static final int INITIAL = 0;
    @PortedFrom(file="RAutomaton.h", name="final")
    public static final int FINAL_STATE = 1;
    @PortedFrom(file="RAutomaton.h", name="Base")
    private final List<RAStateTransitions> base = new ArrayList<RAStateTransitions>();
    @PortedFrom(file="RAutomaton.h", name="map")
    private int[] map = new int[0];
    @PortedFrom(file="RAutomaton.h", name="iRA")
    private int initialRA = 0;
    @PortedFrom(file="RAutomaton.h", name="ISafe")
    private boolean inputSafe = true;
    @PortedFrom(file="RAutomaton.h", name="OSafe")
    private boolean outputSafe = true;
    @PortedFrom(file="RAutomaton.h", name="Complete")
    private boolean complete;

    public RoleAutomaton() {
        this.ensureState(1);
    }

    @PortedFrom(file="RAutomaton.h", name="ensureState")
    private void ensureState(int state) {
        IntStream.range(this.base.size(), state + 1).forEach(i -> this.base.add(new RAStateTransitions()));
    }

    @PortedFrom(file="RAutomaton.h", name="initChain")
    public void initChain(int from) {
        this.initialRA = from;
    }

    @PortedFrom(file="RAutomaton.h", name="addToChain")
    public boolean addToChain(RoleAutomaton ra, boolean oSafe) {
        return this.addToChain(ra, oSafe, this.size() + 1);
    }

    @PortedFrom(file="RAutomaton.h", name="isISafe")
    public boolean isISafe() {
        return this.inputSafe;
    }

    @PortedFrom(file="RAutomaton.h", name="isOSafe")
    public boolean isOSafe() {
        return this.outputSafe;
    }

    @PortedFrom(file="RAutomaton.h", name="addRA")
    public void addRA(RoleAutomaton ra) {
        if (ra.isSimple()) {
            boolean ok = this.base.get(0).addToExisting(ra.get(0).begin().get(0));
            assert (ok);
        } else {
            this.initChain(0);
            this.addToChain(ra, false, 1);
        }
    }

    @PortedFrom(file="RAutomaton.h", name="addTransitionSafe")
    public void addTransitionSafe(int state, RATransition trans) {
        this.ensureState(state);
        this.ensureState(trans.finalState());
        this.addTransition(state, trans);
    }

    @PortedFrom(file="RAutomaton.h", name="setIUnsafe")
    public void setIUnsafe() {
        this.inputSafe = false;
    }

    @PortedFrom(file="RAutomaton.h", name="setOUnsafe")
    public void setOUnsafe() {
        this.outputSafe = false;
    }

    @PortedFrom(file="RAutomaton.h", name="checkTransition")
    public void checkTransition(int from, int to) {
        if (from == 1) {
            this.setOUnsafe();
        }
        if (to == 0) {
            this.setIUnsafe();
        }
    }

    @PortedFrom(file="RAutomaton.h", name="addTransition")
    public void addTransition(int from, RATransition trans) {
        this.checkTransition(from, trans.finalState());
        this.base.get(from).add(trans);
    }

    @PortedFrom(file="RAutomaton.h", name="nextChainTransition")
    public void nextChainTransition(int to) {
        this.addTransition(this.initialRA, new RATransition(to));
        this.initialRA = to;
    }

    @PortedFrom(file="RAutomaton.h", name="newState")
    public int newState() {
        int ret = this.base.size();
        this.ensureState(ret);
        return ret;
    }

    @PortedFrom(file="RAutomaton.h", name="begin")
    public RAStateTransitions getRAStateTransitions(int state) {
        return this.base.get(state);
    }

    @PortedFrom(file="RAutomaton.h", name="size")
    public int size() {
        return this.base.size();
    }

    @PortedFrom(file="RAutomaton.h", name="setup")
    public void setup(int nRoles, boolean data) {
        for (int i = 0; i < this.base.size(); ++i) {
            this.base.get(i).setup(i, nRoles, data);
        }
    }

    @PortedFrom(file="RAutomaton.h", name="print")
    public void print(LogAdapter o) {
        this.base.forEach(p -> p.print(o));
    }

    @PortedFrom(file="RAutomaton.h", name="addCopy")
    public void addCopy(RoleAutomaton ra) {
        for (int i = 0; i < ra.size(); ++i) {
            int from = this.map[i];
            RAStateTransitions rst = this.base.get(from);
            RAStateTransitions rstOrig = ra.base.get(i);
            if (rstOrig.empty()) continue;
            rstOrig.begin().forEach(p -> {
                int to = p.finalState();
                RATransition trans = new RATransition(this.map[to]);
                this.checkTransition(from, trans.finalState());
                trans.add((RATransition)p);
                if (to != 1 || !rst.addToExisting(trans)) {
                    rst.add(trans);
                }
            });
        }
    }

    @PortedFrom(file="RAutomaton.h", name="initMap")
    public void initMap(int raSize, int fra) {
        this.map = Arrays.copyOf(this.map, raSize);
        int newState = this.size() - 1;
        this.map[0] = this.initialRA;
        if (fra >= this.size()) {
            fra = this.size();
            ++newState;
        }
        this.map[1] = fra;
        this.checkTransition(this.initialRA, fra);
        this.initialRA = fra;
        for (int i = 2; i < raSize; ++i) {
            this.map[i] = ++newState;
        }
        this.ensureState(newState);
    }

    @PortedFrom(file="RAutomaton.h", name="addToChain")
    public boolean addToChain(RoleAutomaton ra, boolean oSafe, int fRA) {
        boolean needFinalTrans;
        boolean bl = needFinalTrans = fRA < this.size() && !ra.isOSafe();
        if (!oSafe && !ra.isISafe()) {
            this.nextChainTransition(this.newState());
        }
        this.initMap(ra.size(), needFinalTrans ? this.size() : fRA);
        this.addCopy(ra);
        if (needFinalTrans) {
            this.nextChainTransition(fRA);
        }
        return ra.isOSafe();
    }

    @PortedFrom(file="RAutomaton.h", name="begin")
    public List<RAStateTransitions> getBase() {
        return this.base;
    }

    @PortedFrom(file="RAutomaton.h", name="begin")
    public RAStateTransitions get(int i) {
        return this.base.get(i);
    }

    @PortedFrom(file="RAutomaton.h", name="setCompleted")
    public void setCompleted(boolean b) {
        this.complete = b;
    }

    @PortedFrom(file="RAutomaton.h", name="isCompleted")
    public boolean isCompleted() {
        return this.complete;
    }

    @PortedFrom(file="RAutomaton.h", name="isSimple")
    public boolean isSimple() {
        return this.size() == 2 && this.inputSafe && this.outputSafe;
    }
}

