/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.chainsaw.FastSet;
import uk.ac.manchester.cs.chainsaw.FastSetFactory;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeFactory;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.Lexeme;
import uk.ac.manchester.cs.jfact.kernel.MergableLabel;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.RATransition;
import uk.ac.manchester.cs.jfact.kernel.RoleAutomaton;
import uk.ac.manchester.cs.jfact.kernel.RoleCompare;
import uk.ac.manchester.cs.jfact.kernel.Taxonomy;
import uk.ac.manchester.cs.jfact.kernel.Token;
import uk.ac.manchester.cs.jfact.kernel.actors.AddRoleActor;

@PortedFrom(file="tRole.h", name="Role")
public class Role
extends ClassifiableEntry {
    private static final String NON_SIMPLE_ROLE = "Non simple role used as simple: ";
    private static final String CYCLE_IN_RIA = "Cycle in RIA ";
    @PortedFrom(file="tRole.h", name="Inverse")
    private Role inverse = null;
    @PortedFrom(file="tRole.h", name="pDomain")
    private DLTree pDomain = null;
    @PortedFrom(file="tRole.h", name="pSpecialDomain")
    private DLTree pSpecialDomain = null;
    @PortedFrom(file="tRole.h", name="bpSpecialDomain")
    private int bpSpecialDomain = 0;
    @PortedFrom(file="tRole.h", name="bpDomain")
    private int bpDomain = 0;
    @PortedFrom(file="tRole.h", name="Functional")
    private int functional = 0;
    @PortedFrom(file="tRole.h", name="rel")
    private long rel = 0L;
    @PortedFrom(file="tRole.h", name="domLabel")
    private final MergableLabel domLabel = new MergableLabel();
    @PortedFrom(file="tRole.h", name="Ancestor")
    private final List<Role> ancestorRoles = new ArrayList<Role>();
    @PortedFrom(file="tRole.h", name="Descendant")
    private final List<Role> descendantRoles = new ArrayList<Role>();
    @PortedFrom(file="tRole.h", name="TopFunc")
    private final List<Role> topFunctionalRoles = new ArrayList<Role>();
    @PortedFrom(file="tRole.h", name="Disjoint")
    private final Set<Role> disjointRoles = new HashSet<Role>();
    @PortedFrom(file="tRole.h", name="subCompositions")
    private final LinkedHashSet<List<Role>> subCompositions = new LinkedHashSet();
    @PortedFrom(file="tRole.h", name="AncMap")
    private final FastSet ancestorMap = FastSetFactory.create();
    @PortedFrom(file="tRole.h", name="DJRoles")
    private final FastSet disjointRolesIndex = FastSetFactory.create();
    @PortedFrom(file="tRole.h", name="automaton")
    private final RoleAutomaton automaton = new RoleAutomaton();
    @PortedFrom(file="tRole.h", name="Functionality")
    private final KnownValue functionality = new KnownValue();
    @PortedFrom(file="tRole.h", name="Symmetry")
    private final KnownValue symmetry = new KnownValue();
    @PortedFrom(file="tRole.h", name="Asymmetry")
    private final KnownValue asymmetry = new KnownValue();
    @PortedFrom(file="tRole.h", name="Transitivity")
    private final KnownValue transitivity = new KnownValue();
    @PortedFrom(file="tRole.h", name="Reflexivity")
    private final KnownValue reflexivity = new KnownValue();
    @PortedFrom(file="tRole.h", name="Irreflexivity")
    private final KnownValue irreflexivity = new KnownValue();
    @PortedFrom(file="tRole.h", name="SpecialDomain")
    private boolean specialDomain = false;
    @Original
    private boolean dataRole;

    protected Role(IRI name) {
        super(name);
        this.setCompletelyDefined(true);
        this.addTrivialTransition(this);
    }

    @PortedFrom(file="tRole.h", name="addSubRoleAutomaton")
    private void addSubRoleAutomaton(Role r) {
        if (!this.equals(r)) {
            this.automaton.addRA(r.getAutomaton());
        }
    }

    @PortedFrom(file="tRole.h", name="addTrivialTransition")
    private void addTrivialTransition(Role r) {
        this.automaton.addTransitionSafe(0, new RATransition(1, r));
    }

    @PortedFrom(file="tRole.h", name="completeAutomatonByRole")
    private RoleAutomaton completeAutomatonByRole(Role r, Set<Role> rolesInProcess) {
        assert (!r.isSynonym());
        assert (r != this);
        r.completeAutomaton(rolesInProcess);
        return r.automaton;
    }

    @PortedFrom(file="tRole.h", name="mergeSupersDomain")
    public void mergeSupersDomain() {
        this.ancestorRoles.forEach(p -> this.domLabel.merge(p.domLabel));
        if (this.isReflexive()) {
            this.domLabel.merge(this.getRangeLabel());
        }
        this.subCompositions.stream().filter(p -> !p.isEmpty()).forEach(q -> {
            this.domLabel.merge(((Role)q.get((int)0)).domLabel);
            this.getRangeLabel().merge(((Role)q.get(q.size() - 1)).getRangeLabel());
        });
    }

    @PortedFrom(file="tRole.h", name="inverse")
    public Role inverse() {
        return (Role)Role.resolveSynonym((ClassifiableEntry)OWLAPIPreconditions.verifyNotNull((Object)this.inverse, (String)"inverse not initialized"));
    }

    @PortedFrom(file="tRole.h", name="realInverse")
    public Role realInverse() {
        assert (this.inverse != null);
        return this.inverse;
    }

    @PortedFrom(file="tRole.h", name="setInverse")
    public void setInverse(Role p) {
        assert (this.inverse == null);
        assert (p != null);
        this.inverse = p;
    }

    @PortedFrom(file="tRole.h", name="isSimple")
    public boolean isSimple() {
        return this.automaton.isSimple();
    }

    @PortedFrom(file="tRole.h", name="getTSpecialDomain")
    public DLTree getTSpecialDomain() {
        return this.pSpecialDomain;
    }

    @PortedFrom(file="tRole.h", name="hasSpecialDomain")
    public boolean hasSpecialDomain() {
        return this.specialDomain;
    }

    @PortedFrom(file="tRole.h", name="initSpecialDomain")
    public void initSpecialDomain() {
        if (!this.hasSpecialDomain() || this.getTRange() == null) {
            this.pSpecialDomain = DLTreeFactory.createTop();
        } else {
            this.pSpecialDomain = DLTreeFactory.createSNFForall(DLTreeFactory.createRole(this), this.getTRange().copy());
            this.pSpecialDomain = DLTreeFactory.createSNFForall(DLTreeFactory.buildTree(new Lexeme(Token.RNAME, this)), this.getTRange().copy());
        }
    }

    @PortedFrom(file="tRole.h", name="setSpecialDomain")
    public void setSpecialDomain(int bp) {
        this.bpSpecialDomain = bp;
    }

    @Original
    public boolean isDataRole() {
        return this.dataRole;
    }

    @Original
    public void setDataRole(boolean action) {
        this.dataRole = action;
    }

    @PortedFrom(file="tRole.h", name="isFunctional")
    public boolean isFunctional() {
        return this.functionality.getValue();
    }

    @PortedFrom(file="tRole.h", name="isFunctionalityKnown")
    public boolean isFunctionalityKnown() {
        return this.functionality.isKnown();
    }

    @PortedFrom(file="tRole.h", name="setFunctional")
    public void setFunctional(boolean value) {
        this.functionality.setValue(value);
    }

    @PortedFrom(file="tRole.h", name="setFunctional")
    public void setFunctional() {
        if (this.topFunctionalRoles.isEmpty()) {
            this.topFunctionalRoles.add(this);
        }
        this.setFunctional(true);
    }

    @PortedFrom(file="tRole.h", name="isTransitive")
    public boolean isTransitive() {
        return this.transitivity.getValue();
    }

    @PortedFrom(file="tRole.h", name="isTransitivityKnown")
    public boolean isTransitivityKnown() {
        return this.transitivity.isKnown();
    }

    @PortedFrom(file="tRole.h", name="setTransitive")
    public void setTransitive(boolean value) {
        this.transitivity.setValue(value);
        this.inverse().transitivity.setValue(value);
    }

    @PortedFrom(file="tRole.h", name="isSymmetric")
    public boolean isSymmetric() {
        return this.symmetry.getValue();
    }

    @PortedFrom(file="tRole.h", name="isSymmetryKnown")
    public boolean isSymmetryKnown() {
        return this.symmetry.isKnown();
    }

    @PortedFrom(file="tRole.h", name="setSymmetric")
    public void setSymmetric(boolean value) {
        this.symmetry.setValue(value);
        this.inverse().symmetry.setValue(value);
    }

    @PortedFrom(file="tRole.h", name="isAsymmetric")
    public boolean isAsymmetric() {
        return this.asymmetry.getValue();
    }

    @PortedFrom(file="tRole.h", name="isAsymmetryKnown")
    public boolean isAsymmetryKnown() {
        return this.asymmetry.isKnown();
    }

    @PortedFrom(file="tRole.h", name="setAsymmetric")
    public void setAsymmetric(boolean value) {
        this.asymmetry.setValue(value);
        this.inverse().asymmetry.setValue(value);
    }

    @PortedFrom(file="tRole.h", name="isReflexive")
    public boolean isReflexive() {
        return this.reflexivity.getValue();
    }

    @PortedFrom(file="tRole.h", name="isReflexivityKnown")
    public boolean isReflexivityKnown() {
        return this.reflexivity.isKnown();
    }

    @PortedFrom(file="tRole.h", name="setReflexive")
    public void setReflexive(boolean value) {
        this.reflexivity.setValue(value);
        this.inverse().reflexivity.setValue(value);
    }

    @PortedFrom(file="tRole.h", name="isIrreflexive")
    public boolean isIrreflexive() {
        return this.irreflexivity.getValue();
    }

    @PortedFrom(file="tRole.h", name="isIrreflexivityKnown")
    public boolean isIrreflexivityKnown() {
        return this.irreflexivity.isKnown();
    }

    @PortedFrom(file="tRole.h", name="setIrreflexive")
    public void setIrreflexive(boolean value) {
        this.irreflexivity.setValue(value);
        this.inverse().irreflexivity.setValue(value);
    }

    @PortedFrom(file="tRole.h", name="isTopFunc")
    public boolean isTopFunc() {
        return !this.topFunctionalRoles.isEmpty() && this.topFunctionalRoles.get(0).equals(this);
    }

    @PortedFrom(file="tRole.h", name="setFunctional")
    public void setFunctional(int fNode) {
        this.functional = fNode;
    }

    @PortedFrom(file="tRole.h", name="getFunctional")
    public int getFunctional() {
        return this.functional;
    }

    @PortedFrom(file="tRole.h", name="isRelevant")
    public boolean isRelevant(long lab) {
        return lab == this.rel;
    }

    @PortedFrom(file="tRole.h", name="setRelevant")
    public void setRelevant(long lab) {
        this.rel = lab;
    }

    @PortedFrom(file="tRole.h", name="getDomainLabel")
    public MergableLabel getDomainLabel() {
        return this.domLabel;
    }

    @PortedFrom(file="tRole.h", name="getRangeLabel")
    public MergableLabel getRangeLabel() {
        return this.inverse().domLabel;
    }

    @PortedFrom(file="tRole.h", name="setDomain")
    public void setDomain(DLTree p) {
        if (!DLTree.equalTrees(this.pDomain, p)) {
            if (DLTreeFactory.isFunctionalExpr(p, this)) {
                this.setFunctional();
            } else {
                this.pDomain = DLTreeFactory.createSNFReducedAnd(this.pDomain, p);
            }
        }
    }

    @PortedFrom(file="tRole.h", name="setRange")
    public void setRange(DLTree p) {
        this.inverse().setDomain(p);
    }

    @Nullable
    @PortedFrom(file="tRole.h", name="getTDomain")
    public DLTree getTDomain() {
        return this.pDomain;
    }

    @Nullable
    @PortedFrom(file="tRole.h", name="getTRange")
    private DLTree getTRange() {
        return this.inverse().pDomain;
    }

    @PortedFrom(file="tRole.h", name="collectDomainFromSupers")
    public void collectDomainFromSupers() {
        this.ancestorRoles.forEach(p -> this.setDomain(p.pDomain.copy()));
    }

    @PortedFrom(file="tRole.h", name="setBPDomain")
    public void setBPDomain(int p) {
        this.bpDomain = p;
    }

    @PortedFrom(file="tRole.h", name="getBPDomain")
    public int getBPDomain() {
        return this.bpDomain;
    }

    @PortedFrom(file="tRole.h", name="getBPRange")
    public int getBPRange() {
        return this.inverse().bpDomain;
    }

    @PortedFrom(file="tRole.h", name="addDisjointRole")
    public void addDisjointRole(Role r) {
        this.disjointRoles.add(r);
        r.descendantRoles.forEach(p -> {
            this.disjointRoles.add((Role)p);
            p.disjointRoles.add(this);
        });
    }

    @PortedFrom(file="tRole.h", name="checkHierarchicalDisjoint")
    public void checkHierarchicalDisjoint() {
        this.checkHierarchicalDisjoint(this);
        if (this.isReflexive()) {
            this.checkHierarchicalDisjoint(this.inverse());
        }
    }

    @PortedFrom(file="tRole.h", name="isDisjoint")
    public boolean isDisjoint() {
        return !this.disjointRoles.isEmpty();
    }

    @PortedFrom(file="tRole.h", name="isDisjoint")
    public boolean isDisjoint(Role r) {
        return this.disjointRolesIndex.contains(r.getAbsoluteIndex());
    }

    @PortedFrom(file="tRole.h", name="<")
    private boolean lesser(Role r) {
        return this.isDataRole() == r.isDataRole() && this.ancestorMap.contains(r.getAbsoluteIndex());
    }

    @PortedFrom(file="tRole.h", name="<=")
    public boolean lesserequal(Role r) {
        return this.equals(r) || this.lesser(r);
    }

    @PortedFrom(file="tRole.h", name="begin_anc")
    public List<Role> getAncestor() {
        return this.ancestorRoles;
    }

    @PortedFrom(file="tRole.h", name="begin_topfunc")
    public List<Role> beginTopfunc() {
        return this.topFunctionalRoles;
    }

    @PortedFrom(file="tRole.h", name="addAncestorsToBitMap")
    private void addAncestorsToBitMap(FastSet bitmap) {
        for (int i = 0; i < this.ancestorRoles.size(); ++i) {
            bitmap.add(this.ancestorRoles.get(i).getAbsoluteIndex());
        }
    }

    @PortedFrom(file="tRole.h", name="addComposition")
    public void addComposition(DLTree tree) {
        ArrayList<Role> rs = new ArrayList<Role>();
        this.fillsComposition(rs, tree);
        this.subCompositions.add(rs);
    }

    @Override
    public void addParent(ClassifiableEntry parent) {
        this.toldSubsumers.add(parent);
    }

    @Override
    public void addParents(Collection<ClassifiableEntry> entries) {
        entries.forEach(this::addParentIfNew);
    }

    @PortedFrom(file="tRole.h", name="getAutomaton")
    public RoleAutomaton getAutomaton() {
        return this.automaton;
    }

    @PortedFrom(file="tRole.h", name="eliminateToldCycles")
    public Role eliminateToldCycles() {
        HashSet<Role> rolesInProcess = new HashSet<Role>();
        ArrayList<Role> toldSynonyms = new ArrayList<Role>();
        return this.eliminateToldCycles(rolesInProcess, toldSynonyms);
    }

    @PortedFrom(file="tRole.h", name="completeAutomaton")
    public void completeAutomaton(int nRoles) {
        HashSet<Role> rolesInProcess = new HashSet<Role>();
        this.completeAutomaton(rolesInProcess);
        this.automaton.setup(nRoles, this.isDataRole());
    }

    @PortedFrom(file="tRole.h", name="consistent")
    public void consistent() {
        if (this.isSimple()) {
            return;
        }
        if (this.isFunctional()) {
            throw new ReasonerInternalException(NON_SIMPLE_ROLE + this.getIRI());
        }
        if (this.isDataRole()) {
            throw new ReasonerInternalException(NON_SIMPLE_ROLE + this.getIRI());
        }
        if (this.isDisjoint()) {
            throw new ReasonerInternalException(NON_SIMPLE_ROLE + this.getIRI());
        }
    }

    @Original
    private static Role resolveRoleHelper(@Nullable DLTree t, String r) {
        if (t == null) {
            throw new ReasonerInternalException("Role expression expected: " + r);
        }
        switch (t.token()) {
            case RNAME: 
            case DNAME: {
                return (Role)t.elem().getNE();
            }
            case INV: {
                return Role.resolveRoleHelper(t.getChild(), r).inverse();
            }
        }
        throw new ReasonerInternalException("Invalid role expression: " + r + " but got: " + t);
    }

    @PortedFrom(file="tRole.h", name="resolveRole")
    public static Role resolveRole(DLTree t, String r) {
        return Role.resolveSynonym(Role.resolveRoleHelper(t, r));
    }

    @PortedFrom(file="tRole.h", name="resolveRole")
    public static Role resolveRole(DLTree t) {
        return Role.resolveSynonym(Role.resolveRoleHelper(t, ""));
    }

    @PortedFrom(file="tRole.h", name="getIndex")
    public int getAbsoluteIndex() {
        int i = 2 * this.extId;
        return i > 0 ? i : 1 - i;
    }

    @Original
    private int buildIndex() {
        int i = 2 * this.extId;
        return i > 0 ? i : 1 - i;
    }

    @PortedFrom(file="tRole.h", name="fillsComposition")
    private void fillsComposition(List<Role> composition, DLTree tree) {
        if (tree.token() == Token.RCOMPOSITION) {
            tree.getChildren().forEach(t -> this.fillsComposition(composition, (DLTree)t));
        } else {
            composition.add(Role.resolveRole(tree));
        }
    }

    @PortedFrom(file="tRole.h", name="addFeaturesToSynonym")
    public void addFeaturesToSynonym() {
        if (!this.isSynonym()) {
            return;
        }
        Role syn = Role.resolveSynonym(this);
        if (this.isFunctional() || syn.isFunctional()) {
            syn.setFunctional();
        }
        if (this.isTransitive() || syn.isTransitive()) {
            syn.setTransitive(true);
        }
        if (this.isReflexive() || syn.isReflexive()) {
            syn.setReflexive(true);
        }
        if (this.isDataRole() || syn.isDataRole()) {
            syn.setDataRole(true);
        }
        if (this.pDomain != null) {
            syn.setDomain(this.pDomain.copy());
        }
        if (this.isDisjoint()) {
            syn.disjointRoles.addAll(this.disjointRoles);
        }
        syn.subCompositions.addAll(this.subCompositions);
        this.toldSubsumers.clear();
        this.addParent(syn);
    }

    @Nullable
    @PortedFrom(file="tRole.h", name="eliminateToldCycles")
    private Role eliminateToldCycles(Set<Role> rolesInProcess, List<Role> toldSynonyms) {
        if (this.isSynonym()) {
            return null;
        }
        if (rolesInProcess.contains(this)) {
            toldSynonyms.add(this);
            return this;
        }
        Role ret = null;
        rolesInProcess.add(this);
        this.removeSynonymsFromParents();
        for (ClassifiableEntry r : this.toldSubsumers) {
            ret = ((Role)r).eliminateToldCycles(rolesInProcess, toldSynonyms);
            if (ret == null) continue;
            if (ret.equals(this)) {
                Collections.sort(toldSynonyms, new RoleCompare());
                ret = toldSynonyms.get(0);
                for (int i = 1; i < toldSynonyms.size(); ++i) {
                    Role p = toldSynonyms.get(i);
                    p.setSynonym(ret);
                    ret.addParents(p.getToldSubsumers());
                }
                toldSynonyms.clear();
                rolesInProcess.remove(this);
                return ret.eliminateToldCycles(rolesInProcess, toldSynonyms);
            }
            toldSynonyms.add(this);
            break;
        }
        rolesInProcess.remove(this);
        return ret;
    }

    @Override
    public String toString() {
        return this.extName.toString();
    }

    @PortedFrom(file="tRole.h", name="print")
    public void print(LogAdapter o) {
        o.print((Object)"Role \"", (Object)this.getIRI(), (Object)"\"(").print(this.getId()).print(")", this.isTransitive() ? "T" : "", this.isReflexive() ? "R" : "", this.isTopFunc() ? "t" : "", this.isFunctional() ? "F" : "", this.isDataRole() ? "D" : "");
        if (this.isSynonym()) {
            o.print((Object)" = \"", (Object)this.getSynonym().getIRI(), (Object)"\"\n");
            return;
        }
        if (!this.toldSubsumers.isEmpty()) {
            o.print(this.toldSubsumers.stream().map(NamedEntry::getIRI).collect(Collectors.joining("\", \"", " parents={\"", "\"}")));
        }
        if (!this.disjointRoles.isEmpty()) {
            o.print(this.disjointRoles.stream().map(NamedEntry::getIRI).collect(Collectors.joining("\", \"", " disjoint with {\"", "\"}")));
        }
        if (this.pDomain != null) {
            o.print(" Domain=(").print(this.bpDomain).print((Object)")=", (Object)this.pDomain);
        }
        if (this.getTRange() != null) {
            o.print(" Range=(").print(this.getBPRange()).print((Object)")=", (Object)this.getTRange());
        }
        o.print("\nAutomaton (size ").print(this.automaton.size()).print((Object)"): ", (Object)(this.automaton.isISafe() ? "I" : "i"), (Object)(this.automaton.isOSafe() ? "O" : "o"));
        this.automaton.print(o);
        o.print("\n");
    }

    @PortedFrom(file="tRole.h", name="initADbyTaxonomy")
    public void initADbyTaxonomy(Taxonomy pTax, int nRoles) {
        assert (this.isClassified());
        assert (this.ancestorRoles.isEmpty() && this.descendantRoles.isEmpty());
        AddRoleActor anc = new AddRoleActor(this.ancestorRoles);
        pTax.getRelativesInfo(this.getTaxVertex(), anc, false, false, true);
        AddRoleActor desc = new AddRoleActor(this.descendantRoles);
        pTax.getRelativesInfo(this.getTaxVertex(), desc, false, false, false);
        this.addAncestorsToBitMap(this.ancestorMap);
    }

    @PortedFrom(file="tRole.h", name="postProcess")
    public void postProcess() {
        this.initTopFunc();
        if (this.isDisjoint()) {
            this.initDJMap();
        }
    }

    @PortedFrom(file="tRole.h", name="isRealTopFunc")
    private boolean isRealTopFunc() {
        if (!this.isFunctional()) {
            return false;
        }
        return this.ancestorRoles.stream().noneMatch(p -> p.isTopFunc());
    }

    @PortedFrom(file="tRole.h", name="initTopFunc")
    private void initTopFunc() {
        if (this.isRealTopFunc()) {
            return;
        }
        if (this.isTopFunc()) {
            this.topFunctionalRoles.clear();
        }
        OWLAPIStreamUtils.add(this.topFunctionalRoles, this.ancestorRoles.stream().filter(Role::isRealTopFunc));
        if (!this.topFunctionalRoles.isEmpty()) {
            this.functionality.setValue(true);
        }
    }

    @PortedFrom(file="tRole.h", name="checkHierarchicalDisjoint")
    private void checkHierarchicalDisjoint(Role r) {
        if (this.disjointRoles.contains(r)) {
            this.setDomain(DLTreeFactory.createBottom());
            this.disjointRoles.clear();
            return;
        }
        r.descendantRoles.stream().filter(this.disjointRoles::contains).forEach(p -> {
            p.setDomain(DLTreeFactory.createBottom());
            this.disjointRoles.remove(p);
            p.disjointRoles.clear();
        });
    }

    @PortedFrom(file="tRole.h", name="initDJMap")
    private void initDJMap() {
        this.disjointRoles.forEach(p -> this.disjointRolesIndex.add(p.getAbsoluteIndex()));
    }

    @PortedFrom(file="tRole.h", name="preprocessComposition")
    private void preprocessComposition(List<Role> rs) {
        boolean same = false;
        int last = rs.size() - 1;
        for (int i = 0; i < rs.size(); ++i) {
            Role p = rs.get(i);
            Role r = Role.resolveSynonym(p);
            if (r.isBottom()) {
                rs.clear();
                return;
            }
            if (r.equals(this)) {
                if (i != 0 && i != last) {
                    throw new ReasonerInternalException(CYCLE_IN_RIA + this.getIRI());
                }
                if (same) {
                    if (last == 1) {
                        rs.clear();
                        this.setTransitive(true);
                        return;
                    }
                    throw new ReasonerInternalException(CYCLE_IN_RIA + this.getIRI());
                }
                same = true;
            }
            rs.set(i, r);
        }
    }

    @PortedFrom(file="tRole.h", name="completeAutomaton")
    private void completeAutomaton(Set<Role> rolesInProcess) {
        if (this.automaton.isCompleted()) {
            return;
        }
        if (rolesInProcess.contains(this)) {
            throw new ReasonerInternalException(CYCLE_IN_RIA + this.getIRI());
        }
        rolesInProcess.add(this);
        this.descendantRoles.forEach(p -> p.completeAutomaton(rolesInProcess));
        this.subCompositions.forEach(q -> this.addSubCompositionAutomaton((List<Role>)q, rolesInProcess));
        if (this.isTransitive()) {
            this.automaton.addTransitionSafe(1, new RATransition(0));
        }
        this.automaton.setCompleted(true);
        if (!this.isBottom()) {
            this.toldSubsumers.forEach(this::initRole);
        }
        rolesInProcess.remove(this);
    }

    protected void initRole(ClassifiableEntry p) {
        Role r = (Role)Role.resolveSynonym(p);
        r.addSubRoleAutomaton(this);
        if (this.hasSpecialDomain()) {
            r.specialDomain = true;
        }
    }

    @PortedFrom(file="tRole.h", name="addSubCompositionAutomaton")
    private void addSubCompositionAutomaton(List<Role> rs, Set<Role> rolesInProcess) {
        this.preprocessComposition(rs);
        if (rs.isEmpty()) {
            return;
        }
        this.specialDomain = true;
        int p = 0;
        int pLast = rs.size() - 1;
        int from = 0;
        int to = 1;
        if (rs.get(0).equals(this)) {
            ++p;
            from = 1;
        } else if (rs.get(pLast).equals(this)) {
            --pLast;
            to = 0;
        }
        assert (p <= pLast);
        boolean oSafe = false;
        this.automaton.initChain(from);
        while (p != pLast) {
            oSafe = this.automaton.addToChain(this.completeAutomatonByRole(rs.get(p), rolesInProcess), oSafe);
            ++p;
        }
        this.automaton.addToChain(this.completeAutomatonByRole(rs.get(p), rolesInProcess), oSafe, to);
    }

    @Original
    public Role getInverse() {
        return this.inverse;
    }

    static class KnownValue
    implements Serializable {
        protected boolean value;
        protected boolean known;

        public KnownValue(boolean val) {
            this.value = val;
            this.known = false;
        }

        public KnownValue() {
            this(false);
        }

        protected boolean isKnown() {
            return this.known;
        }

        protected boolean getValue() {
            return this.value;
        }

        protected void setValue(boolean val) {
            this.value = val;
            this.known = true;
        }
    }
}

