/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapitools.decomposition.AxiomWrapper;
import org.semanticweb.owlapitools.decomposition.Decomposer;
import org.semanticweb.owlapitools.decomposition.LocalityChecker;
import org.semanticweb.owlapitools.decomposition.OntologyAtom;
import org.semanticweb.owlapitools.decomposition.SemanticLocalityChecker;
import org.semanticweb.owlapitools.decomposition.Signature;
import org.semanticweb.owlapitools.decomposition.SyntacticLocalityChecker;
import uk.ac.manchester.cs.atomicdecomposition.AtomicDecomposition;
import uk.ac.manchester.cs.atomicdecomposition.AtomicDecompositionImpl;
import uk.ac.manchester.cs.jfact.KnowledgeExplorer;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.LiteralEntry;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeFactory;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.helpers.Timer;
import uk.ac.manchester.cs.jfact.kernel.CacheStatus;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTreeArc;
import uk.ac.manchester.cs.jfact.kernel.ExpressionCache;
import uk.ac.manchester.cs.jfact.kernel.ExpressionManager;
import uk.ac.manchester.cs.jfact.kernel.ExpressionTranslator;
import uk.ac.manchester.cs.jfact.kernel.Individual;
import uk.ac.manchester.cs.jfact.kernel.KBStatus;
import uk.ac.manchester.cs.jfact.kernel.Lexeme;
import uk.ac.manchester.cs.jfact.kernel.Ontology;
import uk.ac.manchester.cs.jfact.kernel.OntologyLoader;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.RoleMaster;
import uk.ac.manchester.cs.jfact.kernel.TBox;
import uk.ac.manchester.cs.jfact.kernel.Taxonomy;
import uk.ac.manchester.cs.jfact.kernel.TaxonomyVertex;
import uk.ac.manchester.cs.jfact.kernel.Token;
import uk.ac.manchester.cs.jfact.kernel.actors.Actor;
import uk.ac.manchester.cs.jfact.kernel.actors.RIActor;
import uk.ac.manchester.cs.jfact.kernel.actors.SupConceptActor;
import uk.ac.manchester.cs.jfact.kernel.actors.TaxonomyActor;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptName;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptTop;
import uk.ac.manchester.cs.jfact.kernel.dl.IndividualName;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleName;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.IndividualExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.NamedEntity;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleComplexExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.RoleExpression;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;

@PortedFrom(file="Kernel.h", name="ReasoningKernel")
public class ReasoningKernel
implements Serializable {
    private static final String ROLE_EXPRESSION_EXPECTED = "Role expression expected in isDisjointRoles()";
    private static final String ROLE_EXPECTED = "Role expression expected in getNeighbours() method";
    @PortedFrom(file="Kernel.h", name="KernelOptions")
    private final JFactReasonerConfiguration kernelOptions;
    @PortedFrom(file="Kernel.h", name="pTBox")
    protected TBox pTBox;
    @PortedFrom(file="Kernel.h", name="Ontology")
    private final Ontology ontology = new Ontology();
    @PortedFrom(file="Kernel.h", name="pET")
    private ExpressionTranslator pET;
    @PortedFrom(file="Kernel.h", name="Name2Sig")
    private final Map<OWLEntity, Signature> name2Sig = new HashMap<OWLEntity, Signature>();
    @PortedFrom(file="Kernel.h", name="OntoSig")
    private Collection<NamedEntity> ontoSig;
    @Original
    private AtomicBoolean interrupted;
    @PortedFrom(file="Kernel.h", name="cacheLevel")
    private CacheStatus cacheLevel;
    @PortedFrom(file="Kernel.h", name="cachedQueryTree")
    private DLTree cachedQueryTree = null;
    @PortedFrom(file="Kernel.h", name="cachedConcept")
    private Concept cachedConcept;
    @PortedFrom(file="Kernel.h", name="cachedVertex")
    private TaxonomyVertex cachedVertex;
    @PortedFrom(file="Kernel.h", name="reasoningFailed")
    private boolean reasoningFailed = false;
    @PortedFrom(file="Kernel.h", name="TraceVec")
    private final List<AxiomWrapper> traceVec = new ArrayList<AxiomWrapper>();
    @PortedFrom(file="Kernel.h", name="NeedTracing")
    private boolean needTracing = false;
    @Original
    private final DatatypeFactory datatypeFactory;
    @PortedFrom(file="Kernel.h", name="KE")
    private KnowledgeExplorer ke;
    @PortedFrom(file="Kernel.h", name="AD")
    private AtomicDecomposition ad;
    @PortedFrom(file="Kernel.h", name="ModSyn")
    private Decomposer modSyn = null;
    @PortedFrom(file="Kernel.h", name="ModSem")
    private Decomposer modSem = null;
    @PortedFrom(file="Kernel.h", name="Result")
    private final Set<AxiomWrapper> result = new HashSet<AxiomWrapper>();
    @PortedFrom(file="Kernel.h", name="cachedQuery")
    private ConceptExpression cachedQuery = null;
    @PortedFrom(file="Kernel.h", name="ignoreExprCache")
    private boolean ignoreExprCache = false;
    private final Timer moduleTimer = new Timer();
    private OWLDataFactory df;

    public ReasoningKernel(JFactReasonerConfiguration conf, DatatypeFactory factory, OWLDataFactory df) {
        this.kernelOptions = conf;
        this.datatypeFactory = factory;
        this.pTBox = null;
        this.pET = null;
        this.cachedQuery = null;
        this.df = df;
        this.initCacheAndFlags();
    }

    @Original
    public void setInterruptedSwitch(AtomicBoolean b) {
        this.interrupted = b;
    }

    @PortedFrom(file="Kernel.h", name="clearQueryCache")
    private void clearQueryCache() {
        this.cachedQuery = null;
        this.cachedQueryTree = null;
    }

    @PortedFrom(file="Kernel.h", name="setQueryCache")
    private void setQueryCache(ConceptExpression query) {
        this.clearQueryCache();
        this.cachedQuery = query;
    }

    @PortedFrom(file="Kernel.h", name="setQueryCache")
    private void setQueryCache(DLTree query) {
        this.clearQueryCache();
        this.cachedQueryTree = query;
    }

    @PortedFrom(file="Kernel.h", name="setIgnoreExprCache")
    public void setIgnoreExprCache(boolean value) {
        this.ignoreExprCache = value;
    }

    @PortedFrom(file="Kernel.h", name="checkQueryCache")
    private boolean checkQueryCache(ConceptExpression query) {
        return this.ignoreExprCache ? false : query.equals(this.cachedQuery);
    }

    @PortedFrom(file="Kernel.h", name="checkQueryCache")
    private boolean checkQueryCache(DLTree query) {
        return DLTree.equalTrees(this.cachedQueryTree, query);
    }

    @PortedFrom(file="Kernel.h", name="getStatus")
    private KBStatus getStatus() {
        if (this.pTBox == null) {
            return KBStatus.KBEMPTY;
        }
        if (this.ontology.isChanged()) {
            return KBStatus.KBLOADING;
        }
        return this.pTBox.getStatus();
    }

    @PortedFrom(file="Kernel.h", name="e")
    public DLTree e(Expression expr) {
        return expr.accept(this.pET);
    }

    @PortedFrom(file="Kernel.h", name="getFreshFiller")
    private DLTree getFreshFiller(Role r) {
        if (r.isDataRole()) {
            LiteralEntry t = new LiteralEntry("freshliteral");
            t.setLiteral(DatatypeFactory.LITERAL.buildLiteral("freshliteral"));
            return DLTreeFactory.wrap(t);
        }
        return this.getTBox().getFreshConcept();
    }

    @PortedFrom(file="Kernel.h", name="Role")
    private RoleExpression role(Role r) {
        if (r.isDataRole()) {
            return this.getExpressionManager().dataRole(r.getEntity().getEntity());
        }
        return this.getExpressionManager().objectRole(r.getEntity().getEntity());
    }

    @PortedFrom(file="Kernel.h", name="initCacheAndFlags")
    private void initCacheAndFlags() {
        this.cacheLevel = CacheStatus.EMPTY;
        this.clearQueryCache();
        this.cachedConcept = null;
        this.cachedVertex = null;
        this.needTracing = false;
    }

    @PortedFrom(file="Kernel.h", name="needTracing")
    public void needTracing() {
        this.needTracing = true;
    }

    @PortedFrom(file="Kernel.h", name="getTrace")
    public List<AxiomWrapper> getTrace() {
        ArrayList<AxiomWrapper> toReturn = new ArrayList<AxiomWrapper>(this.traceVec);
        this.traceVec.clear();
        return toReturn;
    }

    @PortedFrom(file="Kernel.h", name="setSignature")
    public void setSignature(Signature sig) {
        if (this.pET != null) {
            this.pET.setSignature(sig);
        }
    }

    @PortedFrom(file="Kernel.h", name="getOntology")
    public Ontology getOntology() {
        return this.ontology;
    }

    @PortedFrom(file="Kernel.h", name="getRelated")
    private List<Individual> getRelated(Individual i, Role r) {
        if (!i.hasRelatedCache(r)) {
            i.setRelatedCache(r, this.buildRelatedCache(i, r));
        }
        return i.getRelatedCache(r);
    }

    @PortedFrom(file="Kernel.h", name="checkSatTree")
    private boolean checkSatTree(DLTree c) {
        if (c.isTOP()) {
            return true;
        }
        if (c.isBOTTOM()) {
            return false;
        }
        this.setUpCache(c, CacheStatus.SAT);
        return this.getTBox().isSatisfiable(this.cachedConcept);
    }

    @PortedFrom(file="Kernel.h", name="checkSat")
    private boolean checkSat(ConceptExpression c) {
        this.setUpCache(c, CacheStatus.SAT);
        return this.getTBox().isSatisfiable(this.cachedConcept);
    }

    @PortedFrom(file="Kernel.h", name="isNameOrConst")
    private static boolean isNameOrConst(ConceptExpression c) {
        return c instanceof ConceptName || c instanceof ConceptTop || c instanceof ConceptBottom;
    }

    @PortedFrom(file="Kernel.h", name="isNameOrConst")
    private static boolean isNameOrConst(DLTree c) {
        return c.isBOTTOM() || c.isTOP() || c.isName();
    }

    @PortedFrom(file="Kernel.h", name="checkSub")
    private boolean checkSub(ConceptExpression c, ConceptExpression d) {
        if (ReasoningKernel.isNameOrConst(d) && ReasoningKernel.isNameOrConst(c)) {
            return this.checkSub(this.getTBox().getCI(this.e(c)), this.getTBox().getCI(this.e(d)));
        }
        return !this.checkSat(ExpressionManager.and(c, ExpressionManager.not(d)));
    }

    @PortedFrom(file="Kernel.h", name="getModExtractor")
    public Decomposer getModExtractor(boolean useSemantic, OWLReasoner r) {
        if (useSemantic) {
            if (this.modSem == null) {
                this.modSem = new Decomposer(this.ontology.getAxioms(), (LocalityChecker)new SemanticLocalityChecker(r));
            }
            return this.modSem;
        }
        if (this.modSyn == null) {
            this.modSyn = new Decomposer(this.ontology.getAxioms(), (LocalityChecker)new SyntacticLocalityChecker());
        }
        return this.modSyn;
    }

    @PortedFrom(file="Kernel.h", name="getModule")
    public Collection<AxiomWrapper> getModule(List<Expression> signature, boolean useSemantic, ModuleType type, OWLReasoner r) {
        Signature sig = new Signature();
        sig.setLocality(false);
        signature.stream().filter(p -> p instanceof NamedEntity).map(p -> ((NamedEntity)((Object)p)).getEntity()).forEach(arg_0 -> ((Signature)sig).add(arg_0));
        return this.getModExtractor(useSemantic, r).getModule(sig.getSignature().stream(), useSemantic, type);
    }

    @PortedFrom(file="Kernel.h", name="getNonLocal")
    public Set<AxiomWrapper> getNonLocal(List<Expression> signature, boolean useSemantic, ModuleType type, OWLReasoner r) {
        Signature sig = new Signature();
        sig.setLocality(type == ModuleType.TOP);
        signature.stream().filter(p -> p instanceof NamedEntity).map(p -> ((NamedEntity)((Object)p)).getEntity()).forEach(arg_0 -> ((Signature)sig).add(arg_0));
        LocalityChecker lc = this.getModExtractor(useSemantic, r).getModularizer().getLocalityChecker();
        lc.setSignatureValue(sig);
        this.result.clear();
        OWLAPIStreamUtils.add(this.result, this.getOntology().getAxioms().stream().filter(p -> !lc.local(p.getAxiom())));
        return this.result;
    }

    @PortedFrom(file="Kernel.h", name="checkSub")
    private boolean checkSub(Concept c, Concept d) {
        if (d.getpName() == 0) {
            if (c.getpName() == 0) {
                return c.equals(d);
            }
            return !this.getTBox().isSatisfiable(c);
        }
        if (c.getpName() == 0) {
            return !this.checkSatTree(DLTreeFactory.createSNFNot(this.getTBox().getTree(c)));
        }
        if (d.isTop() || c.isBottom()) {
            return true;
        }
        if (this.getStatus().ordinal() < KBStatus.KBCLASSIFIED.ordinal()) {
            return this.getTBox().isSubHolds(c, d);
        }
        SupConceptActor actor = new SupConceptActor(d);
        Taxonomy tax = this.getCTaxonomy();
        return tax.getRelativesInfo(c.getTaxVertex(), actor, true, false, true);
    }

    @PortedFrom(file="Kernel.h", name="checkTBox")
    private void checkTBox() {
        if (this.pTBox == null) {
            throw new ReasonerInternalException("KB Not Initialised");
        }
    }

    @PortedFrom(file="Kernel.h", name="getTBox")
    public TBox getTBox() {
        this.checkTBox();
        return this.pTBox;
    }

    @PortedFrom(file="Kernel.h", name="clearTBox")
    private void clearTBox() {
        this.pTBox = null;
        this.pET = null;
        this.getExpressionManager().clearNameCache();
    }

    @PortedFrom(file="Kernel.h", name="getORM")
    private RoleMaster getORM() {
        return this.getTBox().getORM();
    }

    @PortedFrom(file="Kernel.h", name="getDRM")
    private RoleMaster getDRM() {
        return this.getTBox().getDRM();
    }

    @PortedFrom(file="Kernel.h", name="getCTaxonomy")
    private Taxonomy getCTaxonomy() {
        return this.getTBox().getTaxonomy();
    }

    @PortedFrom(file="Kernel.h", name="getORTaxonomy")
    private Taxonomy getORTaxonomy() {
        if (!this.isKBPreprocessed()) {
            throw new ReasonerInternalException("No access to the object role taxonomy: ontology not preprocessed");
        }
        return this.getORM().getTaxonomy();
    }

    @PortedFrom(file="Kernel.h", name="getDRTaxonomy")
    private Taxonomy getDRTaxonomy() {
        if (!this.isKBPreprocessed()) {
            throw new ReasonerInternalException("No access to the data role taxonomy: ontology not preprocessed");
        }
        return this.getDRM().getTaxonomy();
    }

    @PortedFrom(file="Kernel.h", name="getIndividual")
    private Individual getIndividual(IndividualExpression i, String reason) {
        return (Individual)OWLAPIPreconditions.verifyNotNull((Object)this.getTBox().getCI((DLTree)OWLAPIPreconditions.verifyNotNull((Object)this.e(i), (String)reason)));
    }

    @PortedFrom(file="Kernel.h", name="getRole")
    private Role getRole(RoleExpression r, String reason) {
        return Role.resolveRole(this.e(r), reason);
    }

    @PortedFrom(file="Kernel.h", name="getTaxonomy")
    private Taxonomy getTaxonomy(Role r) {
        return r.isDataRole() ? this.getDRTaxonomy() : this.getORTaxonomy();
    }

    @PortedFrom(file="Kernel.h", name="getTaxVertex")
    private static TaxonomyVertex getTaxVertex(Role r) {
        return r.getTaxVertex();
    }

    @PortedFrom(file="Kernel.h", name="getOptions")
    public JFactReasonerConfiguration getOptions() {
        return this.kernelOptions;
    }

    @PortedFrom(file="Kernel.h", name="isKBPreprocessed")
    public boolean isKBPreprocessed() {
        return this.getStatus().ordinal() >= KBStatus.KBCHECKED.ordinal();
    }

    @PortedFrom(file="Kernel.h", name="isKBClassified")
    public boolean isKBClassified() {
        return this.getStatus().ordinal() >= KBStatus.KBCLASSIFIED.ordinal();
    }

    @PortedFrom(file="Kernel.h", name="isKBRealised")
    public boolean isKBRealised() {
        return this.getStatus().ordinal() >= KBStatus.KBREALISED.ordinal();
    }

    @PortedFrom(file="Kernel.h", name="writeReasoningResult")
    public void writeReasoningResult(long time) {
        this.getTBox().clearQueryConcept();
        this.getTBox().writeReasoningResult(time);
    }

    @PortedFrom(file="Kernel.h", name="checkFunctionality")
    private boolean checkFunctionality(Role r) {
        DLTree tmp = DLTreeFactory.createSNFExists(DLTreeFactory.createRole(r).copy(), DLTreeFactory.createSNFNot(this.getFreshFiller(r)));
        return !this.checkSatTree(tmp = DLTreeFactory.createSNFAnd(tmp, DLTreeFactory.createSNFExists(DLTreeFactory.createRole(r), this.getFreshFiller(r))));
    }

    @PortedFrom(file="Kernel.h", name="getFunctionality")
    private boolean getFunctionality(Role r) {
        if (!r.isFunctionalityKnown()) {
            r.setFunctional(this.checkFunctionality(r));
        }
        return r.isFunctional();
    }

    @PortedFrom(file="Kernel.h", name="checkTransitivity")
    private boolean checkTransitivity(DLTree r) {
        DLTree tmp = DLTreeFactory.createSNFExists(r.copy(), DLTreeFactory.createSNFNot(this.getTBox().getFreshConcept()));
        tmp = DLTreeFactory.createSNFExists(r.copy(), tmp);
        return !this.checkSatTree(tmp = DLTreeFactory.createSNFAnd(tmp, DLTreeFactory.createSNFForall(r, this.getTBox().getFreshConcept())));
    }

    @PortedFrom(file="Kernel.h", name="checkSymmetry")
    private boolean checkSymmetry(DLTree r) {
        DLTree tmp = DLTreeFactory.createSNFForall(r.copy(), DLTreeFactory.createSNFNot(this.getTBox().getFreshConcept()));
        tmp = DLTreeFactory.createSNFAnd(this.getTBox().getFreshConcept(), DLTreeFactory.createSNFExists(r, tmp));
        return !this.checkSatTree(tmp);
    }

    @PortedFrom(file="Kernel.h", name="checkReflexivity")
    private boolean checkReflexivity(DLTree r) {
        DLTree tmp = DLTreeFactory.createSNFForall(r, DLTreeFactory.createSNFNot(this.getTBox().getFreshConcept()));
        tmp = DLTreeFactory.createSNFAnd(this.getTBox().getFreshConcept(), tmp);
        return !this.checkSatTree(tmp);
    }

    @PortedFrom(file="Kernel.h", name="checkRoleSubsumption")
    private boolean checkRoleSubsumption(Role r, Role s) {
        if (r.isDataRole() != s.isDataRole()) {
            return false;
        }
        DLTree tmp = DLTreeFactory.createSNFForall(DLTreeFactory.createRole(s), DLTreeFactory.createSNFNot(this.getFreshFiller(s)));
        tmp = DLTreeFactory.createSNFAnd(DLTreeFactory.createSNFExists(DLTreeFactory.createRole(r), this.getFreshFiller(r)), tmp);
        return !this.checkSatTree(tmp);
    }

    @PortedFrom(file="Kernel.h", name="getExpressionManager")
    public ExpressionCache getExpressionManager() {
        return this.ontology.getExpressionManager();
    }

    @PortedFrom(file="Kernel.h", name="newKB")
    private boolean newKB() {
        if (this.pTBox != null) {
            return true;
        }
        this.pTBox = new TBox(this.datatypeFactory, this.getOptions(), this.interrupted, this.df);
        this.pET = new ExpressionTranslator(this.pTBox);
        this.initCacheAndFlags();
        return false;
    }

    @PortedFrom(file="Kernel.h", name="releaseKB")
    private boolean releaseKB() {
        this.clearTBox();
        this.ontology.clear();
        this.reasoningFailed = false;
        return false;
    }

    @PortedFrom(file="Kernel.h", name="clearKB")
    public boolean clearKB() {
        if (this.pTBox == null) {
            return true;
        }
        return this.releaseKB() || this.newKB();
    }

    @PortedFrom(file="Kernel.h", name="isKBConsistent")
    public boolean isKBConsistent() {
        if (this.getStatus().ordinal() <= KBStatus.KBLOADING.ordinal()) {
            this.processKB(KBStatus.KBCHECKED);
        }
        return this.getTBox().isConsistent();
    }

    @PortedFrom(file="Kernel.h", name="preprocessKB")
    private void preprocessKB() {
        this.isKBConsistent();
    }

    @PortedFrom(file="Kernel.h", name="classifyKB")
    public void classifyKB() {
        if (!this.isKBClassified()) {
            this.processKB(KBStatus.KBCLASSIFIED);
        }
        this.isKBConsistent();
    }

    @PortedFrom(file="Kernel.h", name="realiseKB")
    public void realiseKB() {
        if (!this.isKBRealised()) {
            this.processKB(KBStatus.KBREALISED);
        }
        if (!this.isKBConsistent()) {
            throw new InconsistentOntologyException();
        }
    }

    @PortedFrom(file="Kernel.h", name="isFunctional")
    public boolean isFunctional(ObjectRoleExpression r) {
        this.preprocessKB();
        Role role = this.getRole(r, "Role expression expected in isFunctional()");
        if (role.isTop()) {
            return false;
        }
        if (role.isBottom()) {
            return true;
        }
        return this.getFunctionality(role);
    }

    @PortedFrom(file="Kernel.h", name="isFunctional")
    public boolean isFunctional(DataRoleExpression r) {
        this.preprocessKB();
        Role role = this.getRole(r, "Role expression expected in isFunctional()");
        if (role.isTop()) {
            return false;
        }
        if (role.isBottom()) {
            return true;
        }
        return this.getFunctionality(role);
    }

    @PortedFrom(file="Kernel.h", name="isInverseFunctional")
    public boolean isInverseFunctional(ObjectRoleExpression r) {
        this.preprocessKB();
        Role role = this.getRole(r, "Role expression expected in isInverseFunctional()").inverse();
        if (role.isTop()) {
            return false;
        }
        if (role.isBottom()) {
            return true;
        }
        return this.getFunctionality(role);
    }

    @PortedFrom(file="Kernel.h", name="isTransitive")
    public boolean isTransitive(ObjectRoleExpression r) {
        this.preprocessKB();
        Role role = this.getRole(r, "Role expression expected in isTransitive()");
        if (role.isTop()) {
            return true;
        }
        if (role.isBottom()) {
            return true;
        }
        if (!role.isTransitivityKnown()) {
            role.setTransitive(this.checkTransitivity(this.e(r)));
        }
        return role.isTransitive();
    }

    @PortedFrom(file="Kernel.h", name="isSymmetric")
    public boolean isSymmetric(ObjectRoleExpression r) {
        this.preprocessKB();
        Role role = this.getRole(r, "Role expression expected in isSymmetric()");
        if (role.isTop()) {
            return true;
        }
        if (role.isBottom()) {
            return true;
        }
        if (!role.isSymmetryKnown()) {
            role.setSymmetric(this.checkSymmetry(this.e(r)));
        }
        return role.isSymmetric();
    }

    @PortedFrom(file="Kernel.h", name="isAsymmetric")
    public boolean isAsymmetric(ObjectRoleExpression r) {
        this.preprocessKB();
        Role role = this.getRole(r, "Role expression expected in isAsymmetric()");
        if (role.isTop()) {
            return false;
        }
        if (role.isBottom()) {
            return true;
        }
        if (!role.isAsymmetryKnown()) {
            role.setAsymmetric(this.getTBox().isDisjointRoles(role, role.inverse()));
        }
        return role.isAsymmetric();
    }

    @PortedFrom(file="Kernel.h", name="isReflexive")
    public boolean isReflexive(ObjectRoleExpression r) {
        this.preprocessKB();
        Role role = this.getRole(r, "Role expression expected in isReflexive()");
        if (role.isTop()) {
            return true;
        }
        if (role.isBottom()) {
            return false;
        }
        if (!role.isReflexivityKnown()) {
            role.setReflexive(this.checkReflexivity(this.e(r)));
        }
        return role.isReflexive();
    }

    @PortedFrom(file="Kernel.h", name="isIrreflexive")
    public boolean isIrreflexive(ObjectRoleExpression r) {
        this.preprocessKB();
        Role role = this.getRole(r, "Role expression expected in isIrreflexive()");
        if (role.isTop()) {
            return false;
        }
        if (role.isBottom()) {
            return true;
        }
        if (!role.isIrreflexivityKnown()) {
            role.setIrreflexive(this.getTBox().isIrreflexive(role));
        }
        return role.isIrreflexive();
    }

    @PortedFrom(file="Kernel.h", name="isDisjointRoles")
    public boolean isDisjointRoles(List<? extends RoleExpression> l) {
        int nTopRoles = 0;
        ArrayList<Role> roles = new ArrayList<Role>(l.size());
        for (RoleExpression roleExpression : l) {
            Role role = this.getRole(roleExpression, ROLE_EXPRESSION_EXPECTED);
            if (role.isBottom()) continue;
            if (role.isTop()) {
                ++nTopRoles;
                continue;
            }
            roles.add(role);
        }
        if (nTopRoles > 0) {
            return nTopRoles <= 1 && roles.isEmpty();
        }
        return !Helper.anyMatchOnAllPairs(roles, v -> !this.getTBox().isDisjointRoles((Role)v.i, (Role)v.j));
    }

    @PortedFrom(file="Kernel.h", name="isDisjointRoles")
    public boolean isDisjointRoles(ObjectRoleExpression or, ObjectRoleExpression os) {
        this.preprocessKB();
        Role r = this.getRole(or, ROLE_EXPRESSION_EXPECTED);
        Role s = this.getRole(os, ROLE_EXPRESSION_EXPECTED);
        if (r.isTop() || s.isTop()) {
            return false;
        }
        if (r.isBottom() || s.isBottom()) {
            return true;
        }
        return this.getTBox().isDisjointRoles(r, s);
    }

    @PortedFrom(file="Kernel.h", name="isDisjointRoles")
    public boolean isDisjointRoles(DataRoleExpression or, DataRoleExpression os) {
        this.preprocessKB();
        Role r = this.getRole(or, ROLE_EXPRESSION_EXPECTED);
        Role s = this.getRole(os, ROLE_EXPRESSION_EXPECTED);
        if (r.isTop() || s.isTop()) {
            return false;
        }
        if (r.isBottom() || s.isBottom()) {
            return true;
        }
        return this.getTBox().isDisjointRoles(r, s);
    }

    @PortedFrom(file="Kernel.h", name="isSubRoles")
    public boolean isSubRoles(RoleExpression or, RoleExpression os) {
        this.preprocessKB();
        Role r = this.getRole(or, "Role expression expected in isSubRoles()");
        Role s = this.getRole(os, "Role expression expected in isSubRoles()");
        if (r.isBottom() || s.isTop()) {
            return true;
        }
        if (r.isTop() && s.isBottom()) {
            return false;
        }
        if (ExpressionManager.isEmptyRole(or) || ExpressionManager.isUniversalRole(os)) {
            return true;
        }
        if (ExpressionManager.isUniversalRole(or) && ExpressionManager.isEmptyRole(os)) {
            return false;
        }
        if (!r.isTop() && !s.isBottom() && r.lesserequal(s)) {
            return true;
        }
        return this.checkRoleSubsumption(r, s);
    }

    @PortedFrom(file="Kernel.h", name="isSatisfiable")
    public boolean isSatisfiable(ConceptExpression c) {
        this.preprocessKB();
        try {
            return this.checkSat(c);
        }
        catch (OWLRuntimeException crn) {
            if (c instanceof ConceptName) {
                return true;
            }
            throw crn;
        }
    }

    @PortedFrom(file="Kernel.h", name="isSubsumedBy")
    public boolean isSubsumedBy(ConceptExpression c, ConceptExpression d) {
        this.preprocessKB();
        if (ReasoningKernel.isNameOrConst(d) && ReasoningKernel.isNameOrConst(c)) {
            return this.checkSub(this.getTBox().getCI(this.e(c)), this.getTBox().getCI(this.e(d)));
        }
        DLTree nD = DLTreeFactory.createSNFNot(this.e(d));
        return !this.checkSatTree(DLTreeFactory.createSNFAnd(this.e(c), nD));
    }

    @PortedFrom(file="Kernel.h", name="isDisjoint")
    public boolean isDisjoint(ConceptExpression c, ConceptExpression d) {
        return !this.isSatisfiable(ExpressionManager.and(c, d));
    }

    @PortedFrom(file="Kernel.h", name="isEquivalent")
    public boolean isEquivalent(ConceptExpression c, ConceptExpression d) {
        if (c.equals(d)) {
            return true;
        }
        this.preprocessKB();
        if (this.isKBClassified() && ReasoningKernel.isNameOrConst(d) && ReasoningKernel.isNameOrConst(c)) {
            TaxonomyVertex cV = this.getTBox().getCI(this.e(c)).getTaxVertex();
            TaxonomyVertex dV = this.getTBox().getCI(this.e(d)).getTaxVertex();
            if (cV == null && dV == null) {
                return false;
            }
            if (cV == null || dV == null) {
                return false;
            }
            return cV.equals(dV);
        }
        return this.isSubsumedBy(c, d) && this.isSubsumedBy(d, c);
    }

    @PortedFrom(file="Kernel.h", name="getSupConcepts")
    public <T extends Expression> TaxonomyActor<T> getConcepts(ConceptExpression c, boolean direct, TaxonomyActor<T> actor, boolean supDirection) {
        this.classifyKB();
        this.setUpCache(c, CacheStatus.CLASSIFIED);
        actor.clear();
        this.getCTaxonomy().getRelativesInfo(this.cachedVertex, actor, false, direct, supDirection);
        return actor;
    }

    @PortedFrom(file="Kernel.h", name="getSubConcepts")
    public Actor getConcepts(ConceptExpression c, boolean direct, Actor actor, boolean supDirection) {
        this.classifyKB();
        this.setUpCache(c, CacheStatus.CLASSIFIED);
        actor.clear();
        Taxonomy tax = this.getCTaxonomy();
        tax.getRelativesInfo(this.cachedVertex, actor, false, direct, supDirection);
        return actor;
    }

    @PortedFrom(file="Kernel.h", name="getEquivalentConcepts")
    public <T extends Expression> TaxonomyActor<T> getEquivalentConcepts(ConceptExpression c, TaxonomyActor<T> actor) {
        this.classifyKB();
        this.setUpCache(c, CacheStatus.CLASSIFIED);
        actor.clear();
        actor.apply(this.cachedVertex);
        return actor;
    }

    @PortedFrom(file="Kernel.h", name="getDisjointConcepts")
    public <T extends Expression> TaxonomyActor<T> getDisjointConcepts(ConceptExpression c, TaxonomyActor<T> actor) {
        this.classifyKB();
        this.setUpCache(ExpressionManager.not(c), CacheStatus.CLASSIFIED);
        actor.clear();
        this.getCTaxonomy().getRelativesInfo(this.cachedVertex, actor, true, false, false);
        return actor;
    }

    @PortedFrom(file="Kernel.h", name="getSupRoles")
    public <T extends RoleExpression> TaxonomyActor<T> getRoles(RoleExpression r, boolean direct, TaxonomyActor<T> actor, boolean supDirection) {
        this.preprocessKB();
        Role role = this.getRole(r, "Role expression expected in getRoles()");
        actor.clear();
        this.getTaxonomy(role).getRelativesInfo(ReasoningKernel.getTaxVertex(role), actor, false, direct, supDirection);
        return actor;
    }

    @PortedFrom(file="Kernel.h", name="getEquivalentRoles")
    public <T extends RoleExpression> TaxonomyActor<T> getEquivalentRoles(RoleExpression r, TaxonomyActor<T> actor) {
        this.preprocessKB();
        Role role = this.getRole(r, "Role expression expected in getEquivalentRoles()");
        actor.clear();
        actor.apply(ReasoningKernel.getTaxVertex(role));
        return actor;
    }

    @PortedFrom(file="Kernel.h", name="getORoleDomain")
    public <T extends ConceptExpression> TaxonomyActor<T> getORoleDomain(ObjectRoleExpression r, boolean direct, TaxonomyActor<T> actor) {
        this.classifyKB();
        this.setUpCache(ExpressionManager.exists(r, ExpressionManager.top()), CacheStatus.CLASSIFIED);
        actor.clear();
        this.getCTaxonomy().getRelativesInfo(this.cachedVertex, actor, true, direct, true);
        return actor;
    }

    @PortedFrom(file="Kernel.h", name="getDRoleDomain")
    public <T extends ConceptExpression> TaxonomyActor<T> getDRoleDomain(DataRoleExpression r, boolean direct, TaxonomyActor<T> actor) {
        this.classifyKB();
        this.setUpCache(ExpressionManager.exists(r, ExpressionManager.dataTop()), CacheStatus.CLASSIFIED);
        actor.clear();
        this.getCTaxonomy().getRelativesInfo(this.cachedVertex, actor, true, direct, true);
        return actor;
    }

    @PortedFrom(file="Kernel.h", name="getRoleRange")
    private <T extends ConceptExpression> void getRoleRange(ObjectRoleExpression r, boolean direct, TaxonomyActor<T> actor) {
        this.getORoleDomain(this.getExpressionManager().inverse(r), direct, actor);
    }

    @PortedFrom(file="Kernel.h", name="getInstances")
    public TaxonomyActor<IndividualExpression> getInstances(ConceptExpression c, TaxonomyActor<IndividualExpression> actor, boolean direct) {
        if (direct) {
            this.getDirectInstances(c, actor);
        } else {
            this.getInstances(c, actor);
        }
        return actor;
    }

    @PortedFrom(file="Kernel.h", name="getDirectInstances")
    public void getDirectInstances(ConceptExpression c, Actor actor) {
        this.realiseKB();
        this.setUpCache(c, CacheStatus.CLASSIFIED);
        actor.clear();
        if (actor.apply(this.cachedVertex)) {
            return;
        }
        this.cachedVertex.neigh(false).forEach(actor::apply);
    }

    @PortedFrom(file="Kernel.h", name="getInstances")
    public void getInstances(ConceptExpression c, Actor actor) {
        this.realiseKB();
        this.setUpCache(c, CacheStatus.CLASSIFIED);
        actor.clear();
        this.getCTaxonomy().getRelativesInfo(this.cachedVertex, actor, true, false, false);
    }

    @PortedFrom(file="Kernel.h", name="getTypes")
    public <T extends Expression> TaxonomyActor<T> getTypes(IndividualName i, boolean direct, TaxonomyActor<T> actor) {
        this.realiseKB();
        this.setUpCache(this.getExpressionManager().oneOf(i), CacheStatus.CLASSIFIED);
        actor.clear();
        this.getCTaxonomy().getRelativesInfo(this.cachedVertex, actor, true, direct, true);
        return actor;
    }

    @PortedFrom(file="Kernel.h", name="getSameAs")
    public <T extends Expression> TaxonomyActor<T> getSameAs(IndividualName i, TaxonomyActor<T> actor) {
        this.realiseKB();
        return this.getEquivalentConcepts(this.getExpressionManager().oneOf(i), actor);
    }

    @PortedFrom(file="Kernel.h", name="isSameIndividuals")
    public boolean isSameIndividuals(IndividualExpression ie, IndividualExpression je) {
        this.realiseKB();
        Individual i = this.getIndividual(ie, "Only known individuals are allowed in the isSameAs()");
        Individual j = this.getIndividual(je, "Only known individuals are allowed in the isSameAs()");
        return this.getTBox().isSameIndividuals(i, j);
    }

    @PortedFrom(file="Kernel.h", name="buildCompletionTree")
    public DlCompletionTree buildCompletionTree(ConceptExpression c) {
        this.preprocessKB();
        this.setUpCache(c, CacheStatus.SAT);
        DlCompletionTree ret = this.getTBox().buildCompletionTree(this.cachedConcept);
        if (this.ke == null) {
            this.ke = new KnowledgeExplorer(this.getTBox(), this.getExpressionManager());
        }
        return ret;
    }

    @Original
    private KnowledgeExplorer getKnowledgeExplorer() {
        return this.ke;
    }

    @PortedFrom(file="Kernel.h", name="getDataRoles")
    public Set<DataRoleExpression> getDataRoles(DlCompletionTree node, boolean onlyDet) {
        return this.ke.getDataRoles(node, onlyDet);
    }

    @PortedFrom(file="Kernel.h", name="getObjectRoles")
    public Set<ObjectRoleExpression> getObjectRoles(DlCompletionTree node, boolean onlyDet, boolean needIncoming) {
        return this.ke.getObjectRoles(node, onlyDet, needIncoming);
    }

    @PortedFrom(file="Kernel.h", name="getNeighbours")
    public List<DlCompletionTree> getNeighbours(DlCompletionTree node, RoleExpression role) {
        return this.ke.getNeighbours(node, this.getRole(role, ROLE_EXPECTED));
    }

    @PortedFrom(file="Kernel.h", name="getLabel")
    public List<ConceptExpression> getObjectLabel(DlCompletionTree node, boolean onlyDet) {
        return this.ke.getObjectLabel(node, onlyDet);
    }

    @PortedFrom(file="Kernel.h", name="getLabel")
    public List<DataExpression> getDataLabel(DlCompletionTree node, boolean onlyDet) {
        return this.ke.getDataLabel(node, onlyDet);
    }

    @PortedFrom(file="Kernel.h", name="getBlocker")
    public DlCompletionTree getBlocker(DlCompletionTree node) {
        return this.ke.getBlocker(node);
    }

    @PortedFrom(file="Kernel.h", name="isInstance")
    public boolean isInstance(IndividualExpression i, ConceptExpression c) {
        this.realiseKB();
        this.getIndividual(i, "individual name expected in the isInstance()");
        return this.isSubsumedBy(this.getExpressionManager().oneOf(i), c);
    }

    @PortedFrom(file="Kernel.h", name="needForceReload")
    private boolean needForceReload() {
        if (this.pTBox == null) {
            return true;
        }
        if (!this.ontology.isChanged()) {
            return false;
        }
        return !this.kernelOptions.isUseIncrementalReasoning();
    }

    @PortedFrom(file="Incremental.cpp", name="doIncremental")
    public void doIncremental() {
        this.modSyn = null;
        HashSet<OWLEntity> mPlus = new HashSet<OWLEntity>();
        HashSet<OWLEntity> mMinus = new HashSet<OWLEntity>();
        Collection<NamedEntity> newSig = this.ontology.getSignature();
        HashSet<NamedEntity> removedEntities = new HashSet<NamedEntity>(this.ontoSig);
        removedEntities.removeAll(newSig);
        HashSet<NamedEntity> addedEntities = new HashSet<NamedEntity>(newSig);
        addedEntities.removeAll(this.ontoSig);
        Taxonomy tax = this.getCTaxonomy();
        for (NamedEntity e : removedEntities) {
            if (!(e.getEntry() instanceof Concept)) continue;
            Concept c = (Concept)e.getEntry();
            c.getTaxVertex().remove();
            this.name2Sig.remove(c.getEntity());
        }
        tax.deFinalise();
        for (NamedEntity e : addedEntities) {
            if (!(e instanceof ConceptName)) continue;
            ConceptName cName = (ConceptName)e;
            this.e(cName);
            Concept concept = (Concept)cName.getEntry();
            this.setupSig(concept.getEntity().getEntity());
            TaxonomyVertex cur = tax.getCurrent();
            cur.clear();
            cur.setSample(concept, true);
            cur.addNeighbour(true, tax.getTopVertex());
            tax.finishCurrentNode();
        }
        this.ontoSig = newSig;
        Timer t = new Timer();
        t.start();
        LocalityChecker lc = this.getModExtractor(false, null).getModularizer().getLocalityChecker();
        block2: for (Map.Entry entry : this.name2Sig.entrySet()) {
            lc.setSignatureValue((Signature)entry.getValue());
            for (AxiomWrapper notProcessed : this.ontology.getAxioms()) {
                if (lc.local(notProcessed.getAxiom())) continue;
                mPlus.add((OWLEntity)entry.getKey());
                break;
            }
            for (AxiomWrapper retracted : this.ontology.getRetracted()) {
                if (lc.local(retracted.getAxiom())) continue;
                mMinus.add((OWLEntity)entry.getKey());
                TaxonomyVertex v = ((ClassifiableEntry)entry.getKey()).getTaxVertex();
                if (!v.noNeighbours(true)) continue block2;
                v.addNeighbour(true, tax.getTopVertex());
                tax.getTopVertex().addNeighbour(false, v);
                continue block2;
            }
        }
        t.stop();
        HashSet<OWLEntity> toProcess = new HashSet<OWLEntity>(mPlus);
        toProcess.addAll(mMinus);
        while (!toProcess.isEmpty()) {
            this.buildSignature((OWLEntity)toProcess.iterator().next(), this.ontology.getAxioms(), toProcess);
        }
        tax.finalise();
        byte[] byArray = ReasoningKernel.save(this.pTBox);
        this.kernelOptions.setUseIncrementalReasoning(false);
        this.forceReload();
        this.pTBox.setNameSigMap(this.name2Sig);
        this.pTBox.isConsistent();
        this.kernelOptions.setUseIncrementalReasoning(true);
        this.pTBox = ReasoningKernel.load(byArray);
        this.pTBox.reclassify(mPlus, mMinus);
        this.getOntology().setProcessed();
    }

    @Nullable
    private static byte[] save(TBox tbox) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oout = new ObjectOutputStream(out);
            oout.writeObject(tbox);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return out.toByteArray();
    }

    @Nullable
    private static TBox load(@Nullable byte[] tbox) {
        try {
            return (TBox)new ObjectInputStream(new ByteArrayInputStream(tbox)).readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @PortedFrom(file="Kernel.h", name="forceReload")
    private void forceReload() {
        this.clearTBox();
        this.newKB();
        this.ontology.getSignature().forEach(p -> p.setEntry(null));
        OntologyLoader ontologyLoader = new OntologyLoader(this.getTBox());
        ontologyLoader.visitOntology(this.ontology);
        if (this.kernelOptions.isUseIncrementalReasoning()) {
            this.initIncremental();
        }
        this.ontology.setProcessed();
    }

    @PortedFrom(file="Incremental.cpp", name="setupSig")
    public void setupSig(@Nullable OWLEntity entity) {
        this.moduleTimer.start();
        if (entity == null) {
            return;
        }
        this.moduleTimer.start();
        Signature sig = new Signature();
        sig.add(entity);
        this.getModExtractor(false, null).getModule(sig.getSignature().stream(), false, ModuleType.BOT);
        this.name2Sig.put(entity, new Signature(this.getModExtractor(false, null).getModularizer().getSignature().getSignature().stream()));
        this.moduleTimer.stop();
    }

    @PortedFrom(file="Incremental.cpp", name="buildSignature")
    public void buildSignature(OWLEntity entity, Collection<AxiomWrapper> module, Set<OWLEntity> toProcess) {
        toProcess.remove(entity);
        this.setupSig(entity);
        Collection newModule = this.getModExtractor(false, null).getModularizer().getModule();
        if (module.size() == newModule.size()) {
            return;
        }
        Signature modSig = this.getModExtractor(false, null).getModularizer().getSignature();
        modSig.getSignature().stream().filter(toProcess::contains).forEach(p -> this.buildSignature((OWLEntity)p, newModule, toProcess));
    }

    @PortedFrom(file="Incremental.cpp", name="initIncremental")
    public void initIncremental() {
        this.name2Sig.clear();
        HashSet<OWLEntity> toProcess = new HashSet<OWLEntity>();
        this.getModExtractor(false, null);
        this.getTBox().getConcepts().forEach(p -> toProcess.add(p.getEntity().getEntity()));
        while (!toProcess.isEmpty()) {
            this.buildSignature((OWLEntity)toProcess.iterator().next(), this.ontology.getAxioms(), toProcess);
        }
        this.getTBox().setNameSigMap(this.name2Sig);
        this.ontoSig = this.ontology.getSignature();
    }

    @PortedFrom(file="Kernel.h", name="processKB")
    private void processKB(KBStatus status) {
        assert (status.ordinal() >= KBStatus.KBCHECKED.ordinal());
        if (this.reasoningFailed) {
            throw new ReasonerInternalException("Can't answer queries due to previous errors");
        }
        KBStatus curStatus = this.getStatus();
        if (curStatus.ordinal() >= status.ordinal()) {
            if (!this.isKBConsistent()) {
                throw new InconsistentOntologyException();
            }
            return;
        }
        if (curStatus == KBStatus.KBEMPTY || curStatus == KBStatus.KBLOADING) {
            this.reasoningFailed = true;
            if (!this.needForceReload()) {
                this.doIncremental();
                this.reasoningFailed = false;
                return;
            }
            this.forceReload();
            this.pTBox.isConsistent();
            this.reasoningFailed = false;
            if (status == KBStatus.KBCHECKED) {
                return;
            }
        }
        if (!this.pTBox.isConsistent()) {
            return;
        }
        if (status == KBStatus.KBREALISED) {
            this.pTBox.performRealisation();
        } else {
            this.pTBox.performClassification();
        }
    }

    @PortedFrom(file="Kernel.h", name="classify")
    private void classify(KBStatus status) {
        if (status != KBStatus.KBREALISED) {
            if (!this.pTBox.isConsistent()) {
                return;
            }
            this.pTBox.performClassification();
            return;
        }
        this.realise();
    }

    @PortedFrom(file="Kernel.h", name="realiseKB")
    private void realise() {
        if (!this.pTBox.isConsistent()) {
            return;
        }
        this.pTBox.performRealisation();
    }

    @PortedFrom(file="Kernel.h", name="classifyQuery")
    private void classifyQuery(boolean named) {
        this.classifyKB();
        if (!named) {
            this.getTBox().classifyQueryConcept();
        }
        this.cachedVertex = this.cachedConcept.getTaxVertex();
        if (this.cachedVertex == null) {
            this.cachedVertex = this.getCTaxonomy().getFreshVertex(this.cachedConcept);
        }
    }

    @PortedFrom(file="Kernel.h", name="setUpCache")
    private void setUpCache(DLTree query, CacheStatus level) {
        assert (!this.ontology.isChanged());
        if (this.checkQueryCache(query)) {
            if (level.ordinal() <= this.cacheLevel.ordinal()) {
                return;
            }
            assert (level == CacheStatus.CLASSIFIED && this.cacheLevel != CacheStatus.CLASSIFIED);
            if (this.cacheLevel == CacheStatus.SAT) {
                this.classifyQuery(this.cachedQueryTree.isCN());
                return;
            }
        } else {
            this.setQueryCache(query);
        }
        this.cachedVertex = null;
        this.cacheLevel = level;
        this.cachedConcept = this.cachedQueryTree.isCN() ? this.getTBox().getCI(this.cachedQueryTree) : this.getTBox().createQueryConcept(this.cachedQueryTree);
        assert (this.cachedConcept != null);
        if (this.cachedConcept.getpName() == 0) {
            this.getTBox().preprocessQueryConcept(this.cachedConcept);
        }
        if (level == CacheStatus.CLASSIFIED) {
            this.classifyQuery(this.cachedQueryTree.isCN());
        }
    }

    @PortedFrom(file="Kernel.h", name="setUpCache")
    private void setUpCache(ConceptExpression query, CacheStatus level) {
        assert (!this.ontology.isChanged());
        if (this.checkQueryCache(query)) {
            if (level.ordinal() <= this.cacheLevel.ordinal()) {
                return;
            }
            assert (level == CacheStatus.CLASSIFIED && this.cacheLevel != CacheStatus.CLASSIFIED);
            if (this.cacheLevel == CacheStatus.SAT) {
                this.classifyQuery(ReasoningKernel.isNameOrConst(this.cachedQuery));
                return;
            }
        } else {
            this.setQueryCache(query);
        }
        this.cachedVertex = null;
        this.cacheLevel = level;
        this.cachedConcept = ReasoningKernel.isNameOrConst(this.cachedQuery) ? this.getTBox().getCI(this.e(this.cachedQuery)) : this.getTBox().createQueryConcept(this.e(this.cachedQuery));
        assert (this.cachedConcept != null);
        if (this.cachedConcept.getpName() == 0) {
            this.getTBox().preprocessQueryConcept(this.cachedConcept);
        }
        if (level == CacheStatus.CLASSIFIED) {
            this.classifyQuery(ReasoningKernel.isNameOrConst(this.cachedQuery));
        }
    }

    @PortedFrom(file="Kernel.cpp", name="isEq")
    protected boolean isEq(DlCompletionTree p, DlCompletionTree q) {
        return false;
    }

    @PortedFrom(file="Kernel.cpp", name="isLt")
    protected boolean isLt(DlCompletionTree p, DlCompletionTree q) {
        return false;
    }

    @PortedFrom(file="Kernel.cpp", name="checkDataRelation")
    private boolean checkDataRelation(DlCompletionTree vR, DlCompletionTree vS, int op) {
        switch (op) {
            case 0: {
                return this.isEq(vR, vS);
            }
            case 1: {
                return !this.isEq(vR, vS);
            }
            case 2: {
                return this.isLt(vR, vS);
            }
            case 3: {
                return this.isLt(vR, vS) || this.isEq(vR, vS);
            }
            case 4: {
                return this.isLt(vS, vR);
            }
            case 5: {
                return this.isLt(vS, vR) || this.isEq(vR, vS);
            }
        }
        throw new ReasonerInternalException("Illegal operation in checkIndividualValues()");
    }

    @PortedFrom(file="Kernel.cpp", name="getDataRelatedIndividuals")
    public Collection<IndividualName> getDataRelatedIndividuals(RoleExpression or, RoleExpression os, int op, Collection<IndividualExpression> individuals) {
        this.realiseKB();
        ArrayList<IndividualName> toReturn = new ArrayList<IndividualName>();
        Role r = this.getRole(or, "Role expression expected in the getIndividualsWith()");
        Role s = this.getRole(os, "Role expression expected in the getIndividualsWith()");
        block0: for (IndividualExpression q : individuals) {
            Individual ind = this.getIndividual(q, "individual name expected in getDataRelatedIndividuals()");
            DlCompletionTree vR = null;
            DlCompletionTree vS = null;
            for (DlCompletionTreeArc edge : ind.getNode().getNeighbour()) {
                if (edge.isNeighbour(r)) {
                    vR = edge.getArcEnd();
                } else if (edge.isNeighbour(s)) {
                    vS = edge.getArcEnd();
                }
                if (vR == null || vS == null || !this.checkDataRelation(vR, vS, op)) continue;
                if (!(q instanceof IndividualName)) continue block0;
                toReturn.add((IndividualName)q);
                continue block0;
            }
        }
        return toReturn;
    }

    @PortedFrom(file="Kernel.h", name="getAtomicDecompositionSize")
    public int getAtomicDecompositionSize(OWLOntology o, boolean useSemantics, ModuleType type) {
        if (this.ad == null) {
            this.ad = new AtomicDecompositionImpl(o);
        }
        return this.ad.getAtoms().size();
    }

    @PortedFrom(file="Kernel.h", name="getAtomAxioms")
    public List<AxiomWrapper> getAtomAxioms(int index) {
        return this.ad.getAtomList().get(index).getAtomAxioms();
    }

    @Original
    public Set<OWLAxiom> getTautologies() {
        return this.ad.getTautologies();
    }

    @PortedFrom(file="Kernel.h", name="getAtomModule")
    public List<AxiomWrapper> getAtomModule(int index) {
        return this.ad.getAtomList().get(index).getModule();
    }

    @PortedFrom(file="Kernel.h", name="getAtomDependents")
    public Set<OntologyAtom> getAtomDependents(int index) {
        return this.ad.getAtomList().get(index).getDependencies();
    }

    @PortedFrom(file="Kernel.h", name="checkSubChain")
    private boolean checkSubChain(Role r, List<ObjectRoleExpression> l) {
        DLTree tmp = DLTreeFactory.createSNFNot(this.getTBox().getFreshConcept());
        for (int i = l.size() - 1; i > -1; --i) {
            ObjectRoleExpression p = l.get(i);
            Role s = this.getRole(p, "Role expression expected in chain of isSubChain()");
            if (s.isBottom()) {
                return true;
            }
            tmp = DLTreeFactory.createSNFExists(DLTreeFactory.createRole(s), tmp);
        }
        return !this.checkSatTree(tmp = DLTreeFactory.createSNFAnd(tmp, DLTreeFactory.createSNFForall(DLTreeFactory.buildTree(new Lexeme(Token.RNAME, r)), this.getTBox().getFreshConcept())));
    }

    @PortedFrom(file="Kernel.h", name="isSubChain")
    public boolean isSubChain(ObjectRoleComplexExpression r, List<ObjectRoleExpression> l) {
        this.preprocessKB();
        Role role = this.getRole(r, "Role expression expected in isSubChain()");
        if (role.isTop()) {
            return true;
        }
        return this.checkSubChain(role, l);
    }

    @PortedFrom(file="Kernel.h", name="buildRelatedCache")
    private List<Individual> buildRelatedCache(Individual i, Role r) {
        if (r.isSynonym()) {
            return this.getRelated(i, ClassifiableEntry.resolveSynonym(r));
        }
        if (r.isDataRole() || r.isBottom()) {
            return new ArrayList<Individual>();
        }
        RIActor actor = new RIActor();
        ObjectRoleName invR = r.getId() > 0 ? this.getExpressionManager().inverse(this.getExpressionManager().objectRole(r.getEntity().getEntity())) : this.getExpressionManager().objectRole(r.inverse().getEntity().getEntity());
        ConceptExpression query = r.isTop() ? ExpressionManager.top() : ExpressionManager.value(invR, this.getExpressionManager().individual(i.getEntity().getEntity()));
        this.getInstances(query, actor);
        return actor.getAcc();
    }

    @PortedFrom(file="Kernel.h", name="getRoleFillers")
    public List<Individual> getRoleFillers(IndividualExpression i, ObjectRoleExpression r) {
        this.realiseKB();
        return this.getRelated(this.getIndividual(i, "Individual name expected in the getRoleFillers()"), this.getRole(r, "Role expression expected in the getRoleFillers()"));
    }

    @PortedFrom(file="Kernel.h", name="isRelated")
    private boolean isRelated(IndividualExpression i, ObjectRoleExpression r, IndividualExpression j) {
        this.realiseKB();
        Individual ind = this.getIndividual(i, "Individual name expected in the isRelated()");
        Role role = this.getRole(r, "Role expression expected in the isRelated()");
        if (role.isDataRole()) {
            return false;
        }
        Individual jind = this.getIndividual(j, "Individual name expected in the isRelated()");
        return this.getRelated(ind, role).stream().anyMatch(jind::equals);
    }
}

