/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeFactory;
import uk.ac.manchester.cs.jfact.kernel.ExpressionTranslator;
import uk.ac.manchester.cs.jfact.kernel.Individual;
import uk.ac.manchester.cs.jfact.kernel.Lexeme;
import uk.ac.manchester.cs.jfact.kernel.Ontology;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.RoleMaster;
import uk.ac.manchester.cs.jfact.kernel.TBox;
import uk.ac.manchester.cs.jfact.kernel.Token;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomConceptInclusion;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDRoleDomain;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDRoleFunctional;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDRoleRange;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDRoleSubsumption;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDeclaration;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDifferentIndividuals;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDisjointConcepts;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDisjointDRoles;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDisjointORoles;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDisjointUnion;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomEquivalentConcepts;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomEquivalentDRoles;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomEquivalentORoles;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomFairnessConstraint;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomImpl;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomInstanceOf;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomORoleDomain;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomORoleFunctional;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomORoleRange;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomORoleSubsumption;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRelatedTo;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRelatedToNot;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleAsymmetric;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleInverse;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleInverseFunctional;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleIrreflexive;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleReflexive;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleSymmetric;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleTransitive;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomSameIndividuals;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomValueOf;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomValueOfNot;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.IndividualExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.RoleExpression;
import uk.ac.manchester.cs.jfact.visitors.DLAxiomVisitor;

@PortedFrom(file="tOntologyLoader.h", name="TOntologyLoader")
public class OntologyLoader
implements DLAxiomVisitor,
Serializable {
    @PortedFrom(file="tOntologyLoader.h", name="kb")
    private final TBox tbox;
    @PortedFrom(file="tOntologyLoader.h", name="ETrans")
    private final ExpressionTranslator expressionTranslator;

    public OntologyLoader(TBox kb) {
        this.tbox = kb;
        this.expressionTranslator = new ExpressionTranslator(kb);
    }

    @PortedFrom(file="tOntologyLoader.h", name="getRole")
    private Role getRole(RoleExpression r, String reason) {
        try {
            return Role.resolveRole(r.accept(this.expressionTranslator));
        }
        catch (OWLRuntimeException e) {
            throw new ReasonerInternalException(reason + '\t' + e.getMessage(), (Throwable)e);
        }
    }

    @PortedFrom(file="tOntologyLoader.h", name="getIndividual")
    public Individual getIndividual(IndividualExpression i, String reason) {
        try {
            DLTree individual = i.accept(this.expressionTranslator);
            return (Individual)this.tbox.getCI(individual);
        }
        catch (OWLRuntimeException e) {
            throw new ReasonerInternalException(reason + '\t' + e.getMessage(), (Throwable)e);
        }
    }

    @PortedFrom(file="tOntologyLoader.h", name="ensureNames")
    public Expression ensureNames(Expression expr) {
        assert (expr != null);
        return expr;
    }

    @PortedFrom(file="tOntologyLoader.h", name="prepareArgList")
    private <T extends Expression> List<DLTree> prepareArgList(Collection<T> c) {
        return OWLAPIStreamUtils.asList(c.stream().map(t -> this.ensureNames((Expression)t).accept(this.expressionTranslator)));
    }

    @Override
    public void visit(AxiomDeclaration axiom) {
        this.ensureNames(axiom.getDeclaration());
        axiom.getDeclaration().accept(this.expressionTranslator);
    }

    @Override
    public void visit(AxiomEquivalentConcepts axiom) {
        this.tbox.processEquivalentC(this.prepareArgList(axiom.getArguments()));
    }

    @Override
    public void visit(AxiomDisjointConcepts axiom) {
        this.tbox.processDisjointC(this.prepareArgList(axiom.getArguments()));
    }

    @Override
    public void visit(AxiomEquivalentORoles axiom) {
        this.tbox.processEquivalentR(this.prepareArgList(axiom.getArguments()));
    }

    @Override
    public void visit(AxiomEquivalentDRoles axiom) {
        this.tbox.processEquivalentR(this.prepareArgList(axiom.getArguments()));
    }

    @Override
    public void visit(AxiomDisjointORoles axiom) {
        this.tbox.processDisjointR(this.prepareArgList(axiom.getArguments()));
    }

    @Override
    public void visit(AxiomDisjointDRoles axiom) {
        this.tbox.processDisjointR(this.prepareArgList(axiom.getArguments()));
    }

    @Override
    public void visit(AxiomDisjointUnion axiom) {
        this.tbox.processDisjointC(this.prepareArgList(axiom.getArguments()));
        ArrayList<DLTree> argList = new ArrayList<DLTree>();
        this.ensureNames(axiom.getConcept());
        argList.add(axiom.getConcept().accept(this.expressionTranslator));
        List list = OWLAPIStreamUtils.asList(axiom.getArguments().stream().map(p -> p.accept(this.expressionTranslator)));
        argList.add(DLTreeFactory.createSNFOr(list));
        this.tbox.processEquivalentC(argList);
    }

    @Override
    public void visit(AxiomSameIndividuals axiom) {
        this.tbox.processSame(this.prepareArgList(axiom.getArguments()));
    }

    @Override
    public void visit(AxiomDifferentIndividuals axiom) {
        this.tbox.processDifferent(this.prepareArgList(axiom.getArguments()));
    }

    @Override
    public void visit(AxiomFairnessConstraint axiom) {
        this.tbox.setFairnessConstraintDLTrees(this.prepareArgList(axiom.getArguments()));
    }

    @Override
    public void visit(AxiomRoleInverse axiom) {
        this.ensureNames(axiom.getRole());
        this.ensureNames(axiom.getInvRole());
        Role r = this.getRole(axiom.getRole(), "Role expression expected in Role Inverse axiom");
        Role iR = this.getRole(axiom.getInvRole(), "Role expression expected in Role Inverse axiom");
        this.tbox.getRM(r);
        RoleMaster.addRoleSynonym(iR.inverse(), r);
    }

    @Override
    public void visit(AxiomORoleSubsumption axiom) {
        this.ensureNames(axiom.getRole());
        this.ensureNames(axiom.getSubRole());
        DLTree sub = axiom.getSubRole().accept(this.expressionTranslator);
        Role r = this.getRole(axiom.getRole(), "Role expression expected in Object Roles Subsumption axiom");
        this.tbox.getRM(r);
        RoleMaster.addRoleParent(sub, r);
    }

    @Override
    public void visit(AxiomDRoleSubsumption axiom) {
        this.ensureNames(axiom.getRole());
        this.ensureNames(axiom.getSubRole());
        Role r = this.getRole(axiom.getRole(), "Role expression expected in Data Roles Subsumption axiom");
        Role s = this.getRole(axiom.getSubRole(), "Role expression expected in Data Roles Subsumption axiom");
        this.tbox.getDRM();
        RoleMaster.addRoleParentProper(s, r);
    }

    @Override
    public void visit(AxiomORoleDomain axiom) {
        this.ensureNames(axiom.getRole());
        this.ensureNames(axiom.getDomain());
        Role r = this.getRole(axiom.getRole(), "Role expression expected in Object Role Domain axiom");
        DLTree c = axiom.getDomain().accept(this.expressionTranslator);
        if (r.isTop()) {
            this.tbox.addSubsumeAxiom(DLTreeFactory.createTop(), c);
        } else if (!r.isBottom()) {
            r.setDomain(c);
        }
    }

    @Override
    public void visit(AxiomDRoleDomain axiom) {
        this.ensureNames(axiom.getRole());
        this.ensureNames(axiom.getDomain());
        Role r = this.getRole(axiom.getRole(), "Role expression expected in Data Role Domain axiom");
        DLTree c = axiom.getDomain().accept(this.expressionTranslator);
        if (r.isTop()) {
            this.tbox.addSubsumeAxiom(DLTreeFactory.createTop(), c);
        } else if (!r.isBottom()) {
            r.setDomain(c);
        }
    }

    @Override
    public void visit(AxiomORoleRange axiom) {
        this.ensureNames(axiom.getRole());
        this.ensureNames(axiom.getRange());
        Role r = this.getRole(axiom.getRole(), "Role expression expected in Object Role Range axiom");
        DLTree c = axiom.getRange().accept(this.expressionTranslator);
        if (r.isTop()) {
            this.tbox.addSubsumeAxiom(DLTreeFactory.createTop(), c);
        } else if (!r.isBottom()) {
            r.setRange(c);
        }
    }

    @Override
    public void visit(AxiomDRoleRange axiom) {
        this.ensureNames(axiom.getRole());
        this.ensureNames(axiom.getRange());
        this.getRole(axiom.getRole(), "Role expression expected in Data Role Range axiom").setRange(axiom.getRange().accept(this.expressionTranslator));
    }

    @Override
    public void visit(AxiomRoleTransitive axiom) {
        this.ensureNames(axiom.getRole());
        Role role = this.getRole(axiom.getRole(), "Role expression expected in Role Transitivity axiom");
        if (!role.isTop() && !role.isBottom()) {
            role.setTransitive(true);
        }
    }

    @Override
    public void visit(AxiomRoleReflexive axiom) {
        this.ensureNames(axiom.getRole());
        Role role = this.getRole(axiom.getRole(), "Role expression expected in Role Reflexivity axiom");
        if (role.isBottom()) {
            throw new InconsistentOntologyException();
        }
        if (!role.isTop()) {
            role.setReflexive(true);
        }
    }

    @Override
    public void visit(AxiomRoleIrreflexive axiom) {
        this.ensureNames(axiom.getRole());
        Role r = this.getRole(axiom.getRole(), "Role expression expected in Role Irreflexivity axiom");
        if (r.isTop()) {
            throw new InconsistentOntologyException();
        }
        if (!r.isBottom()) {
            r.setDomain(DLTreeFactory.createSNFNot(DLTreeFactory.createSNFSelf(axiom.getRole().accept(this.expressionTranslator))));
            r.setDomain(DLTreeFactory.createSNFNot(DLTreeFactory.buildTree(new Lexeme(Token.SELF), axiom.getRole().accept(this.expressionTranslator))));
            r.setIrreflexive(true);
        }
    }

    @Override
    public void visit(AxiomRoleSymmetric axiom) {
        this.ensureNames(axiom.getRole());
        Role r = this.getRole(axiom.getRole(), "Role expression expected in Role Symmetry axiom");
        if (!r.isTop() && !r.isBottom()) {
            r.setSymmetric(true);
            this.tbox.getORM();
            RoleMaster.addRoleParentProper(r, r.inverse());
        }
    }

    @Override
    public void visit(AxiomRoleAsymmetric axiom) {
        this.ensureNames(axiom.getRole());
        Role r = this.getRole(axiom.getRole(), "Role expression expected in Role Asymmetry axiom");
        if (r.isTop()) {
            throw new InconsistentOntologyException();
        }
        if (!r.isBottom()) {
            r.setAsymmetric(true);
            this.tbox.getORM().addDisjointRoles(r, r.inverse());
        }
    }

    @Override
    public void visit(AxiomORoleFunctional axiom) {
        this.ensureNames(axiom.getRole());
        Role role = this.getRole(axiom.getRole(), "Role expression expected in Object Role Functionality axiom");
        if (role.isTop()) {
            throw new InconsistentOntologyException();
        }
        if (!role.isBottom()) {
            role.setFunctional();
        }
    }

    @Override
    public void visit(AxiomDRoleFunctional axiom) {
        this.ensureNames(axiom.getRole());
        Role role = this.getRole(axiom.getRole(), "Role expression expected in Data Role Functionality axiom");
        if (role.isTop()) {
            throw new InconsistentOntologyException();
        }
        if (!role.isBottom()) {
            role.setFunctional();
        }
    }

    @Override
    public void visit(AxiomRoleInverseFunctional axiom) {
        this.ensureNames(axiom.getRole());
        Role role = this.getRole(axiom.getRole(), "Role expression expected in Role Inverse Functionality axiom");
        if (role.isTop()) {
            throw new InconsistentOntologyException();
        }
        if (!role.isBottom()) {
            role.inverse().setFunctional();
        }
    }

    @Override
    public void visit(AxiomConceptInclusion axiom) {
        this.ensureNames(axiom.getSubConcept());
        this.ensureNames(axiom.getSupConcept());
        DLTree c = axiom.getSubConcept().accept(this.expressionTranslator);
        DLTree d = axiom.getSupConcept().accept(this.expressionTranslator);
        this.tbox.addSubsumeAxiom(c, d);
    }

    @Override
    public void visit(AxiomInstanceOf axiom) {
        this.ensureNames(axiom.getIndividual());
        this.ensureNames(axiom.getC());
        this.getIndividual(axiom.getIndividual(), "Individual expected in Instance axiom");
        DLTree i = axiom.getIndividual().accept(this.expressionTranslator);
        DLTree c = axiom.getC().accept(this.expressionTranslator);
        this.tbox.addSubsumeAxiom(i, c);
    }

    @Override
    public void visit(AxiomRelatedTo axiom) {
        this.ensureNames(axiom.getIndividual());
        this.ensureNames(axiom.getRelation());
        this.ensureNames(axiom.getRelatedIndividual());
        Role r = this.getRole(axiom.getRelation(), "Role expression expected in Related To axiom");
        if (r.isBottom()) {
            throw new InconsistentOntologyException();
        }
        if (!r.isTop()) {
            Individual i = this.getIndividual(axiom.getIndividual(), "Individual expected in Related To axiom");
            Individual j = this.getIndividual(axiom.getRelatedIndividual(), "Individual expected in Related To axiom");
            this.tbox.registerIndividualRelation(i, r, j);
        }
    }

    @Override
    public void visit(AxiomRelatedToNot axiom) {
        this.ensureNames(axiom.getIndividual());
        this.ensureNames(axiom.getRelation());
        this.ensureNames(axiom.getRelatedIndividual());
        Role r = this.getRole(axiom.getRelation(), "Role expression expected in Related To Not axiom");
        if (r.isTop()) {
            throw new InconsistentOntologyException();
        }
        if (!r.isBottom()) {
            this.getIndividual(axiom.getIndividual(), "Individual expected in Related To Not axiom");
            this.getIndividual(axiom.getRelatedIndividual(), "Individual expected in Related To Not axiom");
            this.tbox.addSubsumeAxiom(axiom.getIndividual().accept(this.expressionTranslator), DLTreeFactory.createSNFForall(axiom.getRelation().accept(this.expressionTranslator), DLTreeFactory.createSNFNot(axiom.getRelatedIndividual().accept(this.expressionTranslator))));
        }
    }

    @Override
    public void visit(AxiomValueOf axiom) {
        this.ensureNames(axiom.getIndividual());
        this.ensureNames(axiom.getAttribute());
        this.getIndividual(axiom.getIndividual(), "Individual expected in Value Of axiom");
        Role r = this.getRole(axiom.getAttribute(), "Role expression expected in Value Of axiom");
        if (r.isBottom()) {
            throw new InconsistentOntologyException();
        }
        if (!r.isTop()) {
            this.tbox.addSubsumeAxiom(axiom.getIndividual().accept(this.expressionTranslator), DLTreeFactory.createSNFExists(axiom.getAttribute().accept(this.expressionTranslator), axiom.getValue().accept(this.expressionTranslator)));
        }
    }

    @Override
    public void visit(AxiomValueOfNot axiom) {
        this.ensureNames(axiom.getIndividual());
        this.ensureNames(axiom.getAttribute());
        this.getIndividual(axiom.getIndividual(), "Individual expected in Value Of Not axiom");
        Role r = this.getRole(axiom.getAttribute(), "Role expression expected in Value Of Not axiom");
        if (r.isTop()) {
            throw new InconsistentOntologyException();
        }
        if (!r.isBottom()) {
            this.tbox.addSubsumeAxiom(axiom.getIndividual().accept(this.expressionTranslator), DLTreeFactory.createSNFForall(axiom.getAttribute().accept(this.expressionTranslator), DLTreeFactory.createSNFNot(axiom.getValue().accept(this.expressionTranslator))));
        }
    }

    @PortedFrom(file="tOntologyLoader.h", name="visitOntology")
    public void visitOntology(Ontology ontology) {
        ontology.getAxioms().stream().filter(p -> p.isUsed()).forEach(p -> ((AxiomImpl)p).accept(this));
        this.tbox.finishLoading();
    }
}

