/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapitools.decomposition.AxiomWrapper;
import uk.ac.manchester.cs.jfact.kernel.ExpressionCache;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomImpl;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.NamedEntity;

@PortedFrom(file="tOntology.h", name="TOntology")
public class Ontology
implements Serializable {
    @PortedFrom(file="tOntology.h", name="Axioms")
    private final List<AxiomWrapper> axioms = new ArrayList<AxiomWrapper>();
    @PortedFrom(file="tOntology.h", name="Retracted")
    private final List<AxiomWrapper> retracted = new ArrayList<AxiomWrapper>();
    @PortedFrom(file="tOntology.h", name="EManager")
    private final ExpressionCache expressionCache = new ExpressionCache();
    @PortedFrom(file="tOntology.h", name="axiomId")
    private int axiomId = 0;
    @PortedFrom(file="tOntology.h", name="changed")
    private boolean changed = false;

    @PortedFrom(file="tOntology.h", name="get")
    public AxiomWrapper get(int i) {
        return this.axioms.get(i);
    }

    @PortedFrom(file="tOntology.h", name="isChanged")
    public boolean isChanged() {
        return this.changed;
    }

    @PortedFrom(file="tOntology.h", name="setProcessed")
    public void setProcessed() {
        this.retracted.clear();
        this.changed = false;
    }

    @PortedFrom(file="tOntology.h", name="add")
    public AxiomWrapper add(AxiomWrapper p) {
        p.setId(++this.axiomId);
        this.axioms.add(p);
        this.changed = true;
        return p;
    }

    @PortedFrom(file="tOntology.h", name="retract")
    public void retract(AxiomWrapper p) {
        this.changed = true;
        this.retracted.add(p);
        p.setUsed(false);
    }

    @PortedFrom(file="tOntology.h", name="clear")
    public void clear() {
        this.safeClear();
        this.retracted.clear();
        this.expressionCache.clear();
        this.changed = false;
    }

    @PortedFrom(file="tOntology.h", name="safeClear")
    public void safeClear() {
        this.axioms.clear();
    }

    @PortedFrom(file="tOntology.h", name="getExpressionManager")
    public ExpressionCache getExpressionManager() {
        return this.expressionCache;
    }

    @PortedFrom(file="tOntology.h", name="getAxioms")
    public List<AxiomWrapper> getAxioms() {
        return this.axioms;
    }

    @PortedFrom(file="tOntology.h", name="size")
    public int size() {
        return this.axioms.size();
    }

    @Original
    public List<AxiomWrapper> getRetracted() {
        return this.retracted;
    }

    @PortedFrom(file="tOntology.h", name="getSignature")
    public Stream<Expression> signature() {
        return this.axioms.stream().filter(p -> p.isUsed()).flatMap(p -> ((AxiomImpl)p).namedEntitySignature()).distinct();
    }

    public Collection<NamedEntity> getSignature() {
        return OWLAPIStreamUtils.asList(this.signature().filter(p -> p instanceof NamedEntity).map(p -> (NamedEntity)((Object)p)));
    }
}

