/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import uk.ac.manchester.cs.chainsaw.FastSet;
import uk.ac.manchester.cs.chainsaw.FastSetFactory;
import uk.ac.manchester.cs.jfact.dep.DepSet;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.helpers.Reference;
import uk.ac.manchester.cs.jfact.helpers.SaveStack;
import uk.ac.manchester.cs.jfact.helpers.Templates;
import uk.ac.manchester.cs.jfact.kernel.ConceptWDep;
import uk.ac.manchester.cs.jfact.kernel.DLDag;
import uk.ac.manchester.cs.jfact.kernel.DagTag;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTreeArc;
import uk.ac.manchester.cs.jfact.kernel.DlSatTester;
import uk.ac.manchester.cs.jfact.kernel.Restorer;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.SaveStackRare;
import uk.ac.manchester.cs.jfact.kernel.state.DLCompletionGraphSaveState;

@PortedFrom(file="dlCompletionGraph.h", name="DlCompletionGraph")
public class DlCompletionGraph
implements Serializable {
    @PortedFrom(file="dlCompletionGraph.h", name="initIRLevel")
    private static final int INIT_IR_LEVEL = 0;
    @PortedFrom(file="dlCompletionGraph.h", name="CTEdgeHeap")
    private final List<DlCompletionTreeArc> ctEdgeHeap = new ArrayList<DlCompletionTreeArc>();
    @PortedFrom(file="dlCompletionGraph.h", name="NodeBase")
    private final List<DlCompletionTree> nodeBase;
    @PortedFrom(file="dlCompletionGraph.h", name="SavedNodes")
    private final List<DlCompletionTree> savedNodes = new ArrayList<DlCompletionTree>();
    @PortedFrom(file="dlCompletionGraph.h", name="pReasoner")
    private final DlSatTester pReasoner;
    @PortedFrom(file="dlCompletionGraph.h", name="nodeId")
    private int nodeId = 0;
    @PortedFrom(file="dlCompletionGraph.h", name="endUsed")
    private int endUsed;
    @PortedFrom(file="dlCompletionGraph.h", name="branchingLevel")
    private int branchingLevel;
    @PortedFrom(file="dlCompletionGraph.h", name="IRLevel")
    private int irLevel;
    @PortedFrom(file="dlCompletionGraph.h", name="RareStack")
    private final SaveStackRare rareStack = new SaveStackRare();
    @PortedFrom(file="dlCompletionGraph.h", name="Stack")
    private final SaveStack<DLCompletionGraphSaveState> stack = new SaveStack();
    @PortedFrom(file="dlCompletionGraph.h", name="CPGFlag")
    private final FastSet cgpFlag = FastSetFactory.create();
    @PortedFrom(file="dlCompletionGraph.h", name="CPGIndent")
    private int cgpIndent;
    @PortedFrom(file="dlCompletionGraph.h", name="nNodeSaves")
    private int nNodeSaves;
    @PortedFrom(file="dlCompletionGraph.h", name="nNodeRestores")
    private int nNodeRestores;
    @PortedFrom(file="dlCompletionGraph.h", name="maxGraphSize")
    private int maxGraphSize = 0;
    @PortedFrom(file="dlCompletionGraph.h", name="nSkipBeforeBlock")
    private int nSkipBeforeBlock = 0;
    @PortedFrom(file="dlCompletionGraph.h", name="useLazyBlocking")
    private boolean useLazyBlocking;
    @PortedFrom(file="dlCompletionGraph.h", name="useAnywhereBlocking")
    private boolean useAnywhereBlocking;
    @PortedFrom(file="dlCompletionGraph.h", name="sessionHasInverseRoles")
    private boolean sessionHasInverseRoles;
    @PortedFrom(file="dlCompletionGraph.h", name="sessionHasNumberRestrictions")
    private boolean sessionHasNumberRestrictions;

    public DlCompletionGraph(int initSize, DlSatTester p) {
        this.pReasoner = p;
        this.nodeId = 0;
        this.endUsed = 0;
        this.branchingLevel = 1;
        this.irLevel = 0;
        this.nodeBase = new ArrayList<DlCompletionTree>(initSize);
        for (int i = 0; i < initSize; ++i) {
            this.nodeBase.add(new DlCompletionTree(this.nodeId++, this.pReasoner.getOptions()));
        }
        this.clearStatistics();
        this.initRoot();
    }

    @PortedFrom(file="dlCompletionGraph.h", name="grow")
    private void grow() {
        int size = this.nodeBase.size();
        for (int i = 0; i < size; ++i) {
            this.nodeBase.add(new DlCompletionTree(this.nodeId++, this.pReasoner.getOptions()));
        }
    }

    @PortedFrom(file="dlCompletionGraph.h", name="initRoot")
    private void initRoot() {
        assert (this.endUsed == 0);
        this.getNewNode();
    }

    @PortedFrom(file="dlCompletionGraph.h", name="invalidateEdge")
    private void invalidateEdge(DlCompletionTreeArc edge) {
        this.saveRareCond(edge.save());
    }

    @PortedFrom(file="dlCompletionGraph.h", name="isStillDBlocked")
    private boolean isStillDBlocked(DlCompletionTree node) {
        return node.isDBlocked() && this.isBlockedBy(node, node.blocker);
    }

    @PortedFrom(file="dlCompletionGraph.h", name="findDBlocker")
    private void findDBlocker(DlCompletionTree node) {
        this.saveNode(node, this.branchingLevel);
        node.clearAffected();
        if (node.isBlocked()) {
            this.saveRareCond(node.setUBlocked());
        }
        if (this.useAnywhereBlocking) {
            this.findDAnywhereBlocker(node);
        } else {
            this.findDAncestorBlocker(node);
        }
    }

    @PortedFrom(file="dlCompletionGraph.h", name="unblockNodeChildren")
    private void unblockNodeChildren(DlCompletionTree node) {
        node.getNeighbour().stream().filter(q -> q.unblockable()).forEach(q -> this.unblockNode(q.getArcEnd(), false));
    }

    @PortedFrom(file="dlCompletionGraph.h", name="setNodeDBlocked")
    private void setNodeDBlocked(DlCompletionTree node, DlCompletionTree blocker) {
        this.saveRareCond(node.setDBlocked(blocker));
        this.propagateIBlockedStatus(node, node);
    }

    @PortedFrom(file="dlCompletionGraph.h", name="setNodeIBlocked")
    private void setNodeIBlocked(DlCompletionTree node, DlCompletionTree blocker) {
        if (node.isPBlocked() || node.isNominalNode()) {
            return;
        }
        node.clearAffected();
        if (node.isIBlocked() && node.blocker.equals(blocker)) {
            return;
        }
        if (node.equals(blocker)) {
            return;
        }
        this.saveRareCond(node.setIBlocked(blocker));
        this.propagateIBlockedStatus(node, blocker);
    }

    @PortedFrom(file="dlCompletionGraph.h", name="propagateIBlockedStatus")
    private void propagateIBlockedStatus(DlCompletionTree node, DlCompletionTree blocker) {
        node.getNeighbour().stream().filter(q -> q.isSuccEdge() && !q.isIBlocked()).forEach(q -> this.setNodeIBlocked(q.getArcEnd(), blocker));
    }

    @PortedFrom(file="dlCompletionGraph.h", name="canBeUnBlocked")
    private boolean canBeUnBlocked(DlCompletionTree node) {
        if (this.sessionHasInverseRoles) {
            return true;
        }
        return node.isAffected() || node.isIllegallyDBlocked();
    }

    @PortedFrom(file="dlCompletionGraph.h", name="PrintIndent")
    private void printIndent(LogAdapter o) {
        o.print("\n|");
        for (int i = 1; i < this.cgpIndent; ++i) {
            o.print(" |");
        }
    }

    @PortedFrom(file="dlCompletionGraph.h", name="initContext")
    public void initContext(int nSkip, boolean useLB, boolean useAB) {
        this.nSkipBeforeBlock = nSkip;
        this.useLazyBlocking = useLB;
        this.useAnywhereBlocking = useAB;
    }

    @PortedFrom(file="dlCompletionGraph.h", name="setBlockingMethod")
    public void setBlockingMethod(boolean hasInverse, boolean hasQCR) {
        this.sessionHasInverseRoles = hasInverse;
        this.sessionHasNumberRestrictions = hasQCR;
    }

    @PortedFrom(file="dlCompletionGraph.h", name="addConceptToNode")
    public void addConceptToNode(DlCompletionTree node, ConceptWDep c, DagTag tag) {
        node.addConcept(c, tag);
        if (this.useLazyBlocking) {
            node.setAffected();
        } else {
            this.detectBlockedStatus(node);
        }
    }

    @PortedFrom(file="dlCompletionGraph.h", name="getRoot")
    public DlCompletionTree getRoot() {
        return this.nodeBase.get(0).resolvePBlocker();
    }

    @Nullable
    @PortedFrom(file="dlCompletionGraph.h", name="getNode")
    public DlCompletionTree getNode(int i) {
        if (i >= this.endUsed) {
            return null;
        }
        return this.nodeBase.get(i);
    }

    @PortedFrom(file="dlCompletionGraph.h", name="getNode")
    public Stream<DlCompletionTree> nodes() {
        return this.nodeBase.stream().limit(this.endUsed);
    }

    @PortedFrom(file="dlCompletionGraph.h", name="getNewNode")
    public DlCompletionTree getNewNode() {
        if (this.endUsed >= this.nodeBase.size()) {
            this.grow();
        }
        DlCompletionTree ret = this.nodeBase.get(this.endUsed++);
        ret.init(this.branchingLevel);
        return ret;
    }

    @PortedFrom(file="dlCompletionGraph.h", name="updateDBlockedStatus")
    public void updateDBlockedStatus(DlCompletionTree node) {
        if (!this.canBeUnBlocked(node)) {
            return;
        }
        if (this.isStillDBlocked(node)) {
            node.clearAffected();
        } else {
            this.detectBlockedStatus(node);
        }
        assert (!node.isAffected());
    }

    @PortedFrom(file="dlCompletionGraph.h", name="retestCGBlockedStatus")
    public void retestCGBlockedStatus() {
        do {
            this.nodeBase.stream().limit(this.endUsed).filter(DlCompletionTree::isDBlocked).forEach(this::updateDBlockedStatus);
        } while (this.nodeBase.stream().limit(this.endUsed).anyMatch(DlCompletionTree::isIllegallyDBlocked));
    }

    @Nullable
    @PortedFrom(file="dlCompletionGraph.h", name="getFCViolator")
    public DlCompletionTree getFCViolator(int c) {
        return this.nodeBase.stream().filter(p -> p.isDBlocked() && !p.isLoopLabelled(c)).findAny().orElse(null);
    }

    @PortedFrom(file="dlCompletionGraph.h", name="clearStatistics")
    public void clearStatistics() {
        this.nNodeSaves = 0;
        this.nNodeRestores = 0;
        if (this.maxGraphSize < this.endUsed) {
            this.maxGraphSize = this.endUsed;
        }
    }

    @PortedFrom(file="dlCompletionGraph.h", name="maxSize")
    public int maxSize() {
        return this.maxGraphSize;
    }

    @PortedFrom(file="dlCompletionGraph.h", name="clear")
    public void clear() {
        this.ctEdgeHeap.clear();
        this.endUsed = 0;
        this.branchingLevel = 1;
        this.irLevel = 0;
        this.rareStack.clear();
        this.stack.clear();
        this.savedNodes.clear();
        this.initRoot();
    }

    @PortedFrom(file="dlCompletionGraph.h", name="saveRareCond")
    public void saveRareCond(@Nullable Restorer p) {
        if (p == null) {
            throw new IllegalArgumentException();
        }
        this.rareStack.push(p);
    }

    @PortedFrom(file="dlCompletionGraph.h", name="saveRareCond")
    public void saveRareCond(List<Restorer> l) {
        l.forEach(this::saveRareCond);
    }

    public SaveStackRare getRareStack() {
        return this.rareStack;
    }

    @PortedFrom(file="dlCompletionGraph.h", name="addRoleLabel")
    public DlCompletionTreeArc addRoleLabel(DlCompletionTree from, DlCompletionTree to, boolean isPredEdge, Role r, DepSet dep) {
        DlCompletionTreeArc ret = from.getEdgeLabelled(r, to);
        if (ret == null) {
            ret = this.createEdge(from, to, isPredEdge, r, dep);
        } else if (!dep.isEmpty()) {
            this.saveRareCond(ret.addDep(dep));
        }
        return ret;
    }

    @PortedFrom(file="dlCompletionGraph.h", name="createNeighbour")
    public DlCompletionTreeArc createNeighbour(DlCompletionTree from, boolean isPredEdge, Role r, DepSet dep) {
        if (this.pReasoner.getOptions().isImproveSaveRestoreDepset()) assert (this.branchingLevel == dep.level() + 1);
        return this.createEdge(from, this.getNewNode(), isPredEdge, r, dep);
    }

    @PortedFrom(file="dlCompletionGraph.h", name="createLoop")
    public DlCompletionTreeArc createLoop(DlCompletionTree node, Role r, DepSet dep) {
        return this.addRoleLabel(node, node, false, r, dep);
    }

    @PortedFrom(file="dlCompletionGraph.h", name="saveNode")
    public void saveNode(DlCompletionTree node, int level) {
        if (node.needSave(level)) {
            node.save(level);
            this.savedNodes.add(node);
            ++this.nNodeSaves;
        }
    }

    @PortedFrom(file="dlCompletionGraph.h", name="restoreNode")
    private void restoreNode(DlCompletionTree node, int level) {
        if (node.needRestore(level)) {
            node.restore(level);
            ++this.nNodeRestores;
        }
    }

    @PortedFrom(file="dlCompletionGraph.h", name="isBlockedBy")
    private boolean isBlockedBy(DlCompletionTree node, DlCompletionTree blocker) {
        boolean ret;
        assert (!node.isNominalNode());
        assert (!blocker.isNominalNode());
        if (blocker.isBlocked()) {
            return false;
        }
        if (!blocker.canBlockInit(node.getInit())) {
            return false;
        }
        if (this.sessionHasInverseRoles) {
            DLDag dag = this.pReasoner.getDAG();
            ret = this.sessionHasNumberRestrictions ? node.isBlockedBySHIQ(dag, blocker) : node.isBlockedBySHI(dag, blocker);
        } else {
            ret = node.isBlockedBySH(blocker);
        }
        if (this.pReasoner.getOptions().isUseBlockingStatistics() && !ret) {
            this.pReasoner.getOptions().getLog().printTemplateInt(Templates.IS_BLOCKED_FAILURE_BY, node.getId(), blocker.getId());
        }
        return ret;
    }

    @PortedFrom(file="dlCompletionGraph.h", name="detectBlockedStatus")
    public void detectBlockedStatus(DlCompletionTree node) {
        DlCompletionTree p = node;
        boolean wasBlocked = node.isBlocked();
        boolean wasDBlocked = node.isDBlocked();
        node.setAffected();
        while (p.hasParent() && p.isBlockableNode() && p.isAffected()) {
            this.findDBlocker(p);
            if (p.isBlocked()) {
                return;
            }
            p = p.getParentNode();
        }
        p.clearAffected();
        if (wasBlocked && !node.isBlocked()) {
            this.unblockNode(node, wasDBlocked);
        }
    }

    @PortedFrom(file="dlCompletionGraph.h", name="unblockNode")
    private void unblockNode(DlCompletionTree node, boolean wasDBlocked) {
        if (node.isPBlocked() || !node.isBlockableNode()) {
            return;
        }
        if (!wasDBlocked) {
            this.saveRareCond(node.setUBlocked());
        }
        this.pReasoner.repeatUnblockedNode(node, wasDBlocked);
        this.unblockNodeChildren(node);
    }

    @PortedFrom(file="dlCompletionGraph.h", name="findDAncestorBlocker")
    private void findDAncestorBlocker(DlCompletionTree node) {
        DlCompletionTree p = node;
        if (this.pReasoner.getOptions().isUseFairness() && this.nSkipBeforeBlock > 0) {
            for (int n = this.nSkipBeforeBlock - 1; n >= 0 && p.hasParent() && p.isBlockableNode(); --n) {
                p = p.getParentNode();
            }
        }
        while (p.hasParent()) {
            if (!(p = p.getParentNode()).isBlockableNode()) {
                return;
            }
            if (!this.isBlockedBy(node, p)) continue;
            this.setNodeDBlocked(node, p);
            return;
        }
    }

    @PortedFrom(file="dlCompletionGraph.h", name="findDAnywhereBlocker")
    private void findDAnywhereBlocker(DlCompletionTree node) {
        for (int i = 0; i < this.endUsed && i != node.getId(); ++i) {
            DlCompletionTree p = this.nodeBase.get(i);
            if (p.isBlockedPBlockedNominalNodeCached() || !this.isBlockedBy(node, p)) continue;
            this.setNodeDBlocked(node, p);
            return;
        }
    }

    @PortedFrom(file="dlCompletionGraph.h", name="nonMergable")
    public boolean nonMergable(DlCompletionTree p, DlCompletionTree q, Reference<DepSet> dep) {
        return p.nonMergable(q, dep);
    }

    @PortedFrom(file="dlCompletionGraph.h", name="updateIR")
    private void updateIR(DlCompletionTree p, DlCompletionTree q, DepSet toAdd) {
        if (!q.inequalityRelation.isEmpty()) {
            this.saveRareCond(p.updateIR(q, toAdd));
        }
    }

    @PortedFrom(file="dlCompletionGraph.h", name="initIR")
    public void initIR() {
        ++this.irLevel;
    }

    @PortedFrom(file="dlCompletionGraph.h", name="setCurIR")
    public boolean setCurIR(DlCompletionTree node, DepSet ds) {
        return node.initIR(this.irLevel, ds);
    }

    @PortedFrom(file="dlCompletionGraph.h", name="finiIR")
    public void finiIR() {
    }

    @PortedFrom(file="dlCompletionGraph.h", name="createEdge")
    private DlCompletionTreeArc createEdge(DlCompletionTree from, DlCompletionTree to, boolean isPredEdge, Role roleName, DepSet dep) {
        DlCompletionTreeArc forward = new DlCompletionTreeArc(roleName, dep, to);
        this.ctEdgeHeap.add(forward);
        forward.setSuccEdge(!isPredEdge);
        DlCompletionTreeArc backward = new DlCompletionTreeArc(roleName.inverse(), dep, from);
        this.ctEdgeHeap.add(backward);
        backward.setSuccEdge(isPredEdge);
        forward.setReverse(backward);
        this.saveNode(from, this.branchingLevel);
        this.saveNode(to, this.branchingLevel);
        from.addNeighbour(forward);
        to.addNeighbour(backward);
        if (this.pReasoner.getOptions().isLoggingActive()) {
            this.pReasoner.getOptions().getLog().printTemplate(Templates.CREATE_EDGE, Integer.toString(isPredEdge ? to.getId() : from.getId()), isPredEdge ? "<-" : "->", Integer.toString(isPredEdge ? from.getId() : to.getId()), roleName.getIRI());
        }
        return forward;
    }

    @Nullable
    @PortedFrom(file="dlCompletionGraph.h", name="moveEdge")
    private DlCompletionTreeArc moveEdge(DlCompletionTree node, DlCompletionTreeArc edge, boolean isPredEdge, DepSet dep) {
        Optional<DlCompletionTreeArc> findAny;
        if (edge.isIBlocked()) {
            return null;
        }
        if (!isPredEdge && !edge.getArcEnd().isNominalNode()) {
            return null;
        }
        Role r = edge.getRole();
        if (edge.isReflexiveEdge()) {
            return this.createLoop(node, r, dep);
        }
        DlCompletionTree to = edge.getArcEnd();
        if (r != null) {
            this.invalidateEdge(edge);
        }
        if ((findAny = node.getNeighbour().stream().filter(p -> p.getArcEnd() == to && p.isPredEdge() != isPredEdge).findAny()).isPresent()) {
            return this.addRoleLabel(node, to, !isPredEdge, r, dep);
        }
        return this.addRoleLabel(node, to, isPredEdge, r, dep);
    }

    @PortedFrom(file="dlCompletionGraph.h", name="merge")
    public void merge(DlCompletionTree from, DlCompletionTree to, DepSet dep, List<DlCompletionTreeArc> edges) {
        edges.clear();
        from.getNeighbour().forEach(p -> {
            DlCompletionTreeArc temp;
            if ((p.isPredEdge() || p.getArcEnd().isNominalNode()) && (temp = this.moveEdge(to, (DlCompletionTreeArc)p, p.isPredEdge(), dep)) != null) {
                edges.add(temp);
            }
            if (p.isSuccEdge()) {
                this.purgeEdge((DlCompletionTreeArc)p, to, dep);
            }
        });
        this.updateIR(to, from, dep);
        this.purgeNode(from, to, dep);
    }

    @PortedFrom(file="dlCompletionGraph.h", name="purgeNode")
    private void purgeNode(DlCompletionTree p, DlCompletionTree root, DepSet dep) {
        if (p.isPBlocked()) {
            return;
        }
        this.saveRareCond(p.setPBlocked(root, dep));
        p.getNeighbour().stream().filter(q -> q.isSuccEdge() && !q.isIBlocked()).forEach(q -> this.purgeEdge((DlCompletionTreeArc)q, root, dep));
    }

    @PortedFrom(file="dlCompletionGraph.h", name="purgeEdge")
    private void purgeEdge(DlCompletionTreeArc e, DlCompletionTree root, DepSet dep) {
        if (e.getRole() != null) {
            this.invalidateEdge(e);
        }
        if (e.getArcEnd().isBlockableNode()) {
            this.purgeNode(e.getArcEnd(), root, dep);
        }
    }

    @PortedFrom(file="dlCompletionGraph.h", name="save")
    public void save() {
        DLCompletionGraphSaveState s = new DLCompletionGraphSaveState();
        this.stack.push(s);
        s.setnNodes(this.endUsed);
        s.setsNodes(this.savedNodes.size());
        s.setnEdges(this.ctEdgeHeap.size());
        this.rareStack.incLevel();
        ++this.branchingLevel;
    }

    @PortedFrom(file="dlCompletionGraph.h", name="restore")
    public void restore(int level) {
        assert (level > 0);
        this.branchingLevel = level;
        this.rareStack.restore(level);
        DLCompletionGraphSaveState s = this.stack.pop(level);
        this.endUsed = s.getnNodes();
        int nSaved = s.getsNodes();
        if (this.endUsed < Math.abs(this.savedNodes.size() - nSaved)) {
            this.nodeBase.stream().limit(this.endUsed).forEach(p -> this.restoreNode((DlCompletionTree)p, level));
        } else {
            for (int i = nSaved; i < this.savedNodes.size(); ++i) {
                if (this.savedNodes.get(i).getId() >= this.endUsed) continue;
                this.restoreNode(this.savedNodes.get(i), level);
            }
        }
        Helper.resize(this.savedNodes, nSaved);
        Helper.resize(this.ctEdgeHeap, s.getnEdges());
    }

    @PortedFrom(file="dlCompletionGraph.h", name="print")
    public void print(LogAdapter o) {
        int i;
        this.cgpIndent = 0;
        this.cgpFlag.clear();
        List<DlCompletionTree> l = this.nodeBase;
        for (i = 1; i < this.endUsed && l.get(i).isNominalNode(); ++i) {
            this.cgpFlag.add(i);
        }
        this.printNode(l.get(0), o);
        for (i = 1; i < this.endUsed && l.get(i).isNominalNode(); ++i) {
            this.cgpFlag.remove(l.get(i).getId());
            this.printNode(l.get(i), o);
        }
        o.print("\n");
    }

    @PortedFrom(file="dlCompletionGraph.h", name="PrintEdge")
    private void printEdge(List<DlCompletionTreeArc> l, int pos, DlCompletionTreeArc edge, DlCompletionTree parent, LogAdapter o) {
        DlCompletionTreeArc arc = edge;
        DlCompletionTree node = arc.getArcEnd();
        boolean succEdge = arc.isSuccEdge();
        this.printIndent(o);
        if (arc.getArcEnd().equals(node) && arc.isSuccEdge() == succEdge) {
            o.print(" ");
            arc.print(o);
        }
        while (pos < l.size()) {
            arc = l.get(pos);
            if (arc.getArcEnd().equals(node) && arc.isSuccEdge() == succEdge) {
                o.print(" ");
                arc.print(o);
            }
            ++pos;
        }
        if (node.equals(parent)) {
            this.printIndent(o);
            o.print("-loop to node ");
            o.print(parent.getId());
        } else {
            this.printNode(node, o);
        }
    }

    @PortedFrom(file="dlCompletionGraph.h", name="PrintNode")
    private void printNode(DlCompletionTree node, LogAdapter o) {
        if (this.cgpIndent > 0) {
            this.printIndent(o);
            o.print("-");
        } else {
            o.print("\n");
        }
        node.printBody(o);
        if (this.cgpFlag.contains(node.getId())) {
            o.print("d");
            return;
        }
        this.cgpFlag.add(node.getId());
        boolean wantPred = node.isNominalNode();
        ++this.cgpIndent;
        node.getNeighbour().stream().filter(p -> p.isSuccEdge() || wantPred && p.getArcEnd().isNominalNode()).forEach(p -> this.printEdge(node.getNeighbour(), node.getNeighbour().indexOf(p), (DlCompletionTreeArc)p, node, o));
        --this.cgpIndent;
    }
}

