/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.chainsaw.FastSet;
import uk.ac.manchester.cs.chainsaw.FastSetFactory;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeFactory;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.LogicFeatures;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.Token;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptName;

@PortedFrom(file="ConceptWithDep.h", name="Concept")
public class Concept
extends ClassifiableEntry {
    public static final IRI temp = IRI.create((String)"urn:jfact#", (String)"temp");
    public static final IRI query = IRI.create((String)"FaCT++.default");
    public static final IRI nothing = OWLRDFVocabulary.OWL_NOTHING.getIRI();
    public static final IRI thing = OWLRDFVocabulary.OWL_THING.getIRI();
    @PortedFrom(file="tConcept.h", name="rel")
    private long rel = 0L;
    @PortedFrom(file="tConcept.h", name="classTag")
    private CTTag classTag;
    @PortedFrom(file="tConcept.h", name="tsDepth")
    private int tsDepth = 0;
    @PortedFrom(file="tConcept.h", name="pName")
    private int pName = 0;
    @PortedFrom(file="tConcept.h", name="pBody")
    private int pBody = 0;
    @PortedFrom(file="tConcept.h", name="posFeatures")
    private final LogicFeatures posFeatures = new LogicFeatures();
    @PortedFrom(file="tConcept.h", name="negFeatures")
    private final LogicFeatures negFeatures = new LogicFeatures();
    @PortedFrom(file="tConcept.h", name="erSet")
    private final FastSet extraRules = FastSetFactory.create();
    @PortedFrom(file="tConcept.h", name="Description")
    protected DLTree description;
    @Original
    private static final EnumSet<Token> replacements = EnumSet.of(Token.CNAME, Token.INAME, Token.RNAME, Token.DNAME);
    @Original
    private boolean primitive;
    @Original
    private boolean hasSP;
    @Original
    private boolean nominal;
    @Original
    private boolean singleton;

    public Concept(IRI name) {
        super(name);
        this.classTag = CTTag.UNSPECIFIED;
        this.setPrimitive(true);
    }

    @PortedFrom(file="tConcept.h", name="addToldSubsumer")
    private boolean addToldSubsumer(Concept concept) {
        if (concept != this) {
            this.addParentIfNew(concept);
            if (concept.isSingleton() || concept.isHasSP()) {
                this.setHasSP(true);
            }
        }
        return concept.isPrimitive();
    }

    @Original
    public static Concept getBOTTOM(OWLDataFactory df) {
        Concept toReturn = new Concept(nothing);
        toReturn.setBottom();
        toReturn.setId(-1);
        toReturn.setpName(-1);
        toReturn.setpBody(-1);
        toReturn.setEntity(new ConceptName((OWLEntity)df.getOWLNothing()));
        return toReturn;
    }

    @Original
    public static Concept getTOP(OWLDataFactory df) {
        Concept toReturn = new Concept(thing);
        toReturn.setTop();
        toReturn.setId(-1);
        toReturn.setpName(1);
        toReturn.setpBody(1);
        toReturn.setTsDepth(1);
        toReturn.setClassTag(CTTag.COMPLETELYDEFINED);
        toReturn.setEntity(new ConceptName((OWLEntity)df.getOWLThing()));
        return toReturn;
    }

    @Original
    public static Concept getTEMP() {
        Concept temporary = new Concept(temp);
        temporary.setId(-1);
        temporary.setTsDepth(1);
        temporary.setClassTag(CTTag.COMPLETELYDEFINED);
        return temporary;
    }

    public static Concept getQuery() {
        Concept p = new Concept(query);
        p.setSystem();
        return p;
    }

    @PortedFrom(file="tConcept.h", name="addExtraRule")
    public void addExtraRule(int ruleIndex) {
        this.extraRules.add(ruleIndex);
        this.setCompletelyDefined(false);
    }

    @PortedFrom(file="tConcept.h", name="hasExtraRules")
    public boolean hasExtraRules() {
        return !this.extraRules.isEmpty();
    }

    @PortedFrom(file="tConcept.h", name="er_begin")
    public FastSet getExtraRules() {
        return this.extraRules;
    }

    @Original
    public CTTag getClassTagPlain() {
        return this.classTag;
    }

    @PortedFrom(file="tConcept.h", name="getClassTag")
    public CTTag getClassTag() {
        if (this.classTag == CTTag.UNSPECIFIED) {
            this.classTag = this.determineClassTag();
        }
        return this.classTag;
    }

    @PortedFrom(file="tConcept.h", name="removeSelfFromDescription")
    public void removeSelfFromDescription() {
        if (this.hasSelfInDesc()) {
            this.description = this.replaceWithConstOld(this.description);
        }
        this.initToldSubsumers();
    }

    @PortedFrom(file="tConcept.h", name="removeDescription")
    public void removeDescription() {
        this.description = null;
    }

    @PortedFrom(file="tConcept.h", name="canInitNonPrim")
    public boolean canInitNonPrim(DLTree desc) {
        if (this.description == null) {
            return true;
        }
        return this.description.equals(desc);
    }

    @PortedFrom(file="tConcept.h", name="makeNonPrimitive")
    public DLTree makeNonPrimitive(DLTree desc) {
        DLTree ret = this.description;
        this.removeDescription();
        this.addDesc(desc);
        this.setPrimitive(false);
        return ret;
    }

    @Override
    public String toString() {
        return this.extName.toString();
    }

    @PortedFrom(file="tConcept.h", name="initToldSubsumers")
    public void initToldSubsumers() {
        boolean cd;
        this.toldSubsumers.clear();
        this.setHasSP(false);
        if (this.isPrimitive() && this.description != null && this.description.isTOP()) {
            this.removeDescription();
        }
        boolean bl = cd = !this.hasExtraRules() && this.isPrimitive();
        if (this.description != null) {
            cd &= this.initToldSubsumers(this.description, new HashSet<Role>());
        }
        this.setCompletelyDefined(cd);
    }

    @PortedFrom(file="tConcept.h", name="setToldTop")
    public void setToldTop(Concept top) {
        if (this.description == null && !this.hasToldSubsumers()) {
            this.addParent(top);
        }
    }

    @PortedFrom(file="tConcept.h", name="resolveId")
    public int resolveId() {
        if (this.pName == 0) {
            return this.pBody;
        }
        if (this.isSynonym()) {
            return Concept.resolveSynonym(this).resolveId();
        }
        return this.pName;
    }

    @PortedFrom(file="tConcept.h", name="addDesc")
    public void addDesc(@Nullable DLTree desc) {
        if (desc == null) {
            return;
        }
        if (this.description == null) {
            this.description = desc.copy();
            return;
        }
        if (desc.isAND()) {
            if (this.description.isAND()) {
                this.description.addFirstChildren(desc.getChildren());
            } else {
                DLTree t = this.description;
                this.description = desc.copy();
                this.description.addChild(t);
            }
        } else if (this.description.isAND()) {
            this.description.addFirstChild(desc);
        } else {
            this.description = DLTreeFactory.createSNFAnd(desc, this.description);
        }
    }

    @Original
    public void addLeaves(Collection<DLTree> desc) {
        if (this.description == null) {
            this.description = DLTreeFactory.createSNFAnd(desc);
        } else if (this.description.isAND()) {
            desc.forEach(this.description::addChild);
        } else {
            ArrayList<DLTree> l = new ArrayList<DLTree>(desc);
            l.add(this.description);
            this.description = DLTreeFactory.createSNFAnd(l);
        }
    }

    @PortedFrom(file="tConcept.h", name="determineClassTag")
    private CTTag determineClassTag() {
        if (this.isSynonym()) {
            return Concept.resolveSynonym(this).getClassTag();
        }
        if (!this.isPrimitive()) {
            return CTTag.NONPRIMITIVE;
        }
        if (!this.hasToldSubsumers()) {
            return CTTag.ORPHAN;
        }
        boolean hasLCD = false;
        boolean hasOther = false;
        boolean hasNP = false;
        block6: for (ClassifiableEntry p : this.toldSubsumers) {
            switch (((Concept)p).getClassTag()) {
                case COMPLETELYDEFINED: {
                    continue block6;
                }
                case ORPHAN: 
                case LIKECOMPLETELYDEFINED: {
                    hasLCD = true;
                    continue block6;
                }
                case REGULAR: {
                    hasOther = true;
                    continue block6;
                }
                case HASNONPRIMITIVETS: 
                case NONPRIMITIVE: {
                    hasNP = true;
                    continue block6;
                }
            }
            throw new UnreachableSituationException();
        }
        if (hasNP) {
            return CTTag.HASNONPRIMITIVETS;
        }
        if (hasOther || !this.isCompletelyDefined()) {
            return CTTag.REGULAR;
        }
        if (hasLCD) {
            return CTTag.LIKECOMPLETELYDEFINED;
        }
        return CTTag.COMPLETELYDEFINED;
    }

    @Original
    public void push(Deque<DLTree> stack, DLTree current) {
        current.getChildren().stream().filter(p -> p != null).forEach(stack::push);
    }

    @Nullable
    @PortedFrom(file="tConcept.h", name="replaceSelfWithConst")
    private DLTree replaceWithConstOld(@Nullable DLTree t) {
        if (t == null) {
            return null;
        }
        Token token = t.token();
        if (replacements.contains((Object)token) && Concept.resolveSynonym((ClassifiableEntry)t.elem().getNE()).equals(this)) {
            return DLTreeFactory.createTop();
        }
        if (token == Token.AND) {
            return DLTreeFactory.createSNFAnd(OWLAPIStreamUtils.asList(t.getChildren().stream().map(this::replaceWithConstOld)), t);
        }
        if (token == Token.NOT && (t.getChild().isAND() || replacements.contains((Object)t.getChild().token()))) {
            return DLTreeFactory.createSNFNot(this.replaceWithConstOld(t.getChild()));
        }
        return t;
    }

    @PortedFrom(file="tConcept.h", name="hasSelfInDesc")
    private boolean hasSelfInDesc(@Nullable DLTree t) {
        if (t == null) {
            return false;
        }
        Token token = t.token();
        if (replacements.contains((Object)token)) {
            return Concept.resolveSynonym((ClassifiableEntry)t.elem().getNE()).equals(this);
        }
        if (token == Token.AND) {
            return t.getChildren().stream().anyMatch(this::hasSelfInDesc);
        }
        if (token == Token.NOT && (t.getChild().isAND() || replacements.contains((Object)t.getChild().token()))) {
            return this.hasSelfInDesc(t.getChild());
        }
        return false;
    }

    @PortedFrom(file="tConcept.h", name="initToldSubsumers")
    public boolean initToldSubsumers(@Nullable DLTree desc, Set<Role> rolesProcessed) {
        if (desc == null || desc.isTOP()) {
            return true;
        }
        DLTree tree = desc;
        Token token = tree.token();
        if (replacements.contains((Object)token)) {
            return this.addToldSubsumer((Concept)tree.elem().getNE());
        }
        if (token == Token.NOT) {
            if (tree.getChild().token() == Token.FORALL || tree.getChild().token() == Token.LE) {
                this.searchTSbyRoleAndSupers(Role.resolveRole(tree.getChild().getLeft()), rolesProcessed);
            }
            return false;
        }
        if (token == Token.SELF) {
            Role r = Role.resolveRole(tree.getChild());
            this.searchTSbyRoleAndSupers(r, rolesProcessed);
            this.searchTSbyRoleAndSupers(r.inverse(), rolesProcessed);
            return false;
        }
        if (token == Token.AND) {
            AtomicBoolean b = new AtomicBoolean(true);
            tree.getChildren().stream().map(t -> this.initToldSubsumers((DLTree)t, rolesProcessed)).forEach(x -> b.compareAndSet(true, (boolean)x));
            return b.get();
        }
        return false;
    }

    @PortedFrom(file="tConcept.h", name="SearchTSbyRole")
    private void searchTSbyRole(Role r, Set<Role> rolesProcessed) {
        if (rolesProcessed.contains(r)) {
            return;
        }
        DLTree domain = r.getTDomain();
        if (domain == null || domain.isConst()) {
            return;
        }
        rolesProcessed.add(r);
        this.initToldSubsumers(domain, rolesProcessed);
    }

    @PortedFrom(file="tConcept.h", name="SearchTSbyRoleAndSupers")
    public void searchTSbyRoleAndSupers(Role r, Set<Role> rolesProcessed) {
        this.searchTSbyRole(r, rolesProcessed);
        r.getAncestor().forEach(q -> this.searchTSbyRole((Role)q, rolesProcessed));
    }

    @PortedFrom(file="tConcept.h", name="calculateTSDepth")
    public int calculateTSDepth() {
        if (this.tsDepth > 0) {
            return this.tsDepth;
        }
        this.tsDepth = this.toldSubsumers.stream().mapToInt(p -> ((Concept)p).calculateTSDepth()).max().orElse(1);
        return this.tsDepth;
    }

    @PortedFrom(file="tConcept.h", name="clear")
    public void clear() {
        this.setId(0);
        this.taxVertex = null;
        this.toldSubsumers.clear();
        this.setCompletelyDefined(false);
        this.pSynonym = null;
        this.removeDescription();
        this.setPrimitive(true);
        this.pBody = 0;
        this.pName = 0;
    }

    @PortedFrom(file="tConcept.h", name="hasSelfInDesc")
    boolean hasSelfInDesc() {
        return this.hasSelfInDesc(this.description);
    }

    @Original
    public int getpName() {
        return this.pName;
    }

    @Original
    public void setpName(int pName) {
        this.pName = pName;
    }

    @Original
    public int getpBody() {
        return this.pBody;
    }

    @Original
    public void setpBody(int pBody) {
        this.pBody = pBody;
    }

    @Nullable
    @Original
    public DLTree getDescription() {
        return this.description;
    }

    @Original
    public int getTsDepth() {
        return this.tsDepth;
    }

    @Original
    private void setTsDepth(int tsDepth) {
        this.tsDepth = tsDepth;
    }

    @Original
    public LogicFeatures getNegFeatures() {
        return this.negFeatures;
    }

    @Original
    public LogicFeatures getPosFeatures() {
        return this.posFeatures;
    }

    @Original
    @PortedFrom(file="tConcept.h", name="classTag")
    private void setClassTag(CTTag classTag) {
        this.classTag = classTag;
    }

    @Original
    public boolean isPrimitive() {
        return this.primitive;
    }

    @Original
    public boolean isNonPrimitive() {
        return !this.isPrimitive();
    }

    @Original
    public void setPrimitive(boolean action) {
        this.primitive = action;
    }

    @Original
    public boolean isHasSP() {
        return this.hasSP;
    }

    @Original
    public void setHasSP(boolean action) {
        this.hasSP = action;
    }

    @Original
    public boolean isNominal() {
        return this.nominal;
    }

    @Original
    public void setNominal(boolean action) {
        this.nominal = action;
    }

    @Original
    public boolean isSingleton() {
        return this.singleton;
    }

    @Original
    public void setSingleton(boolean action) {
        this.singleton = action;
    }

    @PortedFrom(file="tConcept.h", name="isRelevant")
    public boolean isRelevant(long lab) {
        return lab == this.rel;
    }

    @PortedFrom(file="tConcept.h", name="setRelevant")
    public void setRelevant(long lab) {
        this.rel = lab;
    }

    @PortedFrom(file="tConcept.h", name="dropRelevant")
    public void dropRelevant() {
        this.rel = 0L;
    }

    public static enum CTTag {
        UNSPECIFIED('u'),
        COMPLETELYDEFINED('T'),
        ORPHAN('O'),
        LIKECOMPLETELYDEFINED('L'),
        HASNONPRIMITIVETS('N'),
        REGULAR('r'),
        NONPRIMITIVE('n');

        private final char c;

        private CTTag(char c) {
            this.c = c;
        }

        protected char getCTTagName() {
            return this.c;
        }
    }
}

