/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.TaxonomyVertex;

@PortedFrom(file="taxNamEntry.h", name="ClassifiableEntry")
public class ClassifiableEntry
extends NamedEntry {
    @PortedFrom(file="taxNamEntry.h", name="taxVertex")
    protected TaxonomyVertex taxVertex = null;
    @PortedFrom(file="taxNamEntry.h", name="toldSubsumers")
    protected final Set<ClassifiableEntry> toldSubsumers = new LinkedHashSet<ClassifiableEntry>();
    @PortedFrom(file="taxNamEntry.h", name="pSynonym")
    protected ClassifiableEntry pSynonym = null;
    @PortedFrom(file="taxNamEntry.h", name="Index")
    protected int index = 0;
    @Original
    private boolean completelyDefined;
    @Original
    private boolean nonClassifiable;

    protected ClassifiableEntry(IRI name) {
        super(name);
    }

    @PortedFrom(file="taxNamEntry.h", name="isClassified")
    public boolean isClassified() {
        return this.taxVertex != null;
    }

    @PortedFrom(file="taxNamEntry.h", name="setTaxVertex")
    public void setTaxVertex(TaxonomyVertex vertex) {
        this.taxVertex = vertex;
    }

    @Nullable
    @PortedFrom(file="taxNamEntry.h", name="getTaxVertex")
    public TaxonomyVertex getTaxVertex() {
        return this.taxVertex;
    }

    @Original
    public boolean isCompletelyDefined() {
        return this.completelyDefined;
    }

    @Original
    public void setCompletelyDefined(boolean action) {
        this.completelyDefined = action;
    }

    @Original
    public boolean isNonClassifiable() {
        return this.nonClassifiable;
    }

    @Original
    public void setNonClassifiable(boolean action) {
        this.nonClassifiable = action;
    }

    @PortedFrom(file="taxNamEntry.h", name="told_begin")
    public Collection<ClassifiableEntry> getToldSubsumers() {
        return this.toldSubsumers;
    }

    @PortedFrom(file="taxNamEntry.h", name="hasToldSubsumers")
    public boolean hasToldSubsumers() {
        return !this.toldSubsumers.isEmpty();
    }

    @PortedFrom(file="taxNamEntry.h", name="addParent")
    public void addParent(ClassifiableEntry parent) {
        if (parent != this) {
            this.toldSubsumers.add(parent);
        }
    }

    @PortedFrom(file="taxNamEntry.h", name="addParents")
    public void addParents(Collection<ClassifiableEntry> entries) {
        entries.forEach(this::addParentIfNew);
    }

    @Override
    @PortedFrom(file="taxNamEntry.h", name="getIndex")
    public int getIndex() {
        return this.index;
    }

    @Override
    @PortedFrom(file="taxNamEntry.h", name="setIndex")
    public void setIndex(int ind) {
        this.index = ind;
    }

    @PortedFrom(file="taxNamEntry.h", name="isSynonym")
    public boolean isSynonym() {
        return this.pSynonym != null;
    }

    @PortedFrom(file="taxNamEntry.h", name="getSynonym")
    public ClassifiableEntry getSynonym() {
        return this.pSynonym;
    }

    @PortedFrom(file="taxNamEntry.h", name="canonicaliseSynonym")
    public void canonicaliseSynonym() {
        assert (this.isSynonym());
        this.pSynonym = ClassifiableEntry.resolveSynonym(this.pSynonym);
    }

    @PortedFrom(file="taxNamEntry.h", name="setSynonym")
    public void setSynonym(@Nullable ClassifiableEntry syn) {
        assert (this.pSynonym == null);
        HashSet<ClassifiableEntry> set = new HashSet<ClassifiableEntry>();
        set.add(this);
        ClassifiableEntry runner = syn;
        while (runner.isSynonym() && !set.contains(runner.pSynonym)) {
            set.add(runner.pSynonym);
            runner = runner.pSynonym;
        }
        if (!set.contains(runner.pSynonym)) {
            this.pSynonym = syn;
            this.canonicaliseSynonym();
        }
    }

    @PortedFrom(file="taxNamEntry.h", name="removeSynonymsFromParents")
    public void removeSynonymsFromParents() {
        List toKeep = OWLAPIStreamUtils.asList(this.toldSubsumers.stream().map(ClassifiableEntry::resolveSynonym).filter(p -> this != p));
        this.toldSubsumers.clear();
        this.toldSubsumers.addAll(toKeep);
    }

    @PortedFrom(file="taxNamEntry.h", name="resolveSynonym")
    public static <T extends ClassifiableEntry> T resolveSynonym(T p) {
        if (p.isSynonym()) {
            return (T)ClassifiableEntry.resolveSynonym(p.pSynonym);
        }
        return p;
    }

    @PortedFrom(file="taxNamEntry.h", name="addParentIfNew")
    public void addParentIfNew(ClassifiableEntry parent) {
        this.addParent(ClassifiableEntry.resolveSynonym(parent));
    }
}

