/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeFactory;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.kernel.AbsorptionActions;
import uk.ac.manchester.cs.jfact.kernel.Axiom;
import uk.ac.manchester.cs.jfact.kernel.TBox;

@PortedFrom(file="tAxiomSet.h", name="TAxiomSet")
public class AxiomSet
implements Serializable {
    private static final String POSSIBILITIES = " possibilities";
    @PortedFrom(file="tAxiomSet.h", name="Host")
    @Nonnull
    protected final TBox tboxHost;
    @PortedFrom(file="tAxiomSet.h", name="Accum")
    private List<Axiom> accumulator = new ArrayList<Axiom>();
    private final LogAdapter absorptionLog;
    @PortedFrom(file="tAxiomSet.h", name="ActionVector")
    private final List<AbsorptionActions> actions = new ArrayList<AbsorptionActions>();
    @PortedFrom(file="tAxiomSet.h", name="curAxiom")
    private int curAxiom = 0;

    public AxiomSet(TBox host) {
        this.tboxHost = host;
        this.absorptionLog = this.tboxHost.getOptions().getAbsorptionLog();
        Axiom.setLogAdapter(this.absorptionLog);
    }

    @PortedFrom(file="tAxiomSet.h", name="insertGCI")
    private void insertGCI(Axiom p) {
        this.tboxHost.getOptions().getAbsorptionLog().print("\n new axiom (").print(this.accumulator.size()).print((Object)"):", (Object)p);
        this.accumulator.add(p);
    }

    @PortedFrom(file="tAxiomSet.h", name="copyOf")
    boolean copyOfExisting(Axiom q) {
        int i = this.accumulator.indexOf(q);
        if (i > -1) {
            this.absorptionLog.print(" same as (").print(i).print(")");
            return true;
        }
        return false;
    }

    @PortedFrom(file="tAxiomSet.h", name="processNewAxiom")
    protected boolean processNewAxiom(@Nullable Axiom q) {
        if (q == null) {
            return false;
        }
        if (q.isCyclic()) {
            return false;
        }
        if (this.copyOfExisting(q)) {
            return true;
        }
        this.insertGCI(q);
        return true;
    }

    @PortedFrom(file="tAxiomSet.h", name="addAxiom")
    public void addAxiom(DLTree c, DLTree d) {
        this.tboxHost.getStatistics().sAbsInput();
        Axiom p = new Axiom(null);
        p.add(c);
        p.add(DLTreeFactory.createSNFNot(d));
        this.insertGCI(p);
    }

    @PortedFrom(file="tAxiomSet.h", name="size")
    private int size() {
        return this.accumulator.size();
    }

    @PortedFrom(file="tAxiomSet.h", name="wasRoleAbsorptionApplied")
    public boolean wasRoleAbsorptionApplied() {
        return this.tboxHost.getStatistics().containsSAbsRApply();
    }

    @PortedFrom(file="tAxiomSet.h", name="getGCI")
    public DLTree getGCI() {
        List l = OWLAPIStreamUtils.asList(this.accumulator.stream().map(p -> p.createAnAxiom(null)));
        return DLTreeFactory.createSNFAnd(l);
    }

    @PortedFrom(file="tAxiomSet.h", name="split")
    protected boolean split(Axiom p, TBox tbox) {
        List<Axiom> splitted = p.split(tbox);
        if (splitted.isEmpty()) {
            return false;
        }
        ArrayList<Axiom> kept = new ArrayList<Axiom>();
        for (Axiom q : splitted) {
            if (q.isCyclic()) {
                return false;
            }
            if (this.copyOfExisting(q)) continue;
            kept.add(q);
        }
        kept.forEach(this::insertGCI);
        return true;
    }

    @PortedFrom(file="tAxiomSet.h", name="absorb")
    public int absorb() {
        ArrayList<Axiom> gcis = new ArrayList<Axiom>();
        this.curAxiom = 0;
        while (this.curAxiom < this.accumulator.size()) {
            Axiom ax = this.accumulator.get(this.curAxiom);
            this.tboxHost.getOptions().getAbsorptionLog().print("\nProcessing (").print(this.curAxiom).print("):");
            if (!this.absorbGCI(ax)) {
                gcis.add(ax);
            }
            ++this.curAxiom;
        }
        this.accumulator = gcis;
        if (this.tboxHost.getOptions().isAbsorptionLoggingActive()) {
            this.tboxHost.getOptions().getAbsorptionLog().print("\nAbsorption done with ").print(this.accumulator.size()).print(" GCIs left\n");
            this.printStatistics();
        }
        return this.size();
    }

    @PortedFrom(file="tAxiomSet.h", name="absorbGCI")
    private boolean absorbGCI(Axiom p) {
        this.tboxHost.getStatistics().sAbsAction();
        boolean absorbed = this.actions.stream().anyMatch(abs -> abs.execute(p, this));
        if (!absorbed) {
            this.tboxHost.getOptions().getAbsorptionLog().print(" keep as GCI");
        }
        return absorbed;
    }

    @PortedFrom(file="tAxiomSet.h", name="initAbsorptionFlags")
    public boolean initAbsorptionFlags(String flags) {
        this.actions.clear();
        for (char c : flags.toCharArray()) {
            this.actions.add(AbsorptionActions.get(c));
        }
        this.tboxHost.getOptions().getAbsorptionLog().print("Init absorption order as ").print(flags).print("\n");
        return false;
    }

    @PortedFrom(file="tAxiomSet.h", name="PrintStatistics")
    private void printStatistics() {
        if (!this.tboxHost.getStatistics().containsSAbsAction()) {
            return;
        }
        LogAdapter log = this.tboxHost.getOptions().getAbsorptionLog();
        log.print("\nAbsorption dealt with ").print(this.tboxHost.getStatistics().getSAbsInput()).print(" input axioms\nThere were made ").print(this.tboxHost.getStatistics().getSAbsAction()).print(" absorption actions, of which:");
        if (this.tboxHost.getStatistics().containsSAbsRepCN()) {
            log.print("\n\t").print(this.tboxHost.getStatistics().getSAbsRepCN()).print(" concept name replacements");
        }
        if (this.tboxHost.getStatistics().containsSAbsRepForall()) {
            log.print("\n\t").print(this.tboxHost.getStatistics().getSAbsRepForall()).print(" universals replacements");
        }
        if (this.tboxHost.getStatistics().containsSAbsSplit()) {
            log.print("\n\t").print(this.tboxHost.getStatistics().getSAbsSplit()).print(" conjunction splits");
        }
        if (this.tboxHost.getStatistics().containsSAbsBApply()) {
            log.print("\n\t").print(this.tboxHost.getStatistics().getSAbsBApply()).print(" BOTTOM absorptions");
        }
        if (this.tboxHost.getStatistics().containsSAbsTApply()) {
            log.print("\n\t").print(this.tboxHost.getStatistics().getSAbsTApply()).print(" TOP absorptions");
        }
        if (this.tboxHost.getStatistics().containsSAbsCApply()) {
            log.print("\n\t").print(this.tboxHost.getStatistics().getSAbsCApply()).print(" concept absorption with ").print(this.tboxHost.getStatistics().getSAbsCAttempt()).print(POSSIBILITIES);
        }
        if (this.tboxHost.getStatistics().containsSAbsNApply()) {
            log.print("\n\t").print(this.tboxHost.getStatistics().getSAbsNApply()).print(" negated concept absorption with ").print(this.tboxHost.getStatistics().getSAbsNAttempt()).print(POSSIBILITIES);
        }
        if (this.tboxHost.getStatistics().containsSAbsRApply()) {
            log.print("\n\t").print(this.tboxHost.getStatistics().getSAbsRApply()).print(" role domain absorption with ").print(this.tboxHost.getStatistics().getSAbsRAttempt()).print(POSSIBILITIES);
        }
        if (!this.accumulator.isEmpty()) {
            log.print("\nThere are ").print(this.accumulator.size()).print(" GCIs left");
        }
    }
}

