/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapitools.decomposition.OntologyAtom;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.DLTreeFactory;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.InAx;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.TBox;
import uk.ac.manchester.cs.jfact.kernel.Token;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;

@PortedFrom(file="tAxiom.h", name="TAxiom")
public class Axiom
implements Serializable {
    private static final String AND = ") and";
    private static final String ABSORB_INTO_BOTTOM = " Absorb into BOTTOM due to (not";
    private static LogAdapter absorptionLog;
    private Axiom origin;
    @PortedFrom(file="tAxiom.h", name="Disjuncts")
    private final Set<DLTree> disjuncts = new LinkedHashSet<DLTree>();
    @Original
    private OntologyAtom atom;

    public Axiom(@Nullable Axiom parent) {
        this.origin = parent;
    }

    public static void setLogAdapter(LogAdapter l) {
        absorptionLog = l;
    }

    @PortedFrom(file="tAxiom.h", name="absorbIntoNegConcept")
    public boolean absorbIntoNegConcept(TBox tbox) {
        List cons = OWLAPIStreamUtils.asList(this.disjuncts.stream().filter(this::primitiveNegatedConceptNamesWithoutDescription).peek(p -> tbox.getStatistics().sAbsNAttempt()));
        if (cons.isEmpty()) {
            return false;
        }
        tbox.getStatistics().sAbsNApply();
        DLTree bestConcept = (DLTree)cons.get(0);
        Concept concept = InAx.getConcept(bestConcept.getChild());
        JFactReasonerConfiguration options = tbox.getOptions();
        this.logOptions(" N-Absorb GCI to concept ", cons, concept.getIRI(), options);
        Concept nC = tbox.getAuxConcept(this.createAnAxiom(bestConcept));
        tbox.makeNonPrimitive(concept, DLTreeFactory.createSNFNot(tbox.getTree(nC)));
        return true;
    }

    protected boolean primitiveNegatedConceptNamesWithoutDescription(DLTree p) {
        boolean b;
        boolean bl = b = p.token() == Token.NOT && p.getChild().isName();
        if (!b) {
            return b;
        }
        Concept concept = InAx.getConcept(p.getChild());
        return concept.isPrimitive() && !concept.isSingleton() && concept.getDescription() == null;
    }

    @PortedFrom(file="tAxiom.h", name="copy")
    private Axiom copy(DLTree skip) {
        Axiom ret = new Axiom(this);
        this.disjuncts.stream().filter(i -> !i.equals(skip)).forEach(i -> ret.disjuncts.add(i.copy()));
        return ret;
    }

    @PortedFrom(file="tAxiom.h", name="isCyclic")
    boolean isCyclic() {
        Axiom p = this.origin;
        while (p != null) {
            if (p.equals(this)) {
                absorptionLog.print(" same as ancestor");
                return true;
            }
            p = p.origin;
        }
        return false;
    }

    @PortedFrom(file="tAxiom.h", name="simplifyPosNP")
    private Axiom simplifyPosNP(DLTree pos, TBox tbox) {
        tbox.getStatistics().sAbsRepCN();
        Axiom ret = this.copy(pos);
        ret.add(DLTreeFactory.createSNFNot(InAx.getConcept(pos.getChild()).getDescription().copy()));
        absorptionLog.print((Object)" simplify CN expression for ", (Object)pos.getChild());
        return ret;
    }

    @PortedFrom(file="tAxiom.h", name="simplifyNegNP")
    private Axiom simplifyNegNP(DLTree pos, TBox tbox) {
        tbox.getStatistics().sAbsRepCN();
        Axiom ret = this.copy(pos);
        ret.add(InAx.getConcept(pos).getDescription().copy());
        absorptionLog.print((Object)" simplify ~CN expression for ", (Object)pos);
        return ret;
    }

    @PortedFrom(file="tAxiom.h", name="split")
    private void split(List<Axiom> acc, DLTree pos, DLTree pAnd) {
        if (pAnd.isAND()) {
            ArrayList<DLTree> children = new ArrayList<DLTree>(pAnd.getChildren());
            this.split(acc, pos, (DLTree)children.remove(0));
            if (!children.isEmpty()) {
                this.split(acc, pos, DLTreeFactory.createSNFAnd(children));
            }
        } else {
            Axiom ret = this.copy(pos);
            ret.add(DLTreeFactory.createSNFNot(pAnd.copy()));
            acc.add(ret);
        }
    }

    @PortedFrom(file="tAxiom.h", name="split")
    public List<Axiom> split(TBox tbox) {
        Optional<DLTree> findAny = this.disjuncts.stream().filter(InAx::isAnd).peek(p -> tbox.getStatistics().sAbsSplit()).peek(p -> absorptionLog.print((Object)" split AND expression ", (Object)p.getChild())).findAny();
        ArrayList<Axiom> l = new ArrayList<Axiom>();
        findAny.ifPresent(rep -> rep.children().forEach(child -> this.split((List<Axiom>)l, (DLTree)rep, (DLTree)child)));
        return l;
    }

    @PortedFrom(file="tAxiom.h", name="add")
    public void add(DLTree p) {
        if (InAx.isBot(p)) {
            return;
        }
        if (InAx.isOr(p)) {
            p.getChildren().forEach(this::add);
            return;
        }
        this.disjuncts.add(p);
    }

    public String toString() {
        return this.disjuncts.stream().map(Object::toString).collect(Collectors.joining("", " (neg-and ", ")"));
    }

    @Nullable
    @PortedFrom(file="tAxiom.h", name="simplifyCN")
    public Axiom simplifyCN(TBox t) {
        for (DLTree p : this.disjuncts) {
            if (InAx.isPosNP(p)) {
                return this.simplifyPosNP(p, t);
            }
            if (!InAx.isNegNP(p)) continue;
            return this.simplifyNegNP(p, t);
        }
        return null;
    }

    @Nullable
    @PortedFrom(file="tAxiom.h", name="simplifyForall")
    public Axiom simplifyForall(TBox kb) {
        Optional<DLTree> findany = this.disjuncts.stream().filter(InAx::isAbsForall).findAny();
        if (findany.isPresent()) {
            return this.simplifyForall(findany.get(), kb);
        }
        return null;
    }

    @Nullable
    public Axiom simplifySForall(TBox kb) {
        Optional<DLTree> findany = this.disjuncts.stream().filter(InAx::isSimpleForall).findAny();
        if (findany.isPresent()) {
            return this.simplifyForall(findany.get(), kb);
        }
        return null;
    }

    @PortedFrom(file="tAxiom.h", name="simplifyForall")
    private Axiom simplifyForall(DLTree pos, TBox tbox) {
        tbox.getStatistics().sAbsRepForall();
        DLTree pAll = pos.getChild();
        absorptionLog.print((Object)" simplify ALL expression", (Object)pAll);
        Axiom ret = this.copy(pos);
        ret.add(tbox.getTree(tbox.replaceForall(pAll.copy())));
        return ret;
    }

    @PortedFrom(file="tAxiom.h", name="createAnAxiom")
    public DLTree createAnAxiom(@Nullable DLTree replaced) {
        if (this.disjuncts.isEmpty()) {
            return DLTreeFactory.createBottom();
        }
        List leaves = OWLAPIStreamUtils.asList(this.disjuncts.stream().filter(d -> !d.equals(replaced)).map(d -> d.copy()));
        DLTree result = DLTreeFactory.createSNFAnd(leaves);
        return DLTreeFactory.createSNFNot(result);
    }

    @PortedFrom(file="tAxiom.h", name="absorbIntoBottom")
    public boolean absorbIntoBottom(TBox tbox) {
        HashSet<DLTree> pos = new HashSet<DLTree>();
        HashSet<DLTree> neg = new HashSet<DLTree>();
        block5: for (DLTree p : this.disjuncts) {
            switch (p.token()) {
                case BOTTOM: {
                    tbox.getStatistics().sAbsBApply();
                    absorptionLog.print(" Absorb into BOTTOM");
                    return true;
                }
                case TOP: {
                    continue block5;
                }
                case NOT: {
                    if (pos.contains(p)) {
                        tbox.getStatistics().sAbsBApply();
                        absorptionLog.print((Object)ABSORB_INTO_BOTTOM, (Object)p, (Object)AND, (Object)p);
                        return true;
                    }
                    neg.add(p.getChild());
                    continue block5;
                }
            }
            if (neg.contains(p)) {
                tbox.getStatistics().sAbsBApply();
                absorptionLog.print((Object)ABSORB_INTO_BOTTOM, (Object)p, (Object)AND, (Object)p);
                return true;
            }
            pos.add(p);
        }
        Optional<DLTree> findAny = neg.stream().filter(pos::contains).findAny();
        if (findAny.isPresent()) {
            tbox.getStatistics().sAbsBApply();
            absorptionLog.print((Object)ABSORB_INTO_BOTTOM, (Object)findAny.get(), (Object)AND, (Object)findAny.get());
            return true;
        }
        return false;
    }

    @PortedFrom(file="tAxiom.h", name="absorbIntoConcept")
    public boolean absorbIntoConcept(TBox tbox) {
        ArrayList<DLTree> cons = new ArrayList<DLTree>();
        DLTree bestConcept = null;
        for (DLTree p : this.disjuncts) {
            if (!InAx.isNegPC(p)) continue;
            tbox.getStatistics().sAbsCAttempt();
            cons.add(p);
            if (!InAx.getConcept(p).isSystem()) continue;
            bestConcept = p;
        }
        if (cons.isEmpty()) {
            return false;
        }
        tbox.getStatistics().sAbsCApply();
        if (bestConcept == null) {
            bestConcept = (DLTree)cons.get(0);
        }
        Concept concept = InAx.getConcept(bestConcept);
        this.logOptions(" C-Absorb GCI to concept ", cons, concept.getIRI(), tbox.getOptions());
        concept.addDesc(this.createAnAxiom(bestConcept));
        concept.removeSelfFromDescription();
        tbox.clearRelevanceInfo();
        tbox.checkToldCycle(concept);
        tbox.clearRelevanceInfo();
        return true;
    }

    protected void logOptions(String prefix, List<DLTree> cons, IRI conceptName, JFactReasonerConfiguration options) {
        if (options.isAbsorptionLoggingActive()) {
            absorptionLog.print((Object)prefix, (Object)conceptName);
            if (cons.size() > 1) {
                Stream skip = cons.stream().skip(1L);
                ArrayList l = new ArrayList();
                skip.forEach(t -> {
                    if (t.getChildren().isEmpty()) {
                        l.add(t);
                    } else {
                        l.addAll(t.getChildren());
                    }
                });
                String collect = l.stream().map(p -> InAx.getConcept(p).getIRI()).collect(Collectors.joining(" "));
                absorptionLog.print(" (other options are ").print(collect).print(")");
            }
        }
    }

    @PortedFrom(file="tAxiom.h", name="absorbIntoDomain")
    public boolean absorbIntoDomain(TBox tbox) {
        ArrayList<DLTree> cons = new ArrayList<DLTree>();
        DLTree bestSome = null;
        for (DLTree p : this.disjuncts) {
            if (p.token() != Token.NOT || p.getChild().token() != Token.FORALL && p.getChild().token() != Token.LE) continue;
            tbox.getStatistics().sAbsRAttempt();
            cons.add(p);
            if (!p.getChild().getRight().isBOTTOM()) continue;
            bestSome = p;
            break;
        }
        if (cons.isEmpty()) {
            return false;
        }
        tbox.getStatistics().sAbsRApply();
        Role role = bestSome != null ? Role.resolveRole(bestSome.getChild().getLeft()) : Role.resolveRole(((DLTree)cons.get(0)).getChild().getLeft());
        this.logOptions(" R-Absorb GCI to the domain of role ", cons, role.getIRI(), tbox.getOptions());
        role.setDomain(this.createAnAxiom(bestSome));
        return true;
    }

    @PortedFrom(file="tAxiom.h", name="absorbIntoTop")
    public boolean absorbIntoTop(TBox tbox) {
        Concept c = null;
        for (DLTree p : this.disjuncts) {
            if (InAx.isBot(p)) continue;
            if (InAx.isPosCN(p)) {
                if (c != null) {
                    return false;
                }
                c = InAx.getConcept(p.getChild());
                if (!c.isSingleton()) continue;
                return false;
            }
            return false;
        }
        if (c == null) {
            return false;
        }
        tbox.getStatistics().sAbsTApply();
        DLTree desc = tbox.makeNonPrimitive(c, DLTreeFactory.createTop());
        if (tbox.getOptions().isAbsorptionLoggingActive()) {
            absorptionLog.print("TAxiom.absorbIntoTop() T-Absorb GCI to axiom\n");
            if (desc != null) {
                absorptionLog.print((Object)"s *TOP* [=", (Object)desc, (Object)" and\n");
            }
            absorptionLog.print((Object)" ", (Object)c.getIRI(), (Object)" = *TOP*\n");
        }
        if (desc != null) {
            tbox.addSubsumeAxiom(DLTreeFactory.createTop(), desc);
        }
        return true;
    }

    public boolean equals(@Nullable Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (this == arg0) {
            return true;
        }
        if (arg0 instanceof Axiom) {
            Axiom ax = (Axiom)arg0;
            return this.disjuncts.equals(ax.disjuncts);
        }
        return false;
    }

    public int hashCode() {
        return this.disjuncts.hashCode();
    }

    @Original
    public OntologyAtom getAtom() {
        return this.atom;
    }

    @Original
    public void setAtom(OntologyAtom atom) {
        this.atom = atom;
    }
}

