/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.helpers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionGraph;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;

public class Stats
implements Serializable {
    private static final String TAB = "\n                ";
    private static final String THERE_WERE_MADE = "\nThere were made ";
    private final List<AccumulatedStatistic> root = new ArrayList<AccumulatedStatistic>();
    private final AccumulatedStatistic nTacticCalls = Stats.build(this.root);
    private final AccumulatedStatistic nUseless = Stats.build(this.root);
    private final AccumulatedStatistic nIdCalls = Stats.build(this.root);
    private final AccumulatedStatistic nSingletonCalls = Stats.build(this.root);
    private final AccumulatedStatistic nOrCalls = Stats.build(this.root);
    private final AccumulatedStatistic nOrBrCalls = Stats.build(this.root);
    private final AccumulatedStatistic nAndCalls = Stats.build(this.root);
    private final AccumulatedStatistic nSomeCalls = Stats.build(this.root);
    private final AccumulatedStatistic nAllCalls = Stats.build(this.root);
    private final AccumulatedStatistic nFuncCalls = Stats.build(this.root);
    private final AccumulatedStatistic nLeCalls = Stats.build(this.root);
    private final AccumulatedStatistic nGeCalls = Stats.build(this.root);
    private final AccumulatedStatistic nNNCalls = Stats.build(this.root);
    private final AccumulatedStatistic nMergeCalls = Stats.build(this.root);
    private final AccumulatedStatistic nAutoEmptyLookups = Stats.build(this.root);
    private final AccumulatedStatistic nAutoTransLookups = Stats.build(this.root);
    private final AccumulatedStatistic nSRuleAdd = Stats.build(this.root);
    private final AccumulatedStatistic nSRuleFire = Stats.build(this.root);
    private final AccumulatedStatistic nStateSaves = Stats.build(this.root);
    private final AccumulatedStatistic nStateRestores = Stats.build(this.root);
    private final AccumulatedStatistic nNodeSaves = Stats.build(this.root);
    private final AccumulatedStatistic nNodeRestores = Stats.build(this.root);
    private final AccumulatedStatistic nLookups = Stats.build(this.root);
    private final AccumulatedStatistic nFairnessViolations = Stats.build(this.root);
    private final AccumulatedStatistic nCacheTry = Stats.build(this.root);
    private final AccumulatedStatistic nCacheFailedNoCache = Stats.build(this.root);
    private final AccumulatedStatistic nCacheFailedShallow = Stats.build(this.root);
    private final AccumulatedStatistic nCacheFailed = Stats.build(this.root);
    private final AccumulatedStatistic nCachedSat = Stats.build(this.root);
    private final AccumulatedStatistic nCachedUnsat = Stats.build(this.root);

    public static AccumulatedStatistic build(List<AccumulatedStatistic> list) {
        AccumulatedStatistic toReturn = new AccumulatedStatistic();
        list.add(toReturn);
        return toReturn;
    }

    public void accumulate() {
        this.root.forEach(cur -> cur.accumulate());
    }

    public void logStatisticData(LogAdapter o, boolean needLocal, DlCompletionGraph cGraph, JFactReasonerConfiguration options) {
        if (options.isUseReasoningStatistics()) {
            this.nTacticCalls.print(o, needLocal, THERE_WERE_MADE, " tactic operations, of which:");
            this.nIdCalls.print(o, needLocal, "\n    CN   operations: ", "");
            this.nSingletonCalls.print(o, needLocal, "\n           including ", " singleton ones");
            this.nOrCalls.print(o, needLocal, "\n    OR   operations: ", "");
            this.nOrBrCalls.print(o, needLocal, "\n           ", " of which are branching");
            this.nAndCalls.print(o, needLocal, "\n    AND  operations: ", "");
            this.nSomeCalls.print(o, needLocal, "\n    SOME operations: ", "");
            this.nAllCalls.print(o, needLocal, "\n    ALL  operations: ", "");
            this.nFuncCalls.print(o, needLocal, "\n    Func operations: ", "");
            this.nLeCalls.print(o, needLocal, "\n    LE   operations: ", "");
            this.nGeCalls.print(o, needLocal, "\n    GE   operations: ", "");
            this.nUseless.print(o, needLocal, "\n    N/A  operations: ", "");
            this.nNNCalls.print(o, needLocal, THERE_WERE_MADE, " NN rule application");
            this.nMergeCalls.print(o, needLocal, THERE_WERE_MADE, " merging operations");
            this.nAutoEmptyLookups.print(o, needLocal, THERE_WERE_MADE, " RA empty transition lookups");
            this.nAutoTransLookups.print(o, needLocal, THERE_WERE_MADE, " RA applicable transition lookups");
            this.nSRuleAdd.print(o, needLocal, THERE_WERE_MADE, " simple rule additions");
            this.nSRuleFire.print(o, needLocal, "\n       of which ", " simple rules fired");
            this.nStateSaves.print(o, needLocal, THERE_WERE_MADE, " save(s) of global state");
            this.nStateRestores.print(o, needLocal, THERE_WERE_MADE, " restore(s) of global state");
            this.nNodeSaves.print(o, needLocal, THERE_WERE_MADE, " save(s) of tree state");
            this.nNodeRestores.print(o, needLocal, THERE_WERE_MADE, " restore(s) of tree state");
            this.nLookups.print(o, needLocal, THERE_WERE_MADE, " concept lookups");
            if (options.isUseFairness()) {
                this.nFairnessViolations.print(o, needLocal, "\nThere were ", " fairness constraints violation");
            }
            this.nCacheTry.print(o, needLocal, THERE_WERE_MADE, " tries to cache completion tree node, of which:");
            this.nCacheFailedNoCache.print(o, needLocal, TAB, " fails due to cache absence");
            this.nCacheFailedShallow.print(o, needLocal, TAB, " fails due to shallow node");
            this.nCacheFailed.print(o, needLocal, TAB, " fails due to cache merge failure");
            this.nCachedSat.print(o, needLocal, TAB, " cached satisfiable nodes");
            this.nCachedUnsat.print(o, needLocal, TAB, " cached unsatisfiable nodes");
        }
        if (!needLocal) {
            o.print("\nThe maximal graph size is ").print(cGraph.maxSize()).print(" nodes");
        }
    }

    public AccumulatedStatistic getnTacticCalls() {
        return this.nTacticCalls;
    }

    public AccumulatedStatistic getnUseless() {
        return this.nUseless;
    }

    public AccumulatedStatistic getnIdCalls() {
        return this.nIdCalls;
    }

    public AccumulatedStatistic getnSingletonCalls() {
        return this.nSingletonCalls;
    }

    public AccumulatedStatistic getnOrCalls() {
        return this.nOrCalls;
    }

    public AccumulatedStatistic getnOrBrCalls() {
        return this.nOrBrCalls;
    }

    public AccumulatedStatistic getnAndCalls() {
        return this.nAndCalls;
    }

    public AccumulatedStatistic getnSomeCalls() {
        return this.nSomeCalls;
    }

    public AccumulatedStatistic getnAllCalls() {
        return this.nAllCalls;
    }

    public AccumulatedStatistic getnFuncCalls() {
        return this.nFuncCalls;
    }

    public AccumulatedStatistic getnLeCalls() {
        return this.nLeCalls;
    }

    public AccumulatedStatistic getnGeCalls() {
        return this.nGeCalls;
    }

    public AccumulatedStatistic getnNNCalls() {
        return this.nNNCalls;
    }

    public AccumulatedStatistic getnMergeCalls() {
        return this.nMergeCalls;
    }

    public AccumulatedStatistic getnAutoEmptyLookups() {
        return this.nAutoEmptyLookups;
    }

    public AccumulatedStatistic getnAutoTransLookups() {
        return this.nAutoTransLookups;
    }

    public AccumulatedStatistic getnSRuleAdd() {
        return this.nSRuleAdd;
    }

    public AccumulatedStatistic getnSRuleFire() {
        return this.nSRuleFire;
    }

    public AccumulatedStatistic getnStateSaves() {
        return this.nStateSaves;
    }

    public AccumulatedStatistic getnStateRestores() {
        return this.nStateRestores;
    }

    public AccumulatedStatistic getnNodeSaves() {
        return this.nNodeSaves;
    }

    public AccumulatedStatistic getnNodeRestores() {
        return this.nNodeRestores;
    }

    public AccumulatedStatistic getnLookups() {
        return this.nLookups;
    }

    public AccumulatedStatistic getnFairnessViolations() {
        return this.nFairnessViolations;
    }

    public AccumulatedStatistic getnCacheTry() {
        return this.nCacheTry;
    }

    public AccumulatedStatistic getnCacheFailedNoCache() {
        return this.nCacheFailedNoCache;
    }

    public AccumulatedStatistic getnCacheFailedShallow() {
        return this.nCacheFailedShallow;
    }

    public AccumulatedStatistic getnCacheFailed() {
        return this.nCacheFailed;
    }

    public AccumulatedStatistic getnCachedSat() {
        return this.nCachedSat;
    }

    public AccumulatedStatistic getnCachedUnsat() {
        return this.nCachedUnsat;
    }

    public static class AccumulatedStatistic
    implements Serializable {
        private int total = 0;
        private int local = 0;

        public void inc() {
            ++this.local;
        }

        public void accumulate() {
            this.total += this.local;
            this.local = 0;
        }

        public void print(LogAdapter l, boolean b, String s1, String s2) {
            l.print(s1);
            if (b) {
                l.print(this.local);
            } else {
                l.print(this.total);
            }
            l.print(s2);
        }
    }
}

