/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.helpers;

import uk.ac.manchester.cs.jfact.helpers.DLVertex;

public enum StatIndex {
    DEPTH,
    SIZE,
    BRANCH,
    GENER,
    FREQ;


    public int getIndex(boolean pos) {
        return this.ordinal() * 2 + (pos ? 0 : 1);
    }

    public static int choose(char c) {
        switch (c) {
            case 'S': {
                return SIZE.getIndex(false);
            }
            case 'D': {
                return DEPTH.getIndex(false);
            }
            case 'B': {
                return BRANCH.getIndex(false);
            }
            case 'G': {
                return GENER.getIndex(false);
            }
        }
        return FREQ.getIndex(false);
    }

    public static void updateStatValues(int d, int s, int b, int g, boolean pos, int[] stat, boolean debug) {
        int n = SIZE.getIndex(pos);
        stat[n] = stat[n] + s;
        int n2 = BRANCH.getIndex(pos);
        stat[n2] = stat[n2] + b;
        int n3 = GENER.getIndex(pos);
        stat[n3] = stat[n3] + g;
        if (d > stat[DEPTH.getIndex(pos)]) {
            stat[StatIndex.DEPTH.getIndex((boolean)pos)] = d;
        }
    }

    public static void updateStatValues(DLVertex v, boolean posV, boolean pos, int[] stat, boolean debug) {
        StatIndex.updateStatValues(StatIndex.getDepth(posV, v.stat), StatIndex.getSize(posV, v.stat), StatIndex.getBranch(posV, v.stat), StatIndex.getGener(posV, v.stat), pos, stat, debug);
    }

    public static void incFreqValue(boolean pos, int[] stat) {
        int n = FREQ.getIndex(pos);
        stat[n] = stat[n] + 1;
    }

    public static int getDepth(boolean pos, int[] stat) {
        return stat[DEPTH.getIndex(pos)];
    }

    protected static int getSize(boolean pos, int[] stat) {
        return stat[SIZE.getIndex(pos)];
    }

    protected static int getBranch(boolean pos, int[] stat) {
        return stat[BRANCH.getIndex(pos)];
    }

    protected static int getGener(boolean pos, int[] stat) {
        return stat[GENER.getIndex(pos)];
    }

    protected static int getFreq(boolean pos, int[] stat) {
        return stat[FREQ.getIndex(pos)];
    }
}

