/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.helpers;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import uk.ac.manchester.cs.chainsaw.FastSet;
import uk.ac.manchester.cs.chainsaw.FastSetFactory;
import uk.ac.manchester.cs.jfact.helpers.DLVertexTagDFS;
import uk.ac.manchester.cs.jfact.helpers.SortedIntList;
import uk.ac.manchester.cs.jfact.helpers.StatIndex;
import uk.ac.manchester.cs.jfact.helpers.Templates;
import uk.ac.manchester.cs.jfact.kernel.DLDag;
import uk.ac.manchester.cs.jfact.kernel.DagTag;
import uk.ac.manchester.cs.jfact.kernel.MergableLabel;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.Role;

@PortedFrom(file="dlVertex.h", name="DLVertex")
public class DLVertex
extends DLVertexTagDFS {
    @PortedFrom(file="dlVertex.h", name="Child")
    private final ChildSet child = new ChildSet();
    @PortedFrom(file="dlVertex.h", name="Concept")
    private NamedEntry concept = null;
    @PortedFrom(file="dlVertex.h", name="Role")
    private final Role role;
    @PortedFrom(file="dlVertex.h", name="ProjRole")
    private final Role projRole;
    @PortedFrom(file="dlVertex.h", name="C")
    private int conceptIndex;
    @PortedFrom(file="dlVertex.h", name="n")
    private final int n;
    @PortedFrom(file="dlVertex.h", name="Sort")
    private final MergableLabel sort = new MergableLabel();
    private final DLDag heap;
    @PortedFrom(file="dlVertex.h", name="stat")
    protected final int[] stat = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    @PortedFrom(file="dlVertex.h", name="posUsage")
    protected final long posUsage = 0L;
    @PortedFrom(file="dlVertex.h", name="negUsage")
    protected final long negUsage = 0L;

    public DLVertex(DagTag op, DLDag heap) {
        this(op, 0, null, 0, null, heap);
    }

    public DLVertex(DagTag op, int m, @Nullable Role r, int c, @Nullable Role projR, DLDag heap) {
        super(op);
        this.role = r;
        this.projRole = projR;
        this.conceptIndex = c;
        this.n = m;
        this.heap = heap;
    }

    @PortedFrom(file="dlVertex.h", name="getSort")
    public MergableLabel getSort() {
        return this.sort;
    }

    @PortedFrom(file="dlVertex.h", name="merge")
    public void merge(MergableLabel label) {
        this.sort.merge(label);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof DLVertex) {
            DLVertex v = (DLVertex)obj;
            return this.compareIndexes(v) && this.compareRoles(v) && this.child.equals(v.child);
        }
        return false;
    }

    protected boolean compareIndexes(DLVertex v) {
        return this.op == v.op && this.conceptIndex == v.conceptIndex && this.n == v.n;
    }

    protected boolean compareRoles(DLVertex v) {
        return DLVertex.compare(this.role, v.role) && DLVertex.compare(this.projRole, v.projRole);
    }

    @PortedFrom(file="dlVertex.h", name="compare")
    private static boolean compare(@Nullable Object o1, @Nullable Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public int hashCode() {
        int hash = this.op == null ? 0 : this.op.hashCode();
        hash = 31 * hash + (this.role == null ? 0 : this.role.hashCode());
        hash = 31 * hash + (this.projRole == null ? 0 : this.projRole.hashCode());
        hash = 31 * hash + this.conceptIndex;
        hash = 31 * hash + this.n;
        hash = 31 * hash + (this.child == null ? 0 : this.child.hashCode());
        return hash;
    }

    @PortedFrom(file="dlVertex.h", name="getC")
    public int getConceptIndex() {
        return this.conceptIndex;
    }

    @PortedFrom(file="dlVertex.h", name="getNumberLE")
    public int getNumberLE() {
        return this.n;
    }

    @PortedFrom(file="dlVertex.h", name="getNumberGE")
    public int getNumberGE() {
        return this.n + 1;
    }

    @PortedFrom(file="dlVertex.h", name="getState")
    public int getState() {
        return this.n;
    }

    @PortedFrom(file="dlVertex.h", name="begin")
    public int[] begin() {
        return this.child.sorted();
    }

    @PortedFrom(file="dlVertex.h", name="getRole")
    public Role getRole() {
        return this.role;
    }

    @PortedFrom(file="dlVertex.h", name="getProjRole")
    public Role getProjRole() {
        return this.projRole;
    }

    @Nullable
    @PortedFrom(file="dlVertex.h", name="getConcept")
    public NamedEntry getConcept() {
        return this.concept;
    }

    @PortedFrom(file="dlVertex.h", name="setConcept")
    public void setConcept(NamedEntry p) {
        this.concept = p;
    }

    @PortedFrom(file="dlVertex.h", name="setChild")
    public void setChild(int p) {
        this.conceptIndex = p;
    }

    @PortedFrom(file="dlVertex.h", name="addChild")
    public boolean addChild(int p) {
        if (this.op == DagTag.BAD) {
            return true;
        }
        if (p == 1) {
            return false;
        }
        if (p == -1 || this.child.contains(-p)) {
            this.child.clear();
            this.op = DagTag.BAD;
            return true;
        }
        this.child.add(p);
        return false;
    }

    @Original
    public int getAndToDagValue() {
        if (this.child.children.size() == 0) {
            return 1;
        }
        if (this.child.children.size() == 1) {
            return this.child.children.get(0);
        }
        return 0;
    }

    @PortedFrom(file="dlVertex.h", name="sortEntry")
    public void sortEntry(DLDag dag) {
        if (this.op != DagTag.AND) {
            return;
        }
        this.child.setSorter(dag);
    }

    public String toString(boolean extendedStats) {
        StringBuilder o = new StringBuilder();
        if (extendedStats) {
            o.append(String.format("[d(%s/%s),s(%s/%s),b(%s/%s),g(%s/%s),f(%s/%s)] ", Integer.toString(this.stat[0]), Integer.toString(this.stat[1]), Integer.toString(this.stat[2]), Integer.toString(this.stat[3]), Integer.toString(this.stat[4]), Integer.toString(this.stat[5]), Integer.toString(this.stat[6]), Integer.toString(this.stat[7]), Integer.toString(this.stat[8]), Integer.toString(this.stat[9])));
        }
        o.append(this.toString());
        return o.toString();
    }

    @Nonnull
    public String toString() {
        switch (this.op) {
            case AND: 
            case COLLECTION: {
                break;
            }
            case TOP: 
            case NN: {
                return this.op.getName();
            }
            case DATAEXPR: {
                return this.op.getName() + ' ' + this.concept;
            }
            case DATAVALUE: 
            case DATATYPE: 
            case PCONCEPT: 
            case NCONCEPT: 
            case PSINGLETON: 
            case NSINGLETON: {
                return this.op.getName() + String.format(Templates.DLVERTEXPRINT2.getTemplate(), this.concept.getIRI(), this.op.isNNameTag() ? "=" : "[=", this.concept);
            }
            case LE: {
                return this.op.getName() + ' ' + this.n + ' ' + this.role.getIRI() + ' ' + this.concept;
            }
            case FORALL: {
                return this.op.getName() + String.format(Templates.DLVERTEXPRINT3.getTemplate(), this.role.getIRI(), Integer.toString(this.n), this.concept);
            }
            case IRR: {
                return this.op.getName() + ' ' + this.role.getIRI();
            }
            case PROJ: {
                return this.op.getName() + String.format(Templates.DLVERTEXPRINT4.getTemplate(), this.role.getIRI(), this.concept, this.projRole.getIRI());
            }
            case CHOOSE: {
                return this.op.getName() + ' ' + this.concept;
            }
            default: {
                throw new ReasonerInternalException(String.format("Error printing vertex of type %s(%s)", new Object[]{this.op.getName(), this.op}));
            }
        }
        return this.childrenToString();
    }

    protected String childrenToString() {
        StringBuilder o = new StringBuilder(this.op.getName());
        for (int q : this.child.sorted()) {
            o.append(' ').append(this.heap.get(q));
        }
        return o.toString();
    }

    @PortedFrom(file="dlVertex.h", name="updateStatValues")
    public void updateStatValues(int d, int s, int b, int g, boolean pos) {
        StatIndex.updateStatValues(d, s, b, g, pos, this.stat, false);
    }

    @PortedFrom(file="dlVertex.h", name="updateStatValues")
    public void updateStatValues(DLVertex v, boolean posV, boolean pos) {
        StatIndex.updateStatValues(v, posV, pos, this.stat, false);
    }

    @PortedFrom(file="dlVertex.h", name="incFreqValue")
    public void incFreqValue(boolean pos) {
        StatIndex.incFreqValue(pos, this.stat);
    }

    @PortedFrom(file="dlVertex.h", name="getStat")
    public int getStat(int i) {
        return this.stat[i];
    }

    @PortedFrom(file="dlVertex.h", name="getDepth")
    public int getDepth(boolean pos) {
        return StatIndex.getDepth(pos, this.stat);
    }

    @PortedFrom(file="dlVertex.h", name="getUsage")
    public long getUsage(boolean pos) {
        return pos ? 0L : 0L;
    }

    class ChildSet
    implements Comparator<Integer>,
    Serializable {
        protected final FastSet children = FastSetFactory.create();
        private final SortedIntList original = new SortedIntList();
        private int[] sorted = null;
        protected DLDag sorter = null;

        ChildSet() {
        }

        @Override
        @PortedFrom(file="dlVertex.h", name="compare")
        public int compare(@Nullable Integer o1, @Nullable Integer o2) {
            return this.sorter.compare(o1, o2);
        }

        @Override
        public boolean equals(@Nullable Object arg0) {
            if (arg0 == null) {
                return false;
            }
            if (this == arg0) {
                return true;
            }
            if (arg0 instanceof ChildSet) {
                ChildSet arg = (ChildSet)arg0;
                return this.children.equals(arg.children);
            }
            return false;
        }

        public int hashCode() {
            return this.children.hashCode();
        }

        public void setSorter(DLDag d) {
            this.sorter = d;
            this.sorted = null;
        }

        public int[] sorted() {
            block5: {
                if (this.sorted != null) break block5;
                this.sorted = new int[this.children.size()];
                if (this.sorter == null) {
                    for (int i = 0; i < this.children.size(); ++i) {
                        this.sorted[i] = this.original.get(i);
                    }
                } else {
                    int i;
                    ArrayList<Integer> l = new ArrayList<Integer>();
                    for (i = 0; i < this.children.size(); ++i) {
                        l.add(this.children.get(i));
                    }
                    Collections.sort(l, this);
                    for (i = 0; i < this.sorted.length; ++i) {
                        this.sorted[i] = (Integer)l.get(i);
                    }
                }
            }
            return this.sorted;
        }

        public boolean contains(int inverse) {
            return this.children.contains(inverse);
        }

        public void clear() {
            this.children.clear();
            this.sorted = null;
        }

        public boolean add(int p) {
            if (this.children.add(p)) {
                this.original.add(p);
                this.sorted = null;
                return true;
            }
            return false;
        }
    }
}

