/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.helpers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.LEAFDLTree;
import uk.ac.manchester.cs.jfact.helpers.NDLTree;
import uk.ac.manchester.cs.jfact.helpers.ONEDLTree;
import uk.ac.manchester.cs.jfact.helpers.ReverseCloningVisitor;
import uk.ac.manchester.cs.jfact.helpers.TWODLTree;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.Lexeme;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.Token;

public class DLTreeFactory
implements Serializable {
    private static final EnumSet<Token> snfCalls = EnumSet.of(Token.TOP, new Token[]{Token.BOTTOM, Token.CNAME, Token.INAME, Token.RNAME, Token.DNAME, Token.DATAEXPR, Token.NOT, Token.INV, Token.AND, Token.FORALL, Token.LE, Token.SELF, Token.RCOMPOSITION, Token.PROJFROM, Token.PROJINTO});

    private DLTreeFactory() {
    }

    public static DLTree createBottom() {
        return new LEAFDLTree(new Lexeme(Token.BOTTOM));
    }

    public static DLTree createInverse(DLTree r) {
        assert (r != null);
        if (r.token() == Token.INV) {
            return r.getChild().copy();
        }
        if (r.token() == Token.RNAME) {
            if (DLTreeFactory.isTopRole(r) || DLTreeFactory.isBotRole(r)) {
                return r;
            }
            return new ONEDLTree(new Lexeme(Token.INV), r);
        }
        throw new UnreachableSituationException();
    }

    public static boolean isSemanticallyDataTop(DLTree dr) {
        return dr.elem().getToken() == Token.TOP;
    }

    public static boolean isSemanticallyDataBottom(DLTree dr) {
        return dr.elem().getToken() == Token.BOTTOM;
    }

    public static boolean isDataRangeBigEnough(DLTree dr, int n) {
        return true;
    }

    public static DLTree simplifyDataTopForall(DLTree dr) {
        if (DLTreeFactory.isSemanticallyDataTop(dr)) {
            return DLTreeFactory.createTop();
        }
        return DLTreeFactory.createBottom();
    }

    public static DLTree simplifyDataTopLE(int n, DLTree dr) {
        if (DLTreeFactory.isSemanticallyDataBottom(dr)) {
            return DLTreeFactory.createTop();
        }
        if (!DLTreeFactory.isDataRangeBigEnough(dr, n)) {
            return DLTreeFactory.createTop();
        }
        return DLTreeFactory.createBottom();
    }

    public static DLTree buildDisjAux(List<DLTree> arguments) {
        return DLTreeFactory.createSNFAnd(OWLAPIStreamUtils.asList(arguments.stream().map(DLTree::copy).map(DLTreeFactory::createSNFNot)));
    }

    public static DLTree createSNFAnd(@Nullable DLTree c, @Nullable DLTree d) {
        if (c == null) {
            assert (d != null);
            return d;
        }
        if (d == null) {
            assert (c != null);
            return c;
        }
        if (c.isTOP() || d.isBOTTOM()) {
            return d;
        }
        if (d.isTOP() || c.isBOTTOM()) {
            return c;
        }
        return new NDLTree(new Lexeme(Token.AND), c, d);
    }

    public static DLTree createSNFAnd(Collection<DLTree> collection) {
        if (collection.isEmpty()) {
            return DLTreeFactory.createTop();
        }
        if (collection.size() == 1) {
            DLTree next = collection.iterator().next();
            assert (next != null);
            return next;
        }
        ArrayList<DLTree> l = new ArrayList<DLTree>();
        for (DLTree d : collection) {
            if (d == null) continue;
            if (d.isBOTTOM()) {
                return DLTreeFactory.createBottom();
            }
            if (d.isAND()) {
                l.addAll(d.getChildren());
                continue;
            }
            l.add(d);
        }
        if (l.isEmpty()) {
            return DLTreeFactory.createTop();
        }
        if (l.size() == 1) {
            DLTree dlTree = (DLTree)l.get(0);
            assert (dlTree != null);
            return dlTree;
        }
        return new NDLTree(new Lexeme(Token.AND), l);
    }

    public static DLTree createSNFAnd(Collection<DLTree> collection, DLTree ancestor) {
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        boolean hasTop = false;
        ArrayList<DLTree> l = new ArrayList<DLTree>();
        for (DLTree d : collection) {
            if (d.isTOP()) {
                hasTop = true;
            }
            if (d.isBOTTOM()) {
                return DLTreeFactory.createBottom();
            }
            if (d.isAND()) {
                l.addAll(d.getChildren());
                continue;
            }
            l.add(d);
        }
        if (hasTop && l.isEmpty()) {
            return DLTreeFactory.createTop();
        }
        if (l.size() == 1) {
            return (DLTree)l.get(0);
        }
        if (l.size() == collection.size()) {
            return ancestor;
        }
        return new NDLTree(new Lexeme(Token.AND), l);
    }

    public static boolean containsC(DLTree c, DLTree d) {
        if (c.isCName()) {
            return DLTree.equalTrees(c, d);
        }
        if (c.isAND()) {
            return c.getChildren().stream().anyMatch(p -> DLTreeFactory.containsC(p, d));
        }
        return false;
    }

    public static DLTree createSNFReducedAnd(@Nullable DLTree c, @Nullable DLTree d) {
        if (c == null || d == null) {
            return DLTreeFactory.createSNFAnd(c, d);
        }
        if (d.isCName() && DLTreeFactory.containsC(c, d)) {
            return c;
        }
        if (d.isAND()) {
            for (DLTree t : d.getChildren()) {
                c = DLTreeFactory.createSNFReducedAnd(c, t.copy());
            }
            return c;
        }
        return DLTreeFactory.createSNFAnd(c, d);
    }

    public static DLTree createSNFExists(DLTree r, DLTree c) {
        return DLTreeFactory.createSNFNot(DLTreeFactory.createSNFForall(r, DLTreeFactory.createSNFNot(c)));
    }

    public static DLTree createSNFForall(DLTree r, DLTree c) {
        if (c.isTOP()) {
            return c;
        }
        if (DLTreeFactory.isBotRole(r)) {
            return DLTreeFactory.createTop();
        }
        if (DLTreeFactory.isTopRole(r) && Role.resolveRole(r).isDataRole()) {
            return DLTreeFactory.simplifyDataTopForall(c);
        }
        return new TWODLTree(new Lexeme(Token.FORALL), r, c);
    }

    public static DLTree createRole(Role r) {
        return DLTreeFactory.createEntry(r.isDataRole() ? Token.DNAME : Token.RNAME, r);
    }

    public static DLTree createEntry(Token tag, NamedEntry entry) {
        return new LEAFDLTree(new Lexeme(tag, entry));
    }

    public static DLTree createSNFLE(int n, DLTree r, DLTree c) {
        if (c.isBOTTOM()) {
            return DLTreeFactory.createTop();
        }
        if (n == 0) {
            return DLTreeFactory.createSNFForall(r, DLTreeFactory.createSNFNot(c));
        }
        if (DLTreeFactory.isBotRole(r)) {
            return DLTreeFactory.createTop();
        }
        if (DLTreeFactory.isTopRole(r) && Role.resolveRole(r).isDataRole()) {
            return DLTreeFactory.simplifyDataTopLE(n, c);
        }
        return new TWODLTree(new Lexeme(Token.LE, n), r, c);
    }

    public static boolean isBotRole(DLTree t) {
        return DLTreeFactory.isRName(t) && t.elem().getNE().isBottom();
    }

    public static boolean isTopRole(DLTree t) {
        return DLTreeFactory.isRName(t) && t.elem().getNE().isTop();
    }

    public static DLTree createSNFSelf(DLTree r) {
        if (DLTreeFactory.isBotRole(r)) {
            return DLTreeFactory.createBottom();
        }
        if (DLTreeFactory.isTopRole(r)) {
            return DLTreeFactory.createTop();
        }
        return new ONEDLTree(new Lexeme(Token.SELF), r);
    }

    public static DLTree createSNFGE(int n, DLTree r, DLTree c) {
        if (n == 0) {
            return DLTreeFactory.createTop();
        }
        if (c.isBOTTOM()) {
            return c;
        }
        return DLTreeFactory.createSNFNot(DLTreeFactory.createSNFLE(n - 1, r, c));
    }

    public static DLTree createSNFNot(DLTree c) {
        assert (c != null);
        if (c.isBOTTOM()) {
            return DLTreeFactory.createTop();
        }
        if (c.isTOP()) {
            return DLTreeFactory.createBottom();
        }
        if (c.token() == Token.NOT) {
            return c.getChild().copy();
        }
        return new ONEDLTree(new Lexeme(Token.NOT), c);
    }

    public static DLTree createSNFNot(DLTree c, DLTree ancestor) {
        assert (c != null);
        if (c.isBOTTOM()) {
            return DLTreeFactory.createTop();
        }
        if (c.isTOP()) {
            return DLTreeFactory.createBottom();
        }
        if (c.token() == Token.NOT) {
            return c.getChild().copy();
        }
        return ancestor;
    }

    public static DLTree createSNFOr(Collection<DLTree> c) {
        return DLTreeFactory.createSNFNot(DLTreeFactory.createSNFAnd(OWLAPIStreamUtils.asList(c.stream().map(DLTreeFactory::createSNFNot))));
    }

    public static DLTree createTop() {
        return new LEAFDLTree(new Lexeme(Token.TOP));
    }

    public static DLTree inverseComposition(DLTree tree) {
        if (tree.token() == Token.RCOMPOSITION) {
            return tree.accept(new ReverseCloningVisitor());
        }
        return new LEAFDLTree(new Lexeme(Token.RNAME, Role.resolveRole(tree).inverse()));
    }

    public static DLTree wrap(NamedEntry t) {
        return new LEAFDLTree(new Lexeme(Token.DATAEXPR, t));
    }

    public static NamedEntry unwrap(DLTree t) {
        return t.elem().getNE();
    }

    public static DLTree buildTree(Lexeme t, DLTree t1, DLTree t2) {
        return new TWODLTree(t, t1, t2);
    }

    public static DLTree buildTree(Lexeme t, Collection<DLTree> l) {
        return new NDLTree(t, l);
    }

    public static DLTree buildTree(Lexeme t, DLTree t1) {
        return new ONEDLTree(t, t1);
    }

    public static DLTree buildTree(Lexeme t) {
        return new LEAFDLTree(t);
    }

    private static boolean isRName(@Nullable DLTree t) {
        if (t == null) {
            return false;
        }
        return t.token() == Token.RNAME || t.token() == Token.DNAME;
    }

    public static boolean isFunctionalExpr(@Nullable DLTree t, NamedEntry r) {
        return t != null && t.token() == Token.LE && r.equals(t.getLeft().elem().getNE()) && t.elem().getData() == 1 && t.getRight().isTOP();
    }

    public static boolean isSNF(@Nullable DLTree t) {
        if (t == null) {
            return true;
        }
        if (snfCalls.contains((Object)t.token())) {
            return DLTreeFactory.isSNF(t.getLeft()) && DLTreeFactory.isSNF(t.getRight());
        }
        return false;
    }

    public static boolean isSubTree(@Nullable DLTree t1, @Nullable DLTree t2) {
        if (t1 == null || t1.isTOP()) {
            return true;
        }
        if (t2 == null) {
            return false;
        }
        if (t1.isAND()) {
            return t1.getChildren().stream().allMatch(t -> DLTreeFactory.isSubTree(t, t2));
        }
        if (t2.isAND()) {
            return t2.getChildren().stream().anyMatch(t -> DLTreeFactory.isSubTree(t1, t));
        }
        return t1.equals(t2);
    }

    public static boolean isUniversalRole(DLTree t) {
        return DLTreeFactory.isRName(t) && t.elem().getNE().isTop();
    }

    public static boolean replaceSynonymsFromTree(@Nullable DLTree desc) {
        if (desc == null) {
            return false;
        }
        if (desc.isName()) {
            ClassifiableEntry entry = (ClassifiableEntry)desc.elem.getNE();
            if (entry.isSynonym()) {
                desc.elem = (entry = ClassifiableEntry.resolveSynonym(entry)).isTop() ? new Lexeme(Token.TOP) : (entry.isBottom() ? new Lexeme(Token.BOTTOM) : new Lexeme(((Concept)entry).isSingleton() ? Token.INAME : Token.CNAME, entry));
                return true;
            }
            return false;
        }
        AtomicBoolean b = new AtomicBoolean(false);
        desc.children().forEach(d -> b.set(DLTreeFactory.replaceSynonymsFromTree(d) || b.get()));
        return b.get();
    }
}

