/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.NONNEGATIVEINTEGERDatatype;
import uk.ac.manchester.cs.jfact.datatypes.Utils;

class POSITIVEINTEGERDatatype<R extends Comparable<R>>
extends NONNEGATIVEINTEGERDatatype<R> {
    protected POSITIVEINTEGERDatatype() {
        super((HasIRI)XSDVocabulary.POSITIVE_INTEGER, Utils.generateAncestors(DatatypeFactory.NONNEGATIVEINTEGER));
        this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
        this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
        this.knownNonNumericFacetValues.put(Facets.whiteSpace, DatatypeFactory.WHITESPACE);
        this.knownNonNumericFacetValues.put(Facets.pattern, DatatypeFactory.NUMBER_EXPRESSION);
        this.knownNumericFacetValues.put(Facets.minInclusive, new BigDecimal(1L));
    }

    @Override
    public R parseValue(String s) {
        BigInteger parseValue = new BigInteger(s);
        if (parseValue.compareTo(BigInteger.ZERO) <= 0) {
            throw new ArithmeticException("Positive integer required, but found: " + s);
        }
        return (R)parseValue;
    }
}

