/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.math.BigDecimal;
import java.util.Set;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.INTEGERDatatype;
import uk.ac.manchester.cs.jfact.datatypes.Utils;
import uk.ac.manchester.cs.jfact.datatypes.cardinality;

class LONGDatatype<R extends Comparable<R>>
extends INTEGERDatatype<R> {
    protected LONGDatatype() {
        this((HasIRI)XSDVocabulary.LONG, Utils.generateAncestors(DatatypeFactory.INTEGER));
    }

    protected LONGDatatype(HasIRI uri, Set<Datatype<?>> ancestors) {
        super(uri, ancestors);
        this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
        this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
        this.knownNonNumericFacetValues.put(Facets.whiteSpace, DatatypeFactory.WHITESPACE);
        this.knownNonNumericFacetValues.put(Facets.pattern, DatatypeFactory.NUMBER_EXPRESSION);
        this.knownNumericFacetValues.put(Facets.minInclusive, new BigDecimal(Long.MIN_VALUE));
        this.knownNumericFacetValues.put(Facets.maxInclusive, new BigDecimal(Long.MAX_VALUE));
    }

    @Override
    public R parseValue(String s) {
        return (R)Long.valueOf(s);
    }

    @Override
    public boolean getBounded() {
        return true;
    }

    @Override
    public cardinality getCardinality() {
        return cardinality.FINITE;
    }
}

