/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.math.BigInteger;
import java.util.Set;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import uk.ac.manchester.cs.jfact.datatypes.DECIMALDatatype;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.Utils;

class INTEGERDatatype<R extends Comparable<R>>
extends DECIMALDatatype<R> {
    protected INTEGERDatatype() {
        this((HasIRI)XSDVocabulary.INTEGER, Utils.generateAncestors(DatatypeFactory.DECIMAL));
    }

    protected INTEGERDatatype(HasIRI uri, Set<Datatype<?>> ancestors) {
        super(uri, ancestors);
        this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
        this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
        this.knownNonNumericFacetValues.put(Facets.whiteSpace, DatatypeFactory.WHITESPACE);
        this.knownNonNumericFacetValues.put(Facets.pattern, DatatypeFactory.NUMBER_EXPRESSION);
        this.knownNonNumericFacetValues.put(Facets.fractionDigits, 0);
    }

    @Override
    public R parseValue(String s) {
        return (R)new BigInteger(s);
    }
}

