/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import uk.ac.manchester.cs.jfact.datatypes.AbstractDatatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.Utils;

class HEXBINARYDatatype
extends AbstractDatatype<String> {
    HEXBINARYDatatype() {
        super((HasIRI)XSDVocabulary.HEX_BINARY, DatatypeFactory.STRINGFACETS, Utils.generateAncestors(DatatypeFactory.LITERAL));
        this.knownNonNumericFacetValues.putAll(DatatypeFactory.LITERAL.getKnownNonNumericFacetValues());
        this.knownNumericFacetValues.putAll(DatatypeFactory.LITERAL.getKnownNumericFacetValues());
        this.knownNonNumericFacetValues.put(Facets.whiteSpace, DatatypeFactory.WHITESPACE);
    }

    @Override
    public String parseValue(String s) {
        return Facets.whitespace.COLLAPSE.normalize(s);
    }

    @Override
    public boolean isInValueSpace(String s) {
        return s.chars().allMatch(c -> Character.isDigit((char)c) || "ABCDEF".indexOf(c) > -1);
    }
}

