/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import org.semanticweb.owlapi.vocab.OWLFacet;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facet;
import uk.ac.manchester.cs.jfact.datatypes.Literal;

public class Facets
implements Serializable {
    public static final Facet length = new LimitFacet("length");
    public static final Facet minLength = new LimitFacet("minLength");
    public static final Facet maxLength = new LimitFacet("maxLength");
    public static final Facet totalDigits = new LimitFacet("totalDigits");
    public static final Facet fractionDigits = new LimitFacet("fractionDigits");
    public static final Facet whiteSpace = new AbstractFacet("whiteSpace"){

        @Override
        public boolean isNumberFacet() {
            return false;
        }

        public whitespace parse(Object value) {
            if (value instanceof whitespace) {
                return (whitespace)((Object)value);
            }
            if (value instanceof String) {
                return whitespace.valueOf((String)value);
            }
            throw new ReasonerInternalException("Cannot parse " + value + " as a whitespace enum value");
        }
    };
    public static final Facet pattern = new AbstractFacet("pattern"){

        @Override
        public boolean isNumberFacet() {
            return false;
        }

        public String parse(Object value) {
            return value.toString();
        }
    };
    public static final Facet enumeration = new AbstractFacet("enumeration"){

        @Override
        public boolean isNumberFacet() {
            return false;
        }
    };
    public static final Facet maxInclusive = new LimitFacet("maxInclusive"){

        @Override
        public String toString() {
            return "]";
        }
    };
    public static final Facet maxExclusive = new LimitFacet("maxExclusive"){

        @Override
        public String toString() {
            return ")";
        }
    };
    public static final Facet minInclusive = new LimitFacet("minInclusive"){

        @Override
        public String toString() {
            return "[";
        }
    };
    public static final Facet minExclusive = new LimitFacet("minExclusive"){

        @Override
        public String toString() {
            return "(";
        }
    };
    private static final List<Facet> values = Arrays.asList(enumeration, fractionDigits, length, maxExclusive, maxInclusive, minExclusive, minInclusive, maxLength, minLength, pattern, totalDigits, whiteSpace);

    public static List<Facet> values() {
        return new ArrayList<Facet>(values);
    }

    public static Facet parse(OWLFacet f) {
        switch (f) {
            case LENGTH: {
                return length;
            }
            case MIN_LENGTH: {
                return minLength;
            }
            case MAX_LENGTH: {
                return maxLength;
            }
            case PATTERN: {
                return pattern;
            }
            case MIN_INCLUSIVE: {
                return minInclusive;
            }
            case MIN_EXCLUSIVE: {
                return minExclusive;
            }
            case MAX_INCLUSIVE: {
                return maxInclusive;
            }
            case MAX_EXCLUSIVE: {
                return maxExclusive;
            }
            case TOTAL_DIGITS: {
                return totalDigits;
            }
            case FRACTION_DIGITS: {
                return fractionDigits;
            }
            case LANG_RANGE: {
                return pattern;
            }
        }
        throw new OWLRuntimeException("Unsupported facet: " + f);
    }

    public static Facet parse(String in) {
        String f = '#' + in.substring(in.indexOf(58) + 1);
        for (Facet facet : values) {
            if (!facet.getURI().endsWith(f)) continue;
            return facet;
        }
        throw new OWLRuntimeException("Unsupported facet: " + f);
    }

    public static enum whitespace {
        PRESERVE{

            @Override
            public String normalize(@Nonnull String input) {
                return input;
            }
        }
        ,
        REPLACE{

            @Override
            public String normalize(@Nonnull String input) {
                return input.replace('\t', ' ').replace('\n', ' ').replace('\r', ' ');
            }
        }
        ,
        COLLAPSE{

            @Override
            public String normalize(@Nonnull String input) {
                StringBuilder b = new StringBuilder(REPLACE.normalize(input));
                for (int i = 0; i < b.length(); ++i) {
                    if (b.charAt(i) != ' ') continue;
                    while (i < b.length() - 1 && b.charAt(i + 1) == ' ') {
                        b.deleteCharAt(i + 1);
                    }
                }
                return b.toString();
            }
        };


        public abstract String normalize(String var1);
    }

    private static class LimitFacet
    extends AbstractFacet {
        public LimitFacet(String u) {
            super(u);
        }

        @Override
        public boolean isNumberFacet() {
            return true;
        }
    }

    private static abstract class AbstractFacet
    implements Facet,
    Serializable {
        protected final String uri;
        protected final String fragment;

        public AbstractFacet(String u) {
            this.uri = DatatypeFactory.getNamespace() + u;
            this.fragment = u;
        }

        @Override
        public String getURI() {
            return this.uri;
        }

        public String toString() {
            return "facet[" + this.fragment + ']';
        }

        public int hashCode() {
            return this.uri.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (super.equals(obj)) {
                return true;
            }
            if (obj instanceof Facet) {
                return this.uri.equals(((Facet)obj).getURI());
            }
            return false;
        }

        public Comparable parseNumber(@Nullable Object value) {
            if (!this.isNumberFacet()) {
                throw new UnsupportedOperationException("Only number facets can parse numbers");
            }
            if (value == null) {
                throw new IllegalArgumentException("Cannot parse a null value");
            }
            try {
                if (value instanceof String) {
                    return new BigDecimal((String)value);
                }
                if (value instanceof Number) {
                    return new BigDecimal(value.toString());
                }
                if (value instanceof Literal) {
                    Object typedValue = ((Literal)value).typedValue();
                    if (typedValue instanceof Number) {
                        return new BigDecimal(typedValue.toString());
                    }
                    if (typedValue instanceof Calendar) {
                        return (Comparable)typedValue;
                    }
                }
                if (value instanceof Comparable) {
                    return (Comparable)value;
                }
                return new BigDecimal(value.toString());
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Cannot parse '" + value.toString() + "' as a big decimal: " + e.getMessage());
            }
        }

        @Override
        public Comparable parse(Object o) {
            return (Comparable)o;
        }
    }
}

