/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import uk.ac.manchester.cs.jfact.datatypes.AbstractNumericDatatype;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.Utils;
import uk.ac.manchester.cs.jfact.datatypes.cardinality;

class FLOATDatatype
extends AbstractNumericDatatype<Float> {
    protected FLOATDatatype() {
        super((HasIRI)XSDVocabulary.FLOAT, DatatypeFactory.FACETS4, Utils.generateAncestors(DatatypeFactory.LITERAL));
        this.knownNonNumericFacetValues.putAll(DatatypeFactory.LITERAL.getKnownNonNumericFacetValues());
        this.knownNumericFacetValues.putAll(DatatypeFactory.LITERAL.getKnownNumericFacetValues());
        this.knownNonNumericFacetValues.put(Facets.whiteSpace, DatatypeFactory.WHITESPACE);
    }

    @Override
    public boolean getBounded() {
        return true;
    }

    @Override
    public cardinality getCardinality() {
        return cardinality.FINITE;
    }

    @Override
    public boolean getNumeric() {
        return true;
    }

    @Override
    public Float parseValue(String s) {
        String trim = s.trim();
        if ("-INF".equals(trim)) {
            return Float.valueOf(Float.NEGATIVE_INFINITY);
        }
        if ("INF".equals(trim)) {
            return Float.valueOf(Float.POSITIVE_INFINITY);
        }
        return Float.valueOf(s);
    }

    @Override
    public boolean isCompatible(Datatype<?> type) {
        if (type.isExpression()) {
            type = type.asExpression().getHostType();
        }
        return type.equals(this) || type.equals(DatatypeFactory.LITERAL) || type.isSubType(this) || this.isSubType(type);
    }

    @Override
    public boolean emptyValueSpace() {
        if (!this.hasMin() || !this.hasMax()) {
            return false;
        }
        if (this.hasMaxExclusive() && this.hasMinExclusive()) {
            if (((Float)this.getMin()).compareTo((Float)this.getMax()) == 0) {
                return true;
            }
            return ((Float)this.getMax()).compareTo((Float)DatatypeFactory.increase((Number)this.getMin())) < 0;
        }
        return ((Float)this.getMax()).compareTo((Float)this.getMin()) < 0;
    }
}

