/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import conformance.Original;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.manchester.cs.jfact.datatypes.ANYURIDatatype;
import uk.ac.manchester.cs.jfact.datatypes.BASE64BINARYDatatype;
import uk.ac.manchester.cs.jfact.datatypes.BOOLEANDatatype;
import uk.ac.manchester.cs.jfact.datatypes.BYTEDatatype;
import uk.ac.manchester.cs.jfact.datatypes.DATETIMEDatatype;
import uk.ac.manchester.cs.jfact.datatypes.DATETIMESTAMPDatatype;
import uk.ac.manchester.cs.jfact.datatypes.DECIMALDatatype;
import uk.ac.manchester.cs.jfact.datatypes.DOUBLEDatatype;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.FLOATDatatype;
import uk.ac.manchester.cs.jfact.datatypes.Facet;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.HEXBINARYDatatype;
import uk.ac.manchester.cs.jfact.datatypes.INTDatatype;
import uk.ac.manchester.cs.jfact.datatypes.INTEGERDatatype;
import uk.ac.manchester.cs.jfact.datatypes.LANGUAGEDatatype;
import uk.ac.manchester.cs.jfact.datatypes.LITERALDatatype;
import uk.ac.manchester.cs.jfact.datatypes.LONGDatatype;
import uk.ac.manchester.cs.jfact.datatypes.NAMEDatatype;
import uk.ac.manchester.cs.jfact.datatypes.NCNAMEDatatype;
import uk.ac.manchester.cs.jfact.datatypes.NEGATIVEINTEGERDatatype;
import uk.ac.manchester.cs.jfact.datatypes.NMTOKENDatatype;
import uk.ac.manchester.cs.jfact.datatypes.NMTOKENSDatatype;
import uk.ac.manchester.cs.jfact.datatypes.NONNEGATIVEINTEGERDatatype;
import uk.ac.manchester.cs.jfact.datatypes.NONPOSITIVEINTEGERDatatype;
import uk.ac.manchester.cs.jfact.datatypes.NORMALIZEDSTRINGDatatype;
import uk.ac.manchester.cs.jfact.datatypes.NumericDatatype;
import uk.ac.manchester.cs.jfact.datatypes.PLAINLITERALDatatype;
import uk.ac.manchester.cs.jfact.datatypes.POSITIVEINTEGERDatatype;
import uk.ac.manchester.cs.jfact.datatypes.RATIONALDatatype;
import uk.ac.manchester.cs.jfact.datatypes.REALDatatype;
import uk.ac.manchester.cs.jfact.datatypes.SHORTDatatype;
import uk.ac.manchester.cs.jfact.datatypes.STRINGDatatype;
import uk.ac.manchester.cs.jfact.datatypes.TOKENDatatype;
import uk.ac.manchester.cs.jfact.datatypes.UNSIGNEDINTDatatype;
import uk.ac.manchester.cs.jfact.datatypes.UNSIGNEDLONGDatatype;
import uk.ac.manchester.cs.jfact.datatypes.UNSIGNEDSHORTDatatype;
import uk.ac.manchester.cs.jfact.datatypes.UnsignedByteForShort;
import uk.ac.manchester.cs.jfact.datatypes.Utils;
import uk.ac.manchester.cs.jfact.datatypes.XMLLITERALDatatype;

@Original
public class DatatypeFactory
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatatypeFactory.class);
    static final String NAMESPACE = "http://www.w3.org/2001/XMLSchema#";
    protected static final Comparable NUMBER_EXPRESSION = "[\\-+]?[0-9]+";
    @Nonnull
    protected static final Comparable WHITESPACE = Facets.whitespace.COLLAPSE;
    @Nonnull
    protected static final Facet[] MINMAX = new Facet[]{Facets.maxInclusive, Facets.maxExclusive, Facets.minInclusive, Facets.minExclusive};
    @Nonnull
    protected static final Facet[] PEW = new Facet[]{Facets.pattern, Facets.enumeration, Facets.whiteSpace};
    @Nonnull
    protected static final Facet[] LEN = new Facet[]{Facets.length, Facets.minLength, Facets.maxLength};
    @Nonnull
    protected static final Facet[] DIGS = new Facet[]{Facets.totalDigits, Facets.fractionDigits};
    @Nonnull
    protected static final Set<Facet> STRINGFACETS = Utils.getFacets(new Facet[][]{PEW, LEN});
    @Nonnull
    protected static final Set<Facet> FACETS4 = Utils.getFacets(new Facet[][]{PEW, MINMAX});
    @Nonnull
    public static final Datatype<String> LITERAL = new LITERALDatatype();
    @Nonnull
    public static final Datatype<String> ANYURI = new ANYURIDatatype();
    @Nonnull
    public static final Datatype<String> BASE64BINARY = new BASE64BINARYDatatype();
    @Nonnull
    public static final Datatype<Boolean> BOOLEAN = new BOOLEANDatatype();
    @Nonnull
    public static final Datatype<Date> DATETIME = new DATETIMEDatatype();
    @Nonnull
    public static final Datatype<String> HEXBINARY = new HEXBINARYDatatype();
    @Nonnull
    public static final Datatype<String> PLAINLITERAL = new PLAINLITERALDatatype();
    @Nonnull
    public static final Datatype<String> STRING = new STRINGDatatype();
    @Nonnull
    public static final NumericDatatype<BigDecimal> REAL = new REALDatatype<BigDecimal>();
    @Nonnull
    public static final NumericDatatype<BigDecimal> RATIONAL = new RATIONALDatatype<BigDecimal>();
    @Nonnull
    public static final Datatype<Date> DATETIMESTAMP = new DATETIMESTAMPDatatype();
    @Nonnull
    public static final NumericDatatype<BigDecimal> DECIMAL = new DECIMALDatatype<BigDecimal>();
    @Nonnull
    public static final NumericDatatype<BigInteger> INTEGER = new INTEGERDatatype<BigInteger>();
    @Nonnull
    public static final NumericDatatype<Double> DOUBLE = new DOUBLEDatatype();
    @Nonnull
    public static final NumericDatatype<Float> FLOAT = new FLOATDatatype();
    @Nonnull
    public static final NumericDatatype<BigInteger> NONPOSITIVEINTEGER = new NONPOSITIVEINTEGERDatatype<BigInteger>();
    @Nonnull
    public static final NumericDatatype<BigInteger> NEGATIVEINTEGER = new NEGATIVEINTEGERDatatype<BigInteger>();
    @Nonnull
    public static final NumericDatatype<BigInteger> NONNEGATIVEINTEGER = new NONNEGATIVEINTEGERDatatype<BigInteger>();
    @Nonnull
    public static final NumericDatatype<BigInteger> POSITIVEINTEGER = new POSITIVEINTEGERDatatype<BigInteger>();
    @Nonnull
    public static final NumericDatatype<Long> LONG = new LONGDatatype<Long>();
    @Nonnull
    public static final NumericDatatype<Integer> INT = new INTDatatype<Integer>();
    @Nonnull
    public static final NumericDatatype<Short> SHORT = new SHORTDatatype<Short>();
    @Nonnull
    public static final NumericDatatype<Byte> BYTE = new BYTEDatatype();
    @Nonnull
    public static final NumericDatatype<BigInteger> UNSIGNEDLONG = new UNSIGNEDLONGDatatype<BigInteger>();
    @Nonnull
    public static final NumericDatatype<Long> UNSIGNEDINT = new UNSIGNEDINTDatatype<Long>();
    @Nonnull
    public static final NumericDatatype<Integer> UNSIGNEDSHORT = new UNSIGNEDSHORTDatatype<Integer>();
    @Nonnull
    public static final NumericDatatype<Short> UNSIGNEDBYTE = new UnsignedByteForShort();
    @Nonnull
    public static final Datatype<String> NORMALIZEDSTRING = new NORMALIZEDSTRINGDatatype();
    @Nonnull
    public static final Datatype<String> TOKEN = new TOKENDatatype();
    @Nonnull
    public static final Datatype<String> LANGUAGE = new LANGUAGEDatatype();
    @Nonnull
    public static final Datatype<String> NAME = new NAMEDatatype();
    @Nonnull
    public static final Datatype<String> NCNAME = new NCNAMEDatatype();
    @Nonnull
    public static final Datatype<String> NMTOKEN = new NMTOKENDatatype();
    @Nonnull
    public static final Datatype<String> NMTOKENS = new NMTOKENSDatatype();
    @Nonnull
    public static final Datatype<String> XMLLITERAL = new XMLLITERALDatatype();
    private static final List<Datatype<?>> values = DatatypeFactory.getList();
    private final Map<IRI, Datatype<?>> knownDatatypes = new HashMap();
    private static int uriIndex = 0;

    private DatatypeFactory() {
        values.forEach(d -> this.knownDatatypes.put(d.getDatatypeIRI(), (Datatype<?>)d));
        this.knownDatatypes.put(XSDVocabulary.DATE.getIRI(), DATETIME);
    }

    private static List<Datatype<?>> getList() {
        ArrayList<Datatype<Object>> toReturn = new ArrayList<Datatype<Object>>();
        toReturn.add(ANYURI);
        toReturn.add(BASE64BINARY);
        toReturn.add(BOOLEAN);
        toReturn.add(DATETIME);
        toReturn.add(HEXBINARY);
        toReturn.add(LITERAL);
        toReturn.add(PLAINLITERAL);
        toReturn.add(REAL);
        toReturn.add(STRING);
        toReturn.add(DATETIMESTAMP);
        toReturn.add(DECIMAL);
        toReturn.add(DOUBLE);
        toReturn.add(FLOAT);
        toReturn.add(BYTE);
        toReturn.add(INT);
        toReturn.add(INTEGER);
        toReturn.add(LONG);
        toReturn.add(NEGATIVEINTEGER);
        toReturn.add(NONNEGATIVEINTEGER);
        toReturn.add(NONPOSITIVEINTEGER);
        toReturn.add(POSITIVEINTEGER);
        toReturn.add(SHORT);
        toReturn.add(UNSIGNEDBYTE);
        toReturn.add(UNSIGNEDINT);
        toReturn.add(UNSIGNEDLONG);
        toReturn.add(UNSIGNEDSHORT);
        toReturn.add(RATIONAL);
        toReturn.add(LANGUAGE);
        toReturn.add(NAME);
        toReturn.add(NCNAME);
        toReturn.add(NMTOKEN);
        toReturn.add(NMTOKENS);
        toReturn.add(NORMALIZEDSTRING);
        toReturn.add(TOKEN);
        toReturn.add(XMLLITERAL);
        return Collections.unmodifiableList(toReturn);
    }

    public static List<Datatype<?>> getValues() {
        return values;
    }

    public Collection<Datatype<?>> getKnownDatatypes() {
        return new ArrayList(this.knownDatatypes.values());
    }

    static HasIRI getIndex(String prefix) {
        return () -> IRI.create((String)(prefix + uriIndex++));
    }

    public <R extends Comparable<R>> Datatype<R> getKnownDatatype(IRI key) {
        Datatype<?> datatype = this.knownDatatypes.get(key);
        if (datatype != null) {
            return datatype;
        }
        String iriString = key.toString();
        if (iriString.startsWith("xsd:")) {
            String name = iriString.substring(4);
            for (XSDVocabulary v : XSDVocabulary.values()) {
                if (!v.getShortForm().equals(name)) continue;
                datatype = this.knownDatatypes.get(v.getIRI());
                if (datatype == null) {
                    LOGGER.error("A known datatype for {} cannot be found; literal will be replaced with rdfs:Literal", (Object)iriString);
                    this.knownDatatypes.put(key, LITERAL);
                    return LITERAL;
                }
                return datatype;
            }
        }
        LOGGER.error("A known datatype for {} cannot be found; literal will be replaced with rdfs:Literal", (Object)iriString);
        this.knownDatatypes.put(key, LITERAL);
        return LITERAL;
    }

    public boolean isKnownDatatype(IRI key) {
        return this.knownDatatypes.containsKey(key);
    }

    public static DatatypeFactory getInstance() {
        return new DatatypeFactory();
    }

    public static boolean intervalWithValues(@Nullable Comparable min, @Nullable Comparable max, int excluded) {
        if (min == null) {
            return true;
        }
        if (max == null) {
            return true;
        }
        int comparison = min.compareTo(max);
        if (excluded == 0) {
            return comparison <= 0;
        }
        if (excluded == 1) {
            return comparison < 0;
        }
        if (excluded == 2) {
            Comparable increased = DatatypeFactory.increase((Number)((Object)min));
            int compareTo = increased.compareTo(max);
            return compareTo < 0;
        }
        return false;
    }

    @Nullable
    public static Comparable increase(Number v) {
        if (v instanceof Float) {
            return Float.valueOf(v.floatValue() + Float.MIN_NORMAL);
        }
        if (v instanceof BigDecimal) {
            return ((BigDecimal)v).add(((BigDecimal)v).ulp());
        }
        if (v instanceof BigInteger) {
            return ((BigInteger)v).add(BigInteger.ONE);
        }
        if (v instanceof Double) {
            return Double.valueOf(v.doubleValue() + Double.MIN_NORMAL);
        }
        if (v instanceof Byte) {
            int i = v.byteValue() + 1;
            return Byte.valueOf((byte)i);
        }
        if (v instanceof Integer) {
            return Integer.valueOf(v.intValue() + 1);
        }
        if (v instanceof Long) {
            return Long.valueOf(v.longValue() + 1L);
        }
        if (v instanceof Short) {
            int i = v.shortValue() + 1;
            return Short.valueOf((short)i);
        }
        if (v instanceof AtomicInteger) {
            return Integer.valueOf(((AtomicInteger)v).get() + 1);
        }
        if (v instanceof AtomicLong) {
            return Long.valueOf(((AtomicLong)v).get() + 1L);
        }
        return null;
    }

    public static String getNamespace() {
        return NAMESPACE;
    }
}

