/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.jfact.datatypes.DataTypeReasoner;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeClashes;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeEnumeration;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeExpression;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeNegation;
import uk.ac.manchester.cs.jfact.datatypes.Facet;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.dep.DepSet;

public class DataTypeSituation<R extends Comparable<R>>
implements Serializable {
    private DepSet pType;
    private DepSet nType;
    private Set<DepInterval<R>> constraints = new HashSet<DepInterval<R>>();
    private final DepSet accDep = DepSet.create();
    private final DataTypeReasoner reasoner;
    @Nonnull
    private final Datatype<R> type;
    private final List<Literal<?>> literals = new ArrayList();

    protected DataTypeSituation(Datatype<R> p, DataTypeReasoner dep) {
        this.type = (Datatype)OWLAPIPreconditions.checkNotNull(p);
        this.reasoner = dep;
        this.constraints.add(new DepInterval());
    }

    private boolean addUpdatedInterval(DepInterval<R> i, Datatype<R> interval, DepSet localDep) {
        if (!i.consistent(interval)) {
            localDep.add(i.locDep);
            this.reasoner.reportClash(localDep, DatatypeClashes.DT_C_IT);
            return true;
        }
        if (!(i.update(interval, localDep) && this.hasPType() && i.checkMinMaxClash())) {
            this.constraints.add(i);
        } else {
            this.accDep.add(i.locDep);
        }
        return false;
    }

    public Datatype<?> getType() {
        return this.type;
    }

    public boolean addInterval(Datatype<R> interval, DepSet dep) {
        if (interval.emptyValueSpace()) {
            this.reasoner.reportClash(this.accDep, DatatypeClashes.DT_EMPTY_INTERVAL);
            return true;
        }
        if (interval instanceof DatatypeEnumeration) {
            this.literals.addAll(interval.listValues());
        }
        Set<DepInterval<R>> c = this.constraints;
        this.constraints = new HashSet<DepInterval<R>>();
        if (c.stream().anyMatch(d -> this.addUpdatedInterval((DepInterval<R>)d, interval, dep))) {
            return true;
        }
        if (this.constraints.isEmpty()) {
            this.reasoner.reportClash(this.accDep, DatatypeClashes.DT_C_MM);
            return true;
        }
        return false;
    }

    public boolean checkPNTypeClash() {
        if (this.hasNType() && this.hasPType() && this.getNType().equals(this.getPType())) {
            this.reasoner.reportClash(this.pType, this.nType, DatatypeClashes.DT_TNT);
            return true;
        }
        for (DepInterval<R> d : this.constraints) {
            if (!d.checkMinMaxClash()) continue;
            this.accDep.add(d.locDep);
            this.reasoner.reportClash(this.accDep, DatatypeClashes.DT_C_MM);
            return true;
        }
        return false;
    }

    private boolean emptyConstraints() {
        return this.constraints.isEmpty() || this.constraints.iterator().next().e == null;
    }

    public boolean checkCompatibleValue(DataTypeSituation<?> other) {
        if (this.type.equals(DatatypeFactory.LITERAL) && this.emptyConstraints() || other.type.equals(DatatypeFactory.LITERAL) && super.emptyConstraints()) {
            return true;
        }
        if (this.incompatible(other)) {
            return false;
        }
        if (this.emptyConstraints() && super.emptyConstraints()) {
            return true;
        }
        if (other.literals.isEmpty() && super.emptyConstraints()) {
            return true;
        }
        if (this.literals.isEmpty() && this.emptyConstraints()) {
            return true;
        }
        ArrayList allLiterals = new ArrayList(this.literals);
        allLiterals.addAll(other.literals);
        ArrayList allRestrictions = new ArrayList();
        other.constraints.stream().filter(d -> d.e != null).forEach(d -> allRestrictions.add(d.e));
        this.constraints.stream().filter(d -> d.e != null).forEach(d -> allRestrictions.add(d.e));
        boolean toReturn = this.compareLiterals(other, allLiterals, allRestrictions);
        if (this.hasNType() == other.hasNType() || this.hasPType() == other.hasPType()) {
            return toReturn;
        }
        if (!allRestrictions.isEmpty()) {
            return toReturn;
        }
        return !toReturn;
    }

    protected boolean incompatible(DataTypeSituation<?> other) {
        return !this.type.isCompatible(other.type);
    }

    private boolean compareLiterals(DataTypeSituation<?> other, List<Literal<?>> allLiterals, List<Datatype<?>> allRestrictions) {
        for (Literal<?> l : allLiterals) {
            if (!this.type.isCompatible(l) || !other.type.isCompatible(l)) {
                return false;
            }
            for (Datatype<?> d : allRestrictions) {
                if (d.isCompatible(l)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasPType() {
        return this.pType != null;
    }

    public boolean hasNType() {
        return this.nType != null;
    }

    public void setPType(DepSet type) {
        this.pType = type;
    }

    public void setNType(DepSet t) {
        this.nType = t;
    }

    public DepSet getPType() {
        return this.pType;
    }

    public DepSet getNType() {
        return this.nType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ' ' + this.type + ' ' + this.constraints;
    }

    private boolean hasNoConstraints() {
        return this.constraints.isEmpty() || this.constraints.stream().allMatch(c -> c.e == null);
    }

    private boolean hasConstraints() {
        return !this.constraints.isEmpty() || this.constraints.stream().anyMatch(c -> c.e != null);
    }

    public boolean isSubType(DataTypeSituation<?> other) {
        if (this.incompatible(other)) {
            return false;
        }
        if (!this.type.isSubType(other.type)) {
            return false;
        }
        if (super.hasNoConstraints()) {
            return true;
        }
        if (this.type.equals(other.type) && this.hasConstraints()) {
            return false;
        }
        return this.constraints.stream().allMatch(c -> other.constraints.stream().allMatch(c1 -> c.consistent(c1.e)));
    }

    static class DepInterval<R extends Comparable<R>>
    implements Serializable {
        protected DatatypeExpression<R> e;
        protected DepSet locDep;

        DepInterval() {
        }

        public String toString() {
            return "depInterval{" + this.e + '}';
        }

        public boolean update(Datatype<R> value, @Nullable DepSet dep) {
            if (this.e == null) {
                this.e = value.isExpression() ? value.asExpression() : value.wrapAsDatatypeExpression();
                if (this.locDep == null) {
                    this.locDep = dep;
                } else if (dep != null) {
                    this.locDep.add(dep);
                }
                return false;
            }
            if (this.e instanceof DatatypeEnumeration || this.e instanceof DatatypeNegation) {
                return false;
            }
            value.getKnownNumericFacetValues().forEach((k, v) -> {
                this.e = this.e.addNumericFacet((Facet)k, (Comparable<?>)v);
            });
            value.getKnownNonNumericFacetValues().forEach((k, v) -> {
                this.e = this.e.addNonNumericFacet((Facet)k, (Comparable<?>)v);
            });
            if (this.locDep == null) {
                this.locDep = dep;
            } else if (dep != null) {
                this.locDep.add(dep);
            }
            return true;
        }

        public boolean updateable(Datatype<R> interval) {
            if (this.e == null) {
                return true;
            }
            if (this.e instanceof DatatypeNegation) {
                return false;
            }
            if (this.e instanceof DatatypeEnumeration && interval instanceof DatatypeEnumeration) {
                return true;
            }
            return true;
        }

        boolean consistent(@Nullable Datatype<?> type) {
            return this.e == null || type == null || this.e.isCompatible(type);
        }

        public boolean checkMinMaxClash() {
            if (this.e == null) {
                return false;
            }
            return this.e.emptyValueSpace();
        }

        public boolean equals(@Nullable Object obj) {
            if (super.equals(obj)) {
                return true;
            }
            if (obj instanceof DepInterval) {
                return (this.e == null ? ((DepInterval)obj).e == null : this.e.equals(((DepInterval)obj).e)) && this.locDep == null ? ((DepInterval)obj).locDep == null : this.locDep.equals(((DepInterval)obj).locDep);
            }
            return false;
        }

        public int hashCode() {
            return (this.e == null ? 0 : this.e.hashCode()) + (this.locDep == null ? 0 : this.locDep.hashCode());
        }
    }
}

