/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import uk.ac.manchester.cs.jfact.datatypes.DataTypeSituation;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeClashes;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeEntry;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeEnumeration;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeExpression;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeNumericEnumeration;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.datatypes.LiteralEntry;
import uk.ac.manchester.cs.jfact.dep.DepSet;
import uk.ac.manchester.cs.jfact.helpers.Templates;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.DagTag;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;

@PortedFrom(file="DataReasoning.h", name="DataTypeReasoner")
public final class DataTypeReasoner
implements Serializable {
    @PortedFrom(file="DataReasoning.h", name="Map")
    private final Map<Datatype<?>, DataTypeSituation<?>> map = new HashMap();
    @PortedFrom(file="DataReasoning.h", name="clashDep")
    private Optional<DepSet> clashDep = Optional.empty();
    @Original
    private final JFactReasonerConfiguration options;

    public DataTypeReasoner(JFactReasonerConfiguration config) {
        this.options = config;
    }

    @PortedFrom(file="DataReasoning.h", name="reportClash")
    public void reportClash(DepSet dep, DatatypeClashes reason) {
        this.options.getLog().print((Object)reason);
        this.clashDep = Optional.ofNullable(dep);
    }

    @PortedFrom(file="DataReasoning.h", name="reportClash")
    public void reportClash(DepSet dep1, DepSet dep2, DatatypeClashes reason) {
        this.reportClash(DepSet.plus(dep1, dep2), reason);
    }

    @PortedFrom(file="DataReasoning.h", name="registerDataType")
    private <R extends Comparable<R>> DataTypeSituation<R> getType(Datatype<R> datatype) {
        DataTypeSituation<Object> appearance = this.map.get(datatype);
        if (appearance != null) {
            return appearance;
        }
        appearance = new DataTypeSituation<R>(datatype, this);
        this.map.put(datatype, appearance);
        return appearance;
    }

    @Nullable
    @PortedFrom(file="DataReasoning.h", name="getClashSet")
    public DepSet getClashSet() {
        return this.clashDep.orElse(null);
    }

    @PortedFrom(file="DataReasoning.h", name="addDataEntry")
    public boolean addDataEntry(boolean positive, DagTag type, NamedEntry entry, DepSet dep) {
        switch (type) {
            case DATATYPE: {
                return this.dataType(positive, ((DatatypeEntry)entry).getDatatype(), dep);
            }
            case DATAVALUE: {
                return this.dataValue(positive, ((LiteralEntry)entry).getLiteral(), dep);
            }
            case DATAEXPR: {
                return this.dataExpression(positive, ((DatatypeEntry)entry).getDatatype().asExpression(), dep);
            }
            case AND: {
                return false;
            }
        }
        throw new UnreachableSituationException(type.toString());
    }

    @Original
    private <R extends Comparable<R>> boolean dataExpression(boolean positive, DatatypeExpression<R> c, DepSet dep) {
        Datatype<R> typeToIndex = c.getHostType();
        if (c instanceof DatatypeEnumeration) {
            typeToIndex = c;
        }
        DataTypeSituation<R> type = this.getType(typeToIndex);
        if (positive) {
            type.setPType(dep);
        } else {
            type.setNType(dep);
        }
        if (this.options.isLoggingActive()) {
            this.options.getLog().printTemplate(Templates.INTERVAL, positive ? "+" : "-", c, "", "", "");
        }
        return type.addInterval(c, dep);
    }

    @Original
    private <R extends Comparable<R>> boolean dataType(boolean positive, Datatype<R> c, DepSet dep) {
        if (this.options.isLoggingActive()) {
            this.options.getLog().printTemplate(Templates.INTERVAL, positive ? "+" : "-", c, "", "", "");
        }
        if (positive) {
            this.getType(c).setPType(dep);
        } else {
            this.getType(c).setNType(dep);
        }
        return false;
    }

    @PortedFrom(file="DataReasoning.h", name="dataValue")
    private <R extends Comparable<R>> boolean dataValue(boolean positive, Literal<R> c1, DepSet dep) {
        Datatype<R> d = c1.getDatatypeExpression();
        DatatypeEnumeration interval = d.isNumericDatatype() ? new DatatypeNumericEnumeration<R>(d.asNumericDatatype(), c1) : new DatatypeEnumeration<R>(d, c1);
        this.options.getLog().printTemplate(Templates.INTERVAL, positive ? "+" : "-", interval, "", "", "");
        return this.dataExpression(positive, interval, dep);
    }

    @PortedFrom(file="DataReasoning.h", name="checkClash")
    public boolean checkClash() {
        int size = this.map.size();
        if (size == 0) {
            return false;
        }
        if (size == 1) {
            return this.map.values().iterator().next().checkPNTypeClash();
        }
        ArrayList types = new ArrayList(this.map.values());
        if (this.findClash(types)) {
            return true;
        }
        for (int i = 0; i < size; ++i) {
            DataTypeSituation a = (DataTypeSituation)types.get(i);
            for (int j = i + 1; j < size; ++j) {
                boolean notACompatibleB;
                boolean bSubtypeA;
                boolean aSubtypeB;
                DataTypeSituation b = (DataTypeSituation)types.get(j);
                boolean p1 = a.hasPType();
                boolean n1 = a.hasNType();
                boolean p2 = b.hasPType();
                boolean n2 = b.hasNType();
                if (this.findClash(p1, n2, p2, n1, aSubtypeB = a.isSubType(b), bSubtypeA = b.isSubType(a), a.getPType(), b.getNType())) {
                    return true;
                }
                boolean notBCompatibleA = !b.checkCompatibleValue(a);
                boolean bl = notACompatibleB = !a.checkCompatibleValue(b);
                if (aSubtypeB && this.findClash(aSubtypeB, a.getPType(), b.getNType(), notBCompatibleA)) {
                    return true;
                }
                if (bSubtypeA && this.findClash(bSubtypeA, a.getPType(), b.getNType(), notACompatibleB)) {
                    return true;
                }
                if (!this.findClash(p1, p2, a.getType(), b.getType(), a.getPType(), b.getPType(), notBCompatibleA, notACompatibleB)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean findClash(boolean p1, boolean p2, Datatype<?> t1, Datatype<?> t2, DepSet pType1, DepSet pType2, boolean not12, boolean not21) {
        if (p1 && p2) {
            if (not12 || not21) {
                this.reportClash(pType1, pType2, DatatypeClashes.DT_TT);
                return true;
            }
            if (t1.equals(DatatypeFactory.NONNEGATIVEINTEGER) && t2.equals(DatatypeFactory.NONPOSITIVEINTEGER) || t2.equals(DatatypeFactory.NONNEGATIVEINTEGER) && t1.equals(DatatypeFactory.NONPOSITIVEINTEGER)) {
                this.map.remove(t1);
                this.map.remove(t2);
                DatatypeEnumeration<BigInteger> enumeration = new DatatypeEnumeration<BigInteger>(DatatypeFactory.INTEGER, Collections.singletonList(DatatypeFactory.INTEGER.buildLiteral("0")));
                this.dataExpression(true, enumeration, DepSet.plus(pType1, pType2));
                return this.checkClash();
            }
        }
        return false;
    }

    private boolean findClash(boolean p1, boolean n2, boolean p2, boolean n1, boolean t1subTypet2, boolean t2subTypet1, DepSet pType1, DepSet nType2) {
        if (t1subTypet2 && p1 && n2 || t2subTypet1 && p2 && n1) {
            this.reportClash(pType1, nType2, DatatypeClashes.DT_TT);
            return true;
        }
        return false;
    }

    private boolean findClash(boolean t2subTypet1, DepSet pType1, DepSet nType2, boolean not12) {
        if (t2subTypet1 && not12) {
            this.reportClash(pType1, nType2, DatatypeClashes.DT_TT);
            return true;
        }
        return false;
    }

    private boolean findClash(List<DataTypeSituation<?>> types) {
        Optional<DataTypeSituation> findAny = types.stream().filter(p -> p.checkPNTypeClash()).findAny();
        if (findAny.isPresent()) {
            this.reportClash(findAny.get().getPType(), findAny.get().getNType(), DatatypeClashes.DT_TT);
            return true;
        }
        return false;
    }
}

