/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import uk.ac.manchester.cs.jfact.datatypes.AbstractNumericDatatype;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facet;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.Utils;
import uk.ac.manchester.cs.jfact.datatypes.cardinality;

class DOUBLEDatatype
extends AbstractNumericDatatype<Double> {
    DOUBLEDatatype() {
        super((HasIRI)XSDVocabulary.DOUBLE, Utils.getFacets(new Facet[][]{DatatypeFactory.PEW, DatatypeFactory.MINMAX}), Utils.generateAncestors(DatatypeFactory.LITERAL));
        this.knownNonNumericFacetValues.putAll(DatatypeFactory.LITERAL.getKnownNonNumericFacetValues());
        this.knownNumericFacetValues.putAll(DatatypeFactory.LITERAL.getKnownNumericFacetValues());
        this.knownNonNumericFacetValues.put(Facets.whiteSpace, DatatypeFactory.WHITESPACE);
    }

    @Override
    public boolean getBounded() {
        return true;
    }

    @Override
    public cardinality getCardinality() {
        return cardinality.FINITE;
    }

    @Override
    public boolean getNumeric() {
        return true;
    }

    @Override
    public Double parseValue(String s) {
        return Double.valueOf(s);
    }

    @Override
    public boolean isCompatible(Datatype<?> type) {
        if (type.isExpression()) {
            type = type.asExpression().getHostType();
        }
        return type.equals(this) || type.equals(DatatypeFactory.LITERAL) || type.isSubType(this) || this.isSubType(type);
    }
}

