/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.util.Date;
import java.util.Set;
import javax.annotation.Nullable;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import uk.ac.manchester.cs.jfact.datatypes.AbstractDatatype;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.OrderedDatatype;
import uk.ac.manchester.cs.jfact.datatypes.Utils;
import uk.ac.manchester.cs.jfact.datatypes.ordered;

class DATETIMEDatatype
extends AbstractDatatype<Date>
implements OrderedDatatype<Date> {
    DATETIMEDatatype() {
        this((HasIRI)XSDVocabulary.DATE_TIME);
    }

    DATETIMEDatatype(HasIRI u, Set<Datatype<?>> ancestors) {
        super(u, DatatypeFactory.FACETS4, ancestors);
    }

    DATETIMEDatatype(HasIRI u) {
        super(u, DatatypeFactory.FACETS4, Utils.generateAncestors(DatatypeFactory.LITERAL));
        this.knownNonNumericFacetValues.putAll(DatatypeFactory.LITERAL.getKnownNonNumericFacetValues());
        this.knownNumericFacetValues.putAll(DatatypeFactory.LITERAL.getKnownNumericFacetValues());
        this.knownNonNumericFacetValues.put(Facets.whiteSpace, DatatypeFactory.WHITESPACE);
    }

    @Override
    public ordered getOrdered() {
        return ordered.PARTIAL;
    }

    @Override
    public boolean isOrderedDatatype() {
        return true;
    }

    @Override
    public OrderedDatatype<Date> asOrderedDatatype() {
        return this;
    }

    @Override
    public Date parseValue(String s) {
        try {
            XMLGregorianCalendar cal = javax.xml.datatype.DatatypeFactory.newInstance().newXMLGregorianCalendar(s);
            return cal.normalize().toGregorianCalendar().getTime();
        }
        catch (DatatypeConfigurationException e) {
            throw new ReasonerInternalException((Throwable)e);
        }
    }

    @Override
    public boolean isInValueSpace(Date l) {
        if (this.hasMinExclusive() && this.getMin().compareTo(l) <= 0) {
            return false;
        }
        if (this.hasMinInclusive() && this.getMin().compareTo(l) < 0) {
            return false;
        }
        if (this.hasMaxExclusive() && this.getMax().compareTo(l) >= 0) {
            return false;
        }
        return !this.hasMaxInclusive() || this.getMax().compareTo(l) <= 0;
    }

    @Override
    public boolean isCompatible(Datatype<?> type) {
        if (super.isCompatible(type)) {
            return true;
        }
        if (type.isSubType(this)) {
            OrderedDatatype wrapper = (OrderedDatatype)((Object)type);
            if (!this.hasMax() && !this.hasMin()) {
                return true;
            }
            if (!wrapper.hasMax() && !wrapper.hasMin()) {
                return true;
            }
            if (!this.hasMax() && !wrapper.hasMax()) {
                return true;
            }
            if (!this.hasMin() && !wrapper.hasMin()) {
                return true;
            }
            if (!this.hasMin()) {
                return this.overlapping(this, wrapper);
            }
            if (!this.hasMax()) {
                return this.overlapping(wrapper, this);
            }
            if (!wrapper.hasMin()) {
                return this.overlapping(wrapper, this);
            }
            if (!wrapper.hasMax()) {
                return this.overlapping(this, wrapper);
            }
            return this.overlapping(this, wrapper) || this.overlapping(wrapper, this);
        }
        return false;
    }

    @Override
    public boolean hasMinExclusive() {
        return this.knownNumericFacetValues.containsKey(Facets.minExclusive);
    }

    @Override
    public boolean hasMinInclusive() {
        return this.knownNumericFacetValues.containsKey(Facets.minInclusive);
    }

    @Override
    public boolean hasMaxExclusive() {
        return this.knownNumericFacetValues.containsKey(Facets.maxExclusive);
    }

    @Override
    public boolean hasMaxInclusive() {
        return this.knownNumericFacetValues.containsKey(Facets.maxInclusive);
    }

    @Override
    public boolean hasMin() {
        return this.hasMinInclusive() || this.hasMinExclusive();
    }

    @Override
    public boolean hasMax() {
        return this.hasMaxInclusive() || this.hasMaxExclusive();
    }

    @Override
    @Nullable
    public Date getMin() {
        if (this.hasMinExclusive()) {
            return (Date)this.getFacetValue(Facets.minExclusive);
        }
        if (this.hasMinInclusive()) {
            return (Date)this.getFacetValue(Facets.minInclusive);
        }
        return null;
    }

    @Override
    @Nullable
    public Date getMax() {
        if (this.hasMaxExclusive()) {
            return (Date)this.getFacetValue(Facets.maxExclusive);
        }
        if (this.hasMaxInclusive()) {
            return (Date)this.getFacetValue(Facets.maxInclusive);
        }
        return null;
    }
}

