/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.net.URI;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import uk.ac.manchester.cs.jfact.datatypes.AbstractDatatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.Utils;

class ANYURIDatatype
extends AbstractDatatype<String> {
    ANYURIDatatype() {
        super((HasIRI)XSDVocabulary.ANY_URI, DatatypeFactory.STRINGFACETS, Utils.generateAncestors(DatatypeFactory.LITERAL));
        this.knownNonNumericFacetValues.putAll(DatatypeFactory.LITERAL.getKnownNonNumericFacetValues());
        this.knownNumericFacetValues.putAll(DatatypeFactory.LITERAL.getKnownNumericFacetValues());
        this.knownNonNumericFacetValues.put(Facets.whiteSpace, DatatypeFactory.WHITESPACE);
    }

    @Override
    public String parseValue(String s) {
        return Facets.whitespace.COLLAPSE.normalize(s);
    }

    @Override
    public boolean isInValueSpace(String l) {
        try {
            URI.create(l);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

