/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTreeArc;
import uk.ac.manchester.cs.jfact.kernel.ExpressionCache;
import uk.ac.manchester.cs.jfact.kernel.Individual;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.TBox;
import uk.ac.manchester.cs.jfact.kernel.TDag2Interface;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptName;
import uk.ac.manchester.cs.jfact.kernel.dl.IndividualName;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.NamedEntity;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;

@PortedFrom(file="KnowledgeExplorer.h", name="KnowledgeExplorer")
public class KnowledgeExplorer
implements Serializable {
    @PortedFrom(file="KnowledgeExplorer.h", name="Cs")
    private final Multimap<NamedEntity, Concept> cs = LinkedHashMultimap.create();
    @PortedFrom(file="KnowledgeExplorer.h", name="Is")
    private final Multimap<NamedEntity, Individual> is = LinkedHashMultimap.create();
    @PortedFrom(file="KnowledgeExplorer.h", name="ORs")
    private final Multimap<NamedEntity, Role> ors = LinkedHashMultimap.create();
    @PortedFrom(file="KnowledgeExplorer.h", name="DRs")
    private final Multimap<NamedEntity, Role> drs = LinkedHashMultimap.create();
    @PortedFrom(file="KnowledgeExplorer.h", name="D2I")
    private final TDag2Interface d2i;
    @PortedFrom(file="KnowledgeExplorer.h", name="Nodes")
    private final List<DlCompletionTree> nodes = new ArrayList<DlCompletionTree>();
    @PortedFrom(file="KnowledgeExplorer.h", name="Concepts")
    private final List<Expression> concepts = new ArrayList<Expression>();

    public KnowledgeExplorer(TBox box, ExpressionCache pEM) {
        this.d2i = new TDag2Interface(box.getDag(), pEM);
        box.getConcepts().forEach(c -> this.addConceptsAndIndividuals(this.cs, c));
        box.individuals().forEach(i -> this.addConceptsAndIndividuals(this.is, i));
        box.getORM().getRoles().forEach(r -> this.addRoles(this.ors, (Role)r));
        box.getDRM().getRoles().forEach(r -> this.addRoles(this.drs, (Role)r));
    }

    @PortedFrom(file="KnowledgeExplorer.h", name="addE")
    private static <E extends ClassifiableEntry> void addE(Multimap<E, E> map, E entry) {
        map.put(entry, entry);
        if (entry.isSynonym()) {
            map.put((Object)entry.getSynonym(), entry);
        }
    }

    <T extends ClassifiableEntry> void addConceptsAndIndividuals(Multimap<NamedEntity, T> m, T t) {
        m.put((Object)t.getEntity(), t);
        if (t.isSynonym()) {
            m.put((Object)t.getSynonym().getEntity(), t);
        }
    }

    void addRoles(Multimap<NamedEntity, Role> m, Role t) {
        m.put((Object)t.getEntity(), (Object)t);
        if (t.isSynonym()) {
            m.put((Object)t.getSynonym().getEntity(), (Object)t);
        }
        m.putAll((Object)t.getEntity(), t.getAncestor());
    }

    @PortedFrom(file="KnowledgeExplorer.h", name="addC")
    private void addC(Expression e) {
        if (e instanceof ConceptName) {
            this.cs.get((Object)((ConceptName)e)).forEach(p -> this.concepts.add(this.d2i.getCExpr(p.getId())));
            return;
        }
        if (e instanceof IndividualName) {
            this.is.get((Object)((IndividualName)e)).forEach(p -> this.concepts.add(this.d2i.getCExpr(p.getId())));
            return;
        }
        this.concepts.add(e);
    }

    @PortedFrom(file="KnowledgeExplorer.h", name="getDataRoles")
    public Set<DataRoleExpression> getDataRoles(DlCompletionTree node, boolean onlyDet) {
        return OWLAPIStreamUtils.asSet(node.getNeighbour().stream().filter(p -> this.notBlockedData(onlyDet, (DlCompletionTreeArc)p)).flatMap(p -> this.drs.get((Object)p.getRole().getEntity()).stream()).map(r -> (DataRoleExpression)this.d2i.getDataRoleExpression((Role)r)));
    }

    protected boolean notBlockedData(boolean onlyDet, DlCompletionTreeArc p) {
        return !p.isIBlocked() && p.getArcEnd().isDataNode() && (!onlyDet || p.getDep().isEmpty());
    }

    @PortedFrom(file="KnowledgeExplorer.h", name="getObjectRoles")
    public Set<ObjectRoleExpression> getObjectRoles(DlCompletionTree node, boolean onlyDet, boolean needIncoming) {
        return OWLAPIStreamUtils.asSet(node.getNeighbour().stream().filter(p -> this.notBlockedNotData(onlyDet, needIncoming, (DlCompletionTreeArc)p)).flatMap(p -> this.ors.get((Object)p.getRole().getEntity()).stream()).map(r -> (ObjectRoleExpression)this.d2i.getObjectRoleExpression((Role)r)));
    }

    protected boolean notBlockedNotData(boolean onlyDet, boolean needIncoming, DlCompletionTreeArc p) {
        return !(p.isIBlocked() || p.getArcEnd().isDataNode() || onlyDet && !p.getDep().isEmpty() || !needIncoming && !p.isSuccEdge());
    }

    @PortedFrom(file="KnowledgeExplorer.h", name="getNeighbours")
    public List<DlCompletionTree> getNeighbours(DlCompletionTree node, Role no) {
        this.nodes.clear();
        node.getNeighbour().stream().filter(p -> !p.isIBlocked() && p.isNeighbour(no)).forEach(p -> this.nodes.add(p.getArcEnd()));
        return this.nodes;
    }

    @PortedFrom(file="KnowledgeExplorer.h", name="getLabel")
    public List<ConceptExpression> getObjectLabel(DlCompletionTree node, boolean onlyDet) {
        this.d2i.ensureDagSize();
        assert (!node.isDataNode());
        this.concepts.clear();
        Stream.concat(node.simpleConcepts().stream(), node.complexConcepts().stream()).filter(p -> !onlyDet || p.getDep().isEmpty()).forEach(p -> this.addC(this.d2i.getExpr(p.getConcept(), false)));
        return OWLAPIStreamUtils.asList(this.concepts.stream().filter(e -> e instanceof ConceptExpression).map(e -> (ConceptExpression)e));
    }

    @PortedFrom(file="KnowledgeExplorer.h", name="getLabel")
    public List<DataExpression> getDataLabel(DlCompletionTree node, boolean onlyDet) {
        this.d2i.ensureDagSize();
        assert (node.isDataNode());
        this.concepts.clear();
        Stream.concat(node.simpleConcepts().stream(), node.complexConcepts().stream()).filter(p -> !onlyDet || p.getDep().isEmpty()).forEach(p -> this.addC(this.d2i.getExpr(p.getConcept(), true)));
        return OWLAPIStreamUtils.asList(this.concepts.stream().filter(e -> e instanceof DataExpression).map(e -> (DataExpression)e));
    }

    @PortedFrom(file="KnowledgeExplorer.h", name="getBlocker")
    public DlCompletionTree getBlocker(DlCompletionTree node) {
        return node.getBlocker();
    }
}

