/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact;

import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.impl.DefaultNode;
import org.semanticweb.owlapi.reasoner.impl.DefaultNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNode;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.jfact.OWLEntityTranslator;
import uk.ac.manchester.cs.jfact.TranslationMachinery;
import uk.ac.manchester.cs.jfact.kernel.ExpressionCache;
import uk.ac.manchester.cs.jfact.kernel.ExpressionManager;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;

public class ClassExpressionTranslator
extends OWLEntityTranslator<OWLClass, ConceptExpression>
implements OWLClassExpressionVisitorEx<ConceptExpression> {
    public ClassExpressionTranslator(ExpressionCache em, OWLDataFactory df, TranslationMachinery tr) {
        super(em, df, tr);
    }

    @Override
    @Nullable
    protected ConceptExpression getTopEntityPointer() {
        return ExpressionManager.top();
    }

    @Override
    @Nullable
    protected ConceptExpression getBottomEntityPointer() {
        return ExpressionManager.bottom();
    }

    @Override
    @Nullable
    protected OWLClass getTopEntity() {
        return this.df.getOWLThing();
    }

    @Override
    @Nullable
    protected OWLClass getBottomEntity() {
        return this.df.getOWLNothing();
    }

    @Override
    protected ConceptExpression createPointerForEntity(OWLClass entity) {
        return this.em.concept((OWLEntity)entity);
    }

    @Override
    protected DefaultNode<OWLClass> createDefaultNode(Stream<OWLClass> stream) {
        return new OWLClassNode(stream);
    }

    @Override
    protected DefaultNodeSet<OWLClass> createDefaultNodeSet(Stream<Node<OWLClass>> stream) {
        return new OWLClassNodeSet(stream);
    }

    public ConceptExpression visit(OWLClass desc) {
        return (ConceptExpression)this.getPointerFromEntity(desc);
    }

    public ConceptExpression visit(OWLObjectIntersectionOf desc) {
        return ExpressionManager.and(this.translateClassExpressionSet(desc.operands()));
    }

    private List<ConceptExpression> translateClassExpressionSet(Stream<? extends OWLClassExpression> classExpressions) {
        return OWLAPIStreamUtils.asList(classExpressions.map(c -> (ConceptExpression)c.accept((OWLClassExpressionVisitorEx)this)));
    }

    public ConceptExpression visit(OWLObjectUnionOf desc) {
        return ExpressionManager.or(this.translateClassExpressionSet(desc.operands()));
    }

    public ConceptExpression visit(OWLObjectComplementOf desc) {
        return ExpressionManager.not((ConceptExpression)desc.getOperand().accept((OWLClassExpressionVisitorEx)this));
    }

    public ConceptExpression visit(OWLObjectSomeValuesFrom desc) {
        return ExpressionManager.exists(this.tr.pointer(desc.getProperty()), (ConceptExpression)((OWLClassExpression)desc.getFiller()).accept((OWLClassExpressionVisitorEx)this));
    }

    public ConceptExpression visit(OWLObjectAllValuesFrom desc) {
        return ExpressionManager.forall(this.tr.pointer(desc.getProperty()), (ConceptExpression)((OWLClassExpression)desc.getFiller()).accept((OWLClassExpressionVisitorEx)this));
    }

    public ConceptExpression visit(OWLObjectHasValue desc) {
        return ExpressionManager.value(this.tr.pointer(desc.getProperty()), this.tr.pointer((OWLIndividual)desc.getFiller()));
    }

    public ConceptExpression visit(OWLObjectMinCardinality desc) {
        return ExpressionManager.minCardinality(desc.getCardinality(), this.tr.pointer(desc.getProperty()), (ConceptExpression)((OWLClassExpression)desc.getFiller()).accept((OWLClassExpressionVisitorEx)this));
    }

    public ConceptExpression visit(OWLObjectExactCardinality desc) {
        return ExpressionManager.cardinality(desc.getCardinality(), this.tr.pointer(desc.getProperty()), (ConceptExpression)((OWLClassExpression)desc.getFiller()).accept((OWLClassExpressionVisitorEx)this));
    }

    public ConceptExpression visit(OWLObjectMaxCardinality desc) {
        return ExpressionManager.maxCardinality(desc.getCardinality(), this.tr.pointer(desc.getProperty()), (ConceptExpression)((OWLClassExpression)desc.getFiller()).accept((OWLClassExpressionVisitorEx)this));
    }

    public ConceptExpression visit(OWLObjectHasSelf desc) {
        return ExpressionManager.selfReference(this.tr.pointer(desc.getProperty()));
    }

    public ConceptExpression visit(OWLObjectOneOf desc) {
        return this.em.oneOf(this.tr.translate(desc.individuals()));
    }

    public ConceptExpression visit(OWLDataSomeValuesFrom desc) {
        return ExpressionManager.exists(this.tr.pointer(desc.getProperty()), this.tr.pointer((OWLDataRange)desc.getFiller()));
    }

    public ConceptExpression visit(OWLDataAllValuesFrom desc) {
        return ExpressionManager.forall(this.tr.pointer(desc.getProperty()), this.tr.pointer((OWLDataRange)desc.getFiller()));
    }

    public ConceptExpression visit(OWLDataHasValue desc) {
        return ExpressionManager.value(this.tr.pointer(desc.getProperty()), this.tr.pointer((OWLLiteral)desc.getFiller()));
    }

    public ConceptExpression visit(OWLDataMinCardinality desc) {
        return ExpressionManager.minCardinality(desc.getCardinality(), this.tr.pointer(desc.getProperty()), this.tr.pointer((OWLDataRange)desc.getFiller()));
    }

    public ConceptExpression visit(OWLDataExactCardinality desc) {
        return ExpressionManager.cardinality(desc.getCardinality(), this.tr.pointer(desc.getProperty()), this.tr.pointer((OWLDataRange)desc.getFiller()));
    }

    public ConceptExpression visit(OWLDataMaxCardinality desc) {
        return ExpressionManager.maxCardinality(desc.getCardinality(), this.tr.pointer(desc.getProperty()), this.tr.pointer((OWLDataRange)desc.getFiller()));
    }
}

