/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapitools.decomposition.AxiomWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.manchester.cs.jfact.DeclarationVisitorEx;
import uk.ac.manchester.cs.jfact.TranslationMachinery;
import uk.ac.manchester.cs.jfact.kernel.ExpressionManager;
import uk.ac.manchester.cs.jfact.kernel.Ontology;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomConceptInclusion;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDRoleDomain;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDRoleFunctional;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDRoleRange;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDRoleSubsumption;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDifferentIndividuals;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDisjointConcepts;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDisjointDRoles;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDisjointORoles;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDisjointUnion;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomEquivalentConcepts;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomEquivalentDRoles;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomEquivalentORoles;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomInstanceOf;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomORoleDomain;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomORoleFunctional;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomORoleRange;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomORoleSubsumption;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRelatedTo;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRelatedToNot;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleAsymmetric;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleInverse;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleInverseFunctional;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleIrreflexive;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleReflexive;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleSymmetric;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleTransitive;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomSameIndividuals;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomValueOf;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomValueOfNot;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.Axioms;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;

public class AxiomTranslator
implements OWLAxiomVisitorEx<AxiomWrapper>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AxiomTranslator.class);
    @Nonnull
    private final DeclarationVisitorEx v;
    private Ontology o;
    private TranslationMachinery tr;

    public AxiomTranslator(Ontology o, OWLDataFactory df, TranslationMachinery tr) {
        this.v = new DeclarationVisitorEx(o, df, tr);
        this.o = o;
        this.tr = tr;
    }

    public AxiomWrapper visit(OWLSubClassOfAxiom axiom) {
        return this.o.add(new AxiomConceptInclusion((OWLAxiom)axiom, this.tr.pointer(axiom.getSubClass()), this.tr.pointer(axiom.getSuperClass())));
    }

    public AxiomWrapper visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        return this.o.add(new AxiomRelatedToNot((OWLAxiom)axiom, this.tr.pointer(axiom.getSubject()), this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty()), this.tr.pointer((OWLIndividual)axiom.getObject())));
    }

    public AxiomWrapper visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        return this.o.add(new AxiomRoleAsymmetric((OWLAxiom)axiom, this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty())));
    }

    public AxiomWrapper visit(OWLReflexiveObjectPropertyAxiom axiom) {
        return this.o.add(new AxiomRoleReflexive((OWLAxiom)axiom, this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty())));
    }

    public AxiomWrapper visit(OWLDisjointClassesAxiom axiom) {
        return this.o.add(new AxiomDisjointConcepts((OWLAxiom)axiom, this.translateClassExpressionSet(axiom.classExpressions())));
    }

    private List<ConceptExpression> translateClassExpressionSet(Stream<? extends OWLClassExpression> classExpressions) {
        return OWLAPIStreamUtils.asList(classExpressions.map(this.tr::pointer));
    }

    public AxiomWrapper visit(OWLDataPropertyDomainAxiom axiom) {
        return this.o.add(new AxiomDRoleDomain((OWLAxiom)axiom, this.tr.pointer((OWLDataPropertyExpression)axiom.getProperty()), this.tr.pointer((OWLClassExpression)axiom.getDomain())));
    }

    public AxiomWrapper visit(OWLObjectPropertyDomainAxiom axiom) {
        return this.o.add(new AxiomORoleDomain((OWLAxiom)axiom, this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty()), this.tr.pointer((OWLClassExpression)axiom.getDomain())));
    }

    public AxiomWrapper visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        return this.o.add(new AxiomEquivalentORoles((OWLAxiom)axiom, this.translateObjectPropertySet(axiom.properties())));
    }

    private List<ObjectRoleExpression> translateObjectPropertySet(Stream<OWLObjectPropertyExpression> properties) {
        return OWLAPIStreamUtils.asList(properties.map(this.tr::pointer));
    }

    public AxiomWrapper visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        return this.o.add(new AxiomValueOfNot((OWLAxiom)axiom, this.tr.pointer(axiom.getSubject()), this.tr.pointer((OWLDataPropertyExpression)axiom.getProperty()), this.tr.pointer((OWLLiteral)axiom.getObject())));
    }

    public AxiomWrapper visit(OWLDifferentIndividualsAxiom axiom) {
        return this.o.add(new AxiomDifferentIndividuals((OWLAxiom)axiom, this.tr.translate(axiom.individuals())));
    }

    public AxiomWrapper visit(OWLDisjointDataPropertiesAxiom axiom) {
        return this.o.add(new AxiomDisjointDRoles((OWLAxiom)axiom, this.translateDataPropertySet(axiom.properties())));
    }

    private List<DataRoleExpression> translateDataPropertySet(Stream<OWLDataPropertyExpression> properties) {
        return OWLAPIStreamUtils.asList(properties.map(this.tr::pointer));
    }

    public AxiomWrapper visit(OWLDisjointObjectPropertiesAxiom axiom) {
        return this.o.add(new AxiomDisjointORoles((OWLAxiom)axiom, this.translateObjectPropertySet(axiom.properties())));
    }

    public AxiomWrapper visit(OWLObjectPropertyRangeAxiom axiom) {
        return this.o.add(new AxiomORoleRange((OWLAxiom)axiom, this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty()), this.tr.pointer((OWLClassExpression)axiom.getRange())));
    }

    public AxiomWrapper visit(OWLObjectPropertyAssertionAxiom axiom) {
        return this.o.add(new AxiomRelatedTo((OWLAxiom)axiom, this.tr.pointer(axiom.getSubject()), this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty()), this.tr.pointer((OWLIndividual)axiom.getObject())));
    }

    public AxiomWrapper visit(OWLFunctionalObjectPropertyAxiom axiom) {
        return this.o.add(new AxiomORoleFunctional((OWLAxiom)axiom, this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty())));
    }

    public AxiomWrapper visit(OWLSubObjectPropertyOfAxiom axiom) {
        return this.o.add(new AxiomORoleSubsumption((OWLAxiom)axiom, this.tr.pointer((OWLObjectPropertyExpression)axiom.getSubProperty()), this.tr.pointer((OWLObjectPropertyExpression)axiom.getSuperProperty())));
    }

    public AxiomWrapper visit(OWLDisjointUnionAxiom axiom) {
        return this.o.add(new AxiomDisjointUnion((OWLAxiom)axiom, this.tr.pointer((OWLClassExpression)axiom.getOWLClass()), this.translateClassExpressionSet(axiom.classExpressions())));
    }

    public AxiomWrapper visit(OWLDeclarationAxiom axiom) {
        OWLEntity entity = axiom.getEntity();
        return (AxiomWrapper)entity.accept((OWLEntityVisitorEx)this.v);
    }

    public AxiomWrapper visit(OWLAnnotationAssertionAxiom axiom) {
        return Axioms.dummy();
    }

    public AxiomWrapper visit(OWLSymmetricObjectPropertyAxiom axiom) {
        return this.o.add(new AxiomRoleSymmetric((OWLAxiom)axiom, this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty())));
    }

    public AxiomWrapper visit(OWLDataPropertyRangeAxiom axiom) {
        return this.o.add(new AxiomDRoleRange((OWLAxiom)axiom, this.tr.pointer((OWLDataPropertyExpression)axiom.getProperty()), this.tr.pointer((OWLDataRange)axiom.getRange())));
    }

    public AxiomWrapper visit(OWLFunctionalDataPropertyAxiom axiom) {
        return this.o.add(new AxiomDRoleFunctional((OWLAxiom)axiom, this.tr.pointer((OWLDataPropertyExpression)axiom.getProperty())));
    }

    public AxiomWrapper visit(OWLEquivalentDataPropertiesAxiom axiom) {
        return this.o.add(new AxiomEquivalentDRoles((OWLAxiom)axiom, this.translateDataPropertySet(axiom.properties())));
    }

    public AxiomWrapper visit(OWLClassAssertionAxiom axiom) {
        return this.o.add(new AxiomInstanceOf((OWLAxiom)axiom, this.tr.pointer(axiom.getIndividual()), this.tr.pointer(axiom.getClassExpression())));
    }

    public AxiomWrapper visit(OWLEquivalentClassesAxiom axiom) {
        return this.o.add(new AxiomEquivalentConcepts((OWLAxiom)axiom, this.translateClassExpressionSet(axiom.classExpressions())));
    }

    public AxiomWrapper visit(OWLDataPropertyAssertionAxiom axiom) {
        return this.o.add(new AxiomValueOf((OWLAxiom)axiom, this.tr.pointer(axiom.getSubject()), this.tr.pointer((OWLDataPropertyExpression)axiom.getProperty()), this.tr.pointer((OWLLiteral)axiom.getObject())));
    }

    public AxiomWrapper visit(OWLTransitiveObjectPropertyAxiom axiom) {
        return this.o.add(new AxiomRoleTransitive((OWLAxiom)axiom, this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty())));
    }

    public AxiomWrapper visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        return this.o.add(new AxiomRoleIrreflexive((OWLAxiom)axiom, this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty())));
    }

    public AxiomWrapper visit(OWLSubDataPropertyOfAxiom axiom) {
        return this.o.add(new AxiomDRoleSubsumption((OWLAxiom)axiom, this.tr.pointer((OWLDataPropertyExpression)axiom.getSubProperty()), this.tr.pointer((OWLDataPropertyExpression)axiom.getSuperProperty())));
    }

    public AxiomWrapper visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        return this.o.add(new AxiomRoleInverseFunctional((OWLAxiom)axiom, this.tr.pointer((OWLObjectPropertyExpression)axiom.getProperty())));
    }

    public AxiomWrapper visit(OWLSameIndividualAxiom axiom) {
        return this.o.add(new AxiomSameIndividuals((OWLAxiom)axiom, this.tr.translate(axiom.individuals())));
    }

    public AxiomWrapper visit(OWLSubPropertyChainOfAxiom axiom) {
        return this.o.add(new AxiomORoleSubsumption((OWLAxiom)axiom, ExpressionManager.compose(this.translateObjectPropertySet(axiom.getPropertyChain().stream())), this.tr.pointer(axiom.getSuperProperty())));
    }

    public AxiomWrapper visit(OWLInverseObjectPropertiesAxiom axiom) {
        return this.o.add(new AxiomRoleInverse((OWLAxiom)axiom, this.tr.pointer(axiom.getFirstProperty()), this.tr.pointer(axiom.getSecondProperty())));
    }

    public AxiomWrapper visit(OWLHasKeyAxiom axiom) {
        LOGGER.error("JFact Kernel: unsupported operation 'getDataPropertyKey' {}", (Object)axiom);
        return Axioms.dummy();
    }

    public AxiomWrapper visit(OWLDatatypeDefinitionAxiom axiom) {
        LOGGER.error("JFact Kernel: unsupported operation 'OWLDatatypeDefinitionAxiom' {}", (Object)axiom);
        return Axioms.dummy();
    }

    public AxiomWrapper visit(SWRLRule rule) {
        return Axioms.dummy();
    }

    public AxiomWrapper visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        return Axioms.dummy();
    }

    public AxiomWrapper visit(OWLAnnotationPropertyDomainAxiom axiom) {
        return Axioms.dummy();
    }

    public AxiomWrapper visit(OWLAnnotationPropertyRangeAxiom axiom) {
        return Axioms.dummy();
    }
}

