/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.split;

import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataExactCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataExists;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataForall;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataMaxCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataMinCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptName;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectExactCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectExists;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectForall;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectMaxCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectMinCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleName;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleName;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleProjectionFrom;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleProjectionInto;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.NamedEntity;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.RoleExpression;
import uk.ac.manchester.cs.jfact.split.LowerBoundComplementEvaluator;
import uk.ac.manchester.cs.jfact.split.LowerBoundDirectEvaluator;
import uk.ac.manchester.cs.jfact.split.SigAccessor;
import uk.ac.manchester.cs.jfact.split.TSignature;
import uk.ac.manchester.cs.jfact.split.UpperBoundComplementEvaluator;
import uk.ac.manchester.cs.jfact.split.UpperBoundDirectEvaluator;

abstract class CardinalityEvaluatorBase
extends SigAccessor {
    private static final long serialVersionUID = 11000L;
    protected UpperBoundDirectEvaluator UBD;
    protected LowerBoundDirectEvaluator LBD;
    protected UpperBoundComplementEvaluator UBC;
    protected LowerBoundComplementEvaluator LBC;
    protected int value = 0;

    protected int getValue(Expression expr) {
        expr.accept(this);
        return this.value;
    }

    protected boolean isBotEquivalent(Expression expr) {
        return this.getUpperBoundDirect(expr) == 0;
    }

    protected boolean isTopEquivalent(Expression expr) {
        return this.getUpperBoundComplement(expr) == 0;
    }

    protected abstract int getEntityValue(NamedEntity var1);

    protected abstract int getForallValue(RoleExpression var1, Expression var2);

    protected abstract int getMinValue(int var1, RoleExpression var2, Expression var3);

    protected abstract int getMaxValue(int var1, RoleExpression var2, Expression var3);

    protected abstract int getExactValue(int var1, RoleExpression var2, Expression var3);

    public CardinalityEvaluatorBase(TSignature s) {
        super(s);
    }

    public void setEvaluators(UpperBoundDirectEvaluator pUD, LowerBoundDirectEvaluator pLD, UpperBoundComplementEvaluator pUC, LowerBoundComplementEvaluator pLC) {
        this.UBD = pUD;
        this.LBD = pLD;
        this.UBC = pUC;
        this.LBC = pLC;
        assert (this.UBD == this || this.LBD == this || this.UBC == this || this.LBC == this);
    }

    public int getUpperBoundDirect(Expression expr) {
        return this._getUpperBoundDirect(expr);
    }

    public int getUpperBoundComplement(Expression expr) {
        return this._getUpperBoundComplement(expr);
    }

    public int getLowerBoundDirect(Expression expr) {
        return this._getLowerBoundDirect(expr);
    }

    public int getLowerBoundComplement(Expression expr) {
        return this._getLowerBoundComplement(expr);
    }

    private int _getUpperBoundDirect(Expression expr) {
        return this.UBD.getValue(expr);
    }

    private int _getUpperBoundComplement(Expression expr) {
        return this.UBC.getValue(expr);
    }

    private int _getLowerBoundDirect(Expression expr) {
        return this.LBD.getValue(expr);
    }

    private int _getLowerBoundComplement(Expression expr) {
        return this.LBC.getValue(expr);
    }

    @Override
    public void visit(ConceptName expr) {
        this.value = this.getEntityValue(expr);
    }

    @Override
    public void visit(ConceptObjectExists expr) {
        this.value = this.getMinValue(1, expr.getOR(), expr.getConcept());
    }

    @Override
    public void visit(ConceptObjectForall expr) {
        this.value = this.getForallValue(expr.getOR(), expr.getConcept());
    }

    @Override
    public void visit(ConceptObjectMinCardinality expr) {
        this.value = this.getMinValue(expr.getCardinality(), expr.getOR(), expr.getConcept());
    }

    @Override
    public void visit(ConceptObjectMaxCardinality expr) {
        this.value = this.getMaxValue(expr.getCardinality(), expr.getOR(), expr.getConcept());
    }

    @Override
    public void visit(ConceptObjectExactCardinality expr) {
        this.value = this.getExactValue(expr.getCardinality(), expr.getOR(), expr.getConcept());
    }

    @Override
    public void visit(ConceptDataExists expr) {
        this.value = this.getMinValue(1, expr.getDataRoleExpression(), expr.getExpr());
    }

    @Override
    public void visit(ConceptDataForall expr) {
        this.value = this.getForallValue(expr.getDataRoleExpression(), expr.getExpr());
    }

    @Override
    public void visit(ConceptDataMinCardinality expr) {
        this.value = this.getMinValue(expr.getCardinality(), expr.getDataRoleExpression(), expr.getExpr());
    }

    @Override
    public void visit(ConceptDataMaxCardinality expr) {
        this.value = this.getMaxValue(expr.getCardinality(), expr.getDataRoleExpression(), expr.getExpr());
    }

    @Override
    public void visit(ConceptDataExactCardinality expr) {
        this.value = this.getExactValue(expr.getCardinality(), expr.getDataRoleExpression(), expr.getExpr());
    }

    @Override
    public void visit(ObjectRoleName expr) {
        this.value = this.getEntityValue(expr);
    }

    @Override
    public void visit(ObjectRoleProjectionFrom expr) {
        this.value = this.getMinValue(1, expr.getOR(), expr.getConcept());
    }

    @Override
    public void visit(ObjectRoleProjectionInto expr) {
        this.value = this.getMinValue(1, expr.getOR(), expr.getConcept());
    }

    @Override
    public void visit(DataRoleName expr) {
        this.value = this.getEntityValue(expr);
    }
}

