/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.split;

import conformance.PortedFrom;
import java.io.Serializable;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.datatypes.cardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptAnd;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataExactCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataExists;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataForall;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataMaxCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataMinCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptDataValue;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptName;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptNot;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectExactCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectExists;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectForall;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectMaxCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectMinCardinality;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectSelf;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptObjectValue;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptOneOf;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptOr;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptTop;
import uk.ac.manchester.cs.jfact.kernel.dl.DataAnd;
import uk.ac.manchester.cs.jfact.kernel.dl.DataBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.DataNot;
import uk.ac.manchester.cs.jfact.kernel.dl.DataOneOf;
import uk.ac.manchester.cs.jfact.kernel.dl.DataOr;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleName;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleTop;
import uk.ac.manchester.cs.jfact.kernel.dl.DataTop;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleBottom;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleChain;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleInverse;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleName;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleProjectionFrom;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleProjectionInto;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleTop;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.RoleExpression;
import uk.ac.manchester.cs.jfact.split.SigAccessor;
import uk.ac.manchester.cs.jfact.split.TopEquivalenceEvaluator;
import uk.ac.manchester.cs.jfact.visitors.DLExpressionVisitor;

@PortedFrom(file="SyntacticLocalityChecker.h", name="BotEquivalenceEvaluator")
public class BotEquivalenceEvaluator
extends SigAccessor
implements DLExpressionVisitor,
Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="SyntacticLocalityChecker.h", name="TopEval")
    private TopEquivalenceEvaluator TopEval = null;
    @PortedFrom(file="SyntacticLocalityChecker.h", name="isBotEq")
    private boolean isBotEq = false;

    @PortedFrom(file="SyntacticLocalityChecker.h", name="isTopEquivalent")
    private boolean isTopEquivalent(Expression expr) {
        return this.TopEval.isTopEquivalent(expr);
    }

    @PortedFrom(file="SyntacticLocalityChecker.h", name="isREquivalent")
    private boolean isREquivalent(Expression expr) {
        return this.sig.topRLocal() ? this.isTopEquivalent(expr) : this.isBotEquivalent(expr);
    }

    private boolean isBotDistinct(Expression C) {
        if (this.isTopEquivalent(C)) {
            return true;
        }
        return C instanceof Datatype;
    }

    private boolean isCardLargerThan(Expression C, int n) {
        if (C instanceof DataExpression && this.isTopEquivalent(C)) {
            return true;
        }
        if (n == 0) {
            return this.isBotDistinct(C);
        }
        if (C instanceof Datatype) {
            return ((Datatype)C).getCardinality() == cardinality.COUNTABLYINFINITE;
        }
        return false;
    }

    private boolean isMinBotEquivalent(int n, RoleExpression R, Expression C) {
        return n > 0 && (this.isBotEquivalent(R) || this.isBotEquivalent(C));
    }

    private boolean isMaxBotEquivalent(int n, RoleExpression R, Expression C) {
        return this.isTopEquivalent(R) && this.isCardLargerThan(C, n);
    }

    @PortedFrom(file="SyntacticLocalityChecker.h", name="setTopEval")
    protected void setTopEval(TopEquivalenceEvaluator eval) {
        this.TopEval = eval;
    }

    @PortedFrom(file="SyntacticLocalityChecker.h", name="isBotEquivalent")
    protected boolean isBotEquivalent(Expression expr) {
        expr.accept(this);
        return this.isBotEq;
    }

    @Override
    public void visit(ConceptTop expr) {
        this.isBotEq = false;
    }

    @Override
    public void visit(ConceptBottom expr) {
        this.isBotEq = true;
    }

    @Override
    public void visit(ObjectRoleProjectionFrom expr) {
        this.isBotEq = this.isMinBotEquivalent(1, expr.getOR(), expr.getConcept());
    }

    @Override
    public void visit(ObjectRoleProjectionInto expr) {
        this.isBotEq = this.isMinBotEquivalent(1, expr.getOR(), expr.getConcept());
    }

    @Override
    public void visit(ConceptName expr) {
        this.isBotEq = !this.sig.topCLocal() && !this.sig.contains(expr);
    }

    @Override
    public void visit(ConceptNot expr) {
        this.isBotEq = this.isTopEquivalent(expr.getConcept());
    }

    @Override
    public void visit(ConceptAnd expr) {
        for (ConceptExpression p : expr.getArguments()) {
            if (!this.isBotEquivalent(p)) continue;
            return;
        }
        this.isBotEq = false;
    }

    @Override
    public void visit(ConceptOr expr) {
        for (ConceptExpression p : expr.getArguments()) {
            if (this.isBotEquivalent(p)) continue;
            return;
        }
        this.isBotEq = true;
    }

    @Override
    public void visit(ConceptOneOf<?> expr) {
        this.isBotEq = expr.isEmpty();
    }

    @Override
    public void visit(ConceptObjectSelf expr) {
        this.isBotEq = this.isBotEquivalent(expr.getOR());
    }

    @Override
    public void visit(ConceptObjectValue expr) {
        this.isBotEq = this.isBotEquivalent(expr.getOR());
    }

    @Override
    public void visit(ConceptObjectExists expr) {
        this.isBotEq = this.isMinBotEquivalent(1, expr.getOR(), expr.getConcept());
    }

    @Override
    public void visit(ConceptObjectForall expr) {
        this.isBotEq = this.isTopEquivalent(expr.getOR()) && this.isBotEquivalent(expr.getConcept());
    }

    @Override
    public void visit(ConceptObjectMinCardinality expr) {
        this.isBotEq = expr.getCardinality() > 0 && (this.isBotEquivalent(expr.getConcept()) || !this.sig.topRLocal() && this.isBotEquivalent(expr.getOR()));
    }

    @Override
    public void visit(ConceptObjectMaxCardinality expr) {
        this.isBotEq = this.sig.topRLocal() && expr.getCardinality() > 0 && this.isTopEquivalent(expr.getOR()) && this.isTopEquivalent(expr.getConcept());
    }

    @Override
    public void visit(ConceptObjectExactCardinality expr) {
        ConceptExpression C;
        ObjectRoleExpression R;
        int n = expr.getCardinality();
        this.isBotEq = this.isMinBotEquivalent(n, R = expr.getOR(), C = expr.getConcept()) || this.isMaxBotEquivalent(n, R, C);
    }

    @Override
    public void visit(ConceptDataValue expr) {
        this.isBotEq = this.isBotEquivalent(expr.getDataRoleExpression());
    }

    @Override
    public void visit(ConceptDataExists expr) {
        this.isBotEq = this.isMinBotEquivalent(1, expr.getDataRoleExpression(), expr.getExpr());
    }

    @Override
    public void visit(ConceptDataForall expr) {
        this.isBotEq = this.isTopEquivalent(expr.getDataRoleExpression()) && !this.isTopEquivalent(expr.getExpr());
    }

    @Override
    public void visit(ConceptDataMinCardinality expr) {
        this.isBotEq = !this.sig.topRLocal() && expr.getCardinality() > 0 && this.isBotEquivalent(expr.getDataRoleExpression());
    }

    @Override
    public void visit(ConceptDataMaxCardinality expr) {
        this.isBotEq = this.sig.topRLocal() && this.isTopEquivalent(expr.getDataRoleExpression()) && (expr.getCardinality() <= 1 ? this.isTopOrBuiltInDataType(expr.getExpr()) : this.isTopOrBuiltInDataType(expr.getExpr()));
    }

    @Override
    public void visit(ConceptDataExactCardinality expr) {
        this.isBotEq = this.isREquivalent(expr.getDataRoleExpression()) && (this.sig.topRLocal() ? (expr.getCardinality() == 0 ? this.isTopOrBuiltInDataType(expr.getExpr()) : this.isTopOrBuiltInDataType(expr.getExpr())) : expr.getCardinality() > 0);
    }

    @Override
    public void visit(ObjectRoleTop expr) {
        this.isBotEq = false;
    }

    @Override
    public void visit(ObjectRoleBottom expr) {
        this.isBotEq = true;
    }

    @Override
    public void visit(ObjectRoleName expr) {
        this.isBotEq = !this.sig.topRLocal() && !this.sig.contains(expr);
    }

    @Override
    public void visit(ObjectRoleInverse expr) {
        this.isBotEq = this.isBotEquivalent(expr.getOR());
    }

    @Override
    public void visit(ObjectRoleChain expr) {
        this.isBotEq = true;
        for (ObjectRoleExpression p : expr.getArguments()) {
            if (!this.isBotEquivalent(p)) continue;
            return;
        }
        this.isBotEq = false;
    }

    @Override
    public void visit(DataRoleTop expr) {
        this.isBotEq = false;
    }

    @Override
    public void visit(DataRoleBottom expr) {
        this.isBotEq = true;
    }

    @Override
    public void visit(DataRoleName expr) {
        this.isBotEq = !this.sig.topRLocal() && !this.sig.contains(expr);
    }

    @Override
    public void visit(DataTop arg) {
        this.isBotEq = false;
    }

    @Override
    public void visit(DataBottom arg) {
        this.isBotEq = true;
    }

    @Override
    public void visit(Datatype<?> arg) {
        this.isBotEq = false;
    }

    @Override
    public void visit(Literal<?> arg) {
        this.isBotEq = false;
    }

    @Override
    public void visit(DataNot expr) {
        this.isBotEq = this.isTopEquivalent(expr.getExpr());
    }

    @Override
    public void visit(DataAnd expr) {
        for (DataExpression p : expr.getArguments()) {
            if (!this.isBotEquivalent(p)) continue;
            return;
        }
        this.isBotEq = false;
    }

    @Override
    public void visit(DataOr expr) {
        for (DataExpression p : expr.getArguments()) {
            if (this.isBotEquivalent(p)) continue;
            return;
        }
        this.isBotEq = true;
    }

    @Override
    public void visit(DataOneOf expr) {
        this.isBotEq = expr.isEmpty();
    }
}

