/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.split;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import uk.ac.manchester.cs.jfact.kernel.Ontology;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.AxiomInterface;
import uk.ac.manchester.cs.jfact.split.AOStructure;
import uk.ac.manchester.cs.jfact.split.ModuleType;
import uk.ac.manchester.cs.jfact.split.ProgressIndicatorInterface;
import uk.ac.manchester.cs.jfact.split.TModularizer;
import uk.ac.manchester.cs.jfact.split.TOntologyAtom;
import uk.ac.manchester.cs.jfact.split.TSignature;

@PortedFrom(file="AtomicDecomposer.h", name="AtomicDecomposer")
public class AtomicDecomposer
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="AtomicDecomposer.h", name="AOS")
    private AOStructure AOS = null;
    @PortedFrom(file="AtomicDecomposer.h", name="pModularizer")
    private final TModularizer Modularizer;
    @PortedFrom(file="AtomicDecomposer.h", name="Tautologies")
    private final List<AxiomInterface> Tautologies = new ArrayList<AxiomInterface>();
    @PortedFrom(file="AtomicDecomposer.h", name="PI")
    private ProgressIndicatorInterface PI = null;
    @PortedFrom(file="AtomicDecomposer.h", name="rootAtom")
    private TOntologyAtom rootAtom = null;
    @PortedFrom(file="AtomicDecomposer.h", name="type")
    private ModuleType type;

    public AtomicDecomposer(TModularizer c) {
        this.Modularizer = c;
    }

    @PortedFrom(file="AtomicDecomposer.h", name="restoreTautologies")
    private void restoreTautologies() {
        for (AxiomInterface p : this.Tautologies) {
            p.setUsed(true);
        }
    }

    @PortedFrom(file="AtomicDecomposer.h", name="setProgressIndicator")
    public void setProgressIndicator(ProgressIndicatorInterface pi) {
        this.PI = pi;
    }

    @PortedFrom(file="AtomicDecomposer.h", name="removeTautologies")
    private void removeTautologies(Ontology O) {
        this.Tautologies.clear();
        long nAx = 0L;
        for (AxiomInterface p : O.getAxioms()) {
            if (!p.isUsed()) continue;
            this.Modularizer.extract(p, p.getSignature(), this.type);
            if (this.Modularizer.isTautology(p, this.type)) {
                this.Tautologies.add(p);
                p.setUsed(false);
                continue;
            }
            ++nAx;
        }
        if (this.PI != null) {
            this.PI.setLimit(nAx);
        }
    }

    @PortedFrom(file="AtomicDecomposer.h", name="buildModule")
    private TOntologyAtom buildModule(TSignature sig, TOntologyAtom parent) {
        this.Modularizer.extract(parent.getModule(), sig, this.type);
        List<AxiomInterface> Module2 = this.Modularizer.getModule();
        if (Module2.isEmpty()) {
            return null;
        }
        if (this.PI != null) {
            this.PI.incIndicator();
        }
        if (parent != this.rootAtom && Module2.size() == parent.getModule().size()) {
            return parent;
        }
        TOntologyAtom atom = this.AOS.newAtom();
        atom.setModule(Module2);
        return atom;
    }

    @PortedFrom(file="AtomicDecomposer.h", name="createAtom")
    private TOntologyAtom createAtom(AxiomInterface ax, TOntologyAtom parent) {
        if (ax.getAtom() != null) {
            return ax.getAtom();
        }
        TOntologyAtom atom = this.buildModule(ax.getSignature(), parent);
        assert (atom != null);
        atom.addAxiom(ax);
        if (atom == parent) {
            return parent;
        }
        for (AxiomInterface q : atom.getModule()) {
            if (q.equals(ax)) continue;
            atom.addDepAtom(this.createAtom(q, atom));
        }
        return atom;
    }

    @Original
    public List<AxiomInterface> getTautologies() {
        return new ArrayList<AxiomInterface>(this.Tautologies);
    }

    @PortedFrom(file="AtomicDecomposer.h", name="getAOS")
    public AOStructure getAOS() {
        return this.AOS;
    }

    @PortedFrom(file="AtomicDecomposer.h", name="getAOS")
    public AOStructure getAOS(Ontology O, ModuleType t) {
        this.type = t;
        this.AOS = new AOStructure();
        this.Modularizer.preprocessOntology(O.getAxioms());
        this.removeTautologies(O);
        this.rootAtom = new TOntologyAtom();
        this.rootAtom.setModule(new HashSet<AxiomInterface>(O.getAxioms()));
        TOntologyAtom BottomAtom = this.buildModule(new TSignature(), this.rootAtom);
        if (BottomAtom != null) {
            for (AxiomInterface q : BottomAtom.getModule()) {
                BottomAtom.addAxiom(q);
            }
        }
        for (AxiomInterface p : O.getAxioms()) {
            if (!p.isUsed() || p.getAtom() != null) continue;
            this.createAtom(p, this.rootAtom);
        }
        this.restoreTautologies();
        this.rootAtom = null;
        this.AOS.reduceGraph();
        return this.AOS;
    }

    @PortedFrom(file="AtomicDecomposer.h", name="getLocChekNumber")
    public long getLocChekNumber() {
        return this.Modularizer.getNChecks();
    }
}

