/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.actors;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.TaxonomyVertex;
import uk.ac.manchester.cs.jfact.kernel.actors.Actor;

@Original
public class ActorImpl
implements Actor,
Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="Actor.h", name="found")
    protected final List<TaxonomyVertex> found = new ArrayList<TaxonomyVertex>();
    @PortedFrom(file="Actor.h", name="isRole")
    protected boolean isRole;
    @PortedFrom(file="Actor.h", name="isStandard")
    protected boolean isStandard;
    @PortedFrom(file="Actor.h", name="interrupt")
    protected boolean interrupt;

    @Override
    @PortedFrom(file="Actor.h", name="clear")
    public void clear() {
        this.found.clear();
    }

    @Override
    @PortedFrom(file="Actor.h", name="apply")
    public boolean apply(TaxonomyVertex v) {
        if (this.tryVertex(v)) {
            this.found.add(v);
            return true;
        }
        return false;
    }

    @PortedFrom(file="Actor.h", name="applicable")
    protected boolean applicable(ClassifiableEntry entry) {
        if (this.isRole) {
            if (this.isStandard) {
                return true;
            }
            return entry.getId() > -1;
        }
        return entry instanceof Concept && ((Concept)entry).isSingleton() != this.isStandard;
    }

    @PortedFrom(file="Actor.h", name="fillArray")
    protected List<ClassifiableEntry> fillArray(TaxonomyVertex v) {
        ArrayList<ClassifiableEntry> array = new ArrayList<ClassifiableEntry>();
        if (this.tryEntry(v.getPrimer())) {
            array.add(v.getPrimer());
        }
        for (ClassifiableEntry p : v.synonyms()) {
            if (!this.tryEntry(p)) continue;
            array.add(p);
        }
        return array;
    }

    @Override
    public boolean applicable(TaxonomyVertex v) {
        if (this.tryEntry(v.getPrimer())) {
            return true;
        }
        for (ClassifiableEntry p : v.synonyms()) {
            if (!this.tryEntry(p)) continue;
            return true;
        }
        return false;
    }

    protected boolean tryEntry(ClassifiableEntry p) {
        return !p.isSystem() && this.applicable(p);
    }

    protected boolean tryVertex(TaxonomyVertex v) {
        if (this.tryEntry(v.getPrimer())) {
            return true;
        }
        for (ClassifiableEntry p : v.synonyms()) {
            if (!this.tryEntry(p)) continue;
            return true;
        }
        return false;
    }

    @PortedFrom(file="Actor.h", name="needConcepts")
    public void needConcepts() {
        this.isRole = false;
        this.isStandard = true;
    }

    @PortedFrom(file="Actor.h", name="needIndividuals")
    public void needIndividuals() {
        this.isRole = false;
        this.isStandard = false;
    }

    @PortedFrom(file="Actor.h", name="needObjectRoles")
    public void needObjectRoles() {
        this.isRole = true;
        this.isStandard = true;
    }

    @PortedFrom(file="Actor.h", name="needDataRoles")
    public void needDataRoles() {
        this.isRole = true;
        this.isStandard = false;
    }

    @PortedFrom(file="Actor.h", name="setInterruptAfterFirstFound")
    public void setInterruptAfterFirstFound(boolean value) {
        this.interrupt = value;
    }

    @PortedFrom(file="Actor.h", name="getElements2D")
    public List<List<ClassifiableEntry>> getElements2D() {
        ArrayList<List<ClassifiableEntry>> ret = new ArrayList<List<ClassifiableEntry>>();
        for (int i = 0; i < this.found.size(); ++i) {
            ret.add(this.fillArray(this.found.get(i)));
        }
        return ret;
    }

    @PortedFrom(file="Actor.h", name="getElements1D")
    public List<ClassifiableEntry> getElements1D() {
        ArrayList<ClassifiableEntry> vec = new ArrayList<ClassifiableEntry>();
        for (TaxonomyVertex p : this.found) {
            vec.addAll(this.fillArray(p));
        }
        return vec;
    }

    @Override
    public void removePastBoundaries(Collection<TaxonomyVertex> pastBoundary) {
        for (TaxonomyVertex t : pastBoundary) {
            this.found.remove(t.getPrimer());
            for (TaxonomyVertex t1 = t.getSynonymNode(); t1 != null; t1 = t1.getSynonymNode()) {
                this.found.remove(t1.getPrimer());
            }
        }
    }
}

